/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.ui.view;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.diff.model.DifferenceEvent;
import org.protege.editor.owl.diff.model.DifferenceListener;
import org.protege.editor.owl.diff.model.DifferenceManager;
import org.protege.editor.owl.diff.ui.boot.StartDiff;
import org.protege.editor.owl.diff.ui.render.EntityBasedDiffRenderer;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.service.RenderingService;

public class MissingRefactorsView
extends AbstractOWLViewComponent {
    private static final long serialVersionUID = 184136904457609043L;
    private DifferenceManager differenceManager;
    private JList deletedList;
    private JList createdList;
    private RenderingService renderer;
    private DifferenceListener listener = new DifferenceListener(){

        @Override
        public void statusChanged(DifferenceEvent event) {
            switch (event) {
                case DIFF_RESET: {
                    MissingRefactorsView.this.deletedList.removeAll();
                    MissingRefactorsView.this.createdList.removeAll();
                    break;
                }
                case DIFF_COMPLETED: {
                    MissingRefactorsView.this.refill();
                }
            }
        }
    };

    protected void initialiseOWLView() {
        this.differenceManager = DifferenceManager.get(this.getOWLModelManager());
        this.differenceManager.addDifferenceListener(this.listener);
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new GridLayout(0, 2));
        this.deletedList = this.createEntityBasedDiffList();
        this.deletedList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MissingRefactorsView.this.deletedSelectionChanged();
            }
        });
        this.add(new JScrollPane(this.deletedList));
        this.createdList = this.createEntityBasedDiffList();
        this.createdList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MissingRefactorsView.this.createdSelectionChanged();
            }
        });
        this.add(new JScrollPane(this.createdList));
        this.refill();
    }

    private JList createEntityBasedDiffList() {
        JList l = new JList();
        l.setSelectionMode(0);
        l.setModel(new DefaultListModel());
        l.setSelectionModel(new DefaultListSelectionModel());
        return l;
    }

    private void createdSelectionChanged() {
        Object o = this.createdList.getSelectedValue();
        if (o instanceof EntityBasedDiff && ((EntityBasedDiff)o).getSourceEntity() == null) {
            this.getOWLWorkspace().getOWLSelectionModel().setSelectedEntity(((EntityBasedDiff)o).getTargetEntity());
        }
    }

    private void deletedSelectionChanged() {
        Object o = this.deletedList.getSelectedValue();
        OWLEditorKit altOWLEditorKit = StartDiff.getAltEditorKit(this.getOWLModelManager());
        if (altOWLEditorKit != null && o instanceof EntityBasedDiff && ((EntityBasedDiff)o).getTargetEntity() == null) {
            altOWLEditorKit.getOWLWorkspace().getOWLSelectionModel().setSelectedEntity(((EntityBasedDiff)o).getSourceEntity());
        }
    }

    private void refill() {
        if (this.differenceManager.isReady()) {
            this.renderer = StartDiff.getRenderingService(this.getOWLModelManager());
            this.createdList.removeAll();
            this.createdList.setCellRenderer(new EntityBasedDiffRenderer(this.differenceManager));
            this.deletedList.removeAll();
            this.deletedList.setCellRenderer(new EntityBasedDiffRenderer(this.differenceManager));
            Changes changes = this.differenceManager.getEngine().getChanges();
            ArrayList listOfDiffs = new ArrayList(changes.getEntityBasedDiffs());
            Collections.sort(listOfDiffs, new Comparator<EntityBasedDiff>(){

                @Override
                public int compare(EntityBasedDiff diff1, EntityBasedDiff diff2) {
                    return MissingRefactorsView.this.renderer.renderDiff(diff1).compareTo(MissingRefactorsView.this.renderer.renderDiff(diff2));
                }
            });
            for (EntityBasedDiff diff : listOfDiffs) {
                if (diff.getTargetEntity() == null) {
                    ((DefaultListModel)this.deletedList.getModel()).addElement(diff);
                    continue;
                }
                if (diff.getSourceEntity() != null) continue;
                ((DefaultListModel)this.createdList.getModel()).addElement(diff);
            }
        }
    }

    protected void disposeOWLView() {
        this.differenceManager.removeDifferenceListener(this.listener);
    }
}

