/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.ui.view;

import java.awt.BorderLayout;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.diff.model.DifferenceEvent;
import org.protege.editor.owl.diff.model.DifferenceListener;
import org.protege.editor.owl.diff.model.DifferenceManager;
import org.protege.editor.owl.diff.ui.DifferencesByEntity;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.util.Util;

public class DiffView
extends AbstractOWLViewComponent {
    private static final long serialVersionUID = -953820310817783007L;
    public static final Logger LOGGER = Logger.getLogger(DiffView.class);
    private DifferencesByEntity view;
    private JLabel status;
    private DifferenceListener listener = new DifferenceListener(){

        @Override
        public void statusChanged(DifferenceEvent event) {
            DiffView.this.updateStatus();
        }
    };

    protected void initialiseOWLView() {
        this.setLayout(new BorderLayout());
        this.view = new DifferencesByEntity(this.getOWLEditorKit()){
            private static final long serialVersionUID = -88036681191093269L;

            @Override
            public boolean isSynchronizing() {
                return DiffView.this.isSynchronizing();
            }

            @Override
            public void setSynchronizing(boolean isSynchronized) {
                throw new UnsupportedOperationException();
            }
        };
        this.add(this.view, "Center");
        this.status = new JLabel();
        this.add(this.status, "South");
        DifferenceManager diffs = DifferenceManager.get(this.getOWLModelManager());
        diffs.addDifferenceListener(this.listener);
        this.updateStatus();
    }

    protected void disposeOWLView() {
        DifferenceManager diffs = DifferenceManager.get(this.getOWLModelManager());
        diffs.removeDifferenceListener(this.listener);
        try {
            if (this.view != null) {
                this.view.dispose();
            }
        }
        catch (Exception e) {
            ProtegeApplication.getErrorLog().logError((Throwable)e);
        }
    }

    private void updateStatus() {
        DifferenceManager diffs = DifferenceManager.get(this.getOWLModelManager());
        if (diffs.isReady()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Displaying differences.  ");
            sb.append(Util.getStats((Engine)diffs.getEngine()));
            this.status.setText(sb.toString());
        } else {
            this.status.setText("Differences not ready");
        }
    }
}

