/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.ui.render;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.protege.editor.owl.diff.model.DifferenceManager;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.present.algorithms.IdentifyDeprecatedEntity;
import org.protege.owl.diff.service.RenderingService;

public class EntityBasedDiffRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -2257588249282053158L;
    private DifferenceManager diffs;

    public EntityBasedDiffRenderer(DifferenceManager diffs) {
        this.diffs = diffs;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel text = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof EntityBasedDiff) {
            RenderingService renderer = RenderingService.get((Engine)this.diffs.getEngine());
            EntityBasedDiff diff = (EntityBasedDiff)value;
            StringBuffer sb = new StringBuffer();
            this.appendHtmlHeader(sb, diff);
            sb.append(renderer.renderDiff(diff));
            this.appendHtmlFooter(sb, diff);
            text.setText(sb.toString());
        }
        return this;
    }

    private void appendHtmlHeader(StringBuffer sb, EntityBasedDiff diff) {
        sb.append("<html><body>");
        switch (diff.getDiffType()) {
            case CREATED: {
                sb.append("<font color=\"blue\">");
                break;
            }
            case DELETED: {
                sb.append("<strike>");
            }
        }
    }

    private void appendHtmlFooter(StringBuffer sb, EntityBasedDiff diff) {
        switch (diff.getDiffType()) {
            case CREATED: {
                sb.append("</font>");
                break;
            }
            case DELETED: {
                sb.append("</strike>");
            }
        }
        if (this.isDeprecation(diff)) {
            sb.append("<sup><b>D</b></sup>");
        }
        sb.append("</body></html>");
    }

    private boolean isDeprecation(EntityBasedDiff diff) {
        for (MatchedAxiom match : diff.getAxiomMatches()) {
            if (!match.getDescription().equals((Object)IdentifyDeprecatedEntity.AXIOM_IS_DEPRECATION)) continue;
            return true;
        }
        return false;
    }
}

