/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.ui.boot;

import java.util.UUID;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.diff.model.DifferenceEvent;
import org.protege.editor.owl.diff.model.DifferenceListener;
import org.protege.editor.owl.diff.model.DifferenceManager;
import org.protege.editor.owl.model.selection.OWLSelectionModel;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.semanticweb.owlapi.model.OWLEntity;

public class SynchronizeDifferenceListener
implements DifferenceListener,
Disposable {
    private DifferenceManager differenceManager;
    private OWLEditorKit eKit;
    private boolean isTarget;

    public static void synchronize(DifferenceManager differenceManager, OWLEditorKit eKit, boolean isTarget) {
        differenceManager.addDifferenceListener(new SynchronizeDifferenceListener(differenceManager, eKit, isTarget));
    }

    public SynchronizeDifferenceListener(DifferenceManager differenceManager, OWLEditorKit eKit, boolean isTarget) {
        this.differenceManager = differenceManager;
        this.eKit = eKit;
        this.isTarget = isTarget;
        eKit.put((Object)UUID.randomUUID(), (Disposable)this);
    }

    @Override
    public void statusChanged(DifferenceEvent event) {
        switch (event) {
            case SELECTION_CHANGED: {
                OWLEntity targetEntity;
                OWLSelectionModel selectionModel = this.eKit.getOWLWorkspace().getOWLSelectionModel();
                EntityBasedDiff diff = this.differenceManager.getSelection();
                if (diff == null) {
                    return;
                }
                OWLEntity oWLEntity = targetEntity = this.isTarget ? diff.getTargetEntity() : diff.getSourceEntity();
                if (targetEntity == null) break;
                selectionModel.setSelectedEntity(targetEntity);
                break;
            }
            case DIFF_RESET: {
                this.differenceManager.removeDifferenceListener(this);
            }
        }
    }

    public void dispose() {
        this.differenceManager.removeDifferenceListener(this);
    }
}

