/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.ui.boot;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.ProgressMonitor;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.diff.model.DifferenceManager;
import org.protege.editor.owl.diff.ui.DifferenceDialog;
import org.protege.editor.owl.diff.ui.boot.ConfigureDifferenceRun;
import org.protege.editor.owl.diff.ui.boot.OntologyInAltWorkspaceFactory;
import org.protege.editor.owl.diff.ui.boot.SynchronizeDifferenceListener;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.conf.Configuration;
import org.protege.owl.diff.service.RenderingService;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;

public class StartDiff
extends ProtegeOWLAction {
    private static final long serialVersionUID = -5400122637724517976L;

    public static RenderingService getRenderingService(OWLModelManager modelManager) {
        DifferenceManager differenceManager = DifferenceManager.get(modelManager);
        return RenderingService.get((Engine)differenceManager.getEngine());
    }

    public static OWLEditorKit getAltEditorKit(OWLModelManager p4Manager) {
        OntologyInAltWorkspaceFactory factory = (OntologyInAltWorkspaceFactory)p4Manager.get(OntologyInAltWorkspaceFactory.class);
        return factory != null ? factory.getAltEditorKit() : null;
    }

    public void initialise() {
    }

    public void dispose() {
    }

    public void actionPerformed(ActionEvent e) {
        ConfigureDifferenceRun confWindow = new ConfigureDifferenceRun(this.getOWLEditorKit());
        confWindow.setLocation(new Point(200, 200));
        confWindow.setVisible(true);
        final IRI f = confWindow.getBaseline();
        final boolean loadInSeparateWorkspace = confWindow.getOpenBaselineInSeparateWindow();
        final Configuration configuration = confWindow.getConfiguration();
        if (confWindow.isCommit() && f != null) {
            final ProgressMonitor monitor = new ProgressMonitor((Component)this.getOWLWorkspace(), "Calculating Differences", "", 0, 2);
            monitor.setMillisToPopup(100);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    StartDiff.this.calculateDiffs(f, configuration, monitor, loadInSeparateWorkspace);
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateDiffs(IRI baselineOntologyLocation, Configuration configuration, ProgressMonitor monitor, boolean loadInSeparateWorkspace) {
        try {
            monitor.setNote("Loading ontology for comparison");
            OntologyInAltWorkspaceFactory factory = new OntologyInAltWorkspaceFactory(this.getOWLEditorKit(), loadInSeparateWorkspace);
            OWLOntology baselineOntology = factory.loadInSeparateSynchronizedWorkspace(baselineOntologyLocation);
            this.getOWLEditorKit().getModelManager().put(OntologyInAltWorkspaceFactory.class, (Disposable)factory);
            monitor.setProgress(1);
            monitor.setNote("Calculating differences");
            DifferenceManager diffs = DifferenceManager.get(this.getOWLModelManager());
            diffs.run(baselineOntology, configuration);
            monitor.setProgress(2);
            if (loadInSeparateWorkspace) {
                SynchronizeDifferenceListener.synchronize(diffs, factory.getAltEditorKit(), false);
                diffs.getEngine().addService((Object)factory);
            }
            SynchronizeDifferenceListener.synchronize(diffs, this.getOWLEditorKit(), true);
            this.showDiffs();
        }
        catch (Throwable t) {
            ProtegeApplication.getErrorLog().logError(t);
        }
        finally {
            monitor.close();
        }
    }

    private void showDiffs() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        DifferenceDialog dialog = new DifferenceDialog(this.getOWLEditorKit());
        dialog.setLocation(new Point(100, 100));
        dialog.pack();
        dialog.setSize(new Dimension(1000, 500));
        dialog.setVisible(true);
    }
}

