/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.ui.boot;

import java.awt.Component;
import java.awt.Point;
import java.util.UUID;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.OWLEditorKitFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OntologyInAltWorkspaceFactory
implements Disposable {
    public static final Logger LOGGER = Logger.getLogger(OntologyInAltWorkspaceFactory.class);
    private OWLEditorKit eKit;
    private OWLEditorKit altEditorKit;
    private boolean display;

    public OntologyInAltWorkspaceFactory(OWLEditorKit eKit, boolean display) {
        this.eKit = eKit;
        this.display = display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLOntology loadInSeparateSynchronizedWorkspace(IRI ontologyLocation) throws OWLOntologyCreationException {
        long startTime = System.currentTimeMillis();
        try {
            this.altEditorKit = (OWLEditorKit)((OWLEditorKitFactory)this.eKit.getEditorKitFactory()).createEditorKit();
        }
        catch (Exception e) {
            throw new OWLOntologyCreationException("Could not create editor kit", (Throwable)e);
        }
        OWLOntology ontology = null;
        try {
            ontology = this.loadOntology(this.altEditorKit.getOWLModelManager().getOWLOntologyManager(), ontologyLocation);
        }
        finally {
            if (ontology == null) {
                this.altEditorKit.dispose();
            }
        }
        this.altEditorKit.getOWLModelManager().setActiveOntology(ontology);
        this.altEditorKit.put((Object)UUID.randomUUID(), (Disposable)this);
        if (this.display) {
            ProtegeManager.getInstance().getEditorKitManager().addEditorKit((EditorKit)this.altEditorKit);
            this.altEditorKit.getOWLWorkspace().setTitle("Workspace for original version of ontology");
            Point originalPoint = SwingUtilities.getAncestorOfClass(JFrame.class, (Component)this.eKit.getWorkspace()).getLocation();
            Point newPoint = new Point(originalPoint.x + 60, originalPoint.y + 20);
            SwingUtilities.getAncestorOfClass(JFrame.class, (Component)this.altEditorKit.getOWLWorkspace()).setLocation(newPoint);
        }
        this.eKit.getOWLWorkspace().requestFocusInWindow();
        LOGGER.info((Object)("Ontology load took " + (System.currentTimeMillis() - startTime) + "ms."));
        return ontology;
    }

    protected OWLOntology loadOntology(OWLOntologyManager manager, IRI ontologyLocation) throws OWLOntologyCreationException {
        return manager.loadOntologyFromOntologyDocument(ontologyLocation);
    }

    public OWLEditorKit getAltEditorKit() {
        return this.altEditorKit;
    }

    public void dispose() {
        this.eKit = null;
        this.altEditorKit = null;
    }
}

