/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.ui.boot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.diff.DifferenceActivator;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.owl.diff.align.AlignmentAggressiveness;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.align.algorithms.DeferDeprecationAlgorithm;
import org.protege.owl.diff.conf.Configuration;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLOntology;

public class ConfigureDifferenceRun
extends JDialog {
    private static final long serialVersionUID = -2882654202196117453L;
    private OWLEditorKit eKit;
    private JTextField baselineTextField;
    private JCheckBox openBaselineInSeparateWindow;
    private JCheckBox doDeprecationAndReplace;
    private JComboBox aggressiveness;
    private boolean ok = false;

    public ConfigureDifferenceRun(OWLEditorKit eKit) {
        super((Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)eKit.getOWLWorkspace()), true);
        this.eKit = eKit;
        this.createGui();
        this.pack();
    }

    public IRI getBaseline() {
        String baseline = this.baselineTextField.getText();
        File baselineFile = new File(baseline);
        if (baselineFile.exists()) {
            return IRI.create((File)baselineFile);
        }
        return IRI.create((String)baseline);
    }

    public boolean getOpenBaselineInSeparateWindow() {
        return this.openBaselineInSeparateWindow.isSelected();
    }

    public boolean isCommit() {
        return this.ok;
    }

    public Configuration getConfiguration() {
        Configuration config = new Configuration();
        AlignmentAggressiveness requestedEffort = (AlignmentAggressiveness)this.aggressiveness.getSelectedItem();
        for (Class<? extends AlignmentAlgorithm> clazz : DifferenceActivator.createAlignmentAlgorithms()) {
            try {
                AlignmentAlgorithm algorithm = clazz.newInstance();
                if (algorithm.isCustom() || algorithm.getAggressiveness().compareTo((Enum)requestedEffort) > 0) continue;
                config.addAlignmentAlgorithm(clazz);
            }
            catch (Exception e) {
                ProtegeApplication.getErrorLog().logError((Throwable)e);
            }
        }
        if (this.doDeprecationAndReplace.isSelected()) {
            config.addAlignmentAlgorithm(DeferDeprecationAlgorithm.class);
        }
        for (Class<? extends AlignmentAlgorithm> clazz : DifferenceActivator.createPresentationAlgorithms()) {
            config.addPresentationAlgorithm(clazz);
        }
        return config;
    }

    private void createGui() {
        this.setLayout(new BorderLayout());
        this.addCenterPanel();
        this.addButtons();
        this.updateDeprecateAndReplaceStatus();
    }

    private void addCenterPanel() {
        JPanel centerPanel = new JPanel();
        GridLayout layout = new GridLayout(0, 1);
        centerPanel.setLayout(layout);
        centerPanel.setAlignmentY(0.0f);
        centerPanel.add(this.createFilePanel());
        centerPanel.add(this.createOpenInSeparateWorkspace());
        centerPanel.add(this.createDeprecateAndReplace());
        centerPanel.add(this.chooseAggressivenessDropdown());
        this.add((Component)centerPanel, "Center");
    }

    private JPanel createFilePanel() {
        JPanel panel = new JPanel(new FlowLayout());
        panel.setAlignmentY(0.0f);
        JLabel label = new JLabel("Original Version: ");
        label.setAlignmentY(0.0f);
        panel.add(label);
        this.baselineTextField = new JTextField();
        this.baselineTextField.setEditable(true);
        Dimension preferredTextFieldDimension = new JTextField("Thesaurus-101129-10.11e.owl").getPreferredSize();
        this.baselineTextField.setPreferredSize(preferredTextFieldDimension);
        this.baselineTextField.setEditable(true);
        panel.add(this.baselineTextField);
        JButton browseForBaseline = new JButton("Browse");
        panel.add(browseForBaseline);
        browseForBaseline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIHelper utility = new UIHelper(ConfigureDifferenceRun.this.eKit);
                File f = utility.chooseOWLFile("Choose the baseline ontology");
                if (f != null) {
                    ConfigureDifferenceRun.this.baselineTextField.setText(f.getAbsolutePath());
                }
            }
        });
        panel.setAlignmentY(0.0f);
        return panel;
    }

    private JComponent createDeprecateAndReplace() {
        JPanel panel = new JPanel(new FlowLayout());
        panel.setAlignmentY(0.0f);
        this.doDeprecationAndReplace = new JCheckBox("Search for the deprecate and replace pattern");
        this.doDeprecationAndReplace.setAlignmentY(0.0f);
        panel.add(this.doDeprecationAndReplace);
        return panel;
    }

    private JComponent createOpenInSeparateWorkspace() {
        JPanel panel = new JPanel(new FlowLayout());
        panel.setAlignmentY(0.0f);
        this.openBaselineInSeparateWindow = new JCheckBox("Open original ontology in separate workspace");
        this.openBaselineInSeparateWindow.setAlignmentY(0.0f);
        panel.add(this.openBaselineInSeparateWindow);
        return panel;
    }

    private Set<OWLAnnotationProperty> getAnnotationProperties() {
        HashSet<OWLAnnotationProperty> annotationProperties = new HashSet<OWLAnnotationProperty>();
        Set ontologies = this.eKit.getOWLModelManager().getActiveOntologies();
        for (OWLOntology ontology : ontologies) {
            annotationProperties.addAll(ontology.getAnnotationPropertiesInSignature());
        }
        return annotationProperties;
    }

    private JComponent chooseAggressivenessDropdown() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.setAlignmentY(0.0f);
        this.aggressiveness = new JComboBox();
        this.aggressiveness.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 6340827743615126160L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel rendering = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                rendering.setText(((AlignmentAggressiveness)value).getDescription());
                return rendering;
            }
        });
        for (AlignmentAggressiveness effort : AlignmentAggressiveness.values()) {
            this.aggressiveness.addItem(effort);
        }
        this.aggressiveness.setSelectedItem(AlignmentAggressiveness.IGNORE_REFACTOR);
        this.aggressiveness.setAlignmentY(0.0f);
        panel.add(this.aggressiveness);
        this.aggressiveness.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureDifferenceRun.this.updateDeprecateAndReplaceStatus();
            }
        });
        return panel;
    }

    private void updateDeprecateAndReplaceStatus() {
        this.doDeprecationAndReplace.setEnabled(this.aggressiveness.getSelectedItem() != AlignmentAggressiveness.IGNORE_REFACTOR);
    }

    private void addButtons() {
        JPanel panel = new JPanel(new FlowLayout());
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureDifferenceRun.this.ok = true;
                ConfigureDifferenceRun.this.setVisible(false);
            }
        });
        panel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureDifferenceRun.this.ok = false;
                ConfigureDifferenceRun.this.setVisible(false);
            }
        });
        panel.add(cancelButton);
        this.add((Component)panel, "South");
    }
}

