/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.owl.diff.model.DifferenceEvent;
import org.protege.editor.owl.diff.model.DifferenceListener;
import org.protege.editor.owl.diff.model.DifferenceManager;
import org.protege.editor.owl.diff.ui.DifferenceTable;
import org.protege.editor.owl.diff.ui.DifferenceTableModel;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.MatchedAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;

public class UnattachedDifferencesPanel
extends JPanel {
    private static final long serialVersionUID = 4039090974349587237L;
    private DifferenceManager differenceManager;
    private DifferenceTableModel model;
    private DifferenceListener listener = new DifferenceListener(){

        @Override
        public void statusChanged(DifferenceEvent event) {
            switch (event) {
                case DIFF_COMPLETED: {
                    UnattachedDifferencesPanel.this.updateModel();
                    break;
                }
                case DIFF_RESET: {
                    UnattachedDifferencesPanel.this.model.clear();
                }
            }
        }
    };

    public UnattachedDifferencesPanel(DifferenceManager differenceManager) {
        this.setLayout(new BorderLayout());
        this.differenceManager = differenceManager;
        this.model = new DifferenceTableModel(differenceManager);
        this.add((Component)new JScrollPane(new DifferenceTable(this.model)), "Center");
        differenceManager.addDifferenceListener(this.listener);
        if (differenceManager.isReady()) {
            this.updateModel();
        }
    }

    private void updateModel() {
        this.model.setMatches(this.getUnattachedMatchedAxioms(this.differenceManager));
    }

    private SortedSet<MatchedAxiom> getUnattachedMatchedAxioms(DifferenceManager differenceManager) {
        Changes changes = differenceManager.getEngine().getChanges();
        TreeSet<MatchedAxiom> matches = new TreeSet<MatchedAxiom>();
        for (OWLAxiom axiom : changes.getUnmatchedSourceAxiomsWithNoSubject()) {
            matches.add(new MatchedAxiom(axiom, null, MatchedAxiom.AXIOM_DELETED));
        }
        for (OWLAxiom axiom : changes.getUnmatchedTargetAxiomsWithNoSubject()) {
            matches.add(new MatchedAxiom(null, axiom, MatchedAxiom.AXIOM_ADDED));
        }
        return matches;
    }

    public void dispose() {
        this.differenceManager.removeDifferenceListener(this.listener);
        this.differenceManager = null;
        this.model = null;
    }
}

