/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.ui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.owl.diff.model.DifferenceEvent;
import org.protege.editor.owl.diff.model.DifferenceListener;
import org.protege.editor.owl.diff.model.DifferenceManager;
import org.protege.editor.owl.diff.model.EntityBasedDiffComparator;
import org.protege.editor.owl.diff.ui.render.EntityBasedDiffRenderer;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.service.RenderingService;
import org.semanticweb.owlapi.model.OWLObject;

public class Finder
extends JPanel {
    private DifferenceManager differenceManager;
    private JButton findButton;
    private JTextField text;
    private DifferenceListener listener = new DifferenceListener(){

        @Override
        public void statusChanged(DifferenceEvent event) {
            Finder.this.setEnabled(Finder.this.differenceManager.isReady());
        }
    };

    public Finder(DifferenceManager differenceManager) {
        this.setLayout(new FlowLayout());
        this.differenceManager = differenceManager;
        this.findButton = new JButton("Find");
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Finder.this.doFind();
            }
        });
        this.add(this.findButton);
        this.text = new JTextField();
        this.text.setPreferredSize(new JTextField("DNA topoisomerase type 1 activity").getPreferredSize());
        this.add(this.text);
        this.setEnabled(differenceManager.isReady());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
        this.findButton.setEnabled(enabled);
    }

    private void doFind() {
        Changes changes = this.differenceManager.getEngine().getChanges();
        RenderingService renderer = RenderingService.get((Engine)this.differenceManager.getEngine());
        String toMatch = ".*" + this.text.getText() + ".*";
        ArrayList<EntityBasedDiff> diffs = new ArrayList<EntityBasedDiff>();
        for (EntityBasedDiff diff : changes.getEntityBasedDiffs()) {
            if (diff.getSourceEntity() != null && renderer.renderSourceObject((OWLObject)diff.getSourceEntity()).matches(toMatch)) {
                diffs.add(diff);
                continue;
            }
            if (diff.getTargetEntity() == null || !renderer.renderTargetObject((OWLObject)diff.getTargetEntity()).matches(toMatch)) continue;
            diffs.add(diff);
        }
        Collections.sort(diffs, new EntityBasedDiffComparator(renderer));
        JDialog dialog = new JDialog();
        dialog.setTitle("Find: " + this.text.getText());
        dialog.add(new JScrollPane(this.createSwingList(diffs)));
        dialog.setLocation(new Point(30, 30));
        dialog.setMinimumSize(new Dimension(30, 100));
        dialog.pack();
        dialog.setVisible(true);
    }

    private JList createSwingList(List<EntityBasedDiff> diffs) {
        final JList<Object> swingList = new JList<Object>();
        DefaultListModel<EntityBasedDiff> model = new DefaultListModel<EntityBasedDiff>();
        swingList.setModel(model);
        swingList.setSelectionModel(new DefaultListSelectionModel());
        swingList.setCellRenderer(new EntityBasedDiffRenderer(this.differenceManager));
        swingList.setSelectionMode(0);
        swingList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object o = swingList.getSelectedValue();
                if (o instanceof EntityBasedDiff) {
                    EntityBasedDiff diff = (EntityBasedDiff)o;
                    Finder.this.differenceManager.setSelection(diff);
                }
            }
        });
        for (EntityBasedDiff diff : diffs) {
            model.addElement(diff);
        }
        return swingList;
    }

    public void dispose() {
        this.differenceManager.removeDifferenceListener(this.listener);
        this.differenceManager = null;
        this.text = null;
    }
}

