/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.diff.model.DifferenceEvent;
import org.protege.editor.owl.diff.model.DifferenceListener;
import org.protege.editor.owl.diff.model.DifferenceManager;
import org.protege.editor.owl.diff.model.EntityBasedDiffComparator;
import org.protege.editor.owl.diff.ui.DifferenceTable;
import org.protege.editor.owl.diff.ui.DifferenceTableModel;
import org.protege.editor.owl.diff.ui.boot.StartDiff;
import org.protege.editor.owl.diff.ui.render.EntityBasedDiffRenderer;
import org.protege.owl.diff.align.AlignmentExplanation;
import org.protege.owl.diff.align.OwlDiffMap;
import org.protege.owl.diff.present.Changes;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.service.RenderingService;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class DifferencesByEntity
extends JPanel
implements Disposable {
    private static final long serialVersionUID = -3297368551819068585L;
    private OWLEditorKit editorKit;
    private DifferenceManager diffs;
    private DifferenceTableModel diffModel;
    private JList entityBasedDiffList;
    private JPanel differenceTablePanel;
    private JPanel explanationPanel;
    private boolean synchronizing = true;
    private DifferenceListener diffListener = new DifferenceListener(){

        @Override
        public void statusChanged(DifferenceEvent event) {
            if (event == DifferenceEvent.DIFF_COMPLETED) {
                DifferencesByEntity.this.fillEntityBasedDiffList();
            } else if (event == DifferenceEvent.DIFF_RESET) {
                DifferencesByEntity.this.entityBasedDiffList.removeAll();
                DifferencesByEntity.this.diffModel.clear();
            } else if (event == DifferenceEvent.SELECTION_CHANGED && DifferencesByEntity.this.isSynchronizing()) {
                this.globalDiffSelectionChanged();
            }
        }

        private void globalDiffSelectionChanged() {
            EntityBasedDiff diff = DifferencesByEntity.this.diffs.getSelection();
            if (diff != null) {
                DifferencesByEntity.this.entityBasedDiffList.setSelectedValue(diff, true);
                DifferencesByEntity.this.setDiffModelMatches(diff);
            }
        }
    };

    public DifferencesByEntity(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.setLayout(new BorderLayout());
        this.diffs = DifferenceManager.get(editorKit.getModelManager());
        this.add((Component)this.createDifferenceListComponent(), "West");
        this.add((Component)this.createDifferenceTable(), "Center");
        if (this.diffs.isReady()) {
            this.fillEntityBasedDiffList();
        }
        this.diffs.addDifferenceListener(this.diffListener);
    }

    public boolean isSynchronizing() {
        return this.synchronizing;
    }

    public void setSynchronizing(boolean synchronizing) {
        Object o;
        this.synchronizing = synchronizing;
        if (synchronizing && (o = this.entityBasedDiffList.getSelectedValue()) instanceof EntityBasedDiff) {
            EntityBasedDiff diff = (EntityBasedDiff)o;
            this.diffs.setSelection(diff);
        }
    }

    private void fillEntityBasedDiffList() {
        RenderingService renderer = StartDiff.getRenderingService(this.editorKit.getModelManager());
        Changes changes = this.diffs.getEngine().getChanges();
        final DefaultListModel model = (DefaultListModel)this.entityBasedDiffList.getModel();
        final ArrayList listOfDiffs = new ArrayList(changes.getEntityBasedDiffs());
        Collections.sort(listOfDiffs, new EntityBasedDiffComparator(renderer));
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    model.clear();
                    for (EntityBasedDiff diff : listOfDiffs) {
                        model.addElement(diff);
                    }
                    DifferencesByEntity.this.entityBasedDiffList.repaint();
                }
            });
        }
        catch (Exception e) {
            ProtegeApplication.getErrorLog().logError((Throwable)e);
        }
    }

    private JComponent createDifferenceListComponent() {
        this.entityBasedDiffList = new JList();
        this.entityBasedDiffList.setModel(new DefaultListModel());
        this.entityBasedDiffList.setSelectionModel(new DefaultListSelectionModel());
        this.entityBasedDiffList.setCellRenderer(new EntityBasedDiffRenderer(this.diffs));
        this.entityBasedDiffList.setSelectionMode(0);
        this.entityBasedDiffList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object o = DifferencesByEntity.this.entityBasedDiffList.getSelectedValue();
                if (o instanceof EntityBasedDiff) {
                    EntityBasedDiff diff = (EntityBasedDiff)o;
                    if (DifferencesByEntity.this.isSynchronizing()) {
                        DifferencesByEntity.this.diffs.setSelection(diff);
                    } else {
                        DifferencesByEntity.this.setDiffModelMatches(diff);
                    }
                }
            }
        });
        Dimension textSize = new JLabel("Modified CheeseyPizza -> CheeseyPizza").getPreferredSize();
        JScrollPane pane = new JScrollPane(this.entityBasedDiffList);
        pane.setPreferredSize(new Dimension((int)textSize.getWidth(), (int)(100.0 * textSize.getHeight())));
        return pane;
    }

    private JComponent createDifferenceTable() {
        this.differenceTablePanel = new JPanel();
        this.differenceTablePanel.setLayout(new BorderLayout());
        this.differenceTablePanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.explanationPanel = new JPanel(new BorderLayout());
        this.explanationPanel.setAlignmentX(0.0f);
        this.differenceTablePanel.add((Component)this.explanationPanel, "North");
        this.diffModel = new DifferenceTableModel(this.diffs);
        this.differenceTablePanel.add((Component)new JScrollPane(new DifferenceTable(this.diffModel)), "Center");
        return this.differenceTablePanel;
    }

    private void setDiffModelMatches(EntityBasedDiff diff) {
        this.explanationPanel.removeAll();
        this.diffModel.setMatches(diff.getAxiomMatches());
        OWLEntity sourceEntity = diff.getSourceEntity();
        if (sourceEntity != null) {
            OwlDiffMap diffMap = this.diffs.getEngine().getOwlDiffMap();
            this.addGenericExplanation(diffMap, diff, sourceEntity);
        } else {
            this.addDeprecateAndReplaceExplanation(diff);
        }
        this.differenceTablePanel.validate();
        this.differenceTablePanel.repaint();
    }

    private void addGenericExplanation(OwlDiffMap diffMap, EntityBasedDiff diff, final OWLEntity sourceEntity) {
        final AlignmentExplanation explanation = diffMap.getExplanation(sourceEntity);
        if (explanation != null) {
            JLabel label = new JLabel(explanation.getExplanation());
            this.explanationPanel.add((Component)label, "West");
            if (explanation.hasDetailedExplanation((OWLObject)sourceEntity)) {
                JButton detailsButton = new JButton("Details...");
                detailsButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JDialog dialog = new JDialog();
                        dialog.setTitle("Detailed explanation");
                        JTextPane detailsPane = new JTextPane();
                        detailsPane.setText(explanation.getDetailedExplanation((OWLObject)sourceEntity));
                        detailsPane.setEditable(false);
                        dialog.add(detailsPane);
                        dialog.setLocation(new Point(40, 40));
                        dialog.pack();
                        dialog.setVisible(true);
                    }
                });
                this.explanationPanel.add((Component)detailsButton, "East");
            }
        }
    }

    private void addDeprecateAndReplaceExplanation(final EntityBasedDiff diff) {
        if (diff.getDiffTypeDescription().equals("Deprecated and replaced")) {
            JButton explain = new JButton("Explain This!");
            this.explanationPanel.add((Component)explain, "East");
            explain.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DifferencesByEntity.this.explainDeprecateAndReplace(diff);
                }
            });
        }
    }

    private void explainDeprecateAndReplace(EntityBasedDiff diff) {
        RenderingService renderer = StartDiff.getRenderingService(this.editorKit.getModelManager());
        OWLEntity deprecatedEntity = diff.getTargetEntity();
        final EntityBasedDiff altDiff = (EntityBasedDiff)this.diffs.getEngine().getChanges().getSourceDiffMap().get(deprecatedEntity);
        OWLEntity replacementEntity = altDiff.getTargetEntity();
        final JDialog dialog = new JDialog();
        dialog.setDefaultCloseOperation(2);
        dialog.setLocation(this.getLocation());
        JPanel panel = new JPanel(new BorderLayout());
        JTextArea explanationText = new JTextArea();
        explanationText.setLineWrap(true);
        explanationText.setWrapStyleWord(true);
        explanationText.setText(this.generateDeprecateAndReplaceText(renderer, deprecatedEntity, replacementEntity));
        panel.add((Component)explanationText, "North");
        DifferenceTableModel myModel = new DifferenceTableModel(this.diffs);
        myModel.setMatches(altDiff.getAxiomMatches());
        panel.add((Component)new JScrollPane(new DifferenceTable(myModel)), "Center");
        JPanel bottomButtons = new JPanel(new FlowLayout(1));
        JButton jumpToDiff = new JButton("Jump There");
        jumpToDiff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DifferencesByEntity.this.diffs.setSelection(altDiff);
                if (DifferencesByEntity.this.isSynchronizing()) {
                    dialog.dispose();
                }
            }
        });
        bottomButtons.add(jumpToDiff);
        panel.add((Component)bottomButtons, "South");
        dialog.add(panel);
        dialog.pack();
        dialog.setVisible(true);
    }

    public String generateDeprecateAndReplaceText(RenderingService renderer, OWLEntity deprecatedEntity, OWLEntity replacementEntity) {
        StringBuffer sb = new StringBuffer();
        sb.append("At some point the entity, ");
        sb.append(renderer.renderSourceObject((OWLObject)deprecatedEntity));
        sb.append(", was deprecated and replaced with a new entity, ");
        sb.append(renderer.renderTargetObject((OWLObject)replacementEntity));
        sb.append(".  The difference engine has detected this and responded by mapping the old entity, ");
        sb.append(renderer.renderSourceObject((OWLObject)deprecatedEntity));
        sb.append(", to its replacement, ");
        sb.append(renderer.renderTargetObject((OWLObject)replacementEntity));
        sb.append(".  This is slightly confusing because it means that in the second ontology the deprecated entity, ");
        sb.append(renderer.renderSourceObject((OWLObject)deprecatedEntity));
        sb.append(", and its axioms appear to be new.\n\nThe explanation provided for why ");
        sb.append(renderer.renderSourceObject((OWLObject)deprecatedEntity));
        sb.append(" maps to ");
        sb.append(renderer.renderTargetObject((OWLObject)replacementEntity));
        sb.append(" is \n\n\t");
        sb.append(this.diffs.getEngine().getOwlDiffMap().getExplanation(deprecatedEntity).getExplanation());
        return sb.toString();
    }

    public void dispose() {
        this.diffs.removeDifferenceListener(this.diffListener);
    }
}

