/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import javax.swing.table.AbstractTableModel;
import org.protege.editor.owl.diff.model.DifferenceManager;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.present.MatchedAxiom;
import org.protege.owl.diff.service.RenderingService;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public class DifferenceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1919687859946498484L;
    private DifferenceManager diffs;
    private List<MatchedAxiom> matches = new ArrayList<MatchedAxiom>();

    public DifferenceTableModel(DifferenceManager diffs) {
        this.diffs = diffs;
    }

    public void setMatches(SortedSet<MatchedAxiom> matches) {
        this.matches = new ArrayList<MatchedAxiom>(matches);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public int getRowCount() {
        return this.matches == null ? 0 : this.matches.size();
    }

    public void clear() {
        this.matches.clear();
    }

    @Override
    public String getColumnName(int column) {
        return Column.values()[column].toString();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (Column.values()[col]) {
            case DESCRIPTION: {
                return String.class;
            }
            case SOURCE_AXIOM: 
            case TARGET_AXIOM: {
                return String.class;
            }
        }
        throw new IllegalStateException("Programmer error");
    }

    @Override
    public Object getValueAt(int row, int col) {
        RenderingService renderer = RenderingService.get((Engine)this.diffs.getEngine());
        MatchedAxiom match = this.matches.get(row);
        switch (Column.values()[col]) {
            case DESCRIPTION: {
                return match.getDescription();
            }
            case SOURCE_AXIOM: {
                OWLAxiom axiom = match.getSourceAxiom();
                return axiom == null ? "" : renderer.renderSourceObject((OWLObject)axiom);
            }
            case TARGET_AXIOM: {
                OWLAxiom axiom = match.getTargetAxiom();
                return axiom == null ? "" : renderer.renderTargetObject((OWLObject)axiom);
            }
        }
        throw new IllegalStateException("Programmer error");
    }

    public static enum Column {
        DESCRIPTION("Description"),
        SOURCE_AXIOM("Baseline Axiom"),
        TARGET_AXIOM("New Axiom");

        private String name;

        private Column(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

