/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.diff.model.DifferenceEvent;
import org.protege.editor.owl.diff.model.DifferenceListener;
import org.protege.editor.owl.diff.model.DifferenceManager;
import org.protege.editor.owl.diff.ui.DifferencesByEntity;
import org.protege.editor.owl.diff.ui.Finder;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.util.Util;

public class DifferenceDialog
extends JDialog {
    private static final long serialVersionUID = -7057739761303778176L;
    private DifferenceManager differenceManager;
    private DifferencesByEntity differenceList;
    private JLabel summary;
    private DifferenceListener listener = new DifferenceListener(){

        @Override
        public void statusChanged(DifferenceEvent event) {
            switch (event) {
                case DIFF_RESET: {
                    DifferenceDialog.this.summary.setText("");
                    break;
                }
                case DIFF_COMPLETED: {
                    DifferenceDialog.this.update();
                }
            }
        }
    };

    public DifferenceDialog(OWLEditorKit eKit) {
        this.setLayout(new BorderLayout());
        this.setTitle("Ontology Differences");
        this.differenceManager = DifferenceManager.get(eKit.getModelManager());
        this.add((Component)this.createNorth(), "North");
        this.add((Component)this.createCenter(eKit), "Center");
        this.add((Component)this.createSouth(), "South");
        this.differenceManager.addDifferenceListener(this.listener);
        if (this.differenceManager.isReady()) {
            this.update();
        }
    }

    public JPanel createNorth() {
        JPanel panel = new JPanel(new FlowLayout(2));
        panel.add(new Finder(this.differenceManager));
        return panel;
    }

    public JPanel createCenter(OWLEditorKit eKit) {
        this.differenceList = new DifferencesByEntity(eKit);
        this.differenceList.setSynchronizing(false);
        return this.differenceList;
    }

    public JPanel createSouth() {
        JPanel panel = new JPanel(new BorderLayout());
        this.summary = new JLabel();
        this.summary.setAlignmentX(0.0f);
        panel.add((Component)this.summary, "West");
        final JCheckBox cb = new JCheckBox();
        cb.setAlignmentX(1.0f);
        panel.add((Component)cb, "East");
        cb.setAction(new AbstractAction("Synchronising"){
            private static final long serialVersionUID = -4131922452059512538L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DifferenceDialog.this.differenceList.setSynchronizing(cb.isSelected());
            }
        });
        return panel;
    }

    private void update() {
        this.summary.setText(Util.getStats((Engine)this.differenceManager.getEngine()));
    }

    @Override
    public void dispose() {
        this.differenceManager.removeDifferenceListener(this.listener);
        this.differenceManager = null;
        this.differenceList.dispose();
        this.differenceList = null;
    }
}

