/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.diff.model.DifferenceEvent;
import org.protege.editor.owl.diff.model.DifferenceListener;
import org.protege.editor.owl.diff.ui.boot.ProtegeShortFormProvider;
import org.protege.editor.owl.diff.ui.boot.StartDiff;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.owl.diff.Engine;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.conf.Configuration;
import org.protege.owl.diff.present.EntityBasedDiff;
import org.protege.owl.diff.present.PresentationAlgorithm;
import org.protege.owl.diff.service.RenderingService;
import org.protege.owl.diff.util.StopWatch;
import org.protege.owl.diff.util.Util;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class DifferenceManager
implements Disposable {
    public static final String ID = DifferenceManager.class.getCanonicalName();
    public static final Logger LOGGER = Logger.getLogger(DifferenceManager.class);
    private OWLModelManager manager;
    private OWLOntology workspaceOntology;
    private OWLOntology baselineOntology;
    private Engine engine;
    private Set<DifferenceListener> listeners = new HashSet<DifferenceListener>();
    private EntityBasedDiff selection;
    private List<AlignmentAlgorithm> diffAlgorithms;
    private List<PresentationAlgorithm> presentationAlgorithms;
    private Map<String, String> parameters;

    public static DifferenceManager get(OWLModelManager manager) {
        DifferenceManager configuration = (DifferenceManager)manager.get(DifferenceManager.class);
        if (configuration == null) {
            configuration = new DifferenceManager(manager);
            manager.put(DifferenceManager.class, (Disposable)configuration);
        }
        return configuration;
    }

    private DifferenceManager(OWLModelManager manager) {
        this.manager = manager;
    }

    public void run(OWLOntology baselineOntology, Configuration configuration) throws OWLOntologyCreationException, InstantiationException, IllegalAccessException {
        this.reset();
        this.workspaceOntology = this.manager.getActiveOntology();
        this.baselineOntology = baselineOntology;
        StopWatch stopWatch = new StopWatch(LOGGER);
        LOGGER.info((Object)"Starting Difference calculation...");
        this.engine = new Engine(baselineOntology, this.workspaceOntology);
        this.setupRendering(this.engine);
        configuration.configure(this.engine);
        this.engine.phase1();
        stopWatch.measure();
        LOGGER.info((Object)"Calculating presentation...");
        this.engine.phase2();
        stopWatch.finish();
        this.fireStatusChanged(DifferenceEvent.DIFF_COMPLETED);
        LOGGER.info((Object)("Differences Found: " + Util.getStats((Engine)this.engine)));
    }

    private void setupRendering(Engine e) {
        RenderingService renderer = RenderingService.get((Engine)e);
        renderer.setSourceShortFormProvider((ShortFormProvider)new ProtegeShortFormProvider(StartDiff.getAltEditorKit(this.manager).getModelManager()));
        renderer.setSourceShortFormProvider((ShortFormProvider)new ProtegeShortFormProvider(this.manager));
    }

    public List<AlignmentAlgorithm> getDiffAlgorithms() {
        return this.diffAlgorithms;
    }

    public void setDiffAlgorithms(List<AlignmentAlgorithm> diffAlgorithms) {
        this.diffAlgorithms = diffAlgorithms;
    }

    public List<PresentationAlgorithm> getPresentationAlgorithms() {
        return this.presentationAlgorithms;
    }

    public void setPresentationAlgorithms(List<PresentationAlgorithm> presentationAlgorithms) {
        this.presentationAlgorithms = presentationAlgorithms;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public OWLModelManager getManager() {
        return this.manager;
    }

    public OWLOntology getWorkspaceOntology() {
        return this.workspaceOntology;
    }

    public OWLOntology getBaselineOntology() {
        return this.baselineOntology;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public EntityBasedDiff getSelection() {
        return this.selection;
    }

    public void setSelection(EntityBasedDiff selection) {
        this.selection = selection;
        this.fireStatusChanged(DifferenceEvent.SELECTION_CHANGED);
    }

    public void addDifferenceListener(DifferenceListener listener) {
        this.listeners.add(listener);
    }

    public void removeDifferenceListener(DifferenceListener listener) {
        this.listeners.remove(listener);
    }

    private void fireStatusChanged(DifferenceEvent event) {
        for (DifferenceListener listener : new ArrayList<DifferenceListener>(this.listeners)) {
            try {
                listener.statusChanged(event);
            }
            catch (Exception e) {
                ProtegeApplication.getErrorLog().logError((Throwable)e);
            }
        }
    }

    public boolean isReady() {
        return this.engine != null;
    }

    public void reset() {
        this.fireStatusChanged(DifferenceEvent.DIFF_RESET);
        this.baselineOntology = null;
        this.engine = null;
    }

    public void dispose() {
    }
}

