/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.diff;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ProtegeProperties;
import org.protege.owl.diff.align.AlignmentAlgorithm;
import org.protege.owl.diff.present.PresentationAlgorithm;
import org.protege.owl.diff.util.ClassLoaderWrapper;
import org.protege.owl.diff.util.Util;

public final class DifferenceActivator
implements BundleActivator {
    private static BundleContext context;

    public static List<Class<? extends AlignmentAlgorithm>> createAlignmentAlgorithms() {
        ArrayList<Class<? extends AlignmentAlgorithm>> algorithms = new ArrayList<Class<? extends AlignmentAlgorithm>>();
        for (Bundle b : context.getBundles()) {
            try {
                algorithms.addAll(Util.createDeclaredAlignmentAlgorithms((ClassLoaderWrapper)DifferenceActivator.wrapBundle(b)));
            }
            catch (IOException ioe) {
                ProtegeApplication.getErrorLog().logError((Throwable)ioe);
            }
        }
        return algorithms;
    }

    public static List<Class<? extends PresentationAlgorithm>> createPresentationAlgorithms() {
        ArrayList<Class<? extends PresentationAlgorithm>> algorithms = new ArrayList<Class<? extends PresentationAlgorithm>>();
        for (Bundle b : context.getBundles()) {
            try {
                algorithms.addAll(Util.createDeclaredPresentationAlgorithms((ClassLoaderWrapper)DifferenceActivator.wrapBundle(b)));
            }
            catch (IOException ioe) {
                ProtegeApplication.getErrorLog().logError((Throwable)ioe);
            }
        }
        return algorithms;
    }

    private static ClassLoaderWrapper wrapBundle(final Bundle b) {
        return new ClassLoaderWrapper(){

            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return b.loadClass(name);
            }

            public Enumeration<URL> getResources(String name) throws IOException {
                return b.getResources(name);
            }
        };
    }

    public void start(BundleContext context) {
        DifferenceActivator.context = context;
        ProtegeProperties.getInstance().put((Object)"org.protege.differencecategory", (Object)"Ontology Comparison");
    }

    public void stop(BundleContext context) {
    }
}

