/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import uk.ac.man.cs.mig.util.wizard.WizardEvent;
import uk.ac.man.cs.mig.util.wizard.WizardEventListener;
import uk.ac.man.cs.mig.util.wizard.WizardPage;

public class Wizard
extends JDialog {
    private static final long serialVersionUID = -1208634079248476430L;
    private ArrayList<WizardEventListener> listeners;
    private WizardPage[] pages;
    private JPanel pagePanel;
    private int returnValue = 0;
    public static final int OPTION_CANCEL = 0;
    public static final int OPTION_APPROVE = 1;
    private JButton nextButton;
    private JButton prevButton;
    private JButton cancelButton;
    private String nextText;
    private String prevText;
    private String finishText;
    private String cancelText;
    private int currentPage;
    private boolean ignoreImpendingButtonAction = false;
    private Object userObject;
    private Frame wizardOwner;
    private int NEXT_KEY = 10;
    private int PREV_KEY = 8;

    public Wizard(String title) {
        this((Frame)null, title);
    }

    public Wizard(Frame owner, String title) {
        this(owner, title, "Prev", "Next", "Finish", "Cancel");
    }

    public Wizard(Frame owner, String title, String prevButtonLabel, String nextButtonLabel, String finishButtonLabel, String cancelButtonText) {
        super(owner, title, true);
        this.wizardOwner = owner;
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.listeners = new ArrayList();
        this.nextText = nextButtonLabel;
        this.prevText = prevButtonLabel;
        this.finishText = finishButtonLabel;
        this.cancelText = cancelButtonText;
        this.pagePanel = new JPanel();
        this.createUI();
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Wizard.this.handleKeyEvent(e);
            }
        });
    }

    protected void handleKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == this.NEXT_KEY) {
            if (this.nextButton.isEnabled()) {
                this.nextButtonPressed();
            }
        } else if (keyCode == this.PREV_KEY) {
            if (this.prevButton.isEnabled()) {
                this.prevButtonPressed();
            }
        } else if (keyCode == 27) {
            this.cancelButtonPressed();
        }
    }

    private void createUI() {
        JPanel holder = new JPanel();
        holder.setBorder(new EmptyBorder(12, 12, 12, 12));
        holder.setLayout(new BorderLayout(7, 7));
        this.pagePanel = new JPanel();
        this.pagePanel.setLayout(new CardLayout());
        this.getContentPane().setLayout(new BorderLayout(7, 7));
        holder.add((Component)this.pagePanel, "Center");
        JPanel buttonPanelHolder = new JPanel();
        buttonPanelHolder.setLayout(new FlowLayout(2));
        buttonPanelHolder.add(this.createButtonPanel());
        holder.add((Component)buttonPanelHolder, "South");
        this.getContentPane().add(holder);
    }

    private JComponent createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 0, 7, 7));
        this.nextButton = new JButton(new AbstractAction(this.nextText){
            private static final long serialVersionUID = 7418675241255095162L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Wizard.this.nextButtonPressed();
            }
        });
        this.prevButton = new JButton(new AbstractAction(this.prevText){
            private static final long serialVersionUID = -834311803507939452L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Wizard.this.prevButtonPressed();
            }
        });
        this.cancelButton = new JButton(new AbstractAction(this.cancelText){
            private static final long serialVersionUID = 3724379316615358996L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Wizard.this.cancelButtonPressed();
            }
        });
        buttonPanel.add(this.prevButton);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(this.cancelButton);
        return buttonPanel;
    }

    public void setPages(WizardPage[] pages) {
        int i;
        if (pages == null) {
            throw new NullPointerException("setPages parameter must not be null");
        }
        this.pages = new WizardPage[pages.length];
        for (i = 0; i < pages.length; ++i) {
            this.pages[i] = pages[i];
            this.pages[i].setWizard(this);
            this.pages[i].wizardSet(this);
        }
        this.currentPage = 0;
        this.pagePanel.removeAll();
        for (i = 0; i < pages.length; ++i) {
            this.pagePanel.add((Component)pages[i], pages[i].getName());
        }
        this.firePageChangedEvent();
        this.pack();
        this.setButtonState();
        this.setWizardLocation();
    }

    protected void setWizardLocation() {
        int ownerCentreY;
        int ownerCentreX;
        if (this.wizardOwner != null) {
            ownerCentreX = (int)this.wizardOwner.getBounds().getCenterX();
            ownerCentreY = (int)this.wizardOwner.getBounds().getCenterY();
        } else {
            ownerCentreX = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
            ownerCentreY = Toolkit.getDefaultToolkit().getScreenSize().height / 2;
        }
        this.setLocation(ownerCentreX - this.getSize().width / 2, ownerCentreY - this.getSize().height / 2);
    }

    public int showWizard() {
        if (this.pages == null) {
            throw new NullPointerException("The Wizard does not contain any pages.\nAdd some pages to the Wizard using addPages before calling show Wizard.");
        }
        if (this.pages.length == 0) {
            throw new IndexOutOfBoundsException("The Wizard must contain at least one page.\nAdd some pages to the Wizard using addPages before calling showWizard.");
        }
        this.firstPage();
        super.setVisible(true);
        return this.returnValue;
    }

    protected void nextButtonPressed() {
        if (this.currentPage == this.getNumberOfPages() - 1) {
            this.fireFinishButtonPressedEvent();
            if (!this.ignoreImpendingButtonAction) {
                this.returnValue = 1;
                this.dispose();
            } else {
                this.ignoreImpendingButtonAction = false;
            }
        } else {
            this.fireNextButtonPressedEvent();
            if (!this.ignoreImpendingButtonAction) {
                this.nextPage();
            } else {
                this.ignoreImpendingButtonAction = false;
            }
        }
    }

    protected void prevButtonPressed() {
        this.firePrevButtonPressedEvent();
        if (!this.ignoreImpendingButtonAction) {
            this.prevPage();
        } else {
            this.ignoreImpendingButtonAction = false;
        }
    }

    protected void cancelButtonPressed() {
        this.fireCancelButtonPressedEvent();
        if (!this.ignoreImpendingButtonAction) {
            this.returnValue = 0;
            this.dispose();
        } else {
            this.ignoreImpendingButtonAction = true;
        }
    }

    public int getNumberOfPages() {
        return this.pages.length;
    }

    protected CardLayout getPagePanelLayout() {
        return (CardLayout)this.pagePanel.getLayout();
    }

    public void firstPage() {
        this.currentPage = 0;
        this.getPagePanelLayout().first(this.pagePanel);
        this.setButtonState();
        this.firePageChangedEvent();
    }

    public void nextPage() {
        ++this.currentPage;
        if (this.currentPage > this.pages.length - 1) {
            this.currentPage = this.pages.length - 1;
        } else {
            this.getPagePanelLayout().next(this.pagePanel);
            this.setButtonState();
            this.firePageChangedEvent();
        }
    }

    public void prevPage() {
        --this.currentPage;
        if (this.currentPage < 0) {
            this.currentPage = 0;
        } else {
            this.getPagePanelLayout().previous(this.pagePanel);
            this.setButtonState();
            this.firePageChangedEvent();
        }
    }

    protected void setButtonState() {
        if (this.currentPage == 0) {
            this.prevButton.setEnabled(false);
        } else {
            this.prevButton.setEnabled(true);
        }
        if (this.currentPage == this.getNumberOfPages() - 1) {
            this.nextButton.setText(this.finishText);
        } else {
            this.nextButton.setText(this.nextText);
        }
    }

    public String getPrevButtonLabel() {
        return this.prevText;
    }

    public void setPrevButtonLabel(String label) {
        this.prevText = label;
        this.prevButton.setText(this.prevText);
    }

    public String getNextButtonLabel() {
        return this.nextText;
    }

    public void setNextButtonLabel(String label) {
        this.nextText = label;
        this.setButtonState();
    }

    public String getFinishButtonLabel() {
        return this.finishText;
    }

    public void setFinishButtonLabel(String label) {
        this.finishText = label;
        this.setButtonState();
    }

    public void setNextButtonEnabled(boolean b) {
        this.nextButton.setEnabled(b);
    }

    public void setPrevButtonEnabled(boolean b) {
        this.prevButton.setEnabled(b);
    }

    public void setCurrentPage(String name) {
        for (int i = 0; i < this.pages.length; ++i) {
            if (!this.pages[i].getName().equals(name)) continue;
            this.currentPage = i;
            this.getPagePanelLayout().show(this.pagePanel, name);
            this.firePageChangedEvent();
            this.setButtonState();
        }
    }

    public WizardPage getCurrentPage() {
        return this.pages[this.currentPage];
    }

    public void addWizardListener(WizardEventListener lsnr) {
        this.listeners.add(lsnr);
    }

    public void removeListener(WizardEventListener lsnr) {
        this.listeners.remove(lsnr);
    }

    public void ignoreImpendingButtonAction() {
        this.ignoreImpendingButtonAction = true;
    }

    public void setUserObject(Object obj) {
        this.userObject = obj;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public WizardPage getPage(String pageName) {
        WizardPage page = null;
        for (int i = 0; i < this.pages.length; ++i) {
            if (!this.pages[i].getName().equals(pageName)) continue;
            page = this.pages[i];
            break;
        }
        return page;
    }

    protected void fireNextButtonPressedEvent() {
        WizardEvent evt = new WizardEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).nextPressed(evt);
        }
    }

    protected void firePrevButtonPressedEvent() {
        WizardEvent evt = new WizardEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).prevPressed(evt);
        }
    }

    protected void firePageChangedEvent() {
        WizardEvent evt = new WizardEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).pageChanged(evt);
        }
        this.pages[this.currentPage].pageSelected(this);
    }

    protected void fireFinishButtonPressedEvent() {
        WizardEvent evt = new WizardEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).finishPressed(evt);
        }
    }

    protected void fireCancelButtonPressedEvent() {
        WizardEvent evt = new WizardEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).cancelPressed(evt);
        }
    }
}

