/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.okcanceldialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class OKCancelDialog
extends JDialog {
    private static final long serialVersionUID = -3155387891462538221L;
    JPanel holderPanel;
    JButton approveButton;
    JButton cancelButton;
    public static final int OPTION_APPROVE = 1;
    public static final int OPTION_CANCEL = 2;
    private int retVal = 2;
    private Frame dialogOwner;

    public OKCancelDialog(Frame owner, String title, String approveButtonText, String cancelButtonText) {
        super(owner, title, true);
        this.dialogOwner = owner;
        this.holderPanel = new JPanel(new BorderLayout(7, 7));
        this.holderPanel.setBorder(new EmptyBorder(7, 7, 7, 7));
        this.approveButton = new JButton(approveButtonText);
        this.approveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OKCancelDialog.this.handleOptionApprove();
            }
        });
        this.cancelButton = new JButton(cancelButtonText);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OKCancelDialog.this.handleOptionCancel();
            }
        });
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    OKCancelDialog.this.handleOptionApprove();
                } else if (e.getKeyCode() == 27) {
                    OKCancelDialog.this.handleOptionCancel();
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 0, 7, 7));
        buttonPanel.add(this.approveButton);
        buttonPanel.add(this.cancelButton);
        JPanel buttonPanelHolder = new JPanel(new BorderLayout());
        buttonPanelHolder.add((Component)buttonPanel, "East");
        this.holderPanel.add((Component)buttonPanelHolder, "South");
        this.getContentPane().add(this.holderPanel);
        this.pack();
        this.setDialogLocation();
    }

    protected void setDialogLocation() {
        int ownerCentreY;
        int ownerCentreX;
        if (this.dialogOwner != null) {
            ownerCentreX = (int)this.dialogOwner.getBounds().getCenterX();
            ownerCentreY = (int)this.dialogOwner.getBounds().getCenterY();
        } else {
            ownerCentreX = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
            ownerCentreY = Toolkit.getDefaultToolkit().getScreenSize().height / 2;
        }
        this.setLocation(ownerCentreX - this.getSize().width / 2, ownerCentreY - this.getSize().height / 2);
    }

    protected void handleOptionApprove() {
        this.retVal = 1;
        if (this.validateData()) {
            this.dispose();
        }
    }

    protected void handleOptionCancel() {
        this.retVal = 2;
        this.dispose();
    }

    public void setContent(JComponent content) {
        this.holderPanel.add(content);
        this.pack();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public boolean validateData() {
        return true;
    }
}

