/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.ui.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import uk.ac.man.cs.mig.util.graph.event.ThumbnailViewSourceEvent;
import uk.ac.man.cs.mig.util.graph.event.ThumbnailViewSourceListener;
import uk.ac.man.cs.mig.util.graph.ui.ThumbnailView;
import uk.ac.man.cs.mig.util.graph.ui.ThumbnailViewSource;

public class DefaultThumbnailView
extends ThumbnailView
implements ThumbnailViewSourceListener {
    private static final long serialVersionUID = -8613789722311809917L;
    private ThumbnailViewSource viewSrc;
    private Rectangle sourceViewBounds;
    private double scale;
    Point prevMousePos;

    public DefaultThumbnailView(ThumbnailViewSource viewSrc) {
        this.viewSrc = viewSrc;
        this.viewSrc.addThumbnailViewSourceListener(this);
        this.sourceViewBounds = new Rectangle(viewSrc.getViewBounds());
        this.setPreferredSize(new Dimension(150, 80));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DefaultThumbnailView.this.updateScale();
                DefaultThumbnailView.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                DefaultThumbnailView.this.processMouseDragged(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DefaultThumbnailView.this.prevMousePos = e.getPoint();
            }
        });
        this.updateScale();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.scale, this.scale);
        this.viewSrc.drawThumbnail(g2);
        g2.setColor(Color.LIGHT_GRAY);
        g2.draw(this.sourceViewBounds);
        g2.setColor(Color.RED);
        g2.draw(this.viewSrc.getViewVisibleRect());
    }

    protected void updateScale() {
        double horiScale = (double)this.getWidth() / this.viewSrc.getViewBounds().getWidth();
        double vertScale = (double)this.getHeight() / this.viewSrc.getViewBounds().getHeight();
        this.scale = Math.min(horiScale, vertScale);
    }

    @Override
    public void sourceViewVisibleRectChanged(ThumbnailViewSourceEvent evt) {
        this.repaint();
    }

    @Override
    public void sourceViewContentsChanged(ThumbnailViewSourceEvent evt) {
        this.updateScale();
        this.repaint();
    }

    @Override
    public void sourceViewBoundsChanged(ThumbnailViewSourceEvent evt) {
        this.sourceViewBounds.width = this.viewSrc.getViewBounds().width;
        this.sourceViewBounds.height = this.viewSrc.getViewBounds().height;
        this.updateScale();
        this.repaint();
    }

    protected void processMouseDragged(MouseEvent e) {
        Point curMousePos = e.getPoint();
        Dimension vector = new Dimension(curMousePos.x - this.prevMousePos.x, curMousePos.y - this.prevMousePos.y);
        this.prevMousePos = curMousePos;
        vector.width = (int)((double)vector.width * 1.0 / this.scale);
        vector.height = (int)((double)vector.height * 1.0 / this.scale);
        this.viewSrc.scrollView(vector.width, vector.height);
    }
}

