/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.ui.impl;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import uk.ac.man.cs.mig.util.graph.controller.Controller;
import uk.ac.man.cs.mig.util.graph.graph.Edge;
import uk.ac.man.cs.mig.util.graph.graph.Node;
import uk.ac.man.cs.mig.util.graph.renderer.EdgeRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.NodeRenderer;
import uk.ac.man.cs.mig.util.graph.ui.GraphView;
import uk.ac.man.cs.mig.util.graph.ui.PopupProvider;

public class DefaultGraphView
extends GraphView {
    private static final long serialVersionUID = 5353379644823080882L;
    private Stroke selStroke;
    private int zoomLevel = 100;
    private Color selectionColor = new Color(140, 140, 255);
    private Color backgroundColor = Color.WHITE;
    private PopupProvider popuProv;
    private Object toolTipObject = null;
    public static final int MAXIMUM_ZOOM = 500;
    public static final int MINIMUM_ZOOM = 10;
    public static final int TOOL_TIP_DISMISS_DELAY = 10000;

    public DefaultGraphView(Controller controller, NodeRenderer nodeRenderer, EdgeRenderer edgeRenderer) {
        super(controller);
        if (nodeRenderer == null) {
            throw new NullPointerException("NodeRenderer must not be null");
        }
        if (edgeRenderer == null) {
            throw new NullPointerException("EdgeRenderer must not be null");
        }
        this.selStroke = new BasicStroke(3.0f);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DefaultGraphView.this.displayPopup(e.getPoint());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DefaultGraphView.this.updateTooltipState(e.getPoint());
            }
        });
    }

    @Override
    public void draw(Graphics2D g2, boolean scale, boolean paintSelection, boolean antialias, boolean drawDetail) {
        Shape clip = g2.getClip();
        g2.setColor(this.backgroundColor);
        g2.fill(clip);
        if (this.getGraph() != null) {
            if (scale && this.zoomLevel != 100) {
                g2.scale((double)this.zoomLevel / 100.0, (double)this.zoomLevel / 100.0);
            }
            if (antialias) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            Iterator nodeIt = this.getNodes();
            while (nodeIt.hasNext()) {
                this.controller.getNodeRenderer().renderNode(g2, (Node)nodeIt.next(), !paintSelection, drawDetail);
            }
            Iterator edgeIt = this.getEdges();
            while (edgeIt.hasNext()) {
                this.controller.getEdgeRenderer().renderEdge(g2, (Edge)edgeIt.next(), !paintSelection, drawDetail);
            }
            if (paintSelection) {
                this.controller.getGraphGenerator();
                Object[] selObjects = this.controller.getGraphSelectionModel().getSelectedObjects();
                for (int i = 0; i < selObjects.length; ++i) {
                    Node selNode = this.controller.getGraphGenerator().getNodeForObject(selObjects[i]);
                    if (selNode == null) continue;
                    g2.setColor(this.selectionColor);
                    g2.setStroke(this.selStroke);
                    Rectangle rect = selNode.getShape().getBounds();
                    rect.grow(5, 5);
                    g2.draw(rect);
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.draw(g2, true, true, true, true);
    }

    @Override
    public void setNodeRenderer(NodeRenderer renderer) {
        this.repaint();
    }

    @Override
    public void setEdgeRenderer(EdgeRenderer renderer) {
        this.repaint();
    }

    @Override
    public void setZoomLevel(int percentage) {
        if (percentage >= 500) {
            percentage = 500;
        }
        if (percentage <= 10) {
            percentage = 10;
        }
        this.zoomLevel = percentage;
        this.revalidate();
        this.repaint();
    }

    @Override
    public int getZoomLevel() {
        return this.zoomLevel;
    }

    @Override
    public int getMaximumZoomLevel() {
        return 500;
    }

    @Override
    public int getMinimumZoomLevel() {
        return 10;
    }

    @Override
    public Point pointToZoomedPoint(Point pt) {
        Point convertedPt = new Point(pt);
        convertedPt.x = (int)((double)convertedPt.x * ((double)this.zoomLevel / 100.0));
        convertedPt.y = (int)((double)convertedPt.y * ((double)this.zoomLevel / 100.0));
        return convertedPt;
    }

    @Override
    public Point pointFromZoomedPoint(Point pt) {
        Point convertedPt = new Point(pt);
        convertedPt.x = (int)((double)convertedPt.x * (100.0 / (double)this.zoomLevel));
        convertedPt.y = (int)((double)convertedPt.y * (100.0 / (double)this.zoomLevel));
        return convertedPt;
    }

    @Override
    public Dimension dimensionToZoomedDimension(Dimension dim) {
        Dimension convertedDim = new Dimension(dim);
        convertedDim.width = (int)((double)convertedDim.width * ((double)this.zoomLevel / 100.0));
        convertedDim.height = (int)((double)convertedDim.height * ((double)this.zoomLevel / 100.0));
        return convertedDim;
    }

    @Override
    public Dimension dimensionFromZoomedDimension(Dimension dim) {
        Dimension convertedDim = new Dimension(dim);
        convertedDim.width = (int)((double)convertedDim.width * (100.0 / (double)this.zoomLevel));
        convertedDim.height = (int)((double)convertedDim.height * (100.0 / (double)this.zoomLevel));
        return convertedDim;
    }

    @Override
    public Rectangle rectangleToZoomedRectangle(Rectangle rect) {
        Rectangle convertedRect = new Rectangle(rect);
        convertedRect.x = (int)((double)convertedRect.x * ((double)this.zoomLevel / 100.0));
        convertedRect.y = (int)((double)convertedRect.y * ((double)this.zoomLevel / 100.0));
        convertedRect.width = (int)((double)convertedRect.width * ((double)this.zoomLevel / 100.0));
        convertedRect.height = (int)((double)convertedRect.height * ((double)this.zoomLevel / 100.0));
        return convertedRect;
    }

    @Override
    public Rectangle rectangleFromZoomedRectangle(Rectangle rect) {
        Rectangle convertedRect = new Rectangle(rect);
        convertedRect.x = (int)((double)convertedRect.x * (100.0 / (double)this.zoomLevel));
        convertedRect.y = (int)((double)convertedRect.y * (100.0 / (double)this.zoomLevel));
        convertedRect.width = (int)((double)convertedRect.width * (100.0 / (double)this.zoomLevel));
        convertedRect.height = (int)((double)convertedRect.height * (100.0 / (double)this.zoomLevel));
        return convertedRect;
    }

    @Override
    public void setPopupProvider(PopupProvider popupProv) {
        this.popuProv = popupProv;
    }

    @Override
    public JToolTip createToolTip() {
        if (this.popuProv != null) {
            JPanel content = new JPanel(new BorderLayout());
            content.add((Component)this.popuProv.getPopup(this.getToolTipObject()), "North");
            return this.prepareTooltip(content);
        }
        return this.prepareEmptyTooltip();
    }

    private JToolTip prepareTooltip(JComponent content) {
        JToolTip toolTip = new JToolTip();
        toolTip.setLayout(new BorderLayout());
        toolTip.add(content);
        toolTip.setPreferredSize(content.getPreferredSize());
        toolTip.setFocusable(false);
        toolTip.setComponent(this);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        return toolTip;
    }

    private JToolTip prepareEmptyTooltip() {
        JToolTip tip = new JToolTip();
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(0, 0));
        tip.removeAll();
        tip.add(panel);
        return tip;
    }

    private void updateTooltipState(Point pt) {
        Point graphPt = this.pointFromZoomedPoint(pt);
        Iterator nodeIt = this.controller.getGraphGenerator().getGraph().getNodeIterator();
        while (nodeIt.hasNext()) {
            Node node = (Node)nodeIt.next();
            if (!node.getShape().contains(graphPt)) continue;
            this.showToolTip(node.getUserObject());
            return;
        }
        this.hideToolTip();
    }

    private void hideToolTip() {
        this.setToolTipText(null);
    }

    private void showToolTip(Object toolTipObject) {
        this.toolTipObject = toolTipObject;
        this.setToolTipText("");
    }

    private Object getToolTipObject() {
        return this.toolTipObject;
    }

    protected void displayPopup(Point pt) {
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getGraph() == null) {
            return new Dimension(10, 10);
        }
        Dimension prefSize = new Dimension(this.getGraph().getShape().getBounds().getSize());
        prefSize.width = (int)((double)prefSize.width * ((double)this.zoomLevel / 100.0));
        prefSize.height = (int)((double)prefSize.height * ((double)this.zoomLevel / 100.0));
        return prefSize;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }
}

