/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.model.impl;

import java.util.HashMap;
import java.util.Iterator;

public class DefaultGraphNode {
    Object userObject;
    HashMap parents;
    HashMap children;

    public DefaultGraphNode(Object userObject) {
        this.userObject = userObject;
        this.parents = new HashMap();
        this.children = new HashMap();
    }

    public int getParentCount() {
        return this.parents.size();
    }

    public Iterator getParents() {
        return this.parents.keySet().iterator();
    }

    public Iterator getParentUserObjects() {
        return this.parents.values().iterator();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Iterator getChildren() {
        return this.children.keySet().iterator();
    }

    public Iterator getChilderenUserObjects() {
        return this.children.values().iterator();
    }

    public boolean addParent(DefaultGraphNode node) {
        if (!this.parents.keySet().contains(node)) {
            this.parents.put(node, node.getUserObject());
            node.children.put(this, this.getUserObject());
            return true;
        }
        return false;
    }

    public boolean removeParent(DefaultGraphNode node) {
        if (this.parents.remove(node) != null) {
            node.removeChild(this);
            return true;
        }
        return false;
    }

    public boolean removeChild(DefaultGraphNode node) {
        if (this.children.remove(node) != null) {
            node.removeParent(this);
            return true;
        }
        return false;
    }

    public boolean removeFromChildren() {
        boolean ret = false;
        Iterator it = this.children.keySet().iterator();
        while (it.hasNext()) {
            DefaultGraphNode childNode = (DefaultGraphNode)it.next();
            childNode.parents.remove(this);
            ret = true;
            it.remove();
        }
        return ret;
    }

    public boolean removeFromParents() {
        boolean ret = false;
        Iterator it = this.parents.keySet().iterator();
        while (it.hasNext()) {
            DefaultGraphNode parentNode = (DefaultGraphNode)it.next();
            parentNode.children.remove(this);
            it.remove();
            ret = true;
        }
        return ret;
    }

    public boolean addChild(DefaultGraphNode node) {
        if (!this.children.keySet().contains(node)) {
            this.children.put(node, node.getUserObject());
            node.parents.put(this, this.getUserObject());
            return true;
        }
        return false;
    }

    public Object getUserObject() {
        return this.userObject;
    }
}

