/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.model.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import uk.ac.man.cs.mig.util.graph.event.GraphModelEvent;
import uk.ac.man.cs.mig.util.graph.event.GraphModelListener;
import uk.ac.man.cs.mig.util.graph.model.GraphModel;

public abstract class AbstractGraphModel
implements GraphModel {
    private static Logger log = Logger.getLogger(AbstractGraphModel.class);
    protected ArrayList<GraphModelListener> listeners = new ArrayList();

    @Override
    public void addGraphModelListener(GraphModelListener lsnr) {
        this.listeners.add(lsnr);
    }

    @Override
    public void removeGraphModelListener(GraphModelListener lsnr) {
        this.listeners.remove(lsnr);
    }

    public void fireObjectsAddedEvent(ArrayList objects) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("TRACE(DefaultGraphModel) firing object added event " + objects));
        }
        GraphModelEvent evt = new GraphModelEvent(this, objects);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).objectAdded(evt);
        }
    }

    protected void fireObjectsRemovedEvent(ArrayList objects) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("TRACE(DefaultGraphModel) firing object removed event " + objects));
        }
        GraphModelEvent evt = new GraphModelEvent(this, objects);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).objectRemoved(evt);
        }
    }

    protected void fireObjectsChangedEvent(ArrayList objects) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("TRACE(DefaultGraphModel) firing object changed event " + objects));
        }
        GraphModelEvent evt = new GraphModelEvent(this, objects);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).objectChanged(evt);
        }
    }

    protected void fireParentAddedEvent(Object object, Object parentObject) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(object);
        objects.add(parentObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)("TRACE(DefaultGraphModel) firing parent added event " + objects));
        }
        GraphModelEvent evt = new GraphModelEvent(this, objects);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).parentAdded(evt);
        }
    }

    protected void fireParentRemovedEvent(Object object, Object parentObject) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(object);
        objects.add(parentObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)("TRACE(DefaultGraphModel) firing parent removed event " + objects));
        }
        GraphModelEvent evt = new GraphModelEvent(this, objects);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).parentRemoved(evt);
        }
    }

    protected void fireChildAddedEvent(Object object, Object childObject) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(object);
        objects.add(childObject);
        GraphModelEvent evt = new GraphModelEvent(this, objects);
        if (log.isDebugEnabled()) {
            log.debug((Object)("TRACE(DefaultGraphModel) firing child added event " + objects));
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).childAdded(evt);
        }
    }

    protected void fireChildRemovedEvent(Object object, Object childObject) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(object);
        objects.add(childObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)("TRACE(DefaultGraphModel) firing child removed event " + objects));
        }
        GraphModelEvent evt = new GraphModelEvent(this, objects);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).childRemoved(evt);
        }
    }

    protected void fireModelChangedEvent() {
        ArrayList objects = new ArrayList();
        if (log.isDebugEnabled()) {
            log.debug((Object)("TRACE(DefaultGraphModel) firing child removed event " + objects));
        }
        GraphModelEvent evt = new GraphModelEvent(this, objects);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).modelChanged(evt);
        }
    }

    public void objectChanged(Object obj) {
        ArrayList<Object> objects = new ArrayList<Object>(1);
        objects.add(obj);
        this.fireObjectsChangedEvent(objects);
    }

    @Override
    public Iterator<GraphModelListener> getListeners() {
        return this.listeners.iterator();
    }
}

