/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.layout.dotlayoutengine.dotparser;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import uk.ac.man.cs.mig.util.graph.graph.Edge;
import uk.ac.man.cs.mig.util.graph.graph.Graph;
import uk.ac.man.cs.mig.util.graph.graph.Node;
import uk.ac.man.cs.mig.util.graph.renderer.NodeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.impl.DefaultNodeLabelRenderer;

public class DotParameterSetter {
    private Graph graph;
    private HashMap nodeMap;
    private HashMap edgeMap;
    private Edge[] edges;
    private Node[] nodes;
    private NodeLabelRenderer labelRen = new DefaultNodeLabelRenderer();
    private static int graphHeight = 0;

    public void setGraph(Graph g) {
        this.graph = g;
        graphHeight = 0;
        this.nodes = this.graph.getNodes();
        this.nodeMap = new HashMap(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodeMap.put(this.labelRen.getLabel(this.nodes[i]), this.nodes[i]);
        }
        this.edges = this.graph.getEdges();
        this.edgeMap = new HashMap(this.edges.length);
        for (int i = 0; i < this.edges.length; ++i) {
            String tail = this.labelRen.getLabel(this.edges[i].getTailNode());
            String head = this.labelRen.getLabel(this.edges[i].getHeadNode());
            this.edgeMap.put(new NodeEdgeKey(tail, head), this.edges[i]);
        }
    }

    public void setGraphAttribute(String name, String value) {
        Rectangle r;
        if (name.equals("bb") && (r = this.parseRect(value)) != null) {
            this.graph.setShape(r);
            graphHeight = r.height;
        }
    }

    public void setNodeAttribute(String nodeID, String name, String value) {
        Point p;
        Node n;
        if (name.equals("pos") && (n = (Node)this.nodeMap.get(nodeID)) != null && (p = this.parsePoint(value)) != null) {
            n.setPosition(p.x, graphHeight - p.y);
        }
    }

    public void setEdgeAttribute(String tailNodeID, String headNodeID, String name, String value) {
        NodeEdgeKey nek = new NodeEdgeKey(tailNodeID, headNodeID);
        Edge edge = (Edge)this.edgeMap.get(nek);
        if (edge != null) {
            if (name.equals("pos")) {
                this.setEdgePath(edge, value);
            } else if (name.equals("lp")) {
                Point lp = new Point();
                lp = this.parsePoint(value);
                edge.setLabelPosition(lp.x, graphHeight - lp.y);
            }
        }
    }

    public void setEdgePath(Edge edge, String value) {
        Point edgePoint;
        StringTokenizer tokenizer = new StringTokenizer(value);
        ArrayList<Point> edgePoints = new ArrayList<Point>(10);
        Point startPoint = null;
        Point endPoint = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.charAt(0) == 's') {
                startPoint = this.parsePoint(token.substring(2, token.length()));
                startPoint.y = graphHeight - startPoint.y;
                continue;
            }
            if (token.charAt(0) == 'e') {
                endPoint = this.parsePoint(token.substring(2, token.length()));
                endPoint.y = graphHeight - endPoint.y;
                continue;
            }
            edgePoint = this.parsePoint(token);
            edgePoint.y = graphHeight - edgePoint.y;
            edgePoints.add(edgePoint);
        }
        edge.resetPath();
        edgePoint = (Point)edgePoints.get(0);
        edge.setPathOrigin(edgePoint.x, edgePoint.y);
        int numberOfCtrlPoints = (edgePoints.size() - 1) / 3;
        for (int i = 0; i < numberOfCtrlPoints; ++i) {
            int ctrlPointIndex = i * 3 + 1;
            Point cp1 = (Point)edgePoints.get(ctrlPointIndex);
            Point cp2 = (Point)edgePoints.get(ctrlPointIndex + 1);
            Point cp3 = (Point)edgePoints.get(ctrlPointIndex + 2);
            edge.pathTo(cp1.x, cp1.y, cp2.x, cp2.y, cp3.x, cp3.y);
        }
        if (startPoint != null) {
            Point arrowheadBase = (Point)edgePoints.get(0);
            edge.setArrowTail(arrowheadBase.x, arrowheadBase.y, startPoint.x, startPoint.y);
        }
        if (endPoint != null) {
            Point arrowheadBase = (Point)edgePoints.get(edgePoints.size() - 1);
            edge.setArrowTail(arrowheadBase.x, arrowheadBase.y, endPoint.x, endPoint.y);
        }
    }

    public Point parsePoint(String data) {
        Point p = null;
        int commaPos = data.indexOf(",");
        if (commaPos != -1) {
            int x = (int)Float.parseFloat(data.substring(0, commaPos));
            int y = (int)Float.parseFloat(data.substring(commaPos + 1, data.length()));
            p = new Point(x, y);
        }
        return p;
    }

    public Rectangle parseRect(String data) {
        Rectangle rect = null;
        int start = 0;
        int commaPos = 0;
        commaPos = data.indexOf(44, start);
        rect = new Rectangle();
        rect.x = Integer.parseInt(data.substring(start, commaPos));
        start = commaPos + 1;
        commaPos = data.indexOf(44, start);
        rect.y = Integer.parseInt(data.substring(start, commaPos));
        start = commaPos + 1;
        commaPos = data.indexOf(44, start);
        rect.width = Integer.parseInt(data.substring(start, commaPos));
        start = commaPos + 1;
        rect.height = Integer.parseInt(data.substring(start, data.length()));
        return rect;
    }

    private class NodeEdgeKey {
        private String tail;
        private String head;

        public NodeEdgeKey(String tail, String head) {
            this.tail = tail;
            this.head = head;
        }

        public int hashCode() {
            int hashCode = this.tail.hashCode() * 37 + this.head.hashCode() * 17;
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeEdgeKey nek = (NodeEdgeKey)obj;
            return nek.head.equals(this.head) && nek.tail.equals(this.tail);
        }

        public String toString() {
            return "NodeEdgeKey(" + this.tail + " -> " + this.head + "   hashCode: " + this.hashCode() + ")";
        }
    }
}

