/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.layout.dotlayoutengine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import uk.ac.man.cs.mig.util.graph.graph.Graph;
import uk.ac.man.cs.mig.util.graph.layout.GraphLayoutEngine;
import uk.ac.man.cs.mig.util.graph.layout.dotlayoutengine.DotLayoutEngineProperties;
import uk.ac.man.cs.mig.util.graph.layout.dotlayoutengine.DotProcess;
import uk.ac.man.cs.mig.util.graph.layout.dotlayoutengine.dotparser.DotParameterSetter;
import uk.ac.man.cs.mig.util.graph.layout.dotlayoutengine.dotparser.DotParser;
import uk.ac.man.cs.mig.util.graph.layout.dotlayoutengine.dotparser.ParseException;
import uk.ac.man.cs.mig.util.graph.outputrenderer.GraphOutputRenderer;
import uk.ac.man.cs.mig.util.graph.outputrenderer.impl.DotOutputGraphRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.impl.DefaultEdgeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.impl.DefaultNodeLabelRenderer;

public class DotGraphLayoutEngine
implements GraphLayoutEngine {
    private static Logger log = Logger.getLogger(DotGraphLayoutEngine.class);
    private GraphOutputRenderer renderer = new DotOutputGraphRenderer(new DefaultNodeLabelRenderer(), new DefaultEdgeLabelRenderer());
    private int layoutDirection = 0;

    public void setGraphOutputRenderer(GraphOutputRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public synchronized void layoutGraph(Graph g) {
        DotProcess process = new DotProcess();
        if (this.layoutDirection == 0) {
            this.renderer.setRendererOption("rankdir", "LR");
        } else {
            this.renderer.setRendererOption("rankdir", "TB");
        }
        DotLayoutEngineProperties properties = DotLayoutEngineProperties.getInstance();
        this.renderer.setRendererOption("ranksep", Double.toString(properties.getRankSpacing()));
        this.renderer.setRendererOption("nodesep", Double.toString(properties.getSiblingSpacing()));
        try {
            File file = File.createTempFile("OWLVizScratch", null);
            file.deleteOnExit();
            log.debug((Object)("TRACE(DotGraphLayoutEngine): TempFile: " + file.getAbsolutePath()));
            FileOutputStream fos = new FileOutputStream(file);
            this.renderer.renderGraph(g, fos);
            fos.close();
            if (!process.startProcess(file.getAbsolutePath())) {
                return;
            }
            FileInputStream is = null;
            is = new FileInputStream(file);
            if (is != null) {
                try {
                    DotParameterSetter paramSetter = new DotParameterSetter();
                    paramSetter.setGraph(g);
                    DotParser.parse(paramSetter, is);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                long t1 = System.currentTimeMillis();
                process.killProcess();
                process = null;
            }
            long t2 = System.currentTimeMillis();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    @Override
    public void setLayoutDirection(int layoutDirection) {
        this.layoutDirection = layoutDirection;
    }

    @Override
    public int getLayoutDirection() {
        return this.layoutDirection;
    }
}

