/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.graph.impl;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import uk.ac.man.cs.mig.util.graph.graph.Node;

public class TriangularNode
implements Node {
    private Object userObject;
    private Polygon triangle;
    private Point pos;

    public TriangularNode(Object userObject) {
        this.userObject = userObject;
        this.triangle = new Polygon();
        this.pos = new Point();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setPosition(int x, int y) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        this.pos.x = x;
        this.pos.y = y;
        this.triangle.reset();
        this.triangle.addPoint(x - w / 2, y + h / 4);
        this.triangle.addPoint(x + w / 2, y + h / 4);
        this.triangle.addPoint(x, y - h / 2);
    }

    @Override
    public Point getPosition() {
        return this.pos;
    }

    @Override
    public void setSize(int width, int height) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        this.triangle.reset();
        this.triangle.addPoint(x - width / 2, y + height / 4);
        this.triangle.addPoint(x + width / 2, y + height / 4);
        this.triangle.addPoint(x, y - height / 2);
    }

    @Override
    public Dimension getSize() {
        return this.triangle.getBounds().getSize();
    }

    @Override
    public Shape getShape() {
        return this.triangle;
    }
}

