/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.graph.impl;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import uk.ac.man.cs.mig.util.graph.graph.Node;

public class EllipticalNode
implements Node {
    private Object userObject;
    private Ellipse2D.Double ellipse;
    private Point pos;

    public EllipticalNode(Object userObject) {
        this.userObject = userObject;
        this.ellipse = new Ellipse2D.Double();
        this.pos = new Point();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setPosition(int x, int y) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        this.pos.x = x;
        this.pos.y = y;
        this.ellipse.setFrame(x - w / 2, y - h / 2, w, h);
    }

    @Override
    public Point getPosition() {
        return this.pos;
    }

    @Override
    public void setSize(int width, int height) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        this.ellipse.setFrame(x - width / 2, y - height / 2, width, height);
    }

    @Override
    public Dimension getSize() {
        return this.ellipse.getBounds().getSize();
    }

    @Override
    public Shape getShape() {
        return this.ellipse;
    }
}

