/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.graph.impl;

import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.ac.man.cs.mig.util.graph.graph.Edge;
import uk.ac.man.cs.mig.util.graph.graph.Graph;
import uk.ac.man.cs.mig.util.graph.graph.Node;

public class DefaultGraph
implements Graph {
    private Map nodes = new HashMap();
    private Map edges = new HashMap();
    private Shape shape = new Rectangle();

    @Override
    public void add(Node node) {
        if (!this.nodes.containsKey(node)) {
            this.nodes.put(node, node);
        }
    }

    @Override
    public void remove(Node node) {
        if (this.nodes.containsKey(node)) {
            this.nodes.remove(node);
            Iterator it = this.getEdgeIterator();
            while (it.hasNext()) {
                Edge edge = (Edge)it.next();
                if (node.equals(edge.getTailNode())) {
                    it.remove();
                    continue;
                }
                if (!node.equals(edge.getHeadNode())) continue;
                it.remove();
            }
        }
    }

    @Override
    public void add(Edge edge) {
        if (this.nodes.containsKey(edge.getTailNode()) && this.nodes.containsKey(edge.getHeadNode())) {
            EdgeKey key = new EdgeKey(edge);
            this.edges.put(key, edge);
        }
    }

    @Override
    public void remove(Edge edge) {
        this.edges.remove(new EdgeKey(edge));
    }

    @Override
    public void remove(Node tailNode, Node headNode) {
        this.edges.remove(new EdgeKey(tailNode, headNode));
    }

    @Override
    public void removeAll() {
        this.edges = new HashMap();
        this.nodes = new HashMap();
    }

    @Override
    public int getNodeCount() {
        return this.nodes.size();
    }

    @Override
    public int getEdgeCount() {
        return this.edges.size();
    }

    @Override
    public Iterator getNodeIterator() {
        return this.nodes.keySet().iterator();
    }

    @Override
    public Iterator getEdgeIterator() {
        return this.edges.values().iterator();
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public void setShape(Shape shape) {
        this.shape = shape;
    }

    @Override
    public boolean contains(Node node) {
        return this.nodes.containsKey(node);
    }

    @Override
    public boolean contains(Edge edge) {
        return this.edges.containsKey(new EdgeKey(edge));
    }

    @Override
    public Node[] getNodes() {
        Object[] array = this.nodes.keySet().toArray();
        Node[] nodeArray = new Node[array.length];
        System.arraycopy(array, 0, nodeArray, 0, array.length);
        return nodeArray;
    }

    @Override
    public Edge[] getEdges() {
        Object[] array = this.edges.values().toArray();
        Edge[] edgeArray = new Edge[array.length];
        System.arraycopy(array, 0, edgeArray, 0, array.length);
        return edgeArray;
    }

    public class EdgeKey {
        private Node tailNode;
        private Node headNode;

        public EdgeKey(Edge edge) {
            this.tailNode = edge.getTailNode();
            this.headNode = edge.getHeadNode();
        }

        public EdgeKey(Node tailNode, Node headNode) {
            this.tailNode = tailNode;
            this.headNode = headNode;
        }

        public int hashCode() {
            return this.tailNode.hashCode() * 13 + this.headNode.hashCode() * 37;
        }

        public boolean equals(Object obj) {
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            EdgeKey key = (EdgeKey)obj;
            return key.tailNode.equals(this.tailNode) && key.headNode.equals(this.headNode);
        }
    }
}

