/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.export.impl;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.log4j.Logger;
import uk.ac.man.cs.mig.util.graph.controller.Controller;
import uk.ac.man.cs.mig.util.graph.export.ExportFormat;

public abstract class AbstractRasterFormat
implements ExportFormat {
    private static Logger log = Logger.getLogger(AbstractRasterFormat.class);
    private String format;
    private boolean antialiased = true;
    private double scale = 100.0;

    public AbstractRasterFormat(String format) {
        this.format = format;
    }

    @Override
    public void export(Controller controller, OutputStream os) {
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName(this.format);
        ImageWriter imageWriter = null;
        Dimension size = controller.getGraphGenerator().getGraph().getShape().getBounds().getSize();
        int width = size.width + 10;
        int height = size.height + 10;
        int scaledWidth = (int)((double)width * this.scale / 100.0);
        int scaledHeight = (int)((double)height * this.scale / 100.0);
        if (width > 0 && height > 0) {
            if (it.hasNext()) {
                imageWriter = it.next();
            }
            if (imageWriter != null) {
                try {
                    ImageOutputStream ios = ImageIO.createImageOutputStream(os);
                    imageWriter.setOutput(ios);
                    BufferedImage bufferedImage = new BufferedImage(scaledWidth, scaledHeight, 1);
                    Graphics2D g2 = (Graphics2D)bufferedImage.getGraphics();
                    g2.setClip(0, 0, width, height);
                    if (this.scale != 100.0) {
                        g2.scale(this.scale / 100.0, this.scale / 100.0);
                    }
                    controller.getGraphView().draw(g2, false, false, this.antialiased, true);
                    imageWriter.write(bufferedImage);
                    ios.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                log.error((Object)("No image writer available for the " + this.format + " format."));
            }
        }
    }

    @Override
    public boolean isRasterFormat() {
        return true;
    }

    @Override
    public boolean supportsAntialiasing() {
        return true;
    }

    @Override
    public void setAntialiased(boolean b) {
        this.antialiased = b;
    }

    @Override
    public boolean getAntialiased() {
        return this.antialiased;
    }

    @Override
    public boolean supportsScaledOutput() {
        return true;
    }

    @Override
    public void setScale(double percentage) {
        this.scale = percentage;
    }

    @Override
    public double getScale() {
        return this.scale;
    }
}

