/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.controller.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import uk.ac.man.cs.mig.util.graph.controller.GraphSelectionModel;
import uk.ac.man.cs.mig.util.graph.event.GraphSelectionModelEvent;
import uk.ac.man.cs.mig.util.graph.event.GraphSelectionModelListener;

public class DefaultGraphSelectionModel
implements GraphSelectionModel {
    private static Logger log = Logger.getLogger(DefaultGraphSelectionModel.class);
    private Object selObj = null;
    private ArrayList listeners = new ArrayList();
    private GraphSelectionModelEvent evt = new GraphSelectionModelEvent(this);

    @Override
    public void setSelectedObject(Object obj) {
        if (obj != this.selObj) {
            this.selObj = obj;
            this.fireNodeSelectionChangedEvent();
        }
    }

    @Override
    public boolean supportsMultipleObjectSelection() {
        return false;
    }

    @Override
    public Object getSelectedObject() {
        return this.selObj;
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.selObj == null) {
            return new Object[0];
        }
        return new Object[]{this.selObj};
    }

    @Override
    public void addGraphSelectionModelListener(GraphSelectionModelListener lsnr) {
        this.listeners.add(lsnr);
    }

    @Override
    public void removeGraphSelectionModelListener(GraphSelectionModelListener lsnr) {
        this.listeners.remove(lsnr);
    }

    @Override
    public Iterator getListeners() {
        return this.listeners.iterator();
    }

    protected void fireNodeSelectionChangedEvent() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"TRACE(DefaultGraphSelectionModel) firing node selection changed event");
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphSelectionModelListener)this.listeners.get(i)).selectionChanged(this.evt);
        }
    }

    public String toString() {
        String ret = "DefaultGraphSelectionListener:\n";
        Iterator it = this.getListeners();
        while (it.hasNext()) {
            ret = ret + it.next() + "\n";
        }
        return ret;
    }
}

