/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizIcons;
import uk.ac.man.cs.mig.util.graph.controller.Controller;
import uk.ac.man.cs.mig.util.graph.controller.VisualisedObjectManager;
import uk.ac.man.cs.mig.util.graph.graph.Node;
import uk.ac.man.cs.mig.util.graph.renderer.NodeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.NodeRenderer;

public class OWLClsNodeRenderer
implements NodeRenderer {
    private static final Logger logger = Logger.getLogger(OWLClsNodeRenderer.class);
    private NodeLabelRenderer labelRenderer;
    private static Color fillColor;
    private static Color lineColor;
    private static Controller controller;
    private VisualisedObjectManager visualisedObjectManager;
    private Polygon leftArrow = new Polygon();
    private Polygon rightArrow = new Polygon();
    private FontMetrics fontMetrics;
    private static final int ARROW_SIZE = 5;
    private static final int HORIZONTAL_PADDING = 20;
    private static final int VERTICAL_PADDING = 15;
    private Font labelFont;
    private int layoutDirection = 0;
    public static final String SOMECLS_NAME = "\u2203";
    public static final String ALLCLS_NAME = "\u2200";
    public static final String MINCARDI_NAME = "\u2264";
    public static final String MAXCARDI_NAME = "\u2265";
    public static final String CARDI_NAME = "=";
    public static final String INTERSECTION_NAME = "\u2293";
    public static final String UNION_NAME = "\u2294";
    public static final String COMPLEMENT_NAME = "\u00ac";
    public static final String HAS_NAME = "\u220b";
    public static final String ENUM_NAME = "{ }";
    private static final double NON_EDITABLE_FACTOR = 1.5;
    Color clrMetaClsFill = new Color(140, 255, 120);
    Color clrMetaClsOutline = Color.GRAY;
    Color clrMetaClsFillNonEditable = new Color(182, 252, 131);
    Color clrPrimitiveClsFill = new Color(255, 255, 153);
    Color clrPrimitiveClsOutline = Color.GRAY;
    Color clrPrimitiveClsFillNonEditable = new Color(255, 255, 204);
    Color clrDefinedClsFill = new Color(255, 200, 128);
    Color clrDefinedClsOutline = Color.GRAY;
    Color clrDefinedClsFillNonEditable = this.clrDefinedClsFill.brighter();
    Color clrLogicalClsFill = new Color(236, 210, 185);
    Color clrLogicalClsOutline = Color.GRAY;
    Color clrEnumClsFill = new Color(255, 204, 255);
    Color clrEnumClsOutline = Color.GRAY;
    Color clrHasRestrictionFill = new Color(255, 192, 152);
    Color clrHasRestrictionOutline = Color.GRAY;
    Color clrText = Color.BLACK;
    Color clrTextNonEditable = Color.GRAY;
    Color clrInconsistentClsColor = Color.RED;
    private Color clrConsistentAndChangedColor = Color.BLUE;
    private Icon disjointClassIcon;
    Stroke probeClassStroke = new BasicStroke(3.0f, 0, 1, 2.0f, new float[]{2.0f, 2.0f}, 2.0f);
    Color clrInstance = new Color(255, 204, 255);
    private static final int NOT_DISJOINT = 0;
    private static final int DIRECTLY_DISJOINT = 1;
    private static final int INHERITED_DIRECT_DISJOINT = 2;
    private static final int INHERITED_INDIRECT_DISJOINT = 3;
    private OWLModelManager owlModelManager;

    public OWLClsNodeRenderer(Controller controller, VisualisedObjectManager manager, NodeLabelRenderer labelRenderer, OWLModelManager owlModelManager) {
        this.owlModelManager = owlModelManager;
        if (manager == null) {
            throw new NullPointerException("VisualisedObjectManager must not be null");
        }
        if (labelRenderer == null) {
            throw new NullPointerException("NodeLabelRenderer must not be null");
        }
        this.visualisedObjectManager = manager;
        OWLClsNodeRenderer.controller = controller;
        this.disjointClassIcon = OWLVizIcons.getIcon("DisjointClassIndicatorIcon.gif");
        JPanel pan = new JPanel();
        Font font = pan.getFont();
        this.labelFont = font.deriveFont(10.0f);
        if (this.labelFont == null) {
            logger.warn((Object)"Font is NULL!");
        }
        this.fontMetrics = pan.getFontMetrics(this.labelFont);
        if (this.fontMetrics == null) {
            logger.warn((Object)"Font metrics is NULL!");
        }
        if (this.visualisedObjectManager == null) {
            throw new NullPointerException("DefaultNode renderer constructed beforeVisualisedObjectManager");
        }
        this.labelRenderer = labelRenderer;
        this.leftArrow = new Polygon();
        this.rightArrow = new Polygon();
        this.setupArrows();
    }

    protected void setupArrows() {
        if (controller.getGraphLayoutEngine().getLayoutDirection() == 0) {
            this.leftArrow.reset();
            this.leftArrow.addPoint(5, -5);
            this.leftArrow.addPoint(0, 0);
            this.leftArrow.addPoint(5, 5);
            this.rightArrow.reset();
            this.rightArrow.addPoint(-5, -5);
            this.rightArrow.addPoint(0, 0);
            this.rightArrow.addPoint(-5, 5);
        } else {
            this.leftArrow.reset();
            this.leftArrow.addPoint(-5, 5);
            this.leftArrow.addPoint(0, 0);
            this.leftArrow.addPoint(5, 5);
            this.rightArrow.reset();
            this.rightArrow.addPoint(-5, -5);
            this.rightArrow.addPoint(0, 0);
            this.rightArrow.addPoint(5, -5);
        }
    }

    protected void drawArrows(Graphics2D g2, Shape nodeShape, Object userObject) {
        if (controller.getGraphLayoutEngine().getLayoutDirection() != this.layoutDirection) {
            this.layoutDirection = controller.getGraphLayoutEngine().getLayoutDirection();
            this.setupArrows();
        }
        if (this.layoutDirection == 0) {
            Rectangle rect;
            if (this.visualisedObjectManager.getChildrenHiddenCount(userObject) > 0) {
                rect = nodeShape.getBounds();
                g2.translate(rect.x + rect.width, rect.y + rect.height / 2);
                g2.fill(this.rightArrow);
                g2.translate(-rect.x - rect.width, -rect.y - rect.height / 2);
            }
            if (this.visualisedObjectManager.getParentsHiddenCount(userObject) > 0) {
                rect = nodeShape.getBounds();
                g2.translate(rect.x, rect.y + rect.height / 2);
                g2.fill(this.leftArrow);
                g2.translate(-rect.x, -rect.y - rect.height / 2);
            }
        } else {
            Rectangle rect;
            if (this.visualisedObjectManager.getChildrenHiddenCount(userObject) > 0) {
                rect = nodeShape.getBounds();
                g2.translate(rect.x + rect.width / 2, rect.y + rect.height);
                g2.fill(this.rightArrow);
                g2.translate(-rect.x - rect.width / 2, -rect.y - rect.height);
            }
            if (this.visualisedObjectManager.getParentsHiddenCount(userObject) > 0) {
                rect = nodeShape.getBounds();
                g2.translate(rect.x + rect.width / 2, rect.y);
                g2.fill(this.leftArrow);
                g2.translate(-rect.x - rect.width / 2, -rect.y);
            }
        }
    }

    @Override
    public void renderNode(Graphics2D g2, Node node, boolean forPrinting, boolean drawDetail) {
        Shape sh = node.getShape();
        Rectangle clipBounds = g2.getClipBounds();
        clipBounds.grow(10, 10);
        if (sh.intersects(clipBounds)) {
            Object userObject = node.getUserObject();
            g2.setColor(this.getFillColor(userObject));
            g2.fill(sh);
            g2.setColor(this.getLineColor(userObject));
            g2.draw(sh);
            g2.setColor(Color.BLACK);
            if (drawDetail) {
                this.drawArrows(g2, sh, userObject);
                Object selObj = controller.getGraphSelectionModel().getSelectedObject();
                Point pos = node.getPosition();
                String label = " ";
                label = this.owlModelManager.getRendering((OWLObject)((OWLEntity)userObject));
                Font f = g2.getFont();
                g2.setFont(this.labelFont);
                g2.setColor(this.getTextColor(userObject));
                Rectangle2D labelBounds2D = g2.getFontMetrics().getStringBounds(label, g2);
                Rectangle labelBounds = labelBounds2D.getBounds();
                g2.drawString(label, pos.x - labelBounds.width / 2, pos.y + labelBounds.height / 3);
                g2.setFont(f);
            }
        }
    }

    @Override
    public Dimension getPreferredSize(Node node, Dimension size) {
        if (node.getUserObject() instanceof OWLClass) {
            String label = this.owlModelManager.getRendering((OWLObject)((OWLClass)node.getUserObject()));
            int width = SwingUtilities.computeStringWidth(this.fontMetrics, label);
            int height = this.fontMetrics.getHeight();
            if (size != null) {
                size.width = width + 20;
                size.height = height + 15;
                return size;
            }
            return new Dimension(width, height);
        }
        size.width = 20;
        size.height = 20;
        return size;
    }

    protected Color getFillColor(Object obj) {
        Color color = Color.GRAY;
        if (obj instanceof OWLClass) {
            OWLClass cls = (OWLClass)obj;
            for (OWLOntology ont : this.owlModelManager.getActiveOntologies()) {
                if (!cls.isDefined(ont)) continue;
                return this.clrDefinedClsFill;
            }
            return this.clrPrimitiveClsFillNonEditable;
        }
        return color;
    }

    protected Color getLineColor(Object obj) {
        boolean consistent;
        Color color = Color.GRAY;
        if (obj instanceof OWLClass && !(consistent = this.owlModelManager.getReasoner().isSatisfiable((OWLClassExpression)((OWLClass)obj)))) {
            color = this.clrInconsistentClsColor;
        }
        return color;
    }

    protected Color getTextColor(Object obj) {
        boolean consistent;
        Color color = Color.BLACK;
        if (obj instanceof OWLClass && !(consistent = this.owlModelManager.getReasoner().isSatisfiable((OWLClassExpression)((OWLClass)obj)))) {
            color = this.clrInconsistentClsColor;
        }
        return color;
    }

    protected int areClassesDisjoint(OWLClass cls1, OWLClass cls2) {
        return 0;
    }
}

