/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui.renderer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.protege.editor.owl.model.OWLModelManager;
import uk.ac.man.cs.mig.util.graph.graph.Edge;
import uk.ac.man.cs.mig.util.graph.graph.Graph;
import uk.ac.man.cs.mig.util.graph.graph.Node;
import uk.ac.man.cs.mig.util.graph.outputrenderer.impl.DotOutputGraphRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.EdgeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.NodeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.impl.DefaultEdgeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.impl.DefaultNodeLabelRenderer;

public class DotSubGraphOutputRenderer
extends DotOutputGraphRenderer {
    private OWLModelManager model;
    private static boolean groupByNameSpace = false;

    public DotSubGraphOutputRenderer(OWLModelManager model, NodeLabelRenderer nodeLabelRen, EdgeLabelRenderer edgeLabelRen) {
        super(nodeLabelRen, edgeLabelRen);
        this.model = model;
    }

    public DotSubGraphOutputRenderer(OWLModelManager model) {
        super(new DefaultNodeLabelRenderer(), new DefaultEdgeLabelRenderer());
        this.model = model;
    }

    public static void setGroupByNameSpace(boolean b) {
        groupByNameSpace = b;
    }

    public static boolean getGroupByNameSpace() {
        return groupByNameSpace;
    }

    @Override
    public synchronized void renderGraph(Graph graph, OutputStream os) {
        OutputStreamWriter osw = new OutputStreamWriter(os);
        this.writer = new BufferedWriter(osw);
        try {
            this.writeHeader(graph);
            Node[] nodes = graph.getNodes();
            if (!groupByNameSpace) {
                for (int i = 0; i < nodes.length; ++i) {
                    this.renderNode(nodes[i]);
                }
            }
            Edge[] edges = graph.getEdges();
            for (int i = 0; i < edges.length; ++i) {
                this.renderEdge(edges[i]);
            }
            this.closeGraph();
            this.writer.flush();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }
}

