/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizPreferences;
import uk.ac.man.cs.mig.coode.owlviz.ui.options.ModeOptionsPanel;
import uk.ac.man.cs.mig.util.graph.layout.dotlayoutengine.DotLayoutEngineProperties;

public class OWLVizPreferencesPane
extends OWLPreferencesPanel {
    private static final long serialVersionUID = -943293597478204971L;
    private List<OWLPreferencesPanel> optionPages = new ArrayList<OWLPreferencesPanel>();
    private JTabbedPane tabPane;
    public static final String DEFAULT_PAGE = "General Options";

    public void applyChanges() {
        for (OWLPreferencesPanel optionPage : this.optionPages) {
            optionPage.applyChanges();
        }
    }

    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        this.tabPane = new JTabbedPane();
        this.addOptions(new DotProcessPathPanel(), DEFAULT_PAGE);
        this.addOptions(new LayoutSpacingPanel(), DEFAULT_PAGE);
        this.addOptions(new ModeOptionsAdapter(), DEFAULT_PAGE);
        this.add(this.tabPane, "North");
    }

    public void dispose() throws Exception {
        for (OWLPreferencesPanel optionPage : this.optionPages) {
            optionPage.dispose();
        }
    }

    private void addOptions(OWLPreferencesPanel page, String tabName) throws Exception {
        Component c = this.getTab(tabName);
        if (c == null) {
            Box box = new Box(1);
            box.add((Component)page);
            box.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.tabPane.add(tabName, box);
            this.optionPages.add(page);
        } else {
            Box box = (Box)c;
            box.add(Box.createVerticalStrut(7));
            box.add((Component)page);
            this.optionPages.add(page);
        }
        page.initialise();
    }

    protected Component getTab(String name) {
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            if (!this.tabPane.getTitleAt(i).equals(name)) continue;
            return this.tabPane.getComponentAt(i);
        }
        return null;
    }

    class LayoutSpacingPanel
    extends OWLPreferencesPanel {
        private static final long serialVersionUID = 4096048810803376513L;
        JSpinner rankSpacing;
        JSpinner siblingSpacing;

        LayoutSpacingPanel() {
        }

        public void initialise() {
            this.setLayout(new BorderLayout(12, 12));
            this.add(this.createUI());
            DotLayoutEngineProperties dotLayoutEngineProperties = DotLayoutEngineProperties.getInstance();
            Double dRankSpacing = new Double(dotLayoutEngineProperties.getRankSpacing());
            Double dSiblingSpacing = new Double(dotLayoutEngineProperties.getSiblingSpacing());
            this.rankSpacing.setValue(dRankSpacing);
            this.siblingSpacing.setValue(dSiblingSpacing);
        }

        protected JComponent createUI() {
            JPanel holder = new JPanel(new BorderLayout(12, 12));
            JPanel component = new JPanel();
            GridBagLayout layout = new GridBagLayout();
            component.setLayout(layout);
            JLabel rankSpacingLabel = new JLabel("Rank spacing: ");
            JLabel siblingSpacingLabel = new JLabel("Sibling spacing: ");
            this.rankSpacing = new JSpinner(new SpinnerNumberModel(1.0, 0.05, 10.0, 0.05));
            this.siblingSpacing = new JSpinner(new SpinnerNumberModel(0.2, 0.01, 10.0, 0.01));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 0;
            gbc.anchor = 18;
            gbc.insets = new Insets(6, 6, 6, 6);
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            this.addComponent(component, rankSpacingLabel, gbc, 0, 0, 1, 1);
            this.addComponent(component, this.rankSpacing, gbc, 1, 0, 1, 1);
            this.addComponent(component, siblingSpacingLabel, gbc, 0, 1, 1, 1);
            this.addComponent(component, this.siblingSpacing, gbc, 1, 1, 1, 1);
            holder.setBorder(BorderFactory.createTitledBorder("Spacing"));
            holder.add((Component)component, "West");
            return holder;
        }

        protected void addComponent(JComponent container, JComponent c, GridBagConstraints gbc, int x, int y, int width, int height) {
            gbc.gridx = x;
            gbc.gridy = y;
            gbc.gridwidth = width;
            gbc.gridheight = height;
            container.add((Component)c, gbc);
        }

        public void applyChanges() {
            Double dRankSpacing = (Double)this.rankSpacing.getValue();
            Double dSiblingSpacing = (Double)this.siblingSpacing.getValue();
            DotLayoutEngineProperties dotLayoutEngineProperties = DotLayoutEngineProperties.getInstance();
            dotLayoutEngineProperties.setRankSpacing(dRankSpacing);
            dotLayoutEngineProperties.setSiblingSpacing(dSiblingSpacing);
        }

        public void dispose() throws Exception {
        }
    }

    class DotProcessPathPanel
    extends OWLPreferencesPanel {
        private static final long serialVersionUID = -6685359718444062677L;
        private JTextField pathField;

        DotProcessPathPanel() {
        }

        public void initialise() throws Exception {
            this.setLayout(new BorderLayout(12, 12));
            this.setBorder(BorderFactory.createTitledBorder("Dot Application Path"));
            this.add(this.createUI(), "North");
        }

        public void dispose() throws Exception {
        }

        protected JComponent createUI() {
            Box panel = new Box(2);
            this.pathField = new JTextField(15);
            this.pathField.setText(DotLayoutEngineProperties.getInstance().getDotProcessPath());
            JButton browseButton = new JButton(new AbstractAction("Browse"){
                private static final long serialVersionUID = 6762941646097019849L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    DotProcessPathPanel.this.browseForPath();
                }
            });
            panel.add(new JLabel("Path:"));
            panel.add(this.pathField);
            panel.add(browseButton);
            return panel;
        }

        protected void browseForPath() {
            HashSet<String> exts = new HashSet<String>();
            exts.add("dot");
            exts.add("app");
            exts.add("exe");
            exts.add("bin");
            File file = UIUtil.openFile((Component)new JFrame(), (String)"Dot Application", (String)"Please select the dot application", exts);
            if (file != null) {
                this.pathField.setText(file.getPath());
            }
        }

        public void applyChanges() {
            DotLayoutEngineProperties.getInstance().setDotProcessPath(this.pathField.getText());
        }
    }

    class ModeOptionsAdapter
    extends OWLPreferencesPanel {
        private static final long serialVersionUID = -4017151973463168326L;
        public ModeOptionsPanel panel;

        ModeOptionsAdapter() {
        }

        public void applyChanges() {
            OWLVizPreferences.getInstance().setTrackingModeDefault(this.panel.isTrackerMode());
            OWLVizPreferences.getInstance().setDefaultTrackerRadius(this.panel.getTrackerRadius());
        }

        public void initialise() throws Exception {
            this.setLayout(new BorderLayout());
            this.panel = new ModeOptionsPanel();
            this.panel.setTrackerMode(OWLVizPreferences.getInstance().isTrackingModeDefault());
            this.panel.setTrackerRadius(OWLVizPreferences.getInstance().getDefaultTrackerRadius());
            this.add(this.panel, "North");
        }

        public void dispose() throws Exception {
        }
    }
}

