/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui.options;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import uk.ac.man.cs.mig.coode.owlviz.ui.options.OptionsPage;
import uk.ac.man.cs.mig.util.graph.controller.Controller;

public class LayoutDirectionOptionsPage
extends OptionsPage {
    private static final long serialVersionUID = 3883726222026156722L;
    private Controller assertedController;
    private Controller inferredController;
    private JRadioButton leftToRightButton;
    private JRadioButton topToBottomButton;

    public LayoutDirectionOptionsPage(Controller assertedController, Controller inferredController) {
        this.assertedController = assertedController;
        this.inferredController = inferredController;
        this.setLayout(new BorderLayout(14, 14));
        this.add(this.createUI());
    }

    protected JComponent createUI() {
        this.leftToRightButton = new JRadioButton("Left to Right", true);
        this.topToBottomButton = new JRadioButton("Top To Bottom", false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.leftToRightButton);
        buttonGroup.add(this.topToBottomButton);
        Box box = new Box(1);
        box.add(this.leftToRightButton);
        box.add(this.topToBottomButton);
        box.setBorder(BorderFactory.createTitledBorder("Layout Direction"));
        return box;
    }

    @Override
    public void validateOptions() {
    }

    @Override
    public void applyOptions() {
        int layoutDirection = this.leftToRightButton.isSelected() ? 0 : 1;
        this.assertedController.getGraphLayoutEngine().setLayoutDirection(layoutDirection);
        this.inferredController.getGraphLayoutEngine().setLayoutDirection(layoutDirection);
    }

    @Override
    public void updateInterface() {
        int layoutDirection = this.assertedController.getGraphLayoutEngine().getLayoutDirection();
        if (layoutDirection == 0) {
            this.leftToRightButton.setSelected(true);
        } else {
            this.topToBottomButton.setSelected(true);
        }
    }
}

