/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.man.cs.mig.coode.owlviz.ui.options.OWLVizViewOptions;
import uk.ac.man.cs.mig.coode.owlviz.ui.options.OptionsPage;

public class DisplayOptionsPage
extends OptionsPage {
    private static final long serialVersionUID = -3598573214199342902L;
    private JCheckBox displayDisjointInfo;
    private JCheckBox groupByNameSpace;
    private JCheckBox displayAnonymousClasses;
    private JCheckBox displayIndividuals;
    private JCheckBox displayIsALabels;
    private OWLVizViewOptions options;

    public DisplayOptionsPage(OWLVizViewOptions options) {
        this.options = options;
        this.setLayout(new BorderLayout(12, 12));
        this.add(this.createUI());
        this.displayAnonymousClasses.setEnabled(false);
        this.displayIndividuals.setEnabled(false);
    }

    protected JComponent createUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 100.0;
        gbc.fill = 2;
        gbc.insets = new Insets(7, 7, 7, 7);
        gbc.anchor = 18;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.groupByNameSpace = new JCheckBox("Group classes by namespace");
        panel.add((Component)this.groupByNameSpace, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.displayDisjointInfo = new JCheckBox("Display disjoint class information");
        panel.add((Component)this.displayDisjointInfo, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.displayAnonymousClasses = new JCheckBox("Display restrictions (and other anonymous classes)");
        this.displayAnonymousClasses.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DisplayOptionsPage.this.displayAnonymousClasses.isSelected()) {
                    DisplayOptionsPage.this.displayIndividuals.setSelected(true);
                }
            }
        });
        panel.add((Component)this.displayAnonymousClasses, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.displayIndividuals = new JCheckBox("Display individuals");
        panel.add((Component)this.displayIndividuals, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        this.displayIsALabels = new JCheckBox("Display is-a labels");
        panel.add((Component)this.displayIsALabels, gbc);
        JPanel component = new JPanel(new BorderLayout());
        component.add((Component)panel, "North");
        return component;
    }

    @Override
    public void updateInterface() {
        this.displayDisjointInfo.setSelected(this.options.isDisplayDisjointClassIndicator());
        this.displayIndividuals.setSelected(this.options.isDisplayIndividuals());
        this.displayAnonymousClasses.setSelected(this.options.isDisplayAnonymousClasses());
        this.groupByNameSpace.setSelected(this.options.isGroupClassesByNameSpace());
        this.displayIsALabels.setSelected(this.options.isDisplayIsALabels());
    }

    @Override
    public void validateOptions() {
    }

    @Override
    public void applyOptions() {
        this.options.setDisplayDisjointClassIndicator(this.displayDisjointInfo.isSelected());
        this.options.setDisplayAnonymousClasses(this.displayAnonymousClasses.isSelected());
        this.options.setGroupClassesByNameSpace(this.groupByNameSpace.isSelected());
        this.options.setDisplayIndividuals(this.displayIndividuals.isSelected());
        this.options.setDisplayIsALabels(this.displayIsALabels.isSelected());
    }
}

