/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui.exportwizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.man.cs.mig.util.graph.export.ExportFormat;
import uk.ac.man.cs.mig.util.graph.export.ExportFormatManager;
import uk.ac.man.cs.mig.util.wizard.Wizard;
import uk.ac.man.cs.mig.util.wizard.WizardPage;

public class SelectFormatPage
extends WizardPage {
    private static final long serialVersionUID = 4849781834822854469L;
    ExportFormat selectedFormat;
    JComboBox comboBox;
    JCheckBox antialiasedCheckBox;
    JCheckBox scaledCheckBox;
    JSpinner scaleSpinner;

    public SelectFormatPage() {
        super("SelectFormatPage");
        this.add(this.createUI());
    }

    protected JComponent createUI() {
        Box component = new Box(1);
        component.setAlignmentX(0.0f);
        int SEP_SIZE = 14;
        component.add(this.createFormatComboPanel());
        component.add(Box.createVerticalStrut(SEP_SIZE));
        component.add(this.createAntialiasedOptionPanel());
        component.add(Box.createVerticalStrut(SEP_SIZE));
        component.add(this.createScalingOptionPanel());
        this.setControlState();
        return component;
    }

    protected JComponent createFormatComboPanel() {
        JPanel comboBoxPanel = new JPanel(new BorderLayout(14, 14));
        comboBoxPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        JLabel label = new JLabel("<html><body>Please select the export format that you want to use.");
        comboBoxPanel.add((Component)label, "North");
        ExportFormat[] exportFormats = ExportFormatManager.getExportFormats();
        this.comboBox = new JComboBox<ExportFormat>(exportFormats);
        this.comboBox.setRenderer(new ExportFormatRenderer());
        this.comboBox.setSelectedIndex(0);
        this.selectedFormat = exportFormats[0];
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectFormatPage.this.selectedFormat = (ExportFormat)SelectFormatPage.this.comboBox.getSelectedItem();
                SelectFormatPage.this.setControlState();
                if (SelectFormatPage.this.getWizard() != null) {
                    SelectFormatPage.this.setButtonState(SelectFormatPage.this.getWizard());
                }
            }
        });
        comboBoxPanel.add((Component)this.comboBox, "South");
        return comboBoxPanel;
    }

    protected JComponent createAntialiasedOptionPanel() {
        JPanel antialiasedPanel = new JPanel(new BorderLayout());
        this.antialiasedCheckBox = new JCheckBox("Antialiased");
        this.antialiasedCheckBox.setToolTipText("Antialiasing can make the image look smoother.");
        this.antialiasedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectFormatPage.this.selectedFormat != null) {
                    SelectFormatPage.this.selectedFormat.setAntialiased(SelectFormatPage.this.antialiasedCheckBox.isSelected());
                }
            }
        });
        antialiasedPanel.add((Component)this.antialiasedCheckBox, "West");
        return antialiasedPanel;
    }

    protected JComponent createScalingOptionPanel() {
        JPanel scalingPanel = new JPanel(new BorderLayout(14, 14));
        this.scaledCheckBox = new JCheckBox(new AbstractAction("Scale export"){
            private static final long serialVersionUID = -7815080042660552572L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectFormatPage.this.setControlState();
            }
        });
        this.scaledCheckBox.setToolTipText("The percentage that the export will be scaled to.");
        scalingPanel.add((Component)this.scaledCheckBox, "West");
        this.scaleSpinner = new JSpinner(new SpinnerNumberModel(100, 10, 1000, 10));
        this.scaleSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SelectFormatPage.this.selectedFormat != null) {
                    SelectFormatPage.this.selectedFormat.setScale(((Integer)SelectFormatPage.this.scaleSpinner.getValue()).intValue());
                }
            }
        });
        scalingPanel.add(this.scaleSpinner);
        return scalingPanel;
    }

    protected void setControlState() {
        if (this.selectedFormat == null) {
            this.antialiasedCheckBox.setEnabled(false);
            this.scaledCheckBox.setEnabled(false);
        } else {
            if (this.selectedFormat.supportsScaledOutput()) {
                this.scaledCheckBox.setEnabled(true);
                this.scaleSpinner.setValue(new Integer((int)this.selectedFormat.getScale()));
                if (this.scaledCheckBox.isSelected()) {
                    this.scaleSpinner.setEnabled(true);
                } else {
                    this.scaleSpinner.setEnabled(false);
                }
            } else {
                this.scaledCheckBox.setEnabled(false);
                this.scaleSpinner.setEnabled(false);
            }
            if (this.selectedFormat.isRasterFormat()) {
                if (this.selectedFormat.supportsAntialiasing()) {
                    this.antialiasedCheckBox.setSelected(this.selectedFormat.getAntialiased());
                    this.antialiasedCheckBox.setEnabled(true);
                } else {
                    this.antialiasedCheckBox.setSelected(false);
                    this.antialiasedCheckBox.setEnabled(false);
                }
            } else {
                this.antialiasedCheckBox.setSelected(false);
                this.antialiasedCheckBox.setEnabled(false);
            }
        }
    }

    public ExportFormat getSelectedExportFormat() {
        return this.selectedFormat;
    }

    @Override
    public void pageSelected(Wizard w) {
        this.setControlState();
        this.setButtonState(w);
    }

    protected void setButtonState(Wizard w) {
        if (this.selectedFormat != null) {
            w.setNextButtonEnabled(true);
        } else {
            w.setNextButtonEnabled(true);
        }
    }

    private class ExportFormatRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7269562763321289767L;

        private ExportFormatRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setText(((ExportFormat)value).getFormatName() + " [" + ((ExportFormat)value).getFormatDescription() + "]");
            return label;
        }
    }
}

