/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.protege.editor.owl.ui.transfer.OWLObjectDataFlavor;
import org.protege.editor.owl.ui.view.cls.AbstractOWLClassViewComponent;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import uk.ac.man.cs.mig.coode.owlviz.command.ExportCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.HideAllClassesCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.HideClassCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.HideClassesPastRadiusCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.HideSubclassesCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.SetOptionsCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.ShowAllClassesCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.ShowClassCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.ShowSubclassesCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.ShowSuperclassesCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.ZoomInCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.ZoomOutCommand;
import uk.ac.man.cs.mig.coode.owlviz.model.OWLClassGraphAssertedModel;
import uk.ac.man.cs.mig.coode.owlviz.model.OWLClassGraphInferredModel;
import uk.ac.man.cs.mig.coode.owlviz.ui.ConfigurableOWLVizView;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizGraphPanel;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizSelectionModel;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizViewI;
import uk.ac.man.cs.mig.coode.owlviz.ui.options.GlobalOptionsPage;
import uk.ac.man.cs.mig.coode.owlviz.ui.options.LayoutDirectionOptionsPage;
import uk.ac.man.cs.mig.coode.owlviz.ui.options.ModeOptionsPage;
import uk.ac.man.cs.mig.coode.owlviz.ui.options.OWLVizViewOptions;
import uk.ac.man.cs.mig.coode.owlviz.ui.options.OptionsDialog;
import uk.ac.man.cs.mig.util.graph.controller.Controller;
import uk.ac.man.cs.mig.util.graph.event.GraphSelectionModelEvent;
import uk.ac.man.cs.mig.util.graph.event.GraphSelectionModelListener;
import uk.ac.man.cs.mig.util.graph.event.NodeClickedEvent;
import uk.ac.man.cs.mig.util.graph.event.NodeClickedListener;
import uk.ac.man.cs.mig.util.graph.export.ExportFormatManager;
import uk.ac.man.cs.mig.util.graph.export.impl.JPEGExportFormat;
import uk.ac.man.cs.mig.util.graph.export.impl.PNGExportFormat;
import uk.ac.man.cs.mig.util.graph.ui.GraphComponent;

public class OWLVizView
extends AbstractOWLClassViewComponent
implements DropTargetListener,
OWLVizViewI,
ConfigurableOWLVizView {
    private static final long serialVersionUID = -7785134782365129398L;
    private static Logger logger = Logger.getLogger(OWLVizView.class);
    private GraphComponent assertedGraphComponent;
    private GraphComponent inferredGraphComponent;
    private OWLVizSelectionModel selectionModel;
    private HashSet closableTabs;
    private JTabbedPane tabbedPane;
    private Map<OWLVizGraphPanel, List<GraphComponent>> componentGroupMap;
    private HashSet<GraphComponent> graphComponents;
    public static final String DOT_PATH_PROPERTIES_KEY = "OWLViz.Dot.Path";
    private OWLClassGraphInferredModel inferredGraphModel;
    private OWLClassGraphAssertedModel assertedGraphModel;
    private OWLVizViewOptions options;

    public void initialiseClassView() throws Exception {
        this.loadProperties();
        this.options = new OWLVizViewOptions();
        this.selectionModel = new OWLVizSelectionModel();
        this.setupExportFormats();
        this.closableTabs = new HashSet();
        this.componentGroupMap = new HashMap<OWLVizGraphPanel, List<GraphComponent>>();
        this.graphComponents = new HashSet();
        this.createOWLVizTabUI();
        DropTarget dt = new DropTarget((Component)((Object)this), this);
        dt.setActive(true);
    }

    protected OWLClass updateView(OWLClass selectedClass) {
        this.selectionModel.setSelectedClass(selectedClass);
        return selectedClass;
    }

    public void disposeView() {
        this.assertedGraphModel.dispose();
        this.inferredGraphModel.dispose();
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    @Override
    public OWLVizSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public Collection<GraphComponent> getGraphComponents() {
        return this.getAllGraphComponents();
    }

    @Override
    public Collection<GraphComponent> getAllGraphComponents() {
        return new ArrayList<GraphComponent>(this.graphComponents);
    }

    public GraphComponent getAssertedGraphComponent() {
        return this.assertedGraphComponent;
    }

    public GraphComponent getInferredGraphComponent() {
        return this.inferredGraphComponent;
    }

    protected void createOWLVizTabUI() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.add(this.tabbedPane);
        this.assertedGraphModel = new OWLClassGraphAssertedModel(this.getOWLModelManager());
        OWLVizGraphPanel assertedPanel = new OWLVizGraphPanel("Asserted model", this, this.getOWLEditorKit(), this.assertedGraphModel);
        this.assertedGraphComponent = assertedPanel.getGraphComponent();
        this.setupListeners(this.assertedGraphComponent);
        this.tabbedPane.add(assertedPanel.getName(), assertedPanel);
        this.graphComponents.add(this.assertedGraphComponent);
        this.inferredGraphModel = new OWLClassGraphInferredModel(this.getOWLModelManager());
        OWLVizGraphPanel inferredPanel = new OWLVizGraphPanel("Inferred model", this, this.getOWLEditorKit(), this.inferredGraphModel);
        this.inferredGraphComponent = inferredPanel.getGraphComponent();
        this.tabbedPane.add(inferredPanel.getName(), inferredPanel);
        this.graphComponents.add(this.inferredGraphComponent);
        ArrayList<GraphComponent> list = new ArrayList<GraphComponent>();
        list.add(this.assertedGraphComponent);
        list.add(this.inferredGraphComponent);
        this.componentGroupMap.put(assertedPanel, list);
        this.componentGroupMap.put(inferredPanel, list);
        this.createToolBar(this.assertedGraphComponent.getController(), this.assertedGraphComponent.getController());
    }

    protected void forceRepaint() {
        for (GraphComponent curGraphComponent : this.getGraphComponents()) {
            curGraphComponent.getGraphView().repaint();
        }
    }

    protected void setupListeners(GraphComponent graphComponent) {
        graphComponent.getGraphView().addNodeClickedListener(new NodeClickedListener(){

            @Override
            public void nodeClicked(NodeClickedEvent evt) {
            }
        });
        graphComponent.addGraphSelectionModelListener(new GraphSelectionModelListener(){

            @Override
            public void selectionChanged(GraphSelectionModelEvent event) {
                Object selObj = event.getSource().getSelectedObject();
                if (selObj instanceof OWLClass) {
                    OWLVizView.this.selectionModel.setSelectedClass((OWLClass)selObj);
                    OWLVizView.this.setGlobalSelection((OWLEntity)((OWLClass)selObj));
                }
            }
        });
        this.tabbedPane.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                OWLVizView.this.componentGroupMap.remove(e.getChild());
                OWLVizView.this.closableTabs.remove(e.getChild());
                OWLVizView.this.graphComponents.remove(e.getChild());
                OWLVizGraphPanel panel = (OWLVizGraphPanel)e.getChild();
                panel.dispose();
            }
        });
    }

    protected void createToolBar(Controller assertedController, Controller inferredController) {
        this.addAction(new ShowClassCommand(this, this.getOWLModelManager(), (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this))), "A", "A");
        this.addAction(new ShowSubclassesCommand(this), "A", "B");
        this.addAction(new ShowSuperclassesCommand(this), "A", "C");
        this.addAction(new ShowAllClassesCommand(this, this.getOWLModelManager()), "A", "D");
        this.addAction(new HideClassCommand(this), "A", "E");
        this.addAction(new HideSubclassesCommand(this), "A", "F");
        this.addAction(new HideClassesPastRadiusCommand(assertedController, inferredController), "A", "G");
        this.addAction(new HideAllClassesCommand(this), "A", "H");
        this.addAction(new ZoomOutCommand(this), "B", "A");
        this.addAction(new ZoomInCommand(this), "B", "B");
        this.addAction(new ExportCommand(this), "C", "A");
        this.addAction(new SetOptionsCommand(this, this.setupOptionsDialog()), "D", "A");
    }

    protected void setupExportFormats() {
        ExportFormatManager.addExportFormat(new PNGExportFormat());
        ExportFormatManager.addExportFormat(new JPEGExportFormat());
    }

    protected OptionsDialog setupOptionsDialog() {
        OptionsDialog optionsDialog = new OptionsDialog((Frame)this.getWorkspace().getTopLevelAncestor());
        optionsDialog.addOptionsPage(new ModeOptionsPage(this.getOptions()), "Mode");
        optionsDialog.addOptionsPage(new LayoutDirectionOptionsPage(this.assertedGraphComponent.getController(), this.inferredGraphComponent.getController()), "Layout");
        optionsDialog.addOptionsPage(new GlobalOptionsPage(this.getOWLEditorKit()), "Global");
        return optionsDialog;
    }

    public void loadProperties() {
    }

    public void saveProperties() {
    }

    public void close() {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        logger.info((Object)("Drop: " + dtde));
        if (dtde.isDataFlavorSupported((DataFlavor)OWLObjectDataFlavor.OWL_OBJECT_DATA_FLAVOR)) {
            try {
                List objects = (List)dtde.getTransferable().getTransferData((DataFlavor)OWLObjectDataFlavor.OWL_OBJECT_DATA_FLAVOR);
                ArrayList<OWLClass> clses = new ArrayList<OWLClass>();
                for (OWLObject obj : objects) {
                    if (!(obj instanceof OWLClass)) continue;
                    clses.add((OWLClass)obj);
                }
                if (!clses.isEmpty()) {
                    this.getAssertedGraphComponent().getVisualisedObjectManager().showObjects(clses.toArray());
                    dtde.dropComplete(true);
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public OWLVizViewOptions getOptions() {
        return this.options;
    }
}

