/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.util.HashSet;
import javax.swing.JScrollPane;
import org.protege.editor.owl.ui.view.cls.AbstractOWLClassViewComponent;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.man.cs.mig.coode.owlviz.model.OWLVizAxiomGraphModel;
import uk.ac.man.cs.mig.util.graph.controller.Controller;
import uk.ac.man.cs.mig.util.graph.controller.impl.DefaultController;

public class OWLVizAxiomView
extends AbstractOWLClassViewComponent {
    private static final long serialVersionUID = -2736965181564975528L;
    private Controller controller;
    private OWLVizAxiomGraphModel graphModel;
    private CardLayout cardLayout;

    public void disposeView() {
    }

    public void initialiseClassView() throws Exception {
        this.createGraphModel(null);
        this.controller = new DefaultController(this.graphModel);
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.controller.getGraphView()));
    }

    private void createGraphModel(OWLClass cls) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        if (cls != null) {
            for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
                axioms.addAll(ont.getAxioms(cls));
            }
        }
        this.graphModel = new OWLVizAxiomGraphModel(axioms);
    }

    protected OWLClass updateView(OWLClass selectedClass) {
        this.createGraphModel(selectedClass);
        this.controller.setGraphModel(this.graphModel);
        this.controller.getVisualisedObjectManager().showObjects(this.graphModel.getAllNodes().toArray());
        return selectedClass;
    }
}

