/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.man.cs.mig.util.graph.model.impl.AbstractGraphModel;

public class OWLOntologyImportsGraphModel
extends AbstractGraphModel {
    private static final Logger logger = Logger.getLogger(OWLOntologyImportsGraphModel.class);
    private Map<OWLOntology, Set<OWLOntology>> importMap;
    private OWLModelManager owlModelManager;

    public OWLOntologyImportsGraphModel(OWLModelManager owlModelManager) {
        this.owlModelManager = owlModelManager;
        this.importMap = new HashMap<OWLOntology, Set<OWLOntology>>();
        this.rebuild();
    }

    public void rebuild() {
        this.importMap.clear();
        for (OWLOntology ont : this.owlModelManager.getOntologies()) {
            for (OWLOntology imp : ont.getDirectImports()) {
                this.getImportingOntologies(imp, true).add(ont);
            }
        }
    }

    private Set<OWLOntology> getImportingOntologies(OWLOntology ont, boolean add) {
        Set<OWLOntology> onts = this.importMap.get(ont);
        if (onts == null) {
            onts = new HashSet<OWLOntology>();
            if (add) {
                this.importMap.put(ont, onts);
            }
        }
        return onts;
    }

    @Override
    public int getChildCount(Object obj) {
        return this.getImportingOntologies((OWLOntology)obj, true).size();
    }

    @Override
    public Iterator getChildren(Object obj) {
        return this.getImportingOntologies((OWLOntology)obj, true).iterator();
    }

    @Override
    public int getParentCount(Object obj) {
        return ((OWLOntology)obj).getImportsDeclarations().size();
    }

    @Override
    public Iterator getParents(Object obj) {
        return ((OWLOntology)obj).getImportsDeclarations().iterator();
    }

    @Override
    public boolean contains(Object obj) {
        return this.owlModelManager.getOntologies().contains((OWLOntology)obj);
    }

    @Override
    public Object getRelationshipType(Object parentObject, Object childObject) {
        return "imports";
    }

    @Override
    public int getRelationshipDirection(Object parentObject, Object childObject) {
        return 3;
    }

    @Override
    public Iterator getRelatedObjectsToAdd(Object obj) {
        return Collections.emptySet().iterator();
    }

    @Override
    public Iterator getRelatedObjectsToRemove(Object obj) {
        return Collections.emptySet().iterator();
    }

    @Override
    public void dispose() {
    }
}

