/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProviderListener;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import uk.ac.man.cs.mig.util.graph.model.impl.AbstractGraphModel;

public class AbstractOWLClassGraphModel
extends AbstractGraphModel {
    private OWLModelManager owlModelManager;
    private OWLObjectHierarchyProvider provider;
    private OWLObjectHierarchyProviderListener listener;
    private OWLOntologyChangeListener changeListener;
    private OWLModelManagerListener owlModelManagerListener;

    public AbstractOWLClassGraphModel(OWLModelManager owlModelManager, OWLObjectHierarchyProvider provider) {
        this.owlModelManager = owlModelManager;
        this.listener = new OWLObjectHierarchyProviderListener(){

            public void nodeChanged(OWLObject node) {
            }

            public void childParentAdded(OWLObject child, OWLObject parent) {
                AbstractOWLClassGraphModel.this.fireChildAddedEvent(parent, child);
                AbstractOWLClassGraphModel.this.fireParentAddedEvent(child, parent);
            }

            public void childParentRemoved(OWLObject child, OWLObject parent) {
                AbstractOWLClassGraphModel.this.fireChildRemovedEvent(parent, child);
                AbstractOWLClassGraphModel.this.fireParentRemovedEvent(child, parent);
            }

            public void rootAdded(OWLObject root) {
            }

            public void rootRemoved(OWLObject root) {
            }

            public void hierarchyChanged() {
            }
        };
        provider.addListener(this.listener);
        this.provider = provider;
        this.changeListener = new OWLOntologyChangeListener(){

            public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
            }
        };
        owlModelManager.addOntologyChangeListener(this.changeListener);
        this.owlModelManagerListener = new OWLModelManagerListener(){

            public void handleChange(OWLModelManagerChangeEvent event) {
                if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || event.isType(EventType.ONTOLOGY_RELOADED)) {
                    AbstractOWLClassGraphModel.this.fireModelChangedEvent();
                }
            }
        };
        owlModelManager.addListener(this.owlModelManagerListener);
    }

    @Override
    public void dispose() {
        this.provider.removeListener(this.listener);
        this.owlModelManager.removeOntologyChangeListener(this.changeListener);
        this.owlModelManager.removeListener(this.owlModelManagerListener);
    }

    protected Set<OWLObject> getChildren(OWLObject obj) {
        HashSet<OWLObject> children = new HashSet<OWLObject>();
        children.addAll(this.provider.getChildren(obj));
        children.addAll(this.provider.getEquivalents(obj));
        return children;
    }

    protected Set<OWLObject> getParents(OWLObject obj) {
        HashSet<OWLObject> parents = new HashSet<OWLObject>();
        parents.addAll(this.provider.getParents(obj));
        parents.addAll(this.provider.getEquivalents(obj));
        return parents;
    }

    @Override
    public int getChildCount(Object obj) {
        return this.getChildren((OWLObject)obj).size();
    }

    @Override
    public Iterator getChildren(Object obj) {
        return this.getChildren((OWLObject)obj).iterator();
    }

    @Override
    public int getParentCount(Object obj) {
        return this.getParents((OWLObject)obj).size();
    }

    @Override
    public Iterator getParents(Object obj) {
        return this.getParents((OWLObject)obj).iterator();
    }

    @Override
    public boolean contains(Object obj) {
        if (obj instanceof OWLClass) {
            for (OWLOntology ont : this.owlModelManager.getActiveOntologies()) {
                if (!ont.containsClassInSignature(((OWLClass)obj).getIRI())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getRelationshipType(Object parentObject, Object childObject) {
        return " is-a ";
    }

    @Override
    public int getRelationshipDirection(Object parentObject, Object childObject) {
        return 3;
    }

    @Override
    public Iterator getRelatedObjectsToAdd(Object obj) {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public Iterator getRelatedObjectsToRemove(Object obj) {
        return Collections.EMPTY_LIST.iterator();
    }
}

