/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.command;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.view.OWLSelectionViewAction;
import org.semanticweb.owlapi.model.OWLClass;
import uk.ac.man.cs.mig.coode.owlviz.ui.ClassRadiusDialog;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizIcons;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizViewI;
import uk.ac.man.cs.mig.util.graph.ui.GraphComponent;

public class ShowClassCommand
extends OWLSelectionViewAction {
    private static final long serialVersionUID = 1179591525072515755L;
    private OWLVizViewI view;
    private OWLModelManager kb;
    private Frame owner;

    public ShowClassCommand(OWLVizViewI view, OWLModelManager kb, Frame owner) {
        super("Show class", (Icon)OWLVizIcons.getIcon("ShowClassIcon.png"));
        this.putValue("ShortDescription", "Show class");
        this.view = view;
        this.kb = kb;
        this.owner = owner;
    }

    public void updateState() {
        this.setEnabled(true);
    }

    public void dispose() {
    }

    public void actionPerformed(ActionEvent e) {
        OWLClass selObj;
        ClassRadiusDialog dlg = new ClassRadiusDialog(this.owner, true);
        int retVal = dlg.showDialog();
        if (retVal == 1 && (selObj = this.view.getSelectionModel().getSelectedClass()) != null && selObj instanceof OWLClass) {
            int radius = dlg.getClassRadius();
            int supersSubsOptions = dlg.getSupersSubsOption();
            for (GraphComponent curGraphComponent : this.view.getGraphComponents()) {
                if (supersSubsOptions == 1) {
                    curGraphComponent.getVisualisedObjectManager().showObject(selObj, radius, OWLClass.class);
                    continue;
                }
                if (supersSubsOptions == 2) {
                    curGraphComponent.getVisualisedObjectManager().showParents(selObj, radius, OWLClass.class);
                    continue;
                }
                curGraphComponent.getVisualisedObjectManager().showChildren(selObj, radius, OWLClass.class);
            }
        }
    }
}

