/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.command;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.protege.editor.owl.ui.view.OWLSelectionViewAction;
import org.semanticweb.owlapi.model.OWLClass;
import uk.ac.man.cs.mig.coode.owlviz.ui.ClassRadiusDialog;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizIcons;
import uk.ac.man.cs.mig.util.graph.controller.Controller;

public class HideClassesPastRadiusCommand
extends OWLSelectionViewAction {
    private static final long serialVersionUID = 8091430865811611828L;
    private Controller assertedController;
    private Controller inferredController;
    private ClassRadiusDialog dlg;

    public HideClassesPastRadiusCommand(Controller assertedController, Controller inferredController) {
        super("Hide classes past radius", (Icon)OWLVizIcons.getIcon("HideClassesPastRadiusIcon.png"));
        this.putValue("ShortDescription", "Hide classes past radius");
        this.assertedController = assertedController;
        this.inferredController = inferredController;
        this.dlg = new ClassRadiusDialog(null, false);
    }

    public void updateState() {
        this.setEnabled(true);
    }

    public void dispose() {
    }

    public void actionPerformed(ActionEvent e) {
        Object selObj = this.assertedController.getGraphSelectionModel().getSelectedObject();
        if (selObj != null && this.dlg.showDialog() == 1) {
            int classRadius = this.dlg.getClassRadius();
            this.assertedController.getVisualisedObjectManager().hideObjects(selObj, classRadius, OWLClass.class);
            this.inferredController.getVisualisedObjectManager().hideObjects(selObj, classRadius, OWLClass.class);
        }
    }
}

