/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.NodeIDLessEqualThan;
import org.semanticweb.HermiT.model.NodeIDsAscendingOrEqual;
import org.semanticweb.HermiT.model.Term;
import org.semanticweb.HermiT.model.Variable;
import org.semanticweb.HermiT.tableau.DLClauseEvaluator;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.InterruptFlag;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.HermiT.tableau.UnionDependencySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HyperresolutionManager
implements Serializable {
    private static final long serialVersionUID = -4880817508962130189L;
    protected final ExtensionManager m_extensionManager;
    protected final ExtensionTable.Retrieval[] m_deltaOldRetrievals;
    protected final ExtensionTable.Retrieval m_binaryTableRetrieval;
    protected final Map<DLPredicate, CompiledDLClauseInfo> m_tupleConsumersByDeltaPredicate;
    protected final Map<AtomicRole, CompiledDLClauseInfo> m_atomicRoleTupleConsumersUnguarded;
    protected final HashMap<AtomicRole, Map<AtomicConcept, CompiledDLClauseInfo>> m_atomicRoleTupleConsumersByGuardConcept1;
    protected final HashMap<AtomicRole, Map<AtomicConcept, CompiledDLClauseInfo>> m_atomicRoleTupleConsumersByGuardConcept2;
    protected final Object[][] m_buffersToClear;
    protected final UnionDependencySet[] m_unionDependencySetsToClear;
    protected final Object[] m_valuesBuffer;
    protected final int m_maxNumberOfVariables;

    public HyperresolutionManager(Tableau tableau, Set<DLClause> set) {
        List list;
        Object object;
        InterruptFlag interruptFlag = tableau.m_interruptFlag;
        this.m_extensionManager = tableau.m_extensionManager;
        this.m_tupleConsumersByDeltaPredicate = new HashMap<DLPredicate, CompiledDLClauseInfo>();
        this.m_atomicRoleTupleConsumersUnguarded = new HashMap<AtomicRole, CompiledDLClauseInfo>();
        this.m_atomicRoleTupleConsumersByGuardConcept1 = new HashMap();
        this.m_atomicRoleTupleConsumersByGuardConcept2 = new HashMap();
        HashMap hashMap = new HashMap();
        for (DLClause object22 : set) {
            object = new DLClauseBodyKey(object22);
            list = (List)hashMap.get(object);
            if (list == null) {
                list = new ArrayList();
                hashMap.put(object, list);
            }
            list.add(object22);
            interruptFlag.checkInterrupt();
        }
        HashMap hashMap2 = new HashMap();
        DLClauseEvaluator.BufferSupply bufferSupply = new DLClauseEvaluator.BufferSupply();
        object = new DLClauseEvaluator.ValuesBufferManager(set);
        list = new DLClauseEvaluator.GroundDisjunctionHeaderManager();
        HashMap<Integer, UnionDependencySet> hashMap3 = new HashMap<Integer, UnionDependencySet>();
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        ArrayList<Atom> arrayList2 = new ArrayList<Atom>();
        for (Map.Entry entry : hashMap.entrySet()) {
            DLClause dLClause = ((DLClauseBodyKey)entry.getKey()).m_dlClause;
            BodyAtomsSwapper bodyAtomsSwapper = new BodyAtomsSwapper(dLClause);
            for (int i = 0; i < dLClause.getBodyLength(); ++i) {
                Serializable serializable;
                if (!this.isPredicateWithExtension(dLClause.getBodyAtom(i).getDLPredicate())) continue;
                DLClause dLClause2 = bodyAtomsSwapper.getSwappedDLClause(i);
                Atom atom = dLClause2.getBodyAtom(0);
                DLPredicate dLPredicate = atom.getDLPredicate();
                Integer n = dLPredicate.getArity() + 1;
                ExtensionTable.Retrieval retrieval = (ExtensionTable.Retrieval)hashMap2.get(n);
                if (retrieval == null) {
                    serializable = this.m_extensionManager.getExtensionTable(n);
                    retrieval = serializable.createRetrieval(new boolean[serializable.getArity()], ExtensionTable.View.DELTA_OLD);
                    hashMap2.put(n, retrieval);
                }
                serializable = new DLClauseEvaluator(tableau, dLClause2, (List)entry.getValue(), retrieval, bufferSupply, (DLClauseEvaluator.ValuesBufferManager)object, (DLClauseEvaluator.GroundDisjunctionHeaderManager)((Object)list), (Map<Integer, UnionDependencySet>)hashMap3);
                CompiledDLClauseInfo compiledDLClauseInfo = new CompiledDLClauseInfo((DLClauseEvaluator)serializable, this.m_tupleConsumersByDeltaPredicate.get(dLPredicate));
                this.m_tupleConsumersByDeltaPredicate.put(dLPredicate, compiledDLClauseInfo);
                if (dLPredicate instanceof AtomicRole && atom.getArgument(0) instanceof Variable && atom.getArgument(1) instanceof Variable) {
                    CompiledDLClauseInfo compiledDLClauseInfo2;
                    AtomicConcept atomicConcept;
                    Map<AtomicConcept, CompiledDLClauseInfo> map;
                    AtomicRole atomicRole = (AtomicRole)dLPredicate;
                    this.getAtomicRoleClauseGuards(dLClause2, arrayList, arrayList2);
                    if (!arrayList.isEmpty()) {
                        map = this.m_atomicRoleTupleConsumersByGuardConcept1.get(atomicRole);
                        if (map == null) {
                            map = new HashMap<AtomicConcept, CompiledDLClauseInfo>();
                            this.m_atomicRoleTupleConsumersByGuardConcept1.put(atomicRole, map);
                        }
                        for (Atom atom2 : arrayList) {
                            atomicConcept = (AtomicConcept)atom2.getDLPredicate();
                            compiledDLClauseInfo2 = new CompiledDLClauseInfo((DLClauseEvaluator)serializable, (CompiledDLClauseInfo)map.get(atomicConcept));
                            map.put(atomicConcept, compiledDLClauseInfo2);
                        }
                    }
                    if (!arrayList2.isEmpty()) {
                        map = this.m_atomicRoleTupleConsumersByGuardConcept2.get(atomicRole);
                        if (map == null) {
                            map = new HashMap<AtomicConcept, CompiledDLClauseInfo>();
                            this.m_atomicRoleTupleConsumersByGuardConcept2.put(atomicRole, map);
                        }
                        for (Atom atom2 : arrayList2) {
                            atomicConcept = (AtomicConcept)atom2.getDLPredicate();
                            compiledDLClauseInfo2 = new CompiledDLClauseInfo((DLClauseEvaluator)serializable, (CompiledDLClauseInfo)map.get(atomicConcept));
                            map.put(atomicConcept, compiledDLClauseInfo2);
                        }
                    }
                    if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                        map = new CompiledDLClauseInfo((DLClauseEvaluator)serializable, this.m_atomicRoleTupleConsumersUnguarded.get(atomicRole));
                        this.m_atomicRoleTupleConsumersUnguarded.put(atomicRole, (CompiledDLClauseInfo)((Object)map));
                    }
                }
                bufferSupply.reuseBuffers();
                interruptFlag.checkInterrupt();
            }
        }
        this.m_deltaOldRetrievals = new ExtensionTable.Retrieval[hashMap2.size()];
        hashMap2.values().toArray(this.m_deltaOldRetrievals);
        this.m_binaryTableRetrieval = this.m_extensionManager.getExtensionTable(2).createRetrieval(new boolean[]{false, true}, ExtensionTable.View.EXTENSION_THIS);
        this.m_buffersToClear = bufferSupply.getAllBuffers();
        this.m_unionDependencySetsToClear = new UnionDependencySet[hashMap3.size()];
        hashMap3.values().toArray(this.m_unionDependencySetsToClear);
        this.m_valuesBuffer = ((DLClauseEvaluator.ValuesBufferManager)object).m_valuesBuffer;
        this.m_maxNumberOfVariables = ((DLClauseEvaluator.ValuesBufferManager)object).m_maxNumberOfVariables;
    }

    protected void getAtomicRoleClauseGuards(DLClause dLClause, List<Atom> list, List<Atom> list2) {
        list.clear();
        list2.clear();
        Atom atom = dLClause.getBodyAtom(0);
        Variable variable = atom.getArgumentVariable(0);
        Variable variable2 = atom.getArgumentVariable(1);
        for (int i = 1; i < dLClause.getBodyLength(); ++i) {
            Variable variable3;
            Atom atom2 = dLClause.getBodyAtom(i);
            if (atom2.getDLPredicate() instanceof AtomicConcept && (variable3 = atom2.getArgumentVariable(0)) != null) {
                if (variable.equals(variable3)) {
                    list.add(atom2);
                }
                if (variable2.equals(variable3)) {
                    list2.add(atom2);
                }
            }
            ++i;
        }
    }

    protected boolean isPredicateWithExtension(DLPredicate dLPredicate) {
        return !NodeIDLessEqualThan.INSTANCE.equals(dLPredicate) && !(dLPredicate instanceof NodeIDsAscendingOrEqual);
    }

    public void clear() {
        int n;
        Object[] objectArray;
        int n2;
        for (n2 = this.m_deltaOldRetrievals.length - 1; n2 >= 0; --n2) {
            this.m_deltaOldRetrievals[n2].clear();
        }
        this.m_binaryTableRetrieval.clear();
        for (n2 = this.m_buffersToClear.length - 1; n2 >= 0; --n2) {
            objectArray = this.m_buffersToClear[n2];
            for (n = objectArray.length - 1; n >= 0; --n) {
                objectArray[n] = null;
            }
        }
        for (n2 = this.m_unionDependencySetsToClear.length - 1; n2 >= 0; --n2) {
            objectArray = this.m_unionDependencySetsToClear[n2].m_dependencySets;
            for (n = objectArray.length - 1; n >= 0; --n) {
                objectArray[n] = null;
            }
        }
        for (n2 = 0; n2 < this.m_maxNumberOfVariables; ++n2) {
            this.m_valuesBuffer[n2] = null;
        }
    }

    public void applyDLClauses() {
        for (int i = 0; i < this.m_deltaOldRetrievals.length; ++i) {
            ExtensionTable.Retrieval retrieval = this.m_deltaOldRetrievals[i];
            retrieval.open();
            Object[] objectArray = retrieval.getTupleBuffer();
            while (!retrieval.afterLast() && !this.m_extensionManager.containsClash()) {
                Object object = objectArray[0];
                CompiledDLClauseInfo compiledDLClauseInfo = this.m_tupleConsumersByDeltaPredicate.get(object);
                boolean bl = true;
                if (compiledDLClauseInfo != null && objectArray[0] instanceof AtomicRole) {
                    CompiledDLClauseInfo compiledDLClauseInfo2 = this.m_atomicRoleTupleConsumersUnguarded.get(object);
                    if (compiledDLClauseInfo.m_indexInList > ((Node)objectArray[1]).getNumberOfPositiveAtomicConcepts() + ((Node)objectArray[2]).getNumberOfPositiveAtomicConcepts() + (compiledDLClauseInfo2 == null ? 0 : compiledDLClauseInfo2.m_indexInList)) {
                        CompiledDLClauseInfo compiledDLClauseInfo3;
                        Object object2;
                        Object[] objectArray2;
                        Map<AtomicConcept, CompiledDLClauseInfo> map;
                        bl = false;
                        while (compiledDLClauseInfo2 != null && !this.m_extensionManager.containsClash()) {
                            compiledDLClauseInfo2.m_evaluator.evaluate();
                            compiledDLClauseInfo2 = compiledDLClauseInfo2.m_next;
                        }
                        if (!this.m_extensionManager.containsClash() && (map = this.m_atomicRoleTupleConsumersByGuardConcept1.get(object)) != null) {
                            this.m_binaryTableRetrieval.getBindingsBuffer()[1] = objectArray[1];
                            this.m_binaryTableRetrieval.open();
                            objectArray2 = this.m_binaryTableRetrieval.getTupleBuffer();
                            while (!this.m_binaryTableRetrieval.afterLast() && !this.m_extensionManager.containsClash()) {
                                object2 = objectArray2[0];
                                if (object2 instanceof AtomicConcept) {
                                    compiledDLClauseInfo3 = map.get(object2);
                                    while (compiledDLClauseInfo3 != null && !this.m_extensionManager.containsClash()) {
                                        compiledDLClauseInfo3.m_evaluator.evaluate();
                                        compiledDLClauseInfo3 = compiledDLClauseInfo3.m_next;
                                    }
                                }
                                this.m_binaryTableRetrieval.next();
                            }
                        }
                        if (!this.m_extensionManager.containsClash() && (map = this.m_atomicRoleTupleConsumersByGuardConcept2.get(object)) != null) {
                            this.m_binaryTableRetrieval.getBindingsBuffer()[1] = objectArray[2];
                            this.m_binaryTableRetrieval.open();
                            objectArray2 = this.m_binaryTableRetrieval.getTupleBuffer();
                            while (!this.m_binaryTableRetrieval.afterLast() && !this.m_extensionManager.containsClash()) {
                                object2 = objectArray2[0];
                                if (object2 instanceof AtomicConcept) {
                                    compiledDLClauseInfo3 = map.get(object2);
                                    while (compiledDLClauseInfo3 != null && !this.m_extensionManager.containsClash()) {
                                        compiledDLClauseInfo3.m_evaluator.evaluate();
                                        compiledDLClauseInfo3 = compiledDLClauseInfo3.m_next;
                                    }
                                }
                                this.m_binaryTableRetrieval.next();
                            }
                        }
                    }
                }
                if (bl) {
                    while (compiledDLClauseInfo != null && !this.m_extensionManager.containsClash()) {
                        compiledDLClauseInfo.m_evaluator.evaluate();
                        compiledDLClauseInfo = compiledDLClauseInfo.m_next;
                    }
                }
                retrieval.next();
            }
        }
    }

    protected static final class DLClauseBodyKey {
        protected final DLClause m_dlClause;
        protected final int m_hashCode;

        public DLClauseBodyKey(DLClause dLClause) {
            this.m_dlClause = dLClause;
            int n = 0;
            for (int i = 0; i < this.m_dlClause.getBodyLength(); ++i) {
                n += this.m_dlClause.getBodyAtom(i).hashCode();
            }
            this.m_hashCode = n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            DLClause dLClause = ((DLClauseBodyKey)object).m_dlClause;
            if (this.m_dlClause.getBodyLength() != dLClause.getBodyLength()) {
                return false;
            }
            for (int i = 0; i < this.m_dlClause.getBodyLength(); ++i) {
                if (this.m_dlClause.getBodyAtom(i).equals(dLClause.getBodyAtom(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.m_hashCode;
        }
    }

    protected static final class BodyAtomsSwapper {
        protected final DLClause m_dlClause;
        protected final List<Atom> m_nodeIDComparisonAtoms;
        protected final boolean[] m_usedAtoms;
        protected final List<Atom> m_reorderedAtoms;
        protected final Set<Variable> m_boundVariables;

        public BodyAtomsSwapper(DLClause dLClause) {
            this.m_dlClause = dLClause;
            this.m_nodeIDComparisonAtoms = new ArrayList<Atom>(this.m_dlClause.getBodyLength());
            this.m_usedAtoms = new boolean[this.m_dlClause.getBodyLength()];
            this.m_reorderedAtoms = new ArrayList<Atom>(this.m_dlClause.getBodyLength());
            this.m_boundVariables = new HashSet<Variable>();
        }

        public DLClause getSwappedDLClause(int n) {
            Object object;
            this.m_nodeIDComparisonAtoms.clear();
            for (int i = this.m_usedAtoms.length - 1; i >= 0; --i) {
                this.m_usedAtoms[i] = false;
                object = this.m_dlClause.getBodyAtom(i);
                if (!NodeIDLessEqualThan.INSTANCE.equals(object.getDLPredicate())) continue;
                this.m_nodeIDComparisonAtoms.add((Atom)object);
            }
            this.m_reorderedAtoms.clear();
            this.m_boundVariables.clear();
            Atom atom = this.m_dlClause.getBodyAtom(n);
            atom.getVariables(this.m_boundVariables);
            this.m_reorderedAtoms.add(atom);
            this.m_usedAtoms[n] = true;
            while (this.m_reorderedAtoms.size() != this.m_usedAtoms.length) {
                object = null;
                int n2 = -1;
                int n3 = -1000;
                for (int i = this.m_usedAtoms.length - 1; i >= 0; --i) {
                    int n4;
                    if (this.m_usedAtoms[i] || (n4 = this.getAtomGoodness(atom = this.m_dlClause.getBodyAtom(i))) <= n3) continue;
                    object = atom;
                    n3 = n4;
                    n2 = i;
                }
                this.m_reorderedAtoms.add((Atom)object);
                this.m_usedAtoms[n2] = true;
                object.getVariables(this.m_boundVariables);
                this.m_nodeIDComparisonAtoms.remove(object);
            }
            object = new Atom[this.m_reorderedAtoms.size()];
            this.m_reorderedAtoms.toArray((T[])object);
            return this.m_dlClause.getChangedDLClause(null, (Atom[])object);
        }

        protected int getAtomGoodness(Atom atom) {
            Term term;
            int n;
            if (NodeIDLessEqualThan.INSTANCE.equals(atom.getDLPredicate())) {
                if (this.m_boundVariables.contains(atom.getArgumentVariable(0)) && this.m_boundVariables.contains(atom.getArgumentVariable(1))) {
                    return 1000;
                }
                return -2000;
            }
            if (atom.getDLPredicate() instanceof NodeIDsAscendingOrEqual) {
                int n2 = 0;
                for (int i = atom.getArity() - 1; i >= 0; --i) {
                    Term term2 = atom.getArgument(i);
                    if (!(term2 instanceof Variable) || this.m_boundVariables.contains(term2)) continue;
                    ++n2;
                }
                if (n2 > 0) {
                    return -5000;
                }
                return 5000;
            }
            int n3 = 0;
            int n4 = 0;
            for (n = atom.getArity() - 1; n >= 0; --n) {
                term = atom.getArgument(n);
                if (!(term instanceof Variable)) continue;
                if (this.m_boundVariables.contains(term)) {
                    ++n3;
                    continue;
                }
                ++n4;
            }
            n = n3 * 100 - n4 * 10;
            if (atom.getDLPredicate().getArity() == 2 && n4 == 1 && !this.m_nodeIDComparisonAtoms.isEmpty()) {
                term = atom.getArgumentVariable(0);
                if (this.m_boundVariables.contains(term)) {
                    term = atom.getArgumentVariable(1);
                }
                for (int i = this.m_nodeIDComparisonAtoms.size() - 1; i >= 0; --i) {
                    Atom atom2 = this.m_nodeIDComparisonAtoms.get(i);
                    Variable variable = atom2.getArgumentVariable(0);
                    Variable variable2 = atom2.getArgumentVariable(1);
                    if (!this.m_boundVariables.contains(variable) && !term.equals(variable) || !this.m_boundVariables.contains(variable2) && !term.equals(variable2)) continue;
                    n += 5;
                    break;
                }
            }
            return n;
        }
    }

    protected static final class CompiledDLClauseInfo {
        protected final DLClauseEvaluator m_evaluator;
        protected final CompiledDLClauseInfo m_next;
        protected final int m_indexInList;

        public CompiledDLClauseInfo(DLClauseEvaluator dLClauseEvaluator, CompiledDLClauseInfo compiledDLClauseInfo) {
            this.m_evaluator = dLClauseEvaluator;
            this.m_next = compiledDLClauseInfo;
            this.m_indexInList = this.m_next == null ? 1 : this.m_next.m_indexInList + 1;
        }
    }
}

