/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.HermiT.model.AnnotatedEquality;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Concept;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.model.DescriptionGraph;
import org.semanticweb.HermiT.model.Equality;
import org.semanticweb.HermiT.model.InternalDatatype;
import org.semanticweb.HermiT.model.InverseRole;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.monitor.TableauMonitor;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.DependencySetFactory;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.ExtensionTableWithFullIndex;
import org.semanticweb.HermiT.tableau.ExtensionTableWithTupleIndexes;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.PermanentDependencySet;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.HermiT.tableau.TupleIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionManager
implements Serializable {
    private static final long serialVersionUID = 5900300914631070591L;
    protected final Tableau m_tableau;
    protected final TableauMonitor m_tableauMonitor;
    protected final DependencySetFactory m_dependencySetFactory;
    protected final Map<Integer, ExtensionTable> m_extensionTablesByArity;
    protected final ExtensionTable[] m_allExtensionTablesArray;
    protected final ExtensionTable m_binaryExtensionTable;
    protected final ExtensionTable m_ternaryExtensionTable;
    protected final Object[] m_binaryAuxiliaryTupleContains;
    protected final Object[] m_binaryAuxiliaryTupleAdd;
    protected final Object[] m_ternaryAuxiliaryTupleContains;
    protected final Object[] m_ternaryAuxiliaryTupleAdd;
    protected final Object[] m_fouraryAuxiliaryTupleContains;
    protected final Object[] m_fouraryAuxiliaryTupleAdd;
    protected PermanentDependencySet m_clashDependencySet;
    protected boolean m_addActive;

    public ExtensionManager(Tableau tableau) {
        this.m_tableau = tableau;
        this.m_tableauMonitor = this.m_tableau.m_tableauMonitor;
        this.m_dependencySetFactory = this.m_tableau.m_dependencySetFactory;
        this.m_extensionTablesByArity = new HashMap<Integer, ExtensionTable>();
        this.m_binaryExtensionTable = new ExtensionTableWithTupleIndexes(this.m_tableau, 2, !this.m_tableau.isDeterministic(), new TupleIndex[]{new TupleIndex(new int[]{1, 0}), new TupleIndex(new int[]{0, 1})}){
            private static final long serialVersionUID = 1462821385000191875L;

            public boolean isTupleActive(Object[] objectArray) {
                return ((Node)objectArray[1]).isActive();
            }

            public boolean isTupleActive(int n) {
                return ((Node)this.m_tupleTable.getTupleObject(n, 1)).isActive();
            }
        };
        this.m_extensionTablesByArity.put(new Integer(2), this.m_binaryExtensionTable);
        this.m_ternaryExtensionTable = new ExtensionTableWithTupleIndexes(this.m_tableau, 3, !this.m_tableau.isDeterministic(), new TupleIndex[]{new TupleIndex(new int[]{0, 1, 2}), new TupleIndex(new int[]{1, 2, 0}), new TupleIndex(new int[]{2, 0, 1})}){
            private static final long serialVersionUID = -731201626401421877L;

            public boolean isTupleActive(Object[] objectArray) {
                return ((Node)objectArray[1]).isActive() && ((Node)objectArray[2]).isActive();
            }

            public boolean isTupleActive(int n) {
                return ((Node)this.m_tupleTable.getTupleObject(n, 1)).isActive() && ((Node)this.m_tupleTable.getTupleObject(n, 2)).isActive();
            }
        };
        this.m_extensionTablesByArity.put(new Integer(3), this.m_ternaryExtensionTable);
        for (DescriptionGraph descriptionGraph : this.m_tableau.m_permanentDLOntology.getAllDescriptionGraphs()) {
            Integer n = descriptionGraph.getNumberOfVertices() + 1;
            if (this.m_extensionTablesByArity.containsKey(n)) continue;
            this.m_extensionTablesByArity.put(n, new ExtensionTableWithFullIndex(this.m_tableau, descriptionGraph.getNumberOfVertices() + 1, !this.m_tableau.isDeterministic()));
        }
        this.m_allExtensionTablesArray = new ExtensionTable[this.m_extensionTablesByArity.size()];
        this.m_extensionTablesByArity.values().toArray(this.m_allExtensionTablesArray);
        this.m_binaryAuxiliaryTupleContains = new Object[2];
        this.m_binaryAuxiliaryTupleAdd = new Object[2];
        this.m_ternaryAuxiliaryTupleContains = new Object[3];
        this.m_ternaryAuxiliaryTupleAdd = new Object[3];
        this.m_fouraryAuxiliaryTupleContains = new Object[4];
        this.m_fouraryAuxiliaryTupleAdd = new Object[4];
    }

    public void clear() {
        for (int i = this.m_allExtensionTablesArray.length - 1; i >= 0; --i) {
            this.m_allExtensionTablesArray[i].clear();
        }
        this.m_clashDependencySet = null;
        this.m_binaryAuxiliaryTupleContains[0] = null;
        this.m_binaryAuxiliaryTupleContains[1] = null;
        this.m_binaryAuxiliaryTupleAdd[0] = null;
        this.m_binaryAuxiliaryTupleAdd[1] = null;
        this.m_ternaryAuxiliaryTupleContains[0] = null;
        this.m_ternaryAuxiliaryTupleContains[1] = null;
        this.m_ternaryAuxiliaryTupleContains[2] = null;
        this.m_ternaryAuxiliaryTupleAdd[0] = null;
        this.m_ternaryAuxiliaryTupleAdd[1] = null;
        this.m_ternaryAuxiliaryTupleAdd[2] = null;
        this.m_fouraryAuxiliaryTupleContains[0] = null;
        this.m_fouraryAuxiliaryTupleContains[1] = null;
        this.m_fouraryAuxiliaryTupleContains[2] = null;
        this.m_fouraryAuxiliaryTupleContains[3] = null;
        this.m_fouraryAuxiliaryTupleAdd[0] = null;
        this.m_fouraryAuxiliaryTupleAdd[1] = null;
        this.m_fouraryAuxiliaryTupleAdd[2] = null;
        this.m_fouraryAuxiliaryTupleAdd[3] = null;
    }

    public void branchingPointPushed() {
        for (int i = this.m_allExtensionTablesArray.length - 1; i >= 0; --i) {
            this.m_allExtensionTablesArray[i].branchingPointPushed();
        }
    }

    public void backtrack() {
        for (int i = this.m_allExtensionTablesArray.length - 1; i >= 0; --i) {
            this.m_allExtensionTablesArray[i].backtrack();
        }
    }

    public ExtensionTable getBinaryExtensionTable() {
        return this.m_binaryExtensionTable;
    }

    public ExtensionTable getTernaryExtensionTable() {
        return this.m_ternaryExtensionTable;
    }

    public ExtensionTable getExtensionTable(int n) {
        switch (n) {
            case 2: {
                return this.m_binaryExtensionTable;
            }
            case 3: {
                return this.m_ternaryExtensionTable;
            }
        }
        return this.m_extensionTablesByArity.get(n);
    }

    public Collection<ExtensionTable> getExtensionTables() {
        return this.m_extensionTablesByArity.values();
    }

    public boolean propagateDeltaNew() {
        boolean bl = false;
        for (int i = 0; i < this.m_allExtensionTablesArray.length; ++i) {
            if (!this.m_allExtensionTablesArray[i].propagateDeltaNew()) continue;
            bl = true;
        }
        return bl;
    }

    public void clearClash() {
        if (this.m_clashDependencySet != null) {
            this.m_dependencySetFactory.removeUsage(this.m_clashDependencySet);
            this.m_clashDependencySet = null;
        }
    }

    public void setClash(DependencySet dependencySet) {
        if (this.m_clashDependencySet != null) {
            this.m_dependencySetFactory.removeUsage(this.m_clashDependencySet);
        }
        this.m_clashDependencySet = this.m_dependencySetFactory.getPermanent(dependencySet);
        if (this.m_clashDependencySet != null) {
            this.m_dependencySetFactory.addUsage(this.m_clashDependencySet);
        }
        if (this.m_tableauMonitor != null) {
            this.m_tableauMonitor.clashDetected();
        }
    }

    public DependencySet getClashDependencySet() {
        return this.m_clashDependencySet;
    }

    public boolean containsClash() {
        return this.m_clashDependencySet != null;
    }

    public boolean containsConceptAssertion(Concept concept, Node node) {
        if (node.getNodeType().isAbstract() && AtomicConcept.THING.equals(concept)) {
            return true;
        }
        this.m_binaryAuxiliaryTupleContains[0] = concept;
        this.m_binaryAuxiliaryTupleContains[1] = node;
        return this.m_binaryExtensionTable.containsTuple(this.m_binaryAuxiliaryTupleContains);
    }

    public boolean containsDataRangeAssertion(DataRange dataRange, Node node) {
        if (!node.getNodeType().isAbstract() && InternalDatatype.RDFS_LITERAL.equals(dataRange)) {
            return true;
        }
        this.m_binaryAuxiliaryTupleContains[0] = dataRange;
        this.m_binaryAuxiliaryTupleContains[1] = node;
        return this.m_binaryExtensionTable.containsTuple(this.m_binaryAuxiliaryTupleContains);
    }

    public boolean containsRoleAssertion(Role role, Node node, Node node2) {
        if (role instanceof AtomicRole) {
            this.m_ternaryAuxiliaryTupleContains[0] = role;
            this.m_ternaryAuxiliaryTupleContains[1] = node;
            this.m_ternaryAuxiliaryTupleContains[2] = node2;
        } else {
            this.m_ternaryAuxiliaryTupleContains[0] = ((InverseRole)role).getInverseOf();
            this.m_ternaryAuxiliaryTupleContains[1] = node2;
            this.m_ternaryAuxiliaryTupleContains[2] = node;
        }
        return this.m_ternaryExtensionTable.containsTuple(this.m_ternaryAuxiliaryTupleContains);
    }

    public boolean containsAssertion(DLPredicate dLPredicate, Node node) {
        if (AtomicConcept.THING.equals(dLPredicate)) {
            return true;
        }
        this.m_binaryAuxiliaryTupleContains[0] = dLPredicate;
        this.m_binaryAuxiliaryTupleContains[1] = node;
        return this.m_binaryExtensionTable.containsTuple(this.m_binaryAuxiliaryTupleContains);
    }

    public boolean containsAssertion(DLPredicate dLPredicate, Node node, Node node2) {
        if (Equality.INSTANCE.equals(dLPredicate)) {
            return node == node2;
        }
        this.m_ternaryAuxiliaryTupleContains[0] = dLPredicate;
        this.m_ternaryAuxiliaryTupleContains[1] = node;
        this.m_ternaryAuxiliaryTupleContains[2] = node2;
        return this.m_ternaryExtensionTable.containsTuple(this.m_ternaryAuxiliaryTupleContains);
    }

    public boolean containsAssertion(DLPredicate dLPredicate, Node node, Node node2, Node node3) {
        this.m_fouraryAuxiliaryTupleContains[0] = dLPredicate;
        this.m_fouraryAuxiliaryTupleContains[1] = node;
        this.m_fouraryAuxiliaryTupleContains[2] = node2;
        this.m_fouraryAuxiliaryTupleContains[3] = node3;
        return this.containsTuple(this.m_fouraryAuxiliaryTupleContains);
    }

    public boolean containsAnnotatedEquality(AnnotatedEquality annotatedEquality, Node node, Node node2, Node node3) {
        return this.m_tableau.m_nominalIntroductionManager.canForgetAnnotation(annotatedEquality, node, node2, node3) && node == node2;
    }

    public boolean containsTuple(Object[] objectArray) {
        if (objectArray.length == 0) {
            return this.containsClash();
        }
        if (AtomicConcept.THING.equals(objectArray[0])) {
            return true;
        }
        if (Equality.INSTANCE.equals(objectArray[0])) {
            return objectArray[1] == objectArray[2];
        }
        if (objectArray[0] instanceof AnnotatedEquality) {
            return this.m_tableau.m_nominalIntroductionManager.canForgetAnnotation((AnnotatedEquality)objectArray[0], (Node)objectArray[1], (Node)objectArray[2], (Node)objectArray[3]) && objectArray[1] == objectArray[2];
        }
        return this.getExtensionTable(objectArray.length).containsTuple(objectArray);
    }

    public DependencySet getConceptAssertionDependencySet(Concept concept, Node node) {
        if (AtomicConcept.THING.equals(concept)) {
            return this.m_dependencySetFactory.emptySet();
        }
        this.m_binaryAuxiliaryTupleContains[0] = concept;
        this.m_binaryAuxiliaryTupleContains[1] = node;
        return this.m_binaryExtensionTable.getDependencySet(this.m_binaryAuxiliaryTupleContains);
    }

    public DependencySet getDataRangeAssertionDependencySet(DataRange dataRange, Node node) {
        if (InternalDatatype.RDFS_LITERAL.equals(dataRange)) {
            return this.m_dependencySetFactory.emptySet();
        }
        this.m_binaryAuxiliaryTupleContains[0] = dataRange;
        this.m_binaryAuxiliaryTupleContains[1] = node;
        return this.m_binaryExtensionTable.getDependencySet(this.m_binaryAuxiliaryTupleContains);
    }

    public DependencySet getRoleAssertionDependencySet(Role role, Node node, Node node2) {
        if (role instanceof AtomicRole) {
            this.m_ternaryAuxiliaryTupleContains[0] = role;
            this.m_ternaryAuxiliaryTupleContains[1] = node;
            this.m_ternaryAuxiliaryTupleContains[2] = node2;
        } else {
            this.m_ternaryAuxiliaryTupleContains[0] = ((InverseRole)role).getInverseOf();
            this.m_ternaryAuxiliaryTupleContains[1] = node2;
            this.m_ternaryAuxiliaryTupleContains[2] = node;
        }
        return this.m_ternaryExtensionTable.getDependencySet(this.m_ternaryAuxiliaryTupleContains);
    }

    public DependencySet getAssertionDependencySet(DLPredicate dLPredicate, Node node) {
        this.m_binaryAuxiliaryTupleContains[0] = dLPredicate;
        this.m_binaryAuxiliaryTupleContains[1] = node;
        return this.m_binaryExtensionTable.getDependencySet(this.m_binaryAuxiliaryTupleContains);
    }

    public DependencySet getAssertionDependencySet(DLPredicate dLPredicate, Node node, Node node2) {
        if (Equality.INSTANCE.equals(dLPredicate)) {
            return node == node2 ? this.m_dependencySetFactory.emptySet() : null;
        }
        this.m_ternaryAuxiliaryTupleContains[0] = dLPredicate;
        this.m_ternaryAuxiliaryTupleContains[1] = node;
        this.m_ternaryAuxiliaryTupleContains[2] = node2;
        return this.m_ternaryExtensionTable.getDependencySet(this.m_ternaryAuxiliaryTupleContains);
    }

    public DependencySet getAssertionDependencySet(DLPredicate dLPredicate, Node node, Node node2, Node node3) {
        this.m_fouraryAuxiliaryTupleContains[0] = dLPredicate;
        this.m_fouraryAuxiliaryTupleContains[1] = node;
        this.m_fouraryAuxiliaryTupleContains[2] = node2;
        this.m_fouraryAuxiliaryTupleContains[3] = node3;
        return this.getTupleDependencySet(this.m_fouraryAuxiliaryTupleContains);
    }

    public DependencySet getTupleDependencySet(Object[] objectArray) {
        if (objectArray.length == 0) {
            return this.m_clashDependencySet;
        }
        return this.getExtensionTable(objectArray.length).getDependencySet(objectArray);
    }

    public boolean isCore(Object[] objectArray) {
        if (objectArray.length == 0) {
            return true;
        }
        return this.getExtensionTable(objectArray.length).isCore(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConceptAssertion(Concept concept, Node node, DependencySet dependencySet, boolean bl) {
        if (this.m_addActive) {
            throw new IllegalStateException("ExtensionManager is not reentrant.");
        }
        this.m_addActive = true;
        try {
            this.m_binaryAuxiliaryTupleAdd[0] = concept;
            this.m_binaryAuxiliaryTupleAdd[1] = node;
            boolean bl2 = this.m_binaryExtensionTable.addTuple(this.m_binaryAuxiliaryTupleAdd, dependencySet, bl);
            return bl2;
        }
        finally {
            this.m_addActive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDataRangeAssertion(DataRange dataRange, Node node, DependencySet dependencySet, boolean bl) {
        if (this.m_addActive) {
            throw new IllegalStateException("ExtensionManager is not reentrant.");
        }
        this.m_addActive = true;
        try {
            this.m_binaryAuxiliaryTupleAdd[0] = dataRange;
            this.m_binaryAuxiliaryTupleAdd[1] = node;
            boolean bl2 = this.m_binaryExtensionTable.addTuple(this.m_binaryAuxiliaryTupleAdd, dependencySet, bl);
            return bl2;
        }
        finally {
            this.m_addActive = false;
        }
    }

    public boolean addRoleAssertion(Role role, Node node, Node node2, DependencySet dependencySet, boolean bl) {
        if (role instanceof AtomicRole) {
            return this.addAssertion((AtomicRole)role, node, node2, dependencySet, bl);
        }
        return this.addAssertion(((InverseRole)role).getInverseOf(), node2, node, dependencySet, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAssertion(DLPredicate dLPredicate, Node node, DependencySet dependencySet, boolean bl) {
        if (this.m_addActive) {
            throw new IllegalStateException("ExtensionManager is not reentrant.");
        }
        this.m_addActive = true;
        try {
            this.m_binaryAuxiliaryTupleAdd[0] = dLPredicate;
            this.m_binaryAuxiliaryTupleAdd[1] = node;
            boolean bl2 = this.m_binaryExtensionTable.addTuple(this.m_binaryAuxiliaryTupleAdd, dependencySet, bl);
            return bl2;
        }
        finally {
            this.m_addActive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAssertion(DLPredicate dLPredicate, Node node, Node node2, DependencySet dependencySet, boolean bl) {
        if (Equality.INSTANCE.equals(dLPredicate)) {
            return this.m_tableau.m_mergingManager.mergeNodes(node, node2, dependencySet);
        }
        if (this.m_addActive) {
            throw new IllegalStateException("ExtensionManager is not reentrant.");
        }
        this.m_addActive = true;
        try {
            this.m_ternaryAuxiliaryTupleAdd[0] = dLPredicate;
            this.m_ternaryAuxiliaryTupleAdd[1] = node;
            this.m_ternaryAuxiliaryTupleAdd[2] = node2;
            boolean bl2 = this.m_ternaryExtensionTable.addTuple(this.m_ternaryAuxiliaryTupleAdd, dependencySet, bl);
            return bl2;
        }
        finally {
            this.m_addActive = false;
        }
    }

    public boolean addAssertion(DLPredicate dLPredicate, Node node, Node node2, Node node3, DependencySet dependencySet, boolean bl) {
        if (this.m_addActive) {
            throw new IllegalStateException("ExtensionManager is not reentrant.");
        }
        this.m_fouraryAuxiliaryTupleAdd[0] = dLPredicate;
        this.m_fouraryAuxiliaryTupleAdd[1] = node;
        this.m_fouraryAuxiliaryTupleAdd[2] = node2;
        this.m_fouraryAuxiliaryTupleAdd[3] = node3;
        return this.addTuple(this.m_fouraryAuxiliaryTupleAdd, dependencySet, bl);
    }

    public boolean addAnnotatedEquality(AnnotatedEquality annotatedEquality, Node node, Node node2, Node node3, DependencySet dependencySet) {
        return this.m_tableau.m_nominalIntroductionManager.addAnnotatedEquality(annotatedEquality, node, node2, node3, dependencySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTuple(Object[] objectArray, DependencySet dependencySet, boolean bl) {
        if (objectArray.length == 0) {
            boolean bl2 = this.m_clashDependencySet == null;
            this.setClash(dependencySet);
            return bl2;
        }
        if (Equality.INSTANCE.equals(objectArray[0])) {
            return this.m_tableau.m_mergingManager.mergeNodes((Node)objectArray[1], (Node)objectArray[2], dependencySet);
        }
        if (objectArray[0] instanceof AnnotatedEquality) {
            return this.m_tableau.m_nominalIntroductionManager.addAnnotatedEquality((AnnotatedEquality)objectArray[0], (Node)objectArray[1], (Node)objectArray[2], (Node)objectArray[3], dependencySet);
        }
        if (this.m_addActive) {
            throw new IllegalStateException("ExtensionManager is not reentrant.");
        }
        this.m_addActive = true;
        try {
            boolean bl3 = this.getExtensionTable(objectArray.length).addTuple(objectArray, dependencySet, bl);
            return bl3;
        }
        finally {
            this.m_addActive = false;
        }
    }
}

