/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.semanticweb.HermiT.model.DescriptionGraph;
import org.semanticweb.HermiT.model.ExistsDescriptionGraph;
import org.semanticweb.HermiT.monitor.TableauMonitor;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.InterruptFlag;
import org.semanticweb.HermiT.tableau.MergingManager;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.HermiT.tableau.UnionDependencySet;

public final class DescriptionGraphManager
implements Serializable {
    private static final long serialVersionUID = 4536271856850424712L;
    protected final Tableau m_tableau;
    protected final InterruptFlag m_interruptFlag;
    protected final TableauMonitor m_tableauMonitor;
    protected final ExtensionManager m_extensionManager;
    protected final MergingManager m_mergingManager;
    protected final OccurrenceManager m_occurrenceManager;
    protected final Map<DescriptionGraph, Integer> m_descriptionGraphIndices;
    protected final DescriptionGraph[] m_descriptionGraphsByIndex;
    protected final ExtensionTable[] m_extensionTablesByIndex;
    protected final Object[][] m_auxiliaryTuples1;
    protected final Object[][] m_auxiliaryTuples2;
    protected final List<Node> m_newNodes;
    protected final UnionDependencySet m_binaryUnionDependencySet;
    protected final ExtensionTable.Retrieval[] m_deltaOldRetrievals;

    public DescriptionGraphManager(Tableau tableau) {
        int n;
        this.m_tableau = tableau;
        this.m_interruptFlag = this.m_tableau.m_interruptFlag;
        this.m_tableauMonitor = this.m_tableau.m_tableauMonitor;
        this.m_extensionManager = this.m_tableau.m_extensionManager;
        this.m_mergingManager = this.m_tableau.m_mergingManager;
        this.m_occurrenceManager = new OccurrenceManager();
        this.m_descriptionGraphIndices = new HashMap<DescriptionGraph, Integer>();
        HashSet<ExtensionTable> hashSet = new HashSet<ExtensionTable>();
        ArrayList<DescriptionGraph> arrayList = new ArrayList<DescriptionGraph>();
        ArrayList<ExtensionTable> arrayList2 = new ArrayList<ExtensionTable>();
        for (DescriptionGraph object : this.m_tableau.m_permanentDLOntology.getAllDescriptionGraphs()) {
            this.m_descriptionGraphIndices.put(object, arrayList.size());
            arrayList.add(object);
            ExtensionTable extensionTable = this.m_extensionManager.getExtensionTable(object.getNumberOfVertices() + 1);
            arrayList2.add(extensionTable);
            hashSet.add(extensionTable);
        }
        this.m_descriptionGraphsByIndex = new DescriptionGraph[arrayList.size()];
        arrayList.toArray(this.m_descriptionGraphsByIndex);
        this.m_extensionTablesByIndex = new ExtensionTable[arrayList2.size()];
        arrayList2.toArray(this.m_extensionTablesByIndex);
        this.m_auxiliaryTuples1 = new Object[this.m_descriptionGraphsByIndex.length][];
        this.m_auxiliaryTuples2 = new Object[this.m_descriptionGraphsByIndex.length][];
        for (n = 0; n < this.m_descriptionGraphsByIndex.length; ++n) {
            DescriptionGraph descriptionGraph = this.m_descriptionGraphsByIndex[n];
            this.m_auxiliaryTuples1[n] = new Object[descriptionGraph.getNumberOfVertices() + 1];
            this.m_auxiliaryTuples2[n] = new Object[descriptionGraph.getNumberOfVertices() + 1];
        }
        this.m_newNodes = new ArrayList<Node>();
        this.m_binaryUnionDependencySet = new UnionDependencySet(2);
        this.m_deltaOldRetrievals = new ExtensionTable.Retrieval[hashSet.size()];
        n = 0;
        for (ExtensionTable extensionTable : hashSet) {
            this.m_deltaOldRetrievals[n++] = extensionTable.createRetrieval(new boolean[extensionTable.getArity()], ExtensionTable.View.DELTA_OLD);
        }
    }

    public void clear() {
        for (int i = 0; i < this.m_auxiliaryTuples1.length; ++i) {
            Arrays.fill(this.m_auxiliaryTuples1[i], null);
            Arrays.fill(this.m_auxiliaryTuples2[i], null);
        }
        this.m_occurrenceManager.clear();
        for (Object[] objectArray : this.m_auxiliaryTuples1) {
            Arrays.fill(objectArray, null);
        }
        for (Object[] objectArray : this.m_auxiliaryTuples2) {
            Arrays.fill(objectArray, null);
        }
        this.m_newNodes.clear();
        this.m_binaryUnionDependencySet.m_dependencySets[0] = null;
        this.m_binaryUnionDependencySet.m_dependencySets[1] = null;
        for (Object[] objectArray : this.m_deltaOldRetrievals) {
            objectArray.clear();
        }
    }

    public Object[] getDescriptionGraphTuple(int n, int n2) {
        DescriptionGraph descriptionGraph = this.m_descriptionGraphsByIndex[n];
        ExtensionTable extensionTable = this.m_extensionTablesByIndex[n];
        Object[] objectArray = new Object[descriptionGraph.getNumberOfVertices() + 1];
        extensionTable.retrieveTuple(objectArray, n2);
        return objectArray;
    }

    public boolean checkGraphConstraints() {
        boolean bl = false;
        for (int i = 0; i < this.m_deltaOldRetrievals.length && !this.m_extensionManager.containsClash(); ++i) {
            ExtensionTable.Retrieval retrieval = this.m_deltaOldRetrievals[i];
            ExtensionTable extensionTable = retrieval.getExtensionTable();
            retrieval.open();
            Object[] objectArray = retrieval.getTupleBuffer();
            int n = objectArray.length;
            while (!retrieval.afterLast() && !this.m_extensionManager.containsClash()) {
                if (objectArray[0] instanceof DescriptionGraph) {
                    int n2 = this.m_descriptionGraphIndices.get(objectArray[0]);
                    int n3 = retrieval.getCurrentTupleIndex();
                    for (int j = 1; j < n; ++j) {
                        Node node = (Node)objectArray[j];
                        int n4 = node.m_firstGraphOccurrenceNode;
                        while (n4 != -1) {
                            int n5 = this.m_occurrenceManager.getListNodeComponent(n4, 0);
                            int n6 = this.m_occurrenceManager.getListNodeComponent(n4, 1);
                            int n7 = this.m_occurrenceManager.getListNodeComponent(n4, 2);
                            if (n2 == n5 && (n3 != n6 || j != n7) && extensionTable.isTupleActive(n6)) {
                                this.m_binaryUnionDependencySet.m_dependencySets[0] = retrieval.getDependencySet();
                                this.m_binaryUnionDependencySet.m_dependencySets[1] = extensionTable.getDependencySet(n6);
                                if (this.m_tableauMonitor != null) {
                                    this.m_tableauMonitor.descriptionGraphCheckingStarted(n2, n3, j, n5, n6, n7);
                                }
                                if (j == n7) {
                                    for (int k = n - 1; k >= 1; --k) {
                                        Node node2;
                                        Node node3 = (Node)extensionTable.getTupleObject(n3, k);
                                        if (node3 != (node2 = (Node)extensionTable.getTupleObject(n6, k))) {
                                            this.m_mergingManager.mergeNodes(node3, node2, this.m_binaryUnionDependencySet);
                                            bl = true;
                                        }
                                        this.m_interruptFlag.checkInterrupt();
                                    }
                                } else {
                                    this.m_extensionManager.setClash(this.m_binaryUnionDependencySet);
                                    bl = true;
                                }
                                if (this.m_tableauMonitor != null) {
                                    this.m_tableauMonitor.descriptionGraphCheckingFinished(n2, n3, j, n5, n6, n7);
                                }
                            }
                            n4 = this.m_occurrenceManager.getListNodeComponent(n4, 3);
                            this.m_interruptFlag.checkInterrupt();
                        }
                    }
                }
                retrieval.next();
            }
            this.m_interruptFlag.checkInterrupt();
        }
        return bl;
    }

    public boolean isSatisfied(ExistsDescriptionGraph existsDescriptionGraph, Node node) {
        int n = this.m_descriptionGraphIndices.get(existsDescriptionGraph.getDescriptionGraph());
        int n2 = existsDescriptionGraph.getVertex() + 1;
        int n3 = node.m_firstGraphOccurrenceNode;
        while (n3 != -1) {
            if (n == this.m_occurrenceManager.getListNodeComponent(n3, 0) && n2 == this.m_occurrenceManager.getListNodeComponent(n3, 2)) {
                return true;
            }
            n3 = this.m_occurrenceManager.getListNodeComponent(n3, 3);
        }
        return false;
    }

    public void mergeGraphs(Node node, Node node2, UnionDependencySet unionDependencySet) {
        int n = node.m_firstGraphOccurrenceNode;
        while (n != -1) {
            int n2 = this.m_occurrenceManager.getListNodeComponent(n, 0);
            int n3 = this.m_occurrenceManager.getListNodeComponent(n, 1);
            int n4 = this.m_occurrenceManager.getListNodeComponent(n, 2);
            ExtensionTable extensionTable = this.m_extensionTablesByIndex[n2];
            Object[] objectArray = this.m_auxiliaryTuples1[n2];
            extensionTable.retrieveTuple(objectArray, n3);
            if (extensionTable.isTupleActive(objectArray)) {
                this.m_binaryUnionDependencySet.m_dependencySets[0] = extensionTable.getDependencySet(n3);
                boolean bl = extensionTable.isCore(n3);
                if (this.m_tableauMonitor != null) {
                    Object[] objectArray2 = this.m_auxiliaryTuples2[n2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray[n4] = node2;
                    this.m_tableauMonitor.mergeFactStarted(node, node2, objectArray2, objectArray);
                    this.m_extensionManager.addTuple(objectArray, this.m_binaryUnionDependencySet, bl);
                    this.m_tableauMonitor.mergeFactFinished(node, node2, objectArray2, objectArray);
                } else {
                    objectArray[n4] = node2;
                    this.m_extensionManager.addTuple(objectArray, this.m_binaryUnionDependencySet, bl);
                }
            }
            n = this.m_occurrenceManager.getListNodeComponent(n, 3);
        }
    }

    public void descriptionGraphTupleAdded(int n, Object[] objectArray) {
        int n2 = this.m_descriptionGraphIndices.get(objectArray[0]);
        for (int i = objectArray.length - 1; i >= 1; --i) {
            Node node = (Node)objectArray[i];
            int n3 = this.m_occurrenceManager.newListNode();
            this.m_occurrenceManager.initializeListNode(n3, n2, n, i, node.m_firstGraphOccurrenceNode);
            node.m_firstGraphOccurrenceNode = n3;
        }
    }

    public void descriptionGraphTupleRemoved(int n, Object[] objectArray) {
        for (int i = objectArray.length - 1; i >= 1; --i) {
            Node node = (Node)objectArray[i];
            int n2 = node.m_firstGraphOccurrenceNode;
            assert (this.m_occurrenceManager.getListNodeComponent(n2, 0) == this.m_descriptionGraphIndices.get(objectArray[0]).intValue());
            assert (this.m_occurrenceManager.getListNodeComponent(n2, 1) == n);
            assert (this.m_occurrenceManager.getListNodeComponent(n2, 2) == i);
            node.m_firstGraphOccurrenceNode = this.m_occurrenceManager.getListNodeComponent(n2, 3);
            this.m_occurrenceManager.deleteListNode(n2);
        }
    }

    public void expand(ExistsDescriptionGraph existsDescriptionGraph, Node node) {
        Serializable serializable;
        int n;
        if (this.m_tableau.m_tableauMonitor != null) {
            this.m_tableau.m_tableauMonitor.existentialExpansionStarted(existsDescriptionGraph, node);
        }
        this.m_newNodes.clear();
        DescriptionGraph descriptionGraph = existsDescriptionGraph.getDescriptionGraph();
        DependencySet dependencySet = this.m_extensionManager.getConceptAssertionDependencySet(existsDescriptionGraph, node);
        Object[] objectArray = this.m_auxiliaryTuples1[this.m_descriptionGraphIndices.get(descriptionGraph)];
        objectArray[0] = descriptionGraph;
        for (n = 0; n < descriptionGraph.getNumberOfVertices(); ++n) {
            serializable = n == existsDescriptionGraph.getVertex() ? node : this.m_tableau.createNewGraphNode(node.getClusterAnchor(), dependencySet);
            this.m_newNodes.add((Node)serializable);
            objectArray[n + 1] = serializable;
        }
        this.m_extensionManager.addTuple(objectArray, dependencySet, true);
        for (n = 0; n < descriptionGraph.getNumberOfVertices(); ++n) {
            serializable = this.m_newNodes.get(n);
            dependencySet = ((Node)serializable).addCanonicalNodeDependencySet(dependencySet);
            this.m_newNodes.set(n, ((Node)serializable).getCanonicalNode());
        }
        for (n = 0; n < descriptionGraph.getNumberOfVertices(); ++n) {
            this.m_extensionManager.addConceptAssertion(descriptionGraph.getAtomicConceptForVertex(n), this.m_newNodes.get(n), dependencySet, true);
        }
        for (n = 0; n < descriptionGraph.getNumberOfEdges(); ++n) {
            serializable = descriptionGraph.getEdge(n);
            this.m_extensionManager.addRoleAssertion(((DescriptionGraph.Edge)serializable).getAtomicRole(), this.m_newNodes.get(((DescriptionGraph.Edge)serializable).getFromVertex()), this.m_newNodes.get(((DescriptionGraph.Edge)serializable).getToVertex()), dependencySet, true);
        }
        this.m_newNodes.clear();
        if (this.m_tableau.m_tableauMonitor != null) {
            this.m_tableau.m_tableauMonitor.existentialExpansionFinished(existsDescriptionGraph, node);
        }
    }

    public void intializeNode(Node node) {
        node.m_firstGraphOccurrenceNode = -1;
    }

    public void destroyNode(Node node) {
        int n = node.m_firstGraphOccurrenceNode;
        while (n != -1) {
            int n2 = this.m_occurrenceManager.getListNodeComponent(n, 3);
            this.m_occurrenceManager.deleteListNode(n);
            n = n2;
        }
        node.m_firstGraphOccurrenceNode = -1;
    }

    protected static class OccurrenceManager
    implements Serializable {
        private static final long serialVersionUID = 7594355731105478918L;
        public static final int GRAPH_INDEX = 0;
        public static final int TUPLE_INDEX = 1;
        public static final int POSITION_IN_TUPLE = 2;
        public static final int NEXT_NODE = 3;
        public static final int LIST_NODE_SIZE = 4;
        public static final int LIST_NODE_PAGE_SIZE = 2048;
        protected int[][] m_nodePages = new int[10][];
        protected int m_firstFreeListNode;
        protected int m_numberOfPages;

        public OccurrenceManager() {
            this.m_nodePages[0] = new int[2048];
            this.m_numberOfPages = 1;
            this.m_firstFreeListNode = 0;
            this.setListNodeComponent(this.m_firstFreeListNode, 3, -1);
        }

        public void clear() {
            this.m_firstFreeListNode = 0;
            this.setListNodeComponent(this.m_firstFreeListNode, 3, -1);
        }

        public int getListNodeComponent(int n, int n2) {
            return this.m_nodePages[n / 2048][n % 2048 + n2];
        }

        public void setListNodeComponent(int n, int n2, int n3) {
            this.m_nodePages[n / 2048][n % 2048 + n2] = n3;
        }

        public void initializeListNode(int n, int n2, int n3, int n4, int n5) {
            int n6 = n / 2048;
            int n7 = n % 2048;
            int[] nArray = this.m_nodePages[n6];
            nArray[n7 + 0] = n2;
            nArray[n7 + 1] = n3;
            nArray[n7 + 2] = n4;
            nArray[n7 + 3] = n5;
        }

        public int newListNode() {
            int n = this.m_firstFreeListNode;
            int n2 = this.getListNodeComponent(this.m_firstFreeListNode, 3);
            if (n2 != -1) {
                this.m_firstFreeListNode = n2;
            } else {
                this.m_firstFreeListNode += 4;
                int n3 = this.m_firstFreeListNode / 2048;
                if (n3 >= this.m_numberOfPages) {
                    if (n3 >= this.m_nodePages.length) {
                        int[][] nArrayArray = new int[this.m_nodePages.length * 3 / 2][];
                        System.arraycopy(this.m_nodePages, 0, nArrayArray, 0, this.m_nodePages.length);
                        this.m_nodePages = nArrayArray;
                    }
                    this.m_nodePages[n3] = new int[2048];
                    ++this.m_numberOfPages;
                }
                this.setListNodeComponent(this.m_firstFreeListNode, 3, -1);
            }
            return n;
        }

        public void deleteListNode(int n) {
            this.setListNodeComponent(n, 3, this.m_firstFreeListNode);
            this.m_firstFreeListNode = n;
        }
    }
}

