/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.structural;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.structural.ExpressionManager;
import org.semanticweb.HermiT.structural.OWLAxioms;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLNormalization {
    protected final OWLDataFactory m_factory;
    protected final OWLAxioms m_axioms;
    protected final int m_firstReplacementIndex;
    protected final Map<OWLClassExpression, OWLClassExpression> m_definitions;
    protected final Map<OWLObjectOneOf, OWLClass> m_definitionsForNegativeNominals;
    protected final ExpressionManager m_expressionManager;
    protected final PLVisitor m_plVisitor;
    protected final Map<OWLDataRange, OWLDatatype> m_dataRangeDefinitions;

    public OWLNormalization(OWLDataFactory oWLDataFactory, OWLAxioms oWLAxioms, int n) {
        this.m_factory = oWLDataFactory;
        this.m_axioms = oWLAxioms;
        this.m_firstReplacementIndex = n;
        this.m_definitions = new HashMap<OWLClassExpression, OWLClassExpression>();
        this.m_definitionsForNegativeNominals = new HashMap<OWLObjectOneOf, OWLClass>();
        this.m_expressionManager = new ExpressionManager(this.m_factory);
        this.m_plVisitor = new PLVisitor();
        this.m_dataRangeDefinitions = new HashMap<OWLDataRange, OWLDatatype>();
    }

    public void processOntology(OWLOntology oWLOntology) {
        this.m_axioms.m_classes.addAll(oWLOntology.getClassesInSignature(true));
        this.m_axioms.m_objectProperties.addAll(oWLOntology.getObjectPropertiesInSignature(true));
        this.m_axioms.m_dataProperties.addAll(oWLOntology.getDataPropertiesInSignature(true));
        this.m_axioms.m_namedIndividuals.addAll(oWLOntology.getIndividualsInSignature(true));
        this.processAxioms(oWLOntology.getLogicalAxioms());
    }

    public void processAxioms(Collection<? extends OWLAxiom> collection) {
        AxiomVisitor axiomVisitor = new AxiomVisitor();
        for (OWLAxiom object : collection) {
            object.accept((OWLAxiomVisitor)axiomVisitor);
        }
        RuleNormalizer ruleNormalizer = new RuleNormalizer(this.m_axioms.m_rules, axiomVisitor.m_classExpressionInclusionsAsDisjunctions, axiomVisitor.m_dataRangeInclusionsAsDisjunctions);
        for (SWRLRule sWRLRule : axiomVisitor.m_rules) {
            ruleNormalizer.visit(sWRLRule);
        }
        this.normalizeInclusions(axiomVisitor.m_classExpressionInclusionsAsDisjunctions, axiomVisitor.m_dataRangeInclusionsAsDisjunctions);
    }

    protected void addFact(OWLIndividualAxiom oWLIndividualAxiom) {
        this.m_axioms.m_facts.add(oWLIndividualAxiom);
    }

    protected void addInclusion(OWLObjectPropertyExpression oWLObjectPropertyExpression, OWLObjectPropertyExpression oWLObjectPropertyExpression2) {
        this.m_axioms.m_simpleObjectPropertyInclusions.add(new OWLObjectPropertyExpression[]{oWLObjectPropertyExpression.getSimplified(), oWLObjectPropertyExpression2.getSimplified()});
    }

    protected void addInclusion(OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray, OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        for (int i = oWLObjectPropertyExpressionArray.length - 1; i >= 0; --i) {
            oWLObjectPropertyExpressionArray[i] = oWLObjectPropertyExpressionArray[i].getSimplified();
        }
        this.m_axioms.m_complexObjectPropertyInclusions.add(new OWLAxioms.ComplexObjectPropertyInclusion(oWLObjectPropertyExpressionArray, oWLObjectPropertyExpression.getSimplified()));
    }

    protected void addInclusion(OWLDataPropertyExpression oWLDataPropertyExpression, OWLDataPropertyExpression oWLDataPropertyExpression2) {
        this.m_axioms.m_dataPropertyInclusions.add(new OWLDataPropertyExpression[]{oWLDataPropertyExpression, oWLDataPropertyExpression2});
    }

    protected void makeTransitive(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.m_axioms.m_complexObjectPropertyInclusions.add(new OWLAxioms.ComplexObjectPropertyInclusion(oWLObjectPropertyExpression.getSimplified()));
    }

    protected void makeReflexive(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.m_axioms.m_reflexiveObjectProperties.add(oWLObjectPropertyExpression.getSimplified());
    }

    protected void makeIrreflexive(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.m_axioms.m_irreflexiveObjectProperties.add(oWLObjectPropertyExpression.getSimplified());
    }

    protected void makeAsymmetric(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        this.m_axioms.m_asymmetricObjectProperties.add(oWLObjectPropertyExpression.getSimplified());
    }

    protected static boolean isSimple(OWLClassExpression oWLClassExpression) {
        return oWLClassExpression instanceof OWLClass || oWLClassExpression instanceof OWLObjectComplementOf && ((OWLObjectComplementOf)oWLClassExpression).getOperand() instanceof OWLClass;
    }

    protected static boolean isLiteral(OWLDataRange oWLDataRange) {
        return OWLNormalization.isAtomic(oWLDataRange) || OWLNormalization.isNegatedAtomic(oWLDataRange);
    }

    protected static boolean isAtomic(OWLDataRange oWLDataRange) {
        return oWLDataRange instanceof OWLDatatype || oWLDataRange instanceof OWLDatatypeRestriction || oWLDataRange instanceof OWLDataOneOf;
    }

    protected static boolean isNegatedAtomic(OWLDataRange oWLDataRange) {
        return oWLDataRange instanceof OWLDataComplementOf && OWLNormalization.isAtomic(((OWLDataComplementOf)oWLDataRange).getDataRange());
    }

    protected static boolean isNominal(OWLClassExpression oWLClassExpression) {
        return oWLClassExpression instanceof OWLObjectOneOf;
    }

    protected static boolean isNegatedOneNominal(OWLClassExpression oWLClassExpression) {
        if (!(oWLClassExpression instanceof OWLObjectComplementOf)) {
            return false;
        }
        OWLClassExpression oWLClassExpression2 = ((OWLObjectComplementOf)oWLClassExpression).getOperand();
        if (!(oWLClassExpression2 instanceof OWLObjectOneOf)) {
            return false;
        }
        return ((OWLObjectOneOf)oWLClassExpression2).getIndividuals().size() == 1;
    }

    protected void normalizeInclusions(List<OWLClassExpression[]> list, List<OWLDataRange[]> list2) {
        Object object;
        OWLObjectUnionOf oWLObjectUnionOf;
        DataRangeNormalizer dataRangeNormalizer;
        ClassExpressionNormalizer classExpressionNormalizer = new ClassExpressionNormalizer(list, list2);
        while (!list.isEmpty()) {
            dataRangeNormalizer = this.m_expressionManager.getNNF(this.m_expressionManager.getSimplified((OWLClassExpression)this.m_factory.getOWLObjectUnionOf(list.remove(list.size() - 1))));
            if (dataRangeNormalizer.isOWLThing()) continue;
            if (dataRangeNormalizer instanceof OWLObjectUnionOf) {
                oWLObjectUnionOf = (OWLObjectUnionOf)dataRangeNormalizer;
                object = new OWLClassExpression[oWLObjectUnionOf.getOperands().size()];
                oWLObjectUnionOf.getOperands().toArray((T[])object);
                if (this.distributeUnionOverAnd((OWLClassExpression[])object, list) || this.optimizedNegativeOneOfTranslation((OWLClassExpression[])object, this.m_axioms.m_facts)) continue;
                for (int i = 0; i < ((Object)object).length; ++i) {
                    object[i] = (OWLClassExpression)object[i].accept((OWLClassExpressionVisitorEx)classExpressionNormalizer);
                }
                this.m_axioms.m_conceptInclusions.add((OWLClassExpression[])object);
                continue;
            }
            if (dataRangeNormalizer instanceof OWLObjectIntersectionOf) {
                oWLObjectUnionOf = (OWLObjectIntersectionOf)dataRangeNormalizer;
                for (OWLClassExpression oWLClassExpression : oWLObjectUnionOf.getOperands()) {
                    list.add(new OWLClassExpression[]{oWLClassExpression});
                }
                continue;
            }
            oWLObjectUnionOf = (OWLClassExpression)dataRangeNormalizer.accept(classExpressionNormalizer);
            this.m_axioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLObjectUnionOf});
        }
        dataRangeNormalizer = new DataRangeNormalizer(list2);
        while (!list2.isEmpty()) {
            oWLObjectUnionOf = this.m_expressionManager.getNNF(this.m_expressionManager.getSimplified((OWLDataRange)this.m_factory.getOWLDataUnionOf(list2.remove(classExpressionNormalizer.m_newDataRangeInclusions.size() - 1))));
            if (oWLObjectUnionOf.isTopDatatype()) continue;
            if (oWLObjectUnionOf instanceof OWLDataUnionOf) {
                object = (OWLDataUnionOf)oWLObjectUnionOf;
                OWLDataRange[] oWLDataRangeArray = new OWLDataRange[object.getOperands().size()];
                object.getOperands().toArray(oWLDataRangeArray);
                if (this.distributeUnionOverAnd(oWLDataRangeArray, list2)) continue;
                for (int i = 0; i < oWLDataRangeArray.length; ++i) {
                    oWLDataRangeArray[i] = (OWLDataRange)oWLDataRangeArray[i].accept((OWLDataVisitorEx)dataRangeNormalizer);
                }
                this.m_axioms.m_dataRangeInclusions.add(oWLDataRangeArray);
                continue;
            }
            if (oWLObjectUnionOf instanceof OWLDataIntersectionOf) {
                object = (OWLDataIntersectionOf)oWLObjectUnionOf;
                for (OWLDataRange oWLDataRange : object.getOperands()) {
                    list2.add(new OWLDataRange[]{oWLDataRange});
                }
                continue;
            }
            object = (OWLDataRange)oWLObjectUnionOf.accept((OWLDataVisitorEx)dataRangeNormalizer);
            list2.add(new OWLDataRange[]{object});
        }
    }

    protected boolean distributeUnionOverAnd(OWLClassExpression[] oWLClassExpressionArray, List<OWLClassExpression[]> list) {
        int n = -1;
        for (int i = 0; i < oWLClassExpressionArray.length; ++i) {
            OWLClassExpression oWLClassExpression = oWLClassExpressionArray[i];
            if (OWLNormalization.isSimple(oWLClassExpression)) continue;
            if (oWLClassExpression instanceof OWLObjectIntersectionOf) {
                if (n == -1) {
                    n = i;
                    continue;
                }
                return false;
            }
            return false;
        }
        if (n == -1) {
            return false;
        }
        OWLObjectIntersectionOf oWLObjectIntersectionOf = (OWLObjectIntersectionOf)oWLClassExpressionArray[n];
        for (OWLClassExpression oWLClassExpression : oWLObjectIntersectionOf.getOperands()) {
            OWLClassExpression[] oWLClassExpressionArray2 = (OWLClassExpression[])oWLClassExpressionArray.clone();
            oWLClassExpressionArray2[n] = oWLClassExpression;
            list.add(oWLClassExpressionArray2);
        }
        return true;
    }

    protected boolean distributeUnionOverAnd(OWLDataRange[] oWLDataRangeArray, List<OWLDataRange[]> list) {
        int n = -1;
        for (int i = 0; i < oWLDataRangeArray.length; ++i) {
            OWLDataRange oWLDataRange = oWLDataRangeArray[i];
            if (OWLNormalization.isLiteral(oWLDataRange)) continue;
            if (oWLDataRange instanceof OWLDataIntersectionOf) {
                if (n == -1) {
                    n = i;
                    continue;
                }
                return false;
            }
            return false;
        }
        if (n == -1) {
            return false;
        }
        OWLDataIntersectionOf oWLDataIntersectionOf = (OWLDataIntersectionOf)oWLDataRangeArray[n];
        for (OWLDataRange oWLDataRange : oWLDataIntersectionOf.getOperands()) {
            OWLDataRange[] oWLDataRangeArray2 = (OWLDataRange[])oWLDataRangeArray.clone();
            oWLDataRangeArray2[n] = oWLDataRange;
            list.add(oWLDataRangeArray2);
        }
        return true;
    }

    protected boolean optimizedNegativeOneOfTranslation(OWLClassExpression[] oWLClassExpressionArray, Collection<OWLIndividualAxiom> collection) {
        if (oWLClassExpressionArray.length == 2) {
            OWLObjectOneOf oWLObjectOneOf = null;
            OWLClassExpression oWLClassExpression = null;
            if (oWLClassExpressionArray[0] instanceof OWLObjectComplementOf && ((OWLObjectComplementOf)oWLClassExpressionArray[0]).getOperand() instanceof OWLObjectOneOf) {
                oWLObjectOneOf = (OWLObjectOneOf)((OWLObjectComplementOf)oWLClassExpressionArray[0]).getOperand();
                oWLClassExpression = oWLClassExpressionArray[1];
            } else if (oWLClassExpressionArray[1] instanceof OWLObjectComplementOf && ((OWLObjectComplementOf)oWLClassExpressionArray[1]).getOperand() instanceof OWLObjectOneOf) {
                oWLClassExpression = oWLClassExpressionArray[0];
                oWLObjectOneOf = (OWLObjectOneOf)((OWLObjectComplementOf)oWLClassExpressionArray[1]).getOperand();
            }
            if (oWLObjectOneOf != null && (oWLClassExpression instanceof OWLClass || oWLClassExpression instanceof OWLObjectComplementOf && ((OWLObjectComplementOf)oWLClassExpression).getOperand() instanceof OWLClass)) {
                for (OWLIndividual oWLIndividual : oWLObjectOneOf.getIndividuals()) {
                    collection.add((OWLIndividualAxiom)this.m_factory.getOWLClassAssertionAxiom(oWLClassExpression, oWLIndividual));
                }
                return true;
            }
        }
        return false;
    }

    protected OWLClassExpression getDefinitionFor(OWLClassExpression oWLClassExpression, boolean[] blArray, boolean bl) {
        OWLClassExpression oWLClassExpression2 = this.m_definitions.get(oWLClassExpression);
        if (oWLClassExpression2 == null || bl && !(oWLClassExpression2 instanceof OWLClass)) {
            oWLClassExpression2 = this.m_factory.getOWLClass(IRI.create((String)("internal:def#" + (this.m_definitions.size() + this.m_firstReplacementIndex))));
            if (!bl && !((Boolean)oWLClassExpression.accept((OWLClassExpressionVisitorEx)this.m_plVisitor)).booleanValue()) {
                oWLClassExpression2 = this.m_factory.getOWLObjectComplementOf(oWLClassExpression2);
            }
            this.m_definitions.put(oWLClassExpression, oWLClassExpression2);
            blArray[0] = false;
        } else {
            blArray[0] = true;
        }
        return oWLClassExpression2;
    }

    protected OWLDatatype getDefinitionFor(OWLDataRange oWLDataRange, boolean[] blArray) {
        OWLDatatype oWLDatatype = this.m_dataRangeDefinitions.get(oWLDataRange);
        if (oWLDatatype == null) {
            oWLDatatype = this.m_factory.getOWLDatatype(IRI.create((String)("internal:defdata#" + this.m_dataRangeDefinitions.size())));
            this.m_dataRangeDefinitions.put(oWLDataRange, oWLDatatype);
            blArray[0] = false;
        } else {
            blArray[0] = true;
        }
        return oWLDatatype;
    }

    protected OWLClassExpression getDefinitionFor(OWLClassExpression oWLClassExpression, boolean[] blArray) {
        return this.getDefinitionFor(oWLClassExpression, blArray, false);
    }

    protected OWLClass getClassFor(OWLClassExpression oWLClassExpression, boolean[] blArray) {
        return (OWLClass)this.getDefinitionFor(oWLClassExpression, blArray, true);
    }

    protected OWLClass getDefinitionForNegativeNominal(OWLObjectOneOf oWLObjectOneOf, boolean[] blArray) {
        OWLClass oWLClass = this.m_definitionsForNegativeNominals.get(oWLObjectOneOf);
        if (oWLClass == null) {
            oWLClass = this.m_factory.getOWLClass(IRI.create((String)("internal:nnq#" + this.m_definitionsForNegativeNominals.size())));
            this.m_definitionsForNegativeNominals.put(oWLObjectOneOf, oWLClass);
            blArray[0] = false;
        } else {
            blArray[0] = true;
        }
        return oWLClass;
    }

    protected OWLClassExpression positive(OWLClassExpression oWLClassExpression) {
        return this.m_expressionManager.getNNF(this.m_expressionManager.getSimplified(oWLClassExpression));
    }

    protected OWLClassExpression negative(OWLClassExpression oWLClassExpression) {
        return this.m_expressionManager.getComplementNNF(this.m_expressionManager.getSimplified(oWLClassExpression));
    }

    protected OWLDataRange positive(OWLDataRange oWLDataRange) {
        return this.m_expressionManager.getNNF(this.m_expressionManager.getSimplified(oWLDataRange));
    }

    protected OWLDataRange negative(OWLDataRange oWLDataRange) {
        return this.m_expressionManager.getComplementNNF(this.m_expressionManager.getSimplified(oWLDataRange));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PLVisitor
    implements OWLClassExpressionVisitorEx<Boolean> {
        protected PLVisitor() {
        }

        public Boolean visit(OWLClass oWLClass) {
            if (oWLClass.isOWLThing()) {
                return Boolean.FALSE;
            }
            if (oWLClass.isOWLNothing()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
            for (OWLClassExpression oWLClassExpression : oWLObjectIntersectionOf.getOperands()) {
                if (!((Boolean)oWLClassExpression.accept((OWLClassExpressionVisitorEx)this)).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectUnionOf oWLObjectUnionOf) {
            for (OWLClassExpression oWLClassExpression : oWLObjectUnionOf.getOperands()) {
                if (!((Boolean)oWLClassExpression.accept((OWLClassExpressionVisitorEx)this)).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectComplementOf oWLObjectComplementOf) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectOneOf oWLObjectOneOf) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectAllValuesFrom oWLObjectAllValuesFrom) {
            return (Boolean)((OWLClassExpression)oWLObjectAllValuesFrom.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        }

        public Boolean visit(OWLObjectHasValue oWLObjectHasValue) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectHasSelf oWLObjectHasSelf) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectMinCardinality oWLObjectMinCardinality) {
            return oWLObjectMinCardinality.getCardinality() > 0;
        }

        public Boolean visit(OWLObjectMaxCardinality oWLObjectMaxCardinality) {
            return oWLObjectMaxCardinality.getCardinality() > 0 ? Boolean.TRUE : (Boolean)OWLNormalization.this.m_expressionManager.getComplementNNF((OWLClassExpression)oWLObjectMaxCardinality.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        }

        public Boolean visit(OWLObjectExactCardinality oWLObjectExactCardinality) {
            return oWLObjectExactCardinality.getCardinality() > 0 ? Boolean.TRUE : (Boolean)OWLNormalization.this.m_expressionManager.getComplementNNF((OWLClassExpression)oWLObjectExactCardinality.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        }

        public Boolean visit(OWLDataSomeValuesFrom oWLDataSomeValuesFrom) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataAllValuesFrom oWLDataAllValuesFrom) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataHasValue oWLDataHasValue) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataMinCardinality oWLDataMinCardinality) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataMaxCardinality oWLDataMaxCardinality) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataExactCardinality oWLDataExactCardinality) {
            return Boolean.TRUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class RuleNormalizer
    implements SWRLObjectVisitor {
        protected final Collection<OWLAxioms.DisjunctiveRule> m_rules;
        protected final Collection<OWLClassExpression[]> m_classExpressionInclusions;
        protected final Collection<OWLDataRange[]> m_dataRangeInclusions;
        protected final boolean[] m_alreadyExists;
        protected final List<SWRLAtom> m_bodyAtoms = new ArrayList<SWRLAtom>();
        protected final List<SWRLAtom> m_headAtoms = new ArrayList<SWRLAtom>();
        protected final Set<SWRLAtom> m_normalizedBodyAtoms = new HashSet<SWRLAtom>();
        protected final Set<SWRLAtom> m_normalizedHeadAtoms = new HashSet<SWRLAtom>();
        protected final Map<SWRLVariable, SWRLVariable> m_variableRepresentative = new HashMap<SWRLVariable, SWRLVariable>();
        protected final Map<OWLNamedIndividual, SWRLVariable> m_individualsToVariables = new HashMap<OWLNamedIndividual, SWRLVariable>();
        protected final Set<SWRLVariable> m_bodyDataRangeVariables = new HashSet<SWRLVariable>();
        protected final Set<SWRLVariable> m_headDataRangeVariables = new HashSet<SWRLVariable>();
        protected int m_newVariableIndex = 0;
        protected boolean m_isPositive;

        public RuleNormalizer(Collection<OWLAxioms.DisjunctiveRule> collection, Collection<OWLClassExpression[]> collection2, Collection<OWLDataRange[]> collection3) {
            this.m_rules = collection;
            this.m_classExpressionInclusions = collection2;
            this.m_dataRangeInclusions = collection3;
            this.m_alreadyExists = new boolean[1];
        }

        public void visit(SWRLRule sWRLRule) {
            for (SWRLAtom sWRLAtom : sWRLRule.getHead()) {
                this.m_individualsToVariables.clear();
                this.m_bodyAtoms.clear();
                this.m_headAtoms.clear();
                this.m_variableRepresentative.clear();
                this.m_normalizedBodyAtoms.clear();
                this.m_normalizedHeadAtoms.clear();
                this.m_bodyDataRangeVariables.clear();
                this.m_headDataRangeVariables.clear();
                this.m_bodyAtoms.addAll(sWRLRule.getBody());
                this.m_headAtoms.add(sWRLAtom);
                for (SWRLAtom sWRLAtom2 : sWRLRule.getBody()) {
                    if (!(sWRLAtom2 instanceof SWRLSameIndividualAtom)) continue;
                    this.m_bodyAtoms.remove(sWRLAtom2);
                    SWRLSameIndividualAtom sWRLSameIndividualAtom = (SWRLSameIndividualAtom)sWRLAtom2;
                    SWRLVariable sWRLVariable = this.getVariableFor((SWRLIArgument)sWRLSameIndividualAtom.getFirstArgument());
                    SWRLIArgument sWRLIArgument = (SWRLIArgument)sWRLSameIndividualAtom.getSecondArgument();
                    if (sWRLIArgument instanceof SWRLVariable) {
                        this.m_variableRepresentative.put((SWRLVariable)sWRLIArgument, sWRLVariable);
                        continue;
                    }
                    OWLIndividual oWLIndividual = ((SWRLIndividualArgument)sWRLIArgument).getIndividual();
                    if (oWLIndividual.isAnonymous()) {
                        throw new IllegalArgumentException("Internal error: Rules with anonymous individuals are not supported. ");
                    }
                    this.m_individualsToVariables.put(oWLIndividual.asOWLNamedIndividual(), sWRLVariable);
                    this.m_bodyAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLClassAtom((OWLClassExpression)OWLNormalization.this.m_factory.getOWLObjectOneOf(new OWLIndividual[]{oWLIndividual}), (SWRLIArgument)sWRLVariable));
                }
                this.m_isPositive = true;
                while (!this.m_headAtoms.isEmpty()) {
                    this.m_headAtoms.remove(0).accept((SWRLObjectVisitor)this);
                }
                this.m_isPositive = false;
                while (!this.m_bodyAtoms.isEmpty()) {
                    this.m_bodyAtoms.remove(0).accept((SWRLObjectVisitor)this);
                }
                if (!this.m_bodyDataRangeVariables.containsAll(this.m_headDataRangeVariables)) {
                    throw new IllegalArgumentException("A SWRL rule contains data range variables in the head, but not in the body, and this is not supported.");
                }
                this.m_rules.add(new OWLAxioms.DisjunctiveRule(this.m_normalizedBodyAtoms.toArray(new SWRLAtom[this.m_normalizedBodyAtoms.size()]), this.m_normalizedHeadAtoms.toArray(new SWRLAtom[this.m_normalizedHeadAtoms.size()])));
            }
        }

        public void visit(SWRLClassAtom sWRLClassAtom) {
            OWLClassExpression oWLClassExpression = OWLNormalization.this.m_expressionManager.getSimplified(OWLNormalization.this.m_expressionManager.getNNF(sWRLClassAtom.getPredicate()));
            SWRLVariable sWRLVariable = this.getVariableFor((SWRLIArgument)sWRLClassAtom.getArgument());
            if (this.m_isPositive) {
                if (oWLClassExpression instanceof OWLClass) {
                    this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLClassAtom(oWLClassExpression, (SWRLIArgument)sWRLVariable));
                } else {
                    OWLClass oWLClass = OWLNormalization.this.getClassFor(sWRLClassAtom.getPredicate(), this.m_alreadyExists);
                    if (!this.m_alreadyExists[0]) {
                        this.m_classExpressionInclusions.add(new OWLClassExpression[]{OWLNormalization.this.negative((OWLClassExpression)oWLClass), sWRLClassAtom.getPredicate()});
                    }
                    this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLClassAtom((OWLClassExpression)oWLClass, (SWRLIArgument)sWRLVariable));
                }
            } else if (oWLClassExpression instanceof OWLClass) {
                this.m_normalizedBodyAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLClassAtom(oWLClassExpression, (SWRLIArgument)sWRLVariable));
            } else {
                OWLClass oWLClass = OWLNormalization.this.getClassFor(sWRLClassAtom.getPredicate(), this.m_alreadyExists);
                if (!this.m_alreadyExists[0]) {
                    this.m_classExpressionInclusions.add(new OWLClassExpression[]{OWLNormalization.this.negative(sWRLClassAtom.getPredicate()), oWLClass});
                }
                this.m_normalizedBodyAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLClassAtom((OWLClassExpression)oWLClass, (SWRLIArgument)sWRLVariable));
            }
        }

        public void visit(SWRLDataRangeAtom sWRLDataRangeAtom) {
            OWLDatatype oWLDatatype;
            OWLDataRange oWLDataRange = sWRLDataRangeAtom.getPredicate();
            SWRLDArgument sWRLDArgument = (SWRLDArgument)sWRLDataRangeAtom.getArgument();
            if (!(sWRLDArgument instanceof SWRLVariable)) {
                throw new IllegalArgumentException("A SWRL rule contains a data range with an argument that is not a literal, and such rules are not supported.");
            }
            if (!this.m_isPositive) {
                oWLDataRange = OWLNormalization.this.m_factory.getOWLDataComplementOf(oWLDataRange);
            }
            if ((oWLDataRange = OWLNormalization.this.m_expressionManager.getNNF(OWLNormalization.this.m_expressionManager.getSimplified(oWLDataRange))) instanceof OWLDataIntersectionOf || oWLDataRange instanceof OWLDataUnionOf) {
                oWLDatatype = OWLNormalization.this.getDefinitionFor(oWLDataRange, this.m_alreadyExists);
                if (!this.m_alreadyExists[0]) {
                    this.m_dataRangeInclusions.add(new OWLDataRange[]{OWLNormalization.this.negative((OWLDataRange)oWLDatatype), oWLDataRange});
                }
                oWLDataRange = oWLDatatype;
            }
            oWLDatatype = OWLNormalization.this.m_factory.getSWRLDataRangeAtom(oWLDataRange, sWRLDArgument);
            this.m_normalizedHeadAtoms.add((SWRLAtom)oWLDatatype);
            this.m_headDataRangeVariables.add((SWRLVariable)sWRLDArgument);
        }

        public void visit(SWRLObjectPropertyAtom sWRLObjectPropertyAtom) {
            SWRLVariable sWRLVariable;
            SWRLVariable sWRLVariable2;
            OWLObjectPropertyExpression oWLObjectPropertyExpression = sWRLObjectPropertyAtom.getPredicate().getSimplified();
            OWLObjectProperty oWLObjectProperty = oWLObjectPropertyExpression.getNamedProperty();
            if (oWLObjectPropertyExpression.isAnonymous()) {
                sWRLVariable2 = this.getVariableFor((SWRLIArgument)sWRLObjectPropertyAtom.getSecondArgument());
                sWRLVariable = this.getVariableFor((SWRLIArgument)sWRLObjectPropertyAtom.getFirstArgument());
            } else {
                sWRLVariable2 = this.getVariableFor((SWRLIArgument)sWRLObjectPropertyAtom.getFirstArgument());
                sWRLVariable = this.getVariableFor((SWRLIArgument)sWRLObjectPropertyAtom.getSecondArgument());
            }
            SWRLObjectPropertyAtom sWRLObjectPropertyAtom2 = OWLNormalization.this.m_factory.getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)oWLObjectProperty, (SWRLIArgument)sWRLVariable2, (SWRLIArgument)sWRLVariable);
            if (this.m_isPositive) {
                this.m_normalizedHeadAtoms.add((SWRLAtom)sWRLObjectPropertyAtom2);
            } else {
                this.m_normalizedBodyAtoms.add((SWRLAtom)sWRLObjectPropertyAtom2);
            }
        }

        public void visit(SWRLDataPropertyAtom sWRLDataPropertyAtom) {
            OWLDataProperty oWLDataProperty = sWRLDataPropertyAtom.getPredicate().asOWLDataProperty();
            SWRLVariable sWRLVariable = this.getVariableFor((SWRLIArgument)sWRLDataPropertyAtom.getFirstArgument());
            SWRLDArgument sWRLDArgument = (SWRLDArgument)sWRLDataPropertyAtom.getSecondArgument();
            if (sWRLDArgument instanceof SWRLVariable) {
                SWRLVariable sWRLVariable2 = this.getVariableFor((SWRLIArgument)((SWRLVariable)sWRLDArgument));
                if (this.m_isPositive) {
                    this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLDataPropertyAtom((OWLDataPropertyExpression)oWLDataProperty, (SWRLIArgument)sWRLVariable, (SWRLDArgument)sWRLVariable2));
                    this.m_headDataRangeVariables.add(sWRLVariable2);
                } else if (this.m_bodyDataRangeVariables.add(sWRLVariable2)) {
                    this.m_normalizedBodyAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLDataPropertyAtom((OWLDataPropertyExpression)oWLDataProperty, (SWRLIArgument)sWRLVariable, (SWRLDArgument)sWRLVariable2));
                } else {
                    SWRLVariable sWRLVariable3 = this.getFreshVariable();
                    this.m_normalizedBodyAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLDataPropertyAtom((OWLDataPropertyExpression)oWLDataProperty, (SWRLIArgument)sWRLVariable, (SWRLDArgument)sWRLVariable3));
                    this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLDifferentIndividualsAtom((SWRLIArgument)sWRLVariable2, (SWRLIArgument)sWRLVariable3));
                }
            } else {
                OWLLiteral oWLLiteral = ((SWRLLiteralArgument)sWRLDArgument).getLiteral();
                SWRLClassAtom sWRLClassAtom = OWLNormalization.this.m_factory.getSWRLClassAtom((OWLClassExpression)OWLNormalization.this.m_factory.getOWLDataHasValue((OWLDataPropertyExpression)oWLDataProperty, oWLLiteral), (SWRLIArgument)sWRLVariable);
                if (this.m_isPositive) {
                    this.m_headAtoms.add((SWRLAtom)sWRLClassAtom);
                } else {
                    this.m_bodyAtoms.add((SWRLAtom)sWRLClassAtom);
                }
            }
        }

        public void visit(SWRLBuiltInAtom sWRLBuiltInAtom) {
            throw new IllegalArgumentException("A SWRL rule uses built-in atom, but built-in atoms are not suported yet.");
        }

        public void visit(SWRLSameIndividualAtom sWRLSameIndividualAtom) {
            if (!this.m_isPositive) {
                throw new IllegalStateException("Internal error: this SWRLSameIndividualAtom should have been processed earlier.");
            }
            this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLSameIndividualAtom((SWRLIArgument)this.getVariableFor((SWRLIArgument)sWRLSameIndividualAtom.getFirstArgument()), (SWRLIArgument)this.getVariableFor((SWRLIArgument)sWRLSameIndividualAtom.getSecondArgument())));
        }

        public void visit(SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom) {
            if (this.m_isPositive) {
                this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLDifferentIndividualsAtom((SWRLIArgument)this.getVariableFor((SWRLIArgument)sWRLDifferentIndividualsAtom.getFirstArgument()), (SWRLIArgument)this.getVariableFor((SWRLIArgument)sWRLDifferentIndividualsAtom.getSecondArgument())));
            } else {
                this.m_normalizedHeadAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLSameIndividualAtom((SWRLIArgument)this.getVariableFor((SWRLIArgument)sWRLDifferentIndividualsAtom.getFirstArgument()), (SWRLIArgument)this.getVariableFor((SWRLIArgument)sWRLDifferentIndividualsAtom.getSecondArgument())));
            }
        }

        public void visit(SWRLVariable sWRLVariable) {
        }

        public void visit(SWRLIndividualArgument sWRLIndividualArgument) {
        }

        public void visit(SWRLLiteralArgument sWRLLiteralArgument) {
        }

        protected SWRLVariable getVariableFor(SWRLIArgument sWRLIArgument) {
            SWRLVariable sWRLVariable;
            OWLIndividual oWLIndividual;
            if (sWRLIArgument instanceof SWRLIndividualArgument) {
                oWLIndividual = ((SWRLIndividualArgument)sWRLIArgument).getIndividual();
                if (oWLIndividual.isAnonymous()) {
                    throw new IllegalArgumentException("Internal error: Rules with anonymous individuals are not supported. ");
                }
                sWRLVariable = this.m_individualsToVariables.get(oWLIndividual.asOWLNamedIndividual());
                if (sWRLVariable == null) {
                    sWRLVariable = this.getFreshVariable();
                    this.m_individualsToVariables.put(oWLIndividual.asOWLNamedIndividual(), sWRLVariable);
                    this.m_bodyAtoms.add((SWRLAtom)OWLNormalization.this.m_factory.getSWRLClassAtom((OWLClassExpression)OWLNormalization.this.m_factory.getOWLObjectOneOf(new OWLIndividual[]{oWLIndividual}), (SWRLIArgument)sWRLVariable));
                }
            } else {
                sWRLVariable = (SWRLVariable)sWRLIArgument;
            }
            oWLIndividual = this.m_variableRepresentative.get(sWRLVariable);
            if (oWLIndividual == null) {
                return sWRLVariable;
            }
            return oWLIndividual;
        }

        protected SWRLVariable getFreshVariable() {
            SWRLVariable sWRLVariable = OWLNormalization.this.m_factory.getSWRLVariable(IRI.create((String)("internal:swrl#" + this.m_newVariableIndex)));
            ++this.m_newVariableIndex;
            return sWRLVariable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Rule2FactConverter
    implements SWRLObjectVisitor {
        protected final boolean[] m_alreadyExists = new boolean[1];
        protected final Collection<OWLClassExpression[]> m_newInclusions;
        protected int freshDataProperties = 0;
        protected int freshIndividuals = 0;

        public Rule2FactConverter(Collection<OWLClassExpression[]> collection) {
            this.m_newInclusions = collection;
        }

        protected OWLNamedIndividual getFreshIndividual() {
            OWLNamedIndividual oWLNamedIndividual = OWLNormalization.this.m_factory.getOWLNamedIndividual(IRI.create((String)("internal:nom#swrlfact" + this.freshIndividuals)));
            ++this.freshIndividuals;
            OWLNormalization.this.m_axioms.m_namedIndividuals.add(oWLNamedIndividual);
            return oWLNamedIndividual;
        }

        protected OWLDataProperty getFreshDataProperty() {
            ++this.freshDataProperties;
            return OWLNormalization.this.m_factory.getOWLDataProperty(IRI.create((String)("internal:freshDP#" + this.freshDataProperties)));
        }

        public void visit(SWRLRule sWRLRule) {
        }

        public void visit(SWRLClassAtom sWRLClassAtom) {
            if (!(sWRLClassAtom.getArgument() instanceof SWRLIndividualArgument)) {
                throw new IllegalArgumentException("A SWRL rule contains a head atom " + sWRLClassAtom + " with a variable that does not occur in the body. ");
            }
            OWLIndividual oWLIndividual = ((SWRLIndividualArgument)sWRLClassAtom.getArgument()).getIndividual();
            if (oWLIndividual.isAnonymous()) {
                this.throwAnonIndError((SWRLAtom)sWRLClassAtom);
            }
            if (!OWLNormalization.isSimple(sWRLClassAtom.getPredicate())) {
                OWLClassExpression oWLClassExpression = OWLNormalization.this.getDefinitionFor(sWRLClassAtom.getPredicate(), this.m_alreadyExists);
                if (!this.m_alreadyExists[0]) {
                    this.m_newInclusions.add(new OWLClassExpression[]{OWLNormalization.this.negative(oWLClassExpression), sWRLClassAtom.getPredicate()});
                }
                OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLClassAssertionAxiom(oWLClassExpression, (OWLIndividual)oWLIndividual.asOWLNamedIndividual()));
            } else {
                OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLClassAssertionAxiom(sWRLClassAtom.getPredicate(), (OWLIndividual)oWLIndividual.asOWLNamedIndividual()));
            }
        }

        public void visit(SWRLDataRangeAtom sWRLDataRangeAtom) {
            if (sWRLDataRangeAtom.getArgument() instanceof SWRLVariable) {
                this.throwVarError((SWRLAtom)sWRLDataRangeAtom);
            }
            OWLLiteral oWLLiteral = ((SWRLLiteralArgument)sWRLDataRangeAtom.getArgument()).getLiteral();
            OWLDataRange oWLDataRange = sWRLDataRangeAtom.getPredicate();
            OWLNamedIndividual oWLNamedIndividual = this.getFreshIndividual();
            OWLDataProperty oWLDataProperty = this.getFreshDataProperty();
            OWLDataSomeValuesFrom oWLDataSomeValuesFrom = OWLNormalization.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)oWLDataProperty, (OWLDataRange)OWLNormalization.this.m_factory.getOWLDataOneOf(new OWLLiteral[]{oWLLiteral}));
            OWLClassExpression oWLClassExpression = OWLNormalization.this.getDefinitionFor((OWLClassExpression)oWLDataSomeValuesFrom, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newInclusions.add(new OWLClassExpression[]{OWLNormalization.this.negative(oWLClassExpression), oWLDataSomeValuesFrom});
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLClassAssertionAxiom(oWLClassExpression, (OWLIndividual)oWLNamedIndividual));
            this.m_newInclusions.add(new OWLClassExpression[]{OWLNormalization.this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)oWLDataProperty, oWLDataRange)});
        }

        public void visit(SWRLObjectPropertyAtom sWRLObjectPropertyAtom) {
            if (!(sWRLObjectPropertyAtom.getFirstArgument() instanceof SWRLIndividualArgument) || !(sWRLObjectPropertyAtom.getSecondArgument() instanceof SWRLIndividualArgument)) {
                this.throwVarError((SWRLAtom)sWRLObjectPropertyAtom);
            }
            OWLObjectPropertyExpression oWLObjectPropertyExpression = sWRLObjectPropertyAtom.getPredicate().getSimplified();
            OWLIndividual oWLIndividual = ((SWRLIndividualArgument)sWRLObjectPropertyAtom.getFirstArgument()).getIndividual();
            OWLIndividual oWLIndividual2 = ((SWRLIndividualArgument)sWRLObjectPropertyAtom.getSecondArgument()).getIndividual();
            if (oWLIndividual.isAnonymous() || oWLIndividual2.isAnonymous()) {
                this.throwAnonIndError((SWRLAtom)sWRLObjectPropertyAtom);
            }
            if (oWLObjectPropertyExpression.isAnonymous()) {
                OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)oWLObjectPropertyExpression.getNamedProperty(), (OWLIndividual)oWLIndividual2.asOWLNamedIndividual(), (OWLIndividual)oWLIndividual.asOWLNamedIndividual()));
            } else {
                OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)oWLObjectPropertyExpression.asOWLObjectProperty(), (OWLIndividual)oWLIndividual.asOWLNamedIndividual(), (OWLIndividual)oWLIndividual2.asOWLNamedIndividual()));
            }
        }

        public void visit(SWRLDataPropertyAtom sWRLDataPropertyAtom) {
            OWLIndividual oWLIndividual;
            if (!(sWRLDataPropertyAtom.getSecondArgument() instanceof SWRLLiteralArgument)) {
                this.throwVarError((SWRLAtom)sWRLDataPropertyAtom);
            }
            if (!(sWRLDataPropertyAtom.getFirstArgument() instanceof SWRLIndividualArgument)) {
                this.throwVarError((SWRLAtom)sWRLDataPropertyAtom);
            }
            if ((oWLIndividual = ((SWRLIndividualArgument)sWRLDataPropertyAtom.getFirstArgument()).getIndividual()).isAnonymous()) {
                this.throwAnonIndError((SWRLAtom)sWRLDataPropertyAtom);
            }
            OWLLiteral oWLLiteral = ((SWRLLiteralArgument)sWRLDataPropertyAtom.getSecondArgument()).getLiteral();
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)sWRLDataPropertyAtom.getPredicate().asOWLDataProperty(), (OWLIndividual)oWLIndividual.asOWLNamedIndividual(), oWLLiteral));
        }

        public void visit(SWRLBuiltInAtom sWRLBuiltInAtom) {
            throw new IllegalArgumentException("Error: A rule uses built-in atoms (" + sWRLBuiltInAtom + "), but built-in atoms are not suported yet. ");
        }

        public void visit(SWRLSameIndividualAtom sWRLSameIndividualAtom) {
            HashSet<OWLNamedIndividual> hashSet = new HashSet<OWLNamedIndividual>();
            for (SWRLArgument sWRLArgument : sWRLSameIndividualAtom.getAllArguments()) {
                OWLIndividual oWLIndividual;
                if (!(sWRLArgument instanceof SWRLIndividualArgument)) {
                    this.throwVarError((SWRLAtom)sWRLSameIndividualAtom);
                }
                if ((oWLIndividual = ((SWRLIndividualArgument)sWRLArgument).getIndividual()).isAnonymous()) {
                    this.throwAnonIndError((SWRLAtom)sWRLSameIndividualAtom);
                }
                hashSet.add(oWLIndividual.asOWLNamedIndividual());
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLSameIndividualAxiom(hashSet));
        }

        public void visit(SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom) {
            HashSet<OWLNamedIndividual> hashSet = new HashSet<OWLNamedIndividual>();
            for (SWRLArgument sWRLArgument : sWRLDifferentIndividualsAtom.getAllArguments()) {
                OWLIndividual oWLIndividual;
                if (!(sWRLArgument instanceof SWRLIndividualArgument)) {
                    this.throwVarError((SWRLAtom)sWRLDifferentIndividualsAtom);
                }
                if ((oWLIndividual = ((SWRLIndividualArgument)sWRLArgument).getIndividual()).isAnonymous()) {
                    this.throwAnonIndError((SWRLAtom)sWRLDifferentIndividualsAtom);
                }
                hashSet.add(oWLIndividual.asOWLNamedIndividual());
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLDifferentIndividualsAxiom(hashSet));
        }

        public void visit(SWRLVariable sWRLVariable) {
        }

        public void visit(SWRLIndividualArgument sWRLIndividualArgument) {
        }

        public void visit(SWRLLiteralArgument sWRLLiteralArgument) {
        }

        protected void throwAnonIndError(SWRLAtom sWRLAtom) {
            throw new IllegalArgumentException("A SWRL rule contains a fact (" + sWRLAtom + ") with an anonymous individual, which is not allowed. ");
        }

        protected void throwVarError(SWRLAtom sWRLAtom) {
            throw new IllegalArgumentException("A SWRL rule contains a head atom (" + sWRLAtom + ") with a variable that does not occur in the body. ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DataRangeNormalizer
    implements OWLDataVisitorEx<OWLDataRange> {
        protected final Collection<OWLDataRange[]> m_newDataRangeInclusions;
        protected final boolean[] m_alreadyExists;

        public DataRangeNormalizer(Collection<OWLDataRange[]> collection) {
            this.m_newDataRangeInclusions = collection;
            this.m_alreadyExists = new boolean[1];
        }

        public OWLDataRange visit(OWLDatatype oWLDatatype) {
            return oWLDatatype;
        }

        public OWLDataRange visit(OWLDataComplementOf oWLDataComplementOf) {
            return oWLDataComplementOf;
        }

        public OWLDataRange visit(OWLDataOneOf oWLDataOneOf) {
            return oWLDataOneOf;
        }

        public OWLDataRange visit(OWLDataIntersectionOf oWLDataIntersectionOf) {
            OWLDatatype oWLDatatype = OWLNormalization.this.getDefinitionFor((OWLDataRange)oWLDataIntersectionOf, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                for (OWLDataRange oWLDataRange : oWLDataIntersectionOf.getOperands()) {
                    this.m_newDataRangeInclusions.add(new OWLDataRange[]{OWLNormalization.this.negative((OWLDataRange)oWLDatatype), oWLDataRange});
                }
            }
            return oWLDatatype;
        }

        public OWLDataRange visit(OWLDataUnionOf oWLDataUnionOf) {
            throw new IllegalStateException("OR should be broken down at the outermost level");
        }

        public OWLDataRange visit(OWLDatatypeRestriction oWLDatatypeRestriction) {
            return oWLDatatypeRestriction;
        }

        public OWLDataRange visit(OWLFacetRestriction oWLFacetRestriction) {
            throw new IllegalStateException("Internal error: We shouldn't visit facet restrictions during normalization. ");
        }

        public OWLDataRange visit(OWLLiteral oWLLiteral) {
            throw new IllegalStateException("Internal error: We shouldn't visit typed literals during normalization. ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassExpressionNormalizer
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        protected final Collection<OWLClassExpression[]> m_newInclusions;
        protected final Collection<OWLDataRange[]> m_newDataRangeInclusions;
        protected final boolean[] m_alreadyExists;

        public ClassExpressionNormalizer(Collection<OWLClassExpression[]> collection, Collection<OWLDataRange[]> collection2) {
            this.m_newInclusions = collection;
            this.m_newDataRangeInclusions = collection2;
            this.m_alreadyExists = new boolean[1];
        }

        public OWLClassExpression visit(OWLClass oWLClass) {
            return oWLClass;
        }

        public OWLClassExpression visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
            OWLClassExpression oWLClassExpression = OWLNormalization.this.getDefinitionFor((OWLClassExpression)oWLObjectIntersectionOf, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                for (OWLClassExpression oWLClassExpression2 : oWLObjectIntersectionOf.getOperands()) {
                    this.m_newInclusions.add(new OWLClassExpression[]{OWLNormalization.this.negative(oWLClassExpression), oWLClassExpression2});
                }
            }
            return oWLClassExpression;
        }

        public OWLClassExpression visit(OWLObjectUnionOf oWLObjectUnionOf) {
            throw new IllegalStateException("OR should be broken down at the outermost level");
        }

        public OWLClassExpression visit(OWLObjectComplementOf oWLObjectComplementOf) {
            if (OWLNormalization.isNominal(oWLObjectComplementOf.getOperand())) {
                OWLObjectOneOf oWLObjectOneOf = (OWLObjectOneOf)oWLObjectComplementOf.getOperand();
                OWLClass oWLClass = OWLNormalization.this.getDefinitionForNegativeNominal(oWLObjectOneOf, this.m_alreadyExists);
                if (!this.m_alreadyExists[0]) {
                    for (OWLIndividual oWLIndividual : oWLObjectOneOf.getIndividuals()) {
                        OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLClassAssertionAxiom((OWLClassExpression)oWLClass, oWLIndividual));
                    }
                }
                return OWLNormalization.this.m_factory.getOWLObjectComplementOf((OWLClassExpression)oWLClass);
            }
            return oWLObjectComplementOf;
        }

        public OWLClassExpression visit(OWLObjectOneOf oWLObjectOneOf) {
            for (OWLIndividual oWLIndividual : oWLObjectOneOf.getIndividuals()) {
                if (!oWLIndividual.isAnonymous()) continue;
                throw new IllegalArgumentException("Error: The class expression " + oWLObjectOneOf + " contains anonymous individuals, which is not allowed in OWL 2 (erratum in first OWL 2 spec, to be fixed with next publication of minor corrections). ");
            }
            return oWLObjectOneOf;
        }

        public OWLClassExpression visit(OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom) {
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLObjectSomeValuesFrom.getProperty()).getNamedProperty());
            OWLClassExpression oWLClassExpression = (OWLClassExpression)oWLObjectSomeValuesFrom.getFiller();
            if (OWLNormalization.isSimple(oWLClassExpression) || OWLNormalization.isNominal(oWLClassExpression)) {
                return oWLObjectSomeValuesFrom;
            }
            OWLClassExpression oWLClassExpression2 = OWLNormalization.this.getDefinitionFor(oWLClassExpression, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newInclusions.add(new OWLClassExpression[]{OWLNormalization.this.negative(oWLClassExpression2), oWLClassExpression});
            }
            return OWLNormalization.this.m_factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)oWLObjectSomeValuesFrom.getProperty(), oWLClassExpression2);
        }

        public OWLClassExpression visit(OWLObjectAllValuesFrom oWLObjectAllValuesFrom) {
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLObjectAllValuesFrom.getProperty()).getNamedProperty());
            OWLClassExpression oWLClassExpression = (OWLClassExpression)oWLObjectAllValuesFrom.getFiller();
            if (OWLNormalization.isSimple(oWLClassExpression) || OWLNormalization.isNominal(oWLClassExpression) || OWLNormalization.isNegatedOneNominal(oWLClassExpression)) {
                return oWLObjectAllValuesFrom;
            }
            OWLClassExpression oWLClassExpression2 = OWLNormalization.this.getDefinitionFor(oWLClassExpression, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newInclusions.add(new OWLClassExpression[]{OWLNormalization.this.negative(oWLClassExpression2), oWLClassExpression});
            }
            return OWLNormalization.this.m_factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)oWLObjectAllValuesFrom.getProperty(), oWLClassExpression2);
        }

        public OWLClassExpression visit(OWLObjectHasValue oWLObjectHasValue) {
            throw new IllegalStateException("Internal error: object value restrictions should have been simplified.");
        }

        public OWLClassExpression visit(OWLObjectHasSelf oWLObjectHasSelf) {
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLObjectHasSelf.getProperty()).getNamedProperty());
            return oWLObjectHasSelf;
        }

        public OWLClassExpression visit(OWLObjectMinCardinality oWLObjectMinCardinality) {
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLObjectMinCardinality.getProperty()).getNamedProperty());
            OWLClassExpression oWLClassExpression = (OWLClassExpression)oWLObjectMinCardinality.getFiller();
            if (OWLNormalization.isSimple(oWLClassExpression)) {
                return oWLObjectMinCardinality;
            }
            OWLClassExpression oWLClassExpression2 = OWLNormalization.this.getDefinitionFor(oWLClassExpression, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newInclusions.add(new OWLClassExpression[]{OWLNormalization.this.negative(oWLClassExpression2), oWLClassExpression});
            }
            return OWLNormalization.this.m_factory.getOWLObjectMinCardinality(oWLObjectMinCardinality.getCardinality(), (OWLObjectPropertyExpression)oWLObjectMinCardinality.getProperty(), oWLClassExpression2);
        }

        public OWLClassExpression visit(OWLObjectMaxCardinality oWLObjectMaxCardinality) {
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLObjectMaxCardinality.getProperty()).getNamedProperty());
            OWLClassExpression oWLClassExpression = (OWLClassExpression)oWLObjectMaxCardinality.getFiller();
            if (OWLNormalization.isSimple(oWLClassExpression)) {
                return oWLObjectMaxCardinality;
            }
            OWLClassExpression oWLClassExpression2 = OWLNormalization.this.m_expressionManager.getComplementNNF(oWLClassExpression);
            OWLClassExpression oWLClassExpression3 = OWLNormalization.this.getDefinitionFor(oWLClassExpression2, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newInclusions.add(new OWLClassExpression[]{OWLNormalization.this.negative(oWLClassExpression3), oWLClassExpression2});
            }
            return OWLNormalization.this.m_factory.getOWLObjectMaxCardinality(oWLObjectMaxCardinality.getCardinality(), (OWLObjectPropertyExpression)oWLObjectMaxCardinality.getProperty(), OWLNormalization.this.m_expressionManager.getComplementNNF(oWLClassExpression3));
        }

        public OWLClassExpression visit(OWLObjectExactCardinality oWLObjectExactCardinality) {
            throw new IllegalStateException("Internal error: exact object cardinality restrictions should have been simplified.");
        }

        public OWLClassExpression visit(OWLDataSomeValuesFrom oWLDataSomeValuesFrom) {
            OWLDataRange oWLDataRange = (OWLDataRange)oWLDataSomeValuesFrom.getFiller();
            OWLDataPropertyExpression oWLDataPropertyExpression = (OWLDataPropertyExpression)oWLDataSomeValuesFrom.getProperty();
            if (oWLDataPropertyExpression.isOWLTopDataProperty()) {
                this.throwInvalidTopDPUseError((OWLClassExpression)oWLDataSomeValuesFrom);
            }
            if (OWLNormalization.isLiteral(oWLDataRange)) {
                return OWLNormalization.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)oWLDataSomeValuesFrom.getProperty(), oWLDataRange);
            }
            OWLDatatype oWLDatatype = OWLNormalization.this.getDefinitionFor(oWLDataRange, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newDataRangeInclusions.add(new OWLDataRange[]{OWLNormalization.this.negative((OWLDataRange)oWLDatatype), oWLDataRange});
            }
            return OWLNormalization.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)oWLDataSomeValuesFrom.getProperty(), (OWLDataRange)oWLDatatype);
        }

        public OWLClassExpression visit(OWLDataAllValuesFrom oWLDataAllValuesFrom) {
            OWLDataRange oWLDataRange = (OWLDataRange)oWLDataAllValuesFrom.getFiller();
            OWLDataPropertyExpression oWLDataPropertyExpression = (OWLDataPropertyExpression)oWLDataAllValuesFrom.getProperty();
            if (oWLDataPropertyExpression.isOWLTopDataProperty()) {
                this.throwInvalidTopDPUseError((OWLClassExpression)oWLDataAllValuesFrom);
            }
            if (OWLNormalization.isLiteral(oWLDataRange)) {
                return OWLNormalization.this.m_factory.getOWLDataAllValuesFrom(oWLDataPropertyExpression, oWLDataRange);
            }
            OWLDatatype oWLDatatype = OWLNormalization.this.getDefinitionFor(oWLDataRange, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newDataRangeInclusions.add(new OWLDataRange[]{OWLNormalization.this.negative((OWLDataRange)oWLDatatype), oWLDataRange});
            }
            return OWLNormalization.this.m_factory.getOWLDataAllValuesFrom(oWLDataPropertyExpression, (OWLDataRange)oWLDatatype);
        }

        protected void throwInvalidTopDPUseError(OWLClassExpression oWLClassExpression) {
            throw new IllegalArgumentException("Error: In OWL 2 DL, owl:topDataProperty is only allowed to occur in the super property position of SubDataPropertyOf axioms, but the ontology contains an axiom with the class expression " + oWLClassExpression + " that violates this restriction.");
        }

        public OWLClassExpression visit(OWLDataHasValue oWLDataHasValue) {
            throw new IllegalStateException("Internal error: data value restrictions should have been simplified.");
        }

        public OWLClassExpression visit(OWLDataMinCardinality oWLDataMinCardinality) {
            OWLDataRange oWLDataRange = (OWLDataRange)oWLDataMinCardinality.getFiller();
            OWLDataPropertyExpression oWLDataPropertyExpression = (OWLDataPropertyExpression)oWLDataMinCardinality.getProperty();
            if (oWLDataPropertyExpression.isOWLTopDataProperty()) {
                this.throwInvalidTopDPUseError((OWLClassExpression)oWLDataMinCardinality);
            }
            if (OWLNormalization.isLiteral(oWLDataRange)) {
                return OWLNormalization.this.m_factory.getOWLDataMinCardinality(oWLDataMinCardinality.getCardinality(), oWLDataPropertyExpression, oWLDataRange);
            }
            OWLDatatype oWLDatatype = OWLNormalization.this.getDefinitionFor(oWLDataRange, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newDataRangeInclusions.add(new OWLDataRange[]{OWLNormalization.this.negative((OWLDataRange)oWLDatatype), oWLDataRange});
            }
            return OWLNormalization.this.m_factory.getOWLDataMinCardinality(oWLDataMinCardinality.getCardinality(), oWLDataPropertyExpression, (OWLDataRange)oWLDatatype);
        }

        public OWLClassExpression visit(OWLDataMaxCardinality oWLDataMaxCardinality) {
            OWLDataRange oWLDataRange = (OWLDataRange)oWLDataMaxCardinality.getFiller();
            OWLDataPropertyExpression oWLDataPropertyExpression = (OWLDataPropertyExpression)oWLDataMaxCardinality.getProperty();
            if (oWLDataPropertyExpression.isOWLTopDataProperty()) {
                this.throwInvalidTopDPUseError((OWLClassExpression)oWLDataMaxCardinality);
            }
            if (OWLNormalization.isLiteral(oWLDataRange)) {
                return OWLNormalization.this.m_factory.getOWLDataMaxCardinality(oWLDataMaxCardinality.getCardinality(), oWLDataPropertyExpression, oWLDataRange);
            }
            OWLDataRange oWLDataRange2 = OWLNormalization.this.m_expressionManager.getComplementNNF(oWLDataRange);
            OWLDatatype oWLDatatype = OWLNormalization.this.getDefinitionFor(oWLDataRange2, this.m_alreadyExists);
            if (!this.m_alreadyExists[0]) {
                this.m_newDataRangeInclusions.add(new OWLDataRange[]{OWLNormalization.this.negative((OWLDataRange)oWLDatatype), oWLDataRange});
            }
            return OWLNormalization.this.m_factory.getOWLDataMaxCardinality(oWLDataMaxCardinality.getCardinality(), oWLDataPropertyExpression, OWLNormalization.this.m_expressionManager.getComplementNNF((OWLDataRange)oWLDatatype));
        }

        public OWLClassExpression visit(OWLDataExactCardinality oWLDataExactCardinality) {
            throw new IllegalStateException("Internal error: exact data cardinality restrictions should have been simplified.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AxiomVisitor
    implements OWLAxiomVisitor {
        protected final List<OWLClassExpression[]> m_classExpressionInclusionsAsDisjunctions = new ArrayList<OWLClassExpression[]>();
        protected final List<OWLDataRange[]> m_dataRangeInclusionsAsDisjunctions = new ArrayList<OWLDataRange[]>();
        protected final Collection<SWRLRule> m_rules = new HashSet<SWRLRule>();
        protected final boolean[] m_alreadyExists = new boolean[1];

        public void visit(OWLImportsDeclaration oWLImportsDeclaration) {
        }

        public void visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
        }

        public void visit(OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom) {
        }

        public void visit(OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom) {
        }

        public void visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
            this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{OWLNormalization.this.negative(oWLSubClassOfAxiom.getSubClass()), OWLNormalization.this.positive(oWLSubClassOfAxiom.getSuperClass())});
        }

        public void visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
            if (oWLEquivalentClassesAxiom.getClassExpressions().size() > 1) {
                OWLClassExpression oWLClassExpression;
                Iterator iterator = oWLEquivalentClassesAxiom.getClassExpressions().iterator();
                OWLClassExpression oWLClassExpression2 = oWLClassExpression = (OWLClassExpression)iterator.next();
                while (iterator.hasNext()) {
                    OWLClassExpression oWLClassExpression3 = (OWLClassExpression)iterator.next();
                    this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{OWLNormalization.this.negative(oWLClassExpression2), OWLNormalization.this.positive(oWLClassExpression3)});
                    oWLClassExpression2 = oWLClassExpression3;
                }
                this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{OWLNormalization.this.negative(oWLClassExpression2), OWLNormalization.this.positive(oWLClassExpression)});
            }
        }

        public void visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
            int n;
            if (oWLDisjointClassesAxiom.getClassExpressions().size() <= 1) {
                throw new IllegalArgumentException("Error: Parsed " + oWLDisjointClassesAxiom.toString() + ". A DisjointClasses axiom in OWL 2 DL must have at least two classes as parameters. ");
            }
            OWLClassExpression[] oWLClassExpressionArray = new OWLClassExpression[oWLDisjointClassesAxiom.getClassExpressions().size()];
            oWLDisjointClassesAxiom.getClassExpressions().toArray(oWLClassExpressionArray);
            for (n = 0; n < oWLClassExpressionArray.length; ++n) {
                oWLClassExpressionArray[n] = OWLNormalization.this.m_expressionManager.getComplementNNF(oWLClassExpressionArray[n]);
            }
            for (n = 0; n < oWLClassExpressionArray.length; ++n) {
                for (int i = n + 1; i < oWLClassExpressionArray.length; ++i) {
                    this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{oWLClassExpressionArray[n], oWLClassExpressionArray[i]});
                }
            }
        }

        public void visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
            int n;
            HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>(oWLDisjointUnionAxiom.getClassExpressions());
            hashSet.add(OWLNormalization.this.m_expressionManager.getComplementNNF((OWLClassExpression)oWLDisjointUnionAxiom.getOWLClass()));
            OWLClassExpression[] oWLClassExpressionArray = new OWLClassExpression[oWLDisjointUnionAxiom.getClassExpressions().size() + 1];
            hashSet.toArray(oWLClassExpressionArray);
            this.m_classExpressionInclusionsAsDisjunctions.add(oWLClassExpressionArray);
            for (OWLClassExpression oWLClassExpression : oWLDisjointUnionAxiom.getClassExpressions()) {
                this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{OWLNormalization.this.negative(oWLClassExpression), oWLDisjointUnionAxiom.getOWLClass()});
            }
            OWLClassExpression[] oWLClassExpressionArray2 = new OWLClassExpression[oWLDisjointUnionAxiom.getClassExpressions().size()];
            oWLDisjointUnionAxiom.getClassExpressions().toArray(oWLClassExpressionArray2);
            for (n = 0; n < oWLClassExpressionArray2.length; ++n) {
                oWLClassExpressionArray2[n] = OWLNormalization.this.m_expressionManager.getComplementNNF(oWLClassExpressionArray2[n]);
            }
            for (n = 0; n < oWLClassExpressionArray2.length; ++n) {
                for (int i = n + 1; i < oWLClassExpressionArray2.length; ++i) {
                    this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{oWLClassExpressionArray2[n], oWLClassExpressionArray2[i]});
                }
            }
        }

        public void visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
            if (!((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSubProperty()).isOWLBottomObjectProperty() && !((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSuperProperty()).isOWLTopObjectProperty()) {
                OWLNormalization.this.addInclusion((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSubProperty(), (OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSuperProperty());
            }
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSubProperty()).getNamedProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSuperProperty()).getNamedProperty());
        }

        public void visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
            List list = oWLSubPropertyChainOfAxiom.getPropertyChain();
            if (!this.containsBottomObjectProperty(list) && !oWLSubPropertyChainOfAxiom.getSuperProperty().isOWLTopObjectProperty()) {
                OWLObjectPropertyExpression oWLObjectPropertyExpression = oWLSubPropertyChainOfAxiom.getSuperProperty();
                if (list.size() == 1) {
                    OWLNormalization.this.addInclusion((OWLObjectPropertyExpression)list.get(0), oWLObjectPropertyExpression);
                } else if (list.size() == 2 && ((OWLObjectPropertyExpression)list.get(0)).equals(oWLObjectPropertyExpression) && ((OWLObjectPropertyExpression)list.get(1)).equals(oWLObjectPropertyExpression)) {
                    OWLNormalization.this.makeTransitive(oWLSubPropertyChainOfAxiom.getSuperProperty());
                } else {
                    OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray = new OWLObjectPropertyExpression[list.size()];
                    list.toArray(oWLObjectPropertyExpressionArray);
                    OWLNormalization.this.addInclusion(oWLObjectPropertyExpressionArray, oWLObjectPropertyExpression);
                }
            }
            for (OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray : list) {
                OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(oWLObjectPropertyExpressionArray.getNamedProperty());
            }
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(oWLSubPropertyChainOfAxiom.getSuperProperty().getNamedProperty());
        }

        protected boolean containsBottomObjectProperty(List<OWLObjectPropertyExpression> list) {
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : list) {
                if (!oWLObjectPropertyExpression.isOWLBottomObjectProperty()) continue;
                return true;
            }
            return false;
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
            Set set = oWLEquivalentObjectPropertiesAxiom.getProperties();
            if (set.size() > 1) {
                OWLObjectPropertyExpression oWLObjectPropertyExpression;
                Iterator iterator = set.iterator();
                OWLObjectPropertyExpression oWLObjectPropertyExpression2 = oWLObjectPropertyExpression = (OWLObjectPropertyExpression)iterator.next();
                while (iterator.hasNext()) {
                    OWLObjectPropertyExpression oWLObjectPropertyExpression3 = (OWLObjectPropertyExpression)iterator.next();
                    OWLNormalization.this.addInclusion(oWLObjectPropertyExpression2, oWLObjectPropertyExpression3);
                    oWLObjectPropertyExpression2 = oWLObjectPropertyExpression3;
                }
                OWLNormalization.this.addInclusion(oWLObjectPropertyExpression2, oWLObjectPropertyExpression);
            }
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : set) {
                OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(oWLObjectPropertyExpression.getNamedProperty());
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
            OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray = new OWLObjectPropertyExpression[oWLDisjointObjectPropertiesAxiom.getProperties().size()];
            oWLDisjointObjectPropertiesAxiom.getProperties().toArray(oWLObjectPropertyExpressionArray);
            for (int i = 0; i < oWLObjectPropertyExpressionArray.length; ++i) {
                oWLObjectPropertyExpressionArray[i] = oWLObjectPropertyExpressionArray[i].getSimplified();
                OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(oWLObjectPropertyExpressionArray[i].getNamedProperty());
            }
            OWLNormalization.this.m_axioms.m_disjointObjectProperties.add(oWLObjectPropertyExpressionArray);
        }

        public void visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
            OWLObjectPropertyExpression oWLObjectPropertyExpression = oWLInverseObjectPropertiesAxiom.getFirstProperty();
            OWLObjectPropertyExpression oWLObjectPropertyExpression2 = oWLInverseObjectPropertiesAxiom.getSecondProperty();
            OWLNormalization.this.addInclusion(oWLObjectPropertyExpression, oWLObjectPropertyExpression2.getInverseProperty());
            OWLNormalization.this.addInclusion(oWLObjectPropertyExpression2, oWLObjectPropertyExpression.getInverseProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(oWLObjectPropertyExpression.getNamedProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(oWLObjectPropertyExpression2.getNamedProperty());
        }

        public void visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
            OWLObjectAllValuesFrom oWLObjectAllValuesFrom = OWLNormalization.this.m_factory.getOWLObjectAllValuesFrom(((OWLObjectPropertyExpression)oWLObjectPropertyDomainAxiom.getProperty()).getSimplified(), (OWLClassExpression)OWLNormalization.this.m_factory.getOWLNothing());
            this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{OWLNormalization.this.positive(oWLObjectPropertyDomainAxiom.getDomain()), oWLObjectAllValuesFrom});
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLObjectPropertyDomainAxiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
            OWLObjectAllValuesFrom oWLObjectAllValuesFrom = OWLNormalization.this.m_factory.getOWLObjectAllValuesFrom(((OWLObjectPropertyExpression)oWLObjectPropertyRangeAxiom.getProperty()).getSimplified(), OWLNormalization.this.positive((OWLClassExpression)oWLObjectPropertyRangeAxiom.getRange()));
            this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{oWLObjectAllValuesFrom});
        }

        public void visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
            this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{OWLNormalization.this.m_factory.getOWLObjectMaxCardinality(1, ((OWLObjectPropertyExpression)oWLFunctionalObjectPropertyAxiom.getProperty()).getSimplified())});
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLFunctionalObjectPropertyAxiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
            this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{OWLNormalization.this.m_factory.getOWLObjectMaxCardinality(1, ((OWLObjectPropertyExpression)oWLInverseFunctionalObjectPropertyAxiom.getProperty()).getSimplified().getInverseProperty())});
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLInverseFunctionalObjectPropertyAxiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
            OWLNormalization.this.makeReflexive((OWLObjectPropertyExpression)oWLReflexiveObjectPropertyAxiom.getProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLReflexiveObjectPropertyAxiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
            OWLNormalization.this.makeIrreflexive((OWLObjectPropertyExpression)oWLIrreflexiveObjectPropertyAxiom.getProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLIrreflexiveObjectPropertyAxiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
            OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty();
            OWLNormalization.this.addInclusion(oWLObjectPropertyExpression, oWLObjectPropertyExpression.getInverseProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
            OWLNormalization.this.makeAsymmetric((OWLObjectPropertyExpression)oWLAsymmetricObjectPropertyAxiom.getProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLAsymmetricObjectPropertyAxiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
            OWLNormalization.this.makeTransitive((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty());
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
            OWLDataPropertyExpression oWLDataPropertyExpression = (OWLDataPropertyExpression)oWLSubDataPropertyOfAxiom.getSubProperty();
            this.checkTopDataPropertyUse(oWLDataPropertyExpression, (OWLAxiom)oWLSubDataPropertyOfAxiom);
            OWLDataPropertyExpression oWLDataPropertyExpression2 = (OWLDataPropertyExpression)oWLSubDataPropertyOfAxiom.getSuperProperty();
            if (!oWLDataPropertyExpression.isOWLBottomDataProperty() && !oWLDataPropertyExpression2.isOWLTopDataProperty()) {
                OWLNormalization.this.addInclusion(oWLDataPropertyExpression, oWLDataPropertyExpression2);
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
            for (OWLDataPropertyExpression oWLDataPropertyExpression : oWLEquivalentDataPropertiesAxiom.getProperties()) {
                this.checkTopDataPropertyUse(oWLDataPropertyExpression, (OWLAxiom)oWLEquivalentDataPropertiesAxiom);
            }
            if (oWLEquivalentDataPropertiesAxiom.getProperties().size() > 1) {
                OWLDataPropertyExpression oWLDataPropertyExpression;
                Iterator iterator = oWLEquivalentDataPropertiesAxiom.getProperties().iterator();
                OWLDataPropertyExpression oWLDataPropertyExpression2 = oWLDataPropertyExpression = (OWLDataPropertyExpression)iterator.next();
                while (iterator.hasNext()) {
                    OWLDataPropertyExpression oWLDataPropertyExpression3 = (OWLDataPropertyExpression)iterator.next();
                    OWLNormalization.this.addInclusion(oWLDataPropertyExpression2, oWLDataPropertyExpression3);
                    oWLDataPropertyExpression2 = oWLDataPropertyExpression3;
                }
                OWLNormalization.this.addInclusion(oWLDataPropertyExpression2, oWLDataPropertyExpression);
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
            OWLDataPropertyExpression[] oWLDataPropertyExpressionArray = new OWLDataPropertyExpression[oWLDisjointDataPropertiesAxiom.getProperties().size()];
            oWLDisjointDataPropertiesAxiom.getProperties().toArray(oWLDataPropertyExpressionArray);
            for (OWLDataPropertyExpression oWLDataPropertyExpression : oWLDataPropertyExpressionArray) {
                this.checkTopDataPropertyUse(oWLDataPropertyExpression, (OWLAxiom)oWLDisjointDataPropertiesAxiom);
            }
            OWLNormalization.this.m_axioms.m_disjointDataProperties.add(oWLDataPropertyExpressionArray);
        }

        public void visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
            OWLDataPropertyExpression oWLDataPropertyExpression = (OWLDataPropertyExpression)oWLDataPropertyDomainAxiom.getProperty();
            this.checkTopDataPropertyUse(oWLDataPropertyExpression, (OWLAxiom)oWLDataPropertyDomainAxiom);
            OWLDataComplementOf oWLDataComplementOf = OWLNormalization.this.m_factory.getOWLDataComplementOf((OWLDataRange)OWLNormalization.this.m_factory.getTopDatatype());
            OWLDataAllValuesFrom oWLDataAllValuesFrom = OWLNormalization.this.m_factory.getOWLDataAllValuesFrom(oWLDataPropertyExpression, (OWLDataRange)oWLDataComplementOf);
            this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{OWLNormalization.this.positive(oWLDataPropertyDomainAxiom.getDomain()), oWLDataAllValuesFrom});
        }

        public void visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
            OWLDataPropertyExpression oWLDataPropertyExpression = (OWLDataPropertyExpression)oWLDataPropertyRangeAxiom.getProperty();
            this.checkTopDataPropertyUse(oWLDataPropertyExpression, (OWLAxiom)oWLDataPropertyRangeAxiom);
            OWLDataAllValuesFrom oWLDataAllValuesFrom = OWLNormalization.this.m_factory.getOWLDataAllValuesFrom(oWLDataPropertyExpression, OWLNormalization.this.positive((OWLDataRange)oWLDataPropertyRangeAxiom.getRange()));
            this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{oWLDataAllValuesFrom});
        }

        public void visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
            OWLDataPropertyExpression oWLDataPropertyExpression = (OWLDataPropertyExpression)oWLFunctionalDataPropertyAxiom.getProperty();
            this.checkTopDataPropertyUse(oWLDataPropertyExpression, (OWLAxiom)oWLFunctionalDataPropertyAxiom);
            this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{OWLNormalization.this.m_factory.getOWLDataMaxCardinality(1, oWLDataPropertyExpression)});
        }

        protected void checkTopDataPropertyUse(OWLDataPropertyExpression oWLDataPropertyExpression, OWLAxiom oWLAxiom) {
            if (oWLDataPropertyExpression.isOWLTopDataProperty()) {
                throw new IllegalArgumentException("Error: In OWL 2 DL, owl:topDataProperty is only allowed to occur in the super property position of SubDataPropertyOf axioms, but the ontology contains an axiom " + oWLAxiom + " that violates this condition.");
            }
        }

        public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
            if (oWLSameIndividualAxiom.containsAnonymousIndividuals()) {
                throw new IllegalArgumentException("The axiom " + oWLSameIndividualAxiom + " contains anonymous individuals, which is not allowed in OWL 2. ");
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)oWLSameIndividualAxiom);
        }

        public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
            if (oWLDifferentIndividualsAxiom.containsAnonymousIndividuals()) {
                throw new IllegalArgumentException("The axiom " + oWLDifferentIndividualsAxiom + " contains anonymous individuals, which is not allowed in OWL 2. ");
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)oWLDifferentIndividualsAxiom);
        }

        public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
            OWLDataOneOf oWLDataOneOf;
            OWLDataSomeValuesFrom oWLDataSomeValuesFrom;
            OWLDataRange oWLDataRange;
            OWLClassExpression oWLClassExpression = oWLClassAssertionAxiom.getClassExpression();
            if (oWLClassExpression instanceof OWLDataHasValue) {
                OWLDataHasValue oWLDataHasValue = (OWLDataHasValue)oWLClassExpression;
                OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)oWLDataHasValue.getProperty(), oWLClassAssertionAxiom.getIndividual(), (OWLLiteral)oWLDataHasValue.getValue()));
                return;
            }
            if (oWLClassExpression instanceof OWLDataSomeValuesFrom && (oWLDataRange = (OWLDataRange)(oWLDataSomeValuesFrom = (OWLDataSomeValuesFrom)oWLClassExpression).getFiller()) instanceof OWLDataOneOf && (oWLDataOneOf = (OWLDataOneOf)oWLDataRange).getValues().size() == 1) {
                OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)oWLDataSomeValuesFrom.getProperty(), oWLClassAssertionAxiom.getIndividual(), (OWLLiteral)oWLDataOneOf.getValues().iterator().next()));
                return;
            }
            if (!OWLNormalization.isSimple(oWLClassExpression = OWLNormalization.this.positive(oWLClassExpression))) {
                oWLDataSomeValuesFrom = OWLNormalization.this.getDefinitionFor(oWLClassExpression, this.m_alreadyExists);
                if (!this.m_alreadyExists[0]) {
                    this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{OWLNormalization.this.negative((OWLClassExpression)oWLDataSomeValuesFrom), oWLClassExpression});
                }
                oWLClassExpression = oWLDataSomeValuesFrom;
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLClassAssertionAxiom(oWLClassExpression, oWLClassAssertionAxiom.getIndividual()));
        }

        public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLObjectPropertyAssertionAxiom(((OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty()).getSimplified(), oWLObjectPropertyAssertionAxiom.getSubject(), (OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject()));
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
            if (oWLNegativeObjectPropertyAssertionAxiom.containsAnonymousIndividuals()) {
                throw new IllegalArgumentException("The axiom " + oWLNegativeObjectPropertyAssertionAxiom + " contains anonymous individuals, which is not allowed in OWL 2 DL. ");
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)OWLNormalization.this.m_factory.getOWLNegativeObjectPropertyAssertionAxiom(((OWLObjectPropertyExpression)oWLNegativeObjectPropertyAssertionAxiom.getProperty()).getSimplified(), oWLNegativeObjectPropertyAssertionAxiom.getSubject(), (OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject()));
            OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(((OWLObjectPropertyExpression)oWLNegativeObjectPropertyAssertionAxiom.getProperty()).getNamedProperty());
        }

        public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
            this.checkTopDataPropertyUse((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty(), (OWLAxiom)oWLDataPropertyAssertionAxiom);
            OWLNormalization.this.addFact((OWLIndividualAxiom)oWLDataPropertyAssertionAxiom);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
            this.checkTopDataPropertyUse((OWLDataPropertyExpression)oWLNegativeDataPropertyAssertionAxiom.getProperty(), (OWLAxiom)oWLNegativeDataPropertyAssertionAxiom);
            if (oWLNegativeDataPropertyAssertionAxiom.containsAnonymousIndividuals()) {
                throw new IllegalArgumentException("The axiom " + oWLNegativeDataPropertyAssertionAxiom + " contains anonymous individuals, which is not allowed in OWL 2 DL. ");
            }
            OWLNormalization.this.addFact((OWLIndividualAxiom)oWLNegativeDataPropertyAssertionAxiom);
        }

        public void visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
            OWLNormalization.this.m_axioms.m_definedDatatypesIRIs.add(oWLDatatypeDefinitionAxiom.getDatatype().getIRI().toString());
            this.m_dataRangeInclusionsAsDisjunctions.add(new OWLDataRange[]{OWLNormalization.this.negative((OWLDataRange)oWLDatatypeDefinitionAxiom.getDatatype()), OWLNormalization.this.positive(oWLDatatypeDefinitionAxiom.getDataRange())});
            this.m_dataRangeInclusionsAsDisjunctions.add(new OWLDataRange[]{OWLNormalization.this.negative(oWLDatatypeDefinitionAxiom.getDataRange()), OWLNormalization.this.positive((OWLDataRange)oWLDatatypeDefinitionAxiom.getDatatype())});
        }

        public void visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
            for (Object object : oWLHasKeyAxiom.getDataPropertyExpressions()) {
                this.checkTopDataPropertyUse((OWLDataPropertyExpression)object, (OWLAxiom)oWLHasKeyAxiom);
            }
            OWLClassExpression oWLClassExpression = OWLNormalization.this.positive(oWLHasKeyAxiom.getClassExpression());
            if (!OWLNormalization.isSimple(oWLClassExpression)) {
                Object object;
                object = OWLNormalization.this.getDefinitionFor(oWLClassExpression, this.m_alreadyExists);
                if (!this.m_alreadyExists[0]) {
                    this.m_classExpressionInclusionsAsDisjunctions.add(new OWLClassExpression[]{OWLNormalization.this.negative((OWLClassExpression)object), oWLClassExpression});
                }
                oWLClassExpression = object;
            }
            OWLNormalization.this.m_axioms.m_hasKeys.add(OWLNormalization.this.m_factory.getOWLHasKeyAxiom(oWLClassExpression, oWLHasKeyAxiom.getPropertyExpressions()));
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLHasKeyAxiom.getObjectPropertyExpressions()) {
                OWLNormalization.this.m_axioms.m_objectPropertiesOccurringInOWLAxioms.add(oWLObjectPropertyExpression.getNamedProperty());
            }
        }

        public void visit(SWRLRule sWRLRule) {
            for (Object object : sWRLRule.getBody()) {
                if (!(object instanceof SWRLDataPropertyAtom)) continue;
                this.checkTopDataPropertyUse(((SWRLDataPropertyAtom)object).getPredicate(), (OWLAxiom)sWRLRule);
            }
            for (Object object : sWRLRule.getHead()) {
                if (!(object instanceof SWRLDataPropertyAtom)) continue;
                this.checkTopDataPropertyUse(((SWRLDataPropertyAtom)object).getPredicate(), (OWLAxiom)sWRLRule);
            }
            if (sWRLRule.getBody().isEmpty()) {
                Rule2FactConverter rule2FactConverter = new Rule2FactConverter(this.m_classExpressionInclusionsAsDisjunctions);
                for (SWRLAtom sWRLAtom : sWRLRule.getHead()) {
                    sWRLAtom.accept((SWRLObjectVisitor)rule2FactConverter);
                }
            } else {
                this.m_rules.add(sWRLRule);
            }
        }
    }
}

