/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.structural;

import java.util.HashSet;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;

public class ExpressionManager {
    protected final OWLDataFactory m_factory;
    protected final DescriptionNNFVisitor m_descriptionNNFVisitor;
    protected final DataRangeNNFVisitor m_dataRangeNNFVisitor;
    protected final DescriptionComplementNNFVisitor m_descriptionComplementNNFVisitor;
    protected final DataRangeComplementNNFVisitor m_dataRangeComplementNNFVisitor;
    protected final DescriptionSimplificationVisitor m_descriptionSimplificationVisitor;
    protected final DataRangeSimplificationVisitor m_dataRangeSimplificationVisitor;

    public ExpressionManager(OWLDataFactory oWLDataFactory) {
        this.m_factory = oWLDataFactory;
        this.m_descriptionNNFVisitor = new DescriptionNNFVisitor();
        this.m_dataRangeNNFVisitor = new DataRangeNNFVisitor();
        this.m_descriptionComplementNNFVisitor = new DescriptionComplementNNFVisitor();
        this.m_dataRangeComplementNNFVisitor = new DataRangeComplementNNFVisitor();
        this.m_descriptionSimplificationVisitor = new DescriptionSimplificationVisitor();
        this.m_dataRangeSimplificationVisitor = new DataRangeSimplificationVisitor();
    }

    public OWLClassExpression getNNF(OWLClassExpression oWLClassExpression) {
        return (OWLClassExpression)oWLClassExpression.accept((OWLClassExpressionVisitorEx)this.m_descriptionNNFVisitor);
    }

    public OWLDataRange getNNF(OWLDataRange oWLDataRange) {
        return (OWLDataRange)oWLDataRange.accept((OWLDataVisitorEx)this.m_dataRangeNNFVisitor);
    }

    public OWLClassExpression getComplementNNF(OWLClassExpression oWLClassExpression) {
        return (OWLClassExpression)oWLClassExpression.accept((OWLClassExpressionVisitorEx)this.m_descriptionComplementNNFVisitor);
    }

    public OWLDataRange getComplementNNF(OWLDataRange oWLDataRange) {
        return (OWLDataRange)oWLDataRange.accept((OWLDataVisitorEx)this.m_dataRangeComplementNNFVisitor);
    }

    public OWLClassExpression getSimplified(OWLClassExpression oWLClassExpression) {
        return (OWLClassExpression)oWLClassExpression.accept((OWLClassExpressionVisitorEx)this.m_descriptionSimplificationVisitor);
    }

    public OWLDataRange getSimplified(OWLDataRange oWLDataRange) {
        return (OWLDataRange)oWLDataRange.accept((OWLDataVisitorEx)this.m_dataRangeSimplificationVisitor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DataRangeSimplificationVisitor
    implements OWLDataVisitorEx<OWLDataRange> {
        protected DataRangeSimplificationVisitor() {
        }

        public OWLDataRange visit(OWLDatatype oWLDatatype) {
            return oWLDatatype;
        }

        public OWLDataRange visit(OWLDataComplementOf oWLDataComplementOf) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getSimplified(oWLDataComplementOf.getDataRange());
            if (oWLDataRange instanceof OWLDataComplementOf) {
                return ((OWLDataComplementOf)oWLDataRange).getDataRange();
            }
            return ExpressionManager.this.m_factory.getOWLDataComplementOf(oWLDataRange);
        }

        public OWLDataRange visit(OWLDataOneOf oWLDataOneOf) {
            return oWLDataOneOf;
        }

        public OWLDataRange visit(OWLDatatypeRestriction oWLDatatypeRestriction) {
            return oWLDatatypeRestriction;
        }

        public OWLDataRange visit(OWLFacetRestriction oWLFacetRestriction) {
            return null;
        }

        public OWLDataRange visit(OWLLiteral oWLLiteral) {
            return null;
        }

        public OWLDataRange visit(OWLDataIntersectionOf oWLDataIntersectionOf) {
            HashSet<OWLDataRange> hashSet = new HashSet<OWLDataRange>();
            for (OWLDataRange oWLDataRange : oWLDataIntersectionOf.getOperands()) {
                OWLDataRange oWLDataRange2 = ExpressionManager.this.getSimplified(oWLDataRange);
                if (oWLDataRange2.isTopDatatype()) continue;
                if (oWLDataRange2 instanceof OWLDataIntersectionOf) {
                    hashSet.addAll(((OWLDataIntersectionOf)oWLDataRange2).getOperands());
                    continue;
                }
                hashSet.add(oWLDataRange2);
            }
            return ExpressionManager.this.m_factory.getOWLDataIntersectionOf(hashSet);
        }

        public OWLDataRange visit(OWLDataUnionOf oWLDataUnionOf) {
            HashSet<OWLDataRange> hashSet = new HashSet<OWLDataRange>();
            for (OWLDataRange oWLDataRange : oWLDataUnionOf.getOperands()) {
                OWLDataRange oWLDataRange2 = ExpressionManager.this.getSimplified(oWLDataRange);
                if (oWLDataRange2.isTopDatatype()) {
                    return ExpressionManager.this.m_factory.getTopDatatype();
                }
                if (oWLDataRange2 instanceof OWLDataUnionOf) {
                    hashSet.addAll(((OWLDataUnionOf)oWLDataRange2).getOperands());
                    continue;
                }
                hashSet.add(oWLDataRange2);
            }
            return ExpressionManager.this.m_factory.getOWLDataUnionOf(hashSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DescriptionSimplificationVisitor
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        protected DescriptionSimplificationVisitor() {
        }

        public OWLClassExpression visit(OWLClass oWLClass) {
            return oWLClass;
        }

        public OWLClassExpression visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
            HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>();
            for (OWLClassExpression oWLClassExpression : oWLObjectIntersectionOf.getOperands()) {
                OWLClassExpression oWLClassExpression2 = ExpressionManager.this.getSimplified(oWLClassExpression);
                if (oWLClassExpression2.isOWLThing()) continue;
                if (oWLClassExpression2.isOWLNothing()) {
                    return ExpressionManager.this.m_factory.getOWLNothing();
                }
                if (oWLClassExpression2 instanceof OWLObjectIntersectionOf) {
                    hashSet.addAll(((OWLObjectIntersectionOf)oWLClassExpression2).getOperands());
                    continue;
                }
                hashSet.add(oWLClassExpression2);
            }
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(hashSet);
        }

        public OWLClassExpression visit(OWLObjectUnionOf oWLObjectUnionOf) {
            HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>();
            for (OWLClassExpression oWLClassExpression : oWLObjectUnionOf.getOperands()) {
                OWLClassExpression oWLClassExpression2 = ExpressionManager.this.getSimplified(oWLClassExpression);
                if (oWLClassExpression2.isOWLThing()) {
                    return ExpressionManager.this.m_factory.getOWLThing();
                }
                if (oWLClassExpression2.isOWLNothing()) continue;
                if (oWLClassExpression2 instanceof OWLObjectUnionOf) {
                    hashSet.addAll(((OWLObjectUnionOf)oWLClassExpression2).getOperands());
                    continue;
                }
                hashSet.add(oWLClassExpression2);
            }
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(hashSet);
        }

        public OWLClassExpression visit(OWLObjectComplementOf oWLObjectComplementOf) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getSimplified(oWLObjectComplementOf.getOperand());
            if (oWLClassExpression.isOWLThing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (oWLClassExpression.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (oWLClassExpression instanceof OWLObjectComplementOf) {
                return ((OWLObjectComplementOf)oWLClassExpression).getOperand();
            }
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf(oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectOneOf oWLObjectOneOf) {
            return oWLObjectOneOf;
        }

        public OWLClassExpression visit(OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getSimplified((OWLClassExpression)oWLObjectSomeValuesFrom.getFiller());
            if (oWLClassExpression.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom(((OWLObjectPropertyExpression)oWLObjectSomeValuesFrom.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectAllValuesFrom oWLObjectAllValuesFrom) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getSimplified((OWLClassExpression)oWLObjectAllValuesFrom.getFiller());
            if (oWLClassExpression.isOWLThing()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom(((OWLObjectPropertyExpression)oWLObjectAllValuesFrom.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectHasValue oWLObjectHasValue) {
            OWLObjectOneOf oWLObjectOneOf = ExpressionManager.this.m_factory.getOWLObjectOneOf(new OWLIndividual[]{(OWLIndividual)oWLObjectHasValue.getValue()});
            return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom(((OWLObjectPropertyExpression)oWLObjectHasValue.getProperty()).getSimplified(), (OWLClassExpression)oWLObjectOneOf);
        }

        public OWLClassExpression visit(OWLObjectHasSelf oWLObjectHasSelf) {
            return ExpressionManager.this.m_factory.getOWLObjectHasSelf(((OWLObjectPropertyExpression)oWLObjectHasSelf.getProperty()).getSimplified());
        }

        public OWLClassExpression visit(OWLObjectMinCardinality oWLObjectMinCardinality) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getSimplified((OWLClassExpression)oWLObjectMinCardinality.getFiller());
            if (oWLObjectMinCardinality.getCardinality() <= 0) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (oWLClassExpression.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (oWLObjectMinCardinality.getCardinality() == 1) {
                return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom(((OWLObjectPropertyExpression)oWLObjectMinCardinality.getProperty()).getSimplified(), oWLClassExpression);
            }
            return ExpressionManager.this.m_factory.getOWLObjectMinCardinality(oWLObjectMinCardinality.getCardinality(), ((OWLObjectPropertyExpression)oWLObjectMinCardinality.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectMaxCardinality oWLObjectMaxCardinality) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getSimplified((OWLClassExpression)oWLObjectMaxCardinality.getFiller());
            if (oWLClassExpression.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (oWLObjectMaxCardinality.getCardinality() <= 0) {
                return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom(((OWLObjectPropertyExpression)oWLObjectMaxCardinality.getProperty()).getSimplified(), (OWLClassExpression)ExpressionManager.this.m_factory.getOWLObjectComplementOf(oWLClassExpression));
            }
            return ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(oWLObjectMaxCardinality.getCardinality(), ((OWLObjectPropertyExpression)oWLObjectMaxCardinality.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectExactCardinality oWLObjectExactCardinality) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getSimplified((OWLClassExpression)oWLObjectExactCardinality.getFiller());
            if (oWLObjectExactCardinality.getCardinality() < 0) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (oWLObjectExactCardinality.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom(((OWLObjectPropertyExpression)oWLObjectExactCardinality.getProperty()).getSimplified(), (OWLClassExpression)ExpressionManager.this.m_factory.getOWLObjectComplementOf(oWLClassExpression));
            }
            if (oWLClassExpression.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLObjectMinCardinality oWLObjectMinCardinality = ExpressionManager.this.m_factory.getOWLObjectMinCardinality(oWLObjectExactCardinality.getCardinality(), ((OWLObjectPropertyExpression)oWLObjectExactCardinality.getProperty()).getSimplified(), oWLClassExpression);
            OWLObjectMaxCardinality oWLObjectMaxCardinality = ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(oWLObjectExactCardinality.getCardinality(), ((OWLObjectPropertyExpression)oWLObjectExactCardinality.getProperty()).getSimplified(), oWLClassExpression);
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{oWLObjectMinCardinality, oWLObjectMaxCardinality});
        }

        public OWLClassExpression visit(OWLDataSomeValuesFrom oWLDataSomeValuesFrom) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getSimplified((OWLDataRange)oWLDataSomeValuesFrom.getFiller());
            if (this.isBottomDataRange(oWLDataRange)) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)oWLDataSomeValuesFrom.getProperty(), oWLDataRange);
        }

        public OWLClassExpression visit(OWLDataAllValuesFrom oWLDataAllValuesFrom) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getSimplified((OWLDataRange)oWLDataAllValuesFrom.getFiller());
            if (oWLDataRange.isTopDatatype()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)oWLDataAllValuesFrom.getProperty(), oWLDataRange);
        }

        public OWLClassExpression visit(OWLDataHasValue oWLDataHasValue) {
            OWLDataOneOf oWLDataOneOf = ExpressionManager.this.m_factory.getOWLDataOneOf(new OWLLiteral[]{(OWLLiteral)oWLDataHasValue.getValue()});
            return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)oWLDataHasValue.getProperty(), (OWLDataRange)oWLDataOneOf);
        }

        public OWLClassExpression visit(OWLDataMinCardinality oWLDataMinCardinality) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getSimplified((OWLDataRange)oWLDataMinCardinality.getFiller());
            if (oWLDataMinCardinality.getCardinality() <= 0) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (this.isBottomDataRange(oWLDataRange)) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (oWLDataMinCardinality.getCardinality() == 1) {
                return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)oWLDataMinCardinality.getProperty(), oWLDataRange);
            }
            return ExpressionManager.this.m_factory.getOWLDataMinCardinality(oWLDataMinCardinality.getCardinality(), (OWLDataPropertyExpression)oWLDataMinCardinality.getProperty(), oWLDataRange);
        }

        public OWLClassExpression visit(OWLDataMaxCardinality oWLDataMaxCardinality) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getSimplified((OWLDataRange)oWLDataMaxCardinality.getFiller());
            if (this.isBottomDataRange(oWLDataRange)) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (oWLDataMaxCardinality.getCardinality() <= 0) {
                return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)oWLDataMaxCardinality.getProperty(), (OWLDataRange)ExpressionManager.this.m_factory.getOWLDataComplementOf(oWLDataRange));
            }
            return ExpressionManager.this.m_factory.getOWLDataMaxCardinality(oWLDataMaxCardinality.getCardinality(), (OWLDataPropertyExpression)oWLDataMaxCardinality.getProperty(), oWLDataRange);
        }

        public OWLClassExpression visit(OWLDataExactCardinality oWLDataExactCardinality) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getSimplified((OWLDataRange)oWLDataExactCardinality.getFiller());
            if (oWLDataExactCardinality.getCardinality() < 0) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (oWLDataExactCardinality.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)oWLDataExactCardinality.getProperty(), (OWLDataRange)ExpressionManager.this.m_factory.getOWLDataComplementOf(oWLDataRange));
            }
            if (this.isBottomDataRange(oWLDataRange)) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLDataMinCardinality oWLDataMinCardinality = ExpressionManager.this.m_factory.getOWLDataMinCardinality(oWLDataExactCardinality.getCardinality(), (OWLDataPropertyExpression)oWLDataExactCardinality.getProperty(), oWLDataRange);
            OWLDataMaxCardinality oWLDataMaxCardinality = ExpressionManager.this.m_factory.getOWLDataMaxCardinality(oWLDataExactCardinality.getCardinality(), (OWLDataPropertyExpression)oWLDataExactCardinality.getProperty(), oWLDataRange);
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{oWLDataMinCardinality, oWLDataMaxCardinality});
        }

        protected boolean isBottomDataRange(OWLDataRange oWLDataRange) {
            return oWLDataRange instanceof OWLDataComplementOf && ((OWLDataComplementOf)oWLDataRange).getDataRange().isTopDatatype();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DataRangeComplementNNFVisitor
    implements OWLDataVisitorEx<OWLDataRange> {
        protected DataRangeComplementNNFVisitor() {
        }

        public OWLDataRange visit(OWLDatatype oWLDatatype) {
            return ExpressionManager.this.m_factory.getOWLDataComplementOf((OWLDataRange)oWLDatatype);
        }

        public OWLDataRange visit(OWLDataComplementOf oWLDataComplementOf) {
            return ExpressionManager.this.getNNF(oWLDataComplementOf.getDataRange());
        }

        public OWLDataRange visit(OWLDataOneOf oWLDataOneOf) {
            return ExpressionManager.this.m_factory.getOWLDataComplementOf((OWLDataRange)oWLDataOneOf);
        }

        public OWLDataRange visit(OWLDatatypeRestriction oWLDatatypeRestriction) {
            return ExpressionManager.this.m_factory.getOWLDataComplementOf((OWLDataRange)oWLDatatypeRestriction);
        }

        public OWLDataRange visit(OWLFacetRestriction oWLFacetRestriction) {
            return null;
        }

        public OWLDataRange visit(OWLLiteral oWLLiteral) {
            return null;
        }

        public OWLDataRange visit(OWLDataIntersectionOf oWLDataIntersectionOf) {
            HashSet<OWLDataRange> hashSet = new HashSet<OWLDataRange>();
            for (OWLDataRange oWLDataRange : oWLDataIntersectionOf.getOperands()) {
                hashSet.add(ExpressionManager.this.getComplementNNF(oWLDataRange));
            }
            return ExpressionManager.this.m_factory.getOWLDataUnionOf(hashSet);
        }

        public OWLDataRange visit(OWLDataUnionOf oWLDataUnionOf) {
            HashSet<OWLDataRange> hashSet = new HashSet<OWLDataRange>();
            for (OWLDataRange oWLDataRange : oWLDataUnionOf.getOperands()) {
                hashSet.add(ExpressionManager.this.getComplementNNF(oWLDataRange));
            }
            return ExpressionManager.this.m_factory.getOWLDataIntersectionOf(hashSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DescriptionComplementNNFVisitor
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        protected DescriptionComplementNNFVisitor() {
        }

        public OWLClassExpression visit(OWLClass oWLClass) {
            if (oWLClass.isOWLThing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (oWLClass.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf((OWLClassExpression)oWLClass);
        }

        public OWLClassExpression visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
            HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>();
            for (OWLClassExpression oWLClassExpression : oWLObjectIntersectionOf.getOperands()) {
                hashSet.add(ExpressionManager.this.getComplementNNF(oWLClassExpression));
            }
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(hashSet);
        }

        public OWLClassExpression visit(OWLObjectUnionOf oWLObjectUnionOf) {
            HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>();
            for (OWLClassExpression oWLClassExpression : oWLObjectUnionOf.getOperands()) {
                hashSet.add(ExpressionManager.this.getComplementNNF(oWLClassExpression));
            }
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(hashSet);
        }

        public OWLClassExpression visit(OWLObjectComplementOf oWLObjectComplementOf) {
            return ExpressionManager.this.getNNF(oWLObjectComplementOf.getOperand());
        }

        public OWLClassExpression visit(OWLObjectOneOf oWLObjectOneOf) {
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf((OWLClassExpression)oWLObjectOneOf);
        }

        public OWLClassExpression visit(OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getComplementNNF((OWLClassExpression)oWLObjectSomeValuesFrom.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom(((OWLObjectPropertyExpression)oWLObjectSomeValuesFrom.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectAllValuesFrom oWLObjectAllValuesFrom) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getComplementNNF((OWLClassExpression)oWLObjectAllValuesFrom.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom(((OWLObjectPropertyExpression)oWLObjectAllValuesFrom.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectHasValue oWLObjectHasValue) {
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf(ExpressionManager.this.getNNF((OWLClassExpression)oWLObjectHasValue));
        }

        public OWLClassExpression visit(OWLObjectHasSelf oWLObjectHasSelf) {
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf(ExpressionManager.this.getNNF((OWLClassExpression)oWLObjectHasSelf));
        }

        public OWLClassExpression visit(OWLObjectMinCardinality oWLObjectMinCardinality) {
            if (oWLObjectMinCardinality.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getNNF((OWLClassExpression)oWLObjectMinCardinality.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(oWLObjectMinCardinality.getCardinality() - 1, ((OWLObjectPropertyExpression)oWLObjectMinCardinality.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectMaxCardinality oWLObjectMaxCardinality) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getNNF((OWLClassExpression)oWLObjectMaxCardinality.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectMinCardinality(oWLObjectMaxCardinality.getCardinality() + 1, ((OWLObjectPropertyExpression)oWLObjectMaxCardinality.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectExactCardinality oWLObjectExactCardinality) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getNNF((OWLClassExpression)oWLObjectExactCardinality.getFiller());
            if (oWLObjectExactCardinality.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLObjectMinCardinality(1, ((OWLObjectPropertyExpression)oWLObjectExactCardinality.getProperty()).getSimplified(), oWLClassExpression);
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(oWLObjectExactCardinality.getCardinality() - 1, ((OWLObjectPropertyExpression)oWLObjectExactCardinality.getProperty()).getSimplified(), oWLClassExpression));
            hashSet.add(ExpressionManager.this.m_factory.getOWLObjectMinCardinality(oWLObjectExactCardinality.getCardinality() + 1, ((OWLObjectPropertyExpression)oWLObjectExactCardinality.getProperty()).getSimplified(), oWLClassExpression));
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(hashSet);
        }

        public OWLClassExpression visit(OWLDataSomeValuesFrom oWLDataSomeValuesFrom) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getComplementNNF((OWLDataRange)oWLDataSomeValuesFrom.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)oWLDataSomeValuesFrom.getProperty(), oWLDataRange);
        }

        public OWLClassExpression visit(OWLDataAllValuesFrom oWLDataAllValuesFrom) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getComplementNNF((OWLDataRange)oWLDataAllValuesFrom.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)oWLDataAllValuesFrom.getProperty(), oWLDataRange);
        }

        public OWLClassExpression visit(OWLDataHasValue oWLDataHasValue) {
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf((OWLClassExpression)oWLDataHasValue);
        }

        public OWLClassExpression visit(OWLDataMinCardinality oWLDataMinCardinality) {
            if (oWLDataMinCardinality.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLDataRange oWLDataRange = ExpressionManager.this.getNNF((OWLDataRange)oWLDataMinCardinality.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataMaxCardinality(oWLDataMinCardinality.getCardinality() - 1, (OWLDataPropertyExpression)oWLDataMinCardinality.getProperty(), oWLDataRange);
        }

        public OWLClassExpression visit(OWLDataMaxCardinality oWLDataMaxCardinality) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getNNF((OWLDataRange)oWLDataMaxCardinality.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataMinCardinality(oWLDataMaxCardinality.getCardinality() + 1, (OWLDataPropertyExpression)oWLDataMaxCardinality.getProperty(), oWLDataRange);
        }

        public OWLClassExpression visit(OWLDataExactCardinality oWLDataExactCardinality) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getNNF((OWLDataRange)oWLDataExactCardinality.getFiller());
            if (oWLDataExactCardinality.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLDataMinCardinality(1, (OWLDataPropertyExpression)oWLDataExactCardinality.getProperty(), oWLDataRange);
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(ExpressionManager.this.m_factory.getOWLDataMaxCardinality(oWLDataExactCardinality.getCardinality() - 1, (OWLDataPropertyExpression)oWLDataExactCardinality.getProperty(), oWLDataRange));
            hashSet.add(ExpressionManager.this.m_factory.getOWLDataMinCardinality(oWLDataExactCardinality.getCardinality() + 1, (OWLDataPropertyExpression)oWLDataExactCardinality.getProperty(), oWLDataRange));
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(hashSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DataRangeNNFVisitor
    implements OWLDataVisitorEx<OWLDataRange> {
        protected DataRangeNNFVisitor() {
        }

        public OWLDataRange visit(OWLDatatype oWLDatatype) {
            return oWLDatatype;
        }

        public OWLDataRange visit(OWLDataComplementOf oWLDataComplementOf) {
            return ExpressionManager.this.getComplementNNF(oWLDataComplementOf.getDataRange());
        }

        public OWLDataRange visit(OWLDataOneOf oWLDataOneOf) {
            return oWLDataOneOf;
        }

        public OWLDataRange visit(OWLDataRange oWLDataRange) {
            return oWLDataRange;
        }

        public OWLDataRange visit(OWLDatatypeRestriction oWLDatatypeRestriction) {
            return oWLDatatypeRestriction;
        }

        public OWLDataRange visit(OWLFacetRestriction oWLFacetRestriction) {
            return null;
        }

        public OWLDataRange visit(OWLLiteral oWLLiteral) {
            return null;
        }

        public OWLDataRange visit(OWLDataIntersectionOf oWLDataIntersectionOf) {
            HashSet<OWLDataRange> hashSet = new HashSet<OWLDataRange>();
            for (OWLDataRange oWLDataRange : oWLDataIntersectionOf.getOperands()) {
                hashSet.add(ExpressionManager.this.getNNF(oWLDataRange));
            }
            return ExpressionManager.this.m_factory.getOWLDataIntersectionOf(hashSet);
        }

        public OWLDataRange visit(OWLDataUnionOf oWLDataUnionOf) {
            HashSet<OWLDataRange> hashSet = new HashSet<OWLDataRange>();
            for (OWLDataRange oWLDataRange : oWLDataUnionOf.getOperands()) {
                hashSet.add(ExpressionManager.this.getNNF(oWLDataRange));
            }
            return ExpressionManager.this.m_factory.getOWLDataUnionOf(hashSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DescriptionNNFVisitor
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        protected DescriptionNNFVisitor() {
        }

        public OWLClassExpression visit(OWLClass oWLClass) {
            return oWLClass;
        }

        public OWLClassExpression visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
            HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>();
            for (OWLClassExpression oWLClassExpression : oWLObjectIntersectionOf.getOperands()) {
                OWLClassExpression oWLClassExpression2 = ExpressionManager.this.getNNF(oWLClassExpression);
                hashSet.add(oWLClassExpression2);
            }
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(hashSet);
        }

        public OWLClassExpression visit(OWLObjectUnionOf oWLObjectUnionOf) {
            HashSet<OWLClassExpression> hashSet = new HashSet<OWLClassExpression>();
            for (OWLClassExpression oWLClassExpression : oWLObjectUnionOf.getOperands()) {
                OWLClassExpression oWLClassExpression2 = ExpressionManager.this.getNNF(oWLClassExpression);
                hashSet.add(oWLClassExpression2);
            }
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(hashSet);
        }

        public OWLClassExpression visit(OWLObjectComplementOf oWLObjectComplementOf) {
            return ExpressionManager.this.getComplementNNF(oWLObjectComplementOf.getOperand());
        }

        public OWLClassExpression visit(OWLObjectOneOf oWLObjectOneOf) {
            return oWLObjectOneOf;
        }

        public OWLClassExpression visit(OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getNNF((OWLClassExpression)oWLObjectSomeValuesFrom.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom(((OWLObjectPropertyExpression)oWLObjectSomeValuesFrom.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectAllValuesFrom oWLObjectAllValuesFrom) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getNNF((OWLClassExpression)oWLObjectAllValuesFrom.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom(((OWLObjectPropertyExpression)oWLObjectAllValuesFrom.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectHasValue oWLObjectHasValue) {
            return ExpressionManager.this.m_factory.getOWLObjectHasValue(((OWLObjectPropertyExpression)oWLObjectHasValue.getProperty()).getSimplified(), (OWLIndividual)oWLObjectHasValue.getValue());
        }

        public OWLClassExpression visit(OWLObjectHasSelf oWLObjectHasSelf) {
            return ExpressionManager.this.m_factory.getOWLObjectHasSelf(((OWLObjectPropertyExpression)oWLObjectHasSelf.getProperty()).getSimplified());
        }

        public OWLClassExpression visit(OWLObjectMinCardinality oWLObjectMinCardinality) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getNNF((OWLClassExpression)oWLObjectMinCardinality.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectMinCardinality(oWLObjectMinCardinality.getCardinality(), ((OWLObjectPropertyExpression)oWLObjectMinCardinality.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectMaxCardinality oWLObjectMaxCardinality) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getNNF((OWLClassExpression)oWLObjectMaxCardinality.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(oWLObjectMaxCardinality.getCardinality(), ((OWLObjectPropertyExpression)oWLObjectMaxCardinality.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLObjectExactCardinality oWLObjectExactCardinality) {
            OWLClassExpression oWLClassExpression = ExpressionManager.this.getNNF((OWLClassExpression)oWLObjectExactCardinality.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectExactCardinality(oWLObjectExactCardinality.getCardinality(), ((OWLObjectPropertyExpression)oWLObjectExactCardinality.getProperty()).getSimplified(), oWLClassExpression);
        }

        public OWLClassExpression visit(OWLDataSomeValuesFrom oWLDataSomeValuesFrom) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getNNF((OWLDataRange)oWLDataSomeValuesFrom.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)oWLDataSomeValuesFrom.getProperty(), oWLDataRange);
        }

        public OWLClassExpression visit(OWLDataAllValuesFrom oWLDataAllValuesFrom) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getNNF((OWLDataRange)oWLDataAllValuesFrom.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)oWLDataAllValuesFrom.getProperty(), oWLDataRange);
        }

        public OWLClassExpression visit(OWLDataHasValue oWLDataHasValue) {
            return oWLDataHasValue;
        }

        public OWLClassExpression visit(OWLDataMinCardinality oWLDataMinCardinality) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getNNF((OWLDataRange)oWLDataMinCardinality.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataMinCardinality(oWLDataMinCardinality.getCardinality(), (OWLDataPropertyExpression)oWLDataMinCardinality.getProperty(), oWLDataRange);
        }

        public OWLClassExpression visit(OWLDataMaxCardinality oWLDataMaxCardinality) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getNNF((OWLDataRange)oWLDataMaxCardinality.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataMaxCardinality(oWLDataMaxCardinality.getCardinality(), (OWLDataPropertyExpression)oWLDataMaxCardinality.getProperty(), oWLDataRange);
        }

        public OWLClassExpression visit(OWLDataExactCardinality oWLDataExactCardinality) {
            OWLDataRange oWLDataRange = ExpressionManager.this.getNNF((OWLDataRange)oWLDataExactCardinality.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataExactCardinality(oWLDataExactCardinality.getCardinality(), (OWLDataPropertyExpression)oWLDataExactCardinality.getProperty(), oWLDataRange);
        }
    }
}

