/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.InterningManager;
import org.semanticweb.HermiT.model.Term;

public class Individual
extends Term {
    private static final long serialVersionUID = 2791684055390160959L;
    protected final String m_uri;
    protected static InterningManager<Individual> s_interningManager = new InterningManager<Individual>(){

        @Override
        protected boolean equal(Individual individual, Individual individual2) {
            return individual.m_uri.equals(individual2.m_uri);
        }

        @Override
        protected int getHashCode(Individual individual) {
            return individual.m_uri.hashCode();
        }
    };

    protected Individual(String string) {
        this.m_uri = string;
    }

    public String getIRI() {
        return this.m_uri;
    }

    public boolean isAnonymous() {
        return this.m_uri.startsWith("internal:anonymous#");
    }

    public String toString() {
        return this.toString(Prefixes.STANDARD_PREFIXES);
    }

    protected Object readResolve() {
        return s_interningManager.intern(this);
    }

    public String toString(Prefixes prefixes) {
        return prefixes.abbreviateIRI(this.m_uri);
    }

    public static Individual create(String string) {
        return s_interningManager.intern(new Individual(string));
    }

    public static Individual createAnonymous(String string) {
        return Individual.create(Individual.getAnonymousURI(string));
    }

    public static String getAnonymousURI(String string) {
        return "internal:anonymous#" + string;
    }
}

