/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import java.io.Serializable;
import java.util.HashSet;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.AnnotatedEquality;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.InterningManager;
import org.semanticweb.HermiT.model.Term;
import org.semanticweb.HermiT.model.Variable;

public class DLClause
implements Serializable {
    private static final long serialVersionUID = -4513910129515151732L;
    protected final Atom[] m_headAtoms;
    protected final Atom[] m_bodyAtoms;
    protected static InterningManager<DLClause> s_interningManager = new InterningManager<DLClause>(){

        @Override
        protected boolean equal(DLClause dLClause, DLClause dLClause2) {
            int n;
            if (dLClause.m_headAtoms.length != dLClause2.m_headAtoms.length || dLClause.m_bodyAtoms.length != dLClause2.m_bodyAtoms.length) {
                return false;
            }
            for (n = dLClause.m_headAtoms.length - 1; n >= 0; --n) {
                if (dLClause.m_headAtoms[n] == dLClause2.m_headAtoms[n]) continue;
                return false;
            }
            for (n = dLClause.m_bodyAtoms.length - 1; n >= 0; --n) {
                if (dLClause.m_bodyAtoms[n] == dLClause2.m_bodyAtoms[n]) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int getHashCode(DLClause dLClause) {
            int n;
            int n2 = 0;
            for (n = dLClause.m_bodyAtoms.length - 1; n >= 0; --n) {
                n2 += dLClause.m_bodyAtoms[n].hashCode();
            }
            for (n = dLClause.m_headAtoms.length - 1; n >= 0; --n) {
                n2 += dLClause.m_headAtoms[n].hashCode();
            }
            return n2;
        }
    };

    protected DLClause(Atom[] atomArray, Atom[] atomArray2) {
        this.m_headAtoms = atomArray;
        this.m_bodyAtoms = atomArray2;
    }

    public int getHeadLength() {
        return this.m_headAtoms.length;
    }

    public Atom getHeadAtom(int n) {
        return this.m_headAtoms[n];
    }

    public Atom[] getHeadAtoms() {
        return (Atom[])this.m_headAtoms.clone();
    }

    public int getBodyLength() {
        return this.m_bodyAtoms.length;
    }

    public Atom getBodyAtom(int n) {
        return this.m_bodyAtoms[n];
    }

    public Atom[] getBodyAtoms() {
        return (Atom[])this.m_bodyAtoms.clone();
    }

    public DLClause getSafeVersion(DLPredicate dLPredicate) {
        Variable variable2;
        int n;
        Atom atom;
        int n2;
        HashSet<Variable> hashSet = new HashSet<Variable>();
        for (n2 = 0; n2 < this.m_headAtoms.length; ++n2) {
            atom = this.m_headAtoms[n2];
            for (n = 0; n < atom.getArity(); ++n) {
                variable2 = atom.getArgumentVariable(n);
                if (variable2 == null) continue;
                hashSet.add(variable2);
            }
        }
        for (n2 = 0; n2 < this.m_bodyAtoms.length; ++n2) {
            atom = this.m_bodyAtoms[n2];
            for (n = 0; n < atom.getArity(); ++n) {
                variable2 = atom.getArgumentVariable(n);
                if (variable2 == null) continue;
                hashSet.remove(variable2);
            }
        }
        if (this.m_headAtoms.length == 0 && this.m_bodyAtoms.length == 0) {
            hashSet.add(Variable.create("X"));
        }
        if (hashSet.isEmpty()) {
            return this;
        }
        Atom[] atomArray = new Atom[this.m_bodyAtoms.length + hashSet.size()];
        System.arraycopy(this.m_bodyAtoms, 0, atomArray, 0, this.m_bodyAtoms.length);
        int n3 = this.m_bodyAtoms.length;
        for (Variable variable2 : hashSet) {
            atomArray[n3++] = Atom.create(dLPredicate, variable2);
        }
        return DLClause.create(this.m_headAtoms, atomArray);
    }

    public DLClause getChangedDLClause(Atom[] atomArray, Atom[] atomArray2) {
        if (atomArray == null) {
            atomArray = this.m_headAtoms;
        }
        if (atomArray2 == null) {
            atomArray2 = this.m_bodyAtoms;
        }
        return DLClause.create(atomArray, atomArray2);
    }

    public boolean isAtomicConceptInclusion() {
        if (this.m_bodyAtoms.length == 1 && this.m_headAtoms.length == 1) {
            Atom atom = this.m_bodyAtoms[0];
            Atom atom2 = this.m_headAtoms[0];
            if (atom.getArity() == 1 && atom2.getArity() == 1 && atom.getDLPredicate() instanceof AtomicConcept && atom2.getDLPredicate() instanceof AtomicConcept) {
                Term term = atom.getArgument(0);
                return term instanceof Variable && term.equals(atom2.getArgument(0));
            }
        }
        return false;
    }

    public boolean isAtomicRoleInclusion() {
        if (this.m_bodyAtoms.length == 1 && this.m_headAtoms.length == 1) {
            Atom atom = this.m_bodyAtoms[0];
            Atom atom2 = this.m_headAtoms[0];
            if (atom.getArity() == 2 && atom2.getArity() == 2 && atom.getDLPredicate() instanceof AtomicRole && atom2.getDLPredicate() instanceof AtomicRole) {
                Term term = atom.getArgument(0);
                Term term2 = atom.getArgument(1);
                return term instanceof Variable && term2 instanceof Variable && !term.equals(term2) && term.equals(atom2.getArgument(0)) && term2.equals(atom2.getArgument(1));
            }
        }
        return false;
    }

    public boolean isAtomicRoleInverseInclusion() {
        if (this.m_bodyAtoms.length == 1 && this.m_headAtoms.length == 1) {
            Atom atom = this.m_bodyAtoms[0];
            Atom atom2 = this.m_headAtoms[0];
            if (atom.getArity() == 2 && atom2.getArity() == 2 && atom.getDLPredicate() instanceof AtomicRole && atom2.getDLPredicate() instanceof AtomicRole) {
                Term term = atom.getArgument(0);
                Term term2 = atom.getArgument(1);
                return term instanceof Variable && term2 instanceof Variable && !term.equals(term2) && term.equals(atom2.getArgument(1)) && term2.equals(atom2.getArgument(0));
            }
        }
        return false;
    }

    public boolean isFunctionalityAxiom() {
        Variable variable;
        DLPredicate dLPredicate;
        if (this.m_bodyAtoms.length == 2 && this.m_headAtoms.length == 1 && (dLPredicate = this.getBodyAtom(0).getDLPredicate()) instanceof AtomicRole && this.getBodyAtom(1).getDLPredicate().equals(dLPredicate) && this.getHeadAtom(0).getDLPredicate() instanceof AnnotatedEquality && (variable = this.getBodyAtom(0).getArgumentVariable(0)) != null && variable.equals(this.getBodyAtom(1).getArgument(0))) {
            Variable variable2 = this.getBodyAtom(0).getArgumentVariable(1);
            Variable variable3 = this.getBodyAtom(1).getArgumentVariable(1);
            Variable variable4 = this.getHeadAtom(0).getArgumentVariable(0);
            Variable variable5 = this.getHeadAtom(0).getArgumentVariable(1);
            if (variable2 != null && variable3 != null && !variable2.equals(variable3) && variable4 != null && variable5 != null && (variable2.equals(variable4) && variable3.equals(variable5) || variable2.equals(variable5) && variable3.equals(variable4))) {
                return true;
            }
        }
        return false;
    }

    public boolean isInverseFunctionalityAxiom() {
        Variable variable;
        DLPredicate dLPredicate;
        if (this.getBodyLength() == 2 && this.getHeadLength() == 1 && (dLPredicate = this.getBodyAtom(0).getDLPredicate()) instanceof AtomicRole && this.getBodyAtom(1).getDLPredicate().equals(dLPredicate) && this.getHeadAtom(0).getDLPredicate() instanceof AnnotatedEquality && (variable = this.getBodyAtom(0).getArgumentVariable(1)) != null && variable.equals(this.getBodyAtom(1).getArgument(1))) {
            Variable variable2 = this.getBodyAtom(0).getArgumentVariable(0);
            Variable variable3 = this.getBodyAtom(1).getArgumentVariable(0);
            Variable variable4 = this.getHeadAtom(0).getArgumentVariable(0);
            Variable variable5 = this.getHeadAtom(0).getArgumentVariable(1);
            if (variable2 != null && variable3 != null && !variable2.equals(variable3) && variable4 != null && variable5 != null && (variable2.equals(variable4) && variable3.equals(variable5) || variable2.equals(variable5) && variable3.equals(variable4))) {
                return true;
            }
        }
        return false;
    }

    public String toString(Prefixes prefixes) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.m_headAtoms.length; ++n) {
            if (n != 0) {
                stringBuffer.append(" v ");
            }
            stringBuffer.append(this.m_headAtoms[n].toString(prefixes));
        }
        stringBuffer.append(" :- ");
        for (n = 0; n < this.m_bodyAtoms.length; ++n) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.m_bodyAtoms[n].toString(prefixes));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(Prefixes.STANDARD_PREFIXES);
    }

    public static DLClause create(Atom[] atomArray, Atom[] atomArray2) {
        return s_interningManager.intern(new DLClause(atomArray, atomArray2));
    }
}

