/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import org.semanticweb.HermiT.graph.Graph;
import org.semanticweb.HermiT.hierarchy.ClassificationProgressMonitor;
import org.semanticweb.HermiT.hierarchy.DeterministicClassification;
import org.semanticweb.HermiT.hierarchy.Hierarchy;
import org.semanticweb.HermiT.hierarchy.HierarchyNode;
import org.semanticweb.HermiT.hierarchy.HierarchySearch;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.Individual;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.ReasoningTaskDescription;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuasiOrderClassification {
    protected final Tableau m_tableau;
    protected final ClassificationProgressMonitor m_progressMonitor;
    protected final AtomicConcept m_topElement;
    protected final AtomicConcept m_bottomElement;
    protected final Set<AtomicConcept> m_elements;
    protected final Graph<AtomicConcept> m_knownSubsumptions;
    protected final Graph<AtomicConcept> m_possibleSubsumptions;

    public QuasiOrderClassification(Tableau tableau, ClassificationProgressMonitor classificationProgressMonitor, AtomicConcept atomicConcept, AtomicConcept atomicConcept2, Set<AtomicConcept> set) {
        this.m_tableau = tableau;
        this.m_progressMonitor = classificationProgressMonitor;
        this.m_topElement = atomicConcept;
        this.m_bottomElement = atomicConcept2;
        this.m_elements = set;
        this.m_knownSubsumptions = new Graph();
        this.m_possibleSubsumptions = new Graph();
    }

    public Hierarchy<AtomicConcept> classify() {
        HierarchySearch.Relation<AtomicConcept> relation = new HierarchySearch.Relation<AtomicConcept>(){

            @Override
            public boolean doesSubsume(AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
                boolean bl;
                Set<AtomicConcept> set = QuasiOrderClassification.this.getAllKnownSubsumers(atomicConcept2);
                if (set.contains(atomicConcept)) {
                    return true;
                }
                if (!QuasiOrderClassification.this.m_possibleSubsumptions.getSuccessors(atomicConcept2).contains(atomicConcept)) {
                    return false;
                }
                Individual individual = Individual.createAnonymous("fresh-individual");
                HashMap<Individual, Node> hashMap = new HashMap<Individual, Node>();
                hashMap.put(individual, null);
                boolean bl2 = bl = !QuasiOrderClassification.this.m_tableau.isSatisfiable(true, Collections.singleton(Atom.create(atomicConcept2, individual)), null, null, Collections.singleton(Atom.create(atomicConcept, individual)), hashMap, QuasiOrderClassification.this.getSubsumptionTestDescription(atomicConcept2, atomicConcept));
                if (!bl) {
                    QuasiOrderClassification.this.prunePossibleSubsumers();
                }
                QuasiOrderClassification.this.readKnownSubsumersFromRootNode(atomicConcept2, (Node)hashMap.get(individual));
                QuasiOrderClassification.this.m_possibleSubsumptions.getSuccessors(atomicConcept2).removeAll(QuasiOrderClassification.this.getAllKnownSubsumers(atomicConcept2));
                return bl;
            }
        };
        return this.buildHierarchy(relation);
    }

    protected Hierarchy<AtomicConcept> buildHierarchy(HierarchySearch.Relation<AtomicConcept> relation) {
        double d = this.m_elements.size();
        this.makeConceptUnsatisfiable(this.m_bottomElement);
        this.initialiseKnownSubsumptionsUsingToldSubsumers();
        double d2 = this.updateSubsumptionsUsingLeafNodeStrategy(d);
        HashSet<AtomicConcept> hashSet = new HashSet<AtomicConcept>();
        for (AtomicConcept atomicConcept : this.m_elements) {
            if (this.isUnsatisfiable(atomicConcept)) continue;
            this.m_possibleSubsumptions.getSuccessors(atomicConcept).removeAll(this.getAllKnownSubsumers(atomicConcept));
            if (this.m_possibleSubsumptions.getSuccessors(atomicConcept).isEmpty()) continue;
            hashSet.add(atomicConcept);
        }
        HashSet hashSet2 = new HashSet();
        while (!hashSet.isEmpty()) {
            AtomicConcept atomicConcept;
            atomicConcept = null;
            for (AtomicConcept atomicConcept2 : hashSet) {
                this.m_possibleSubsumptions.getSuccessors(atomicConcept2).removeAll(this.getAllKnownSubsumers(atomicConcept2));
                if (!this.m_possibleSubsumptions.getSuccessors(atomicConcept2).isEmpty()) {
                    atomicConcept = atomicConcept2;
                    break;
                }
                hashSet2.add(atomicConcept2);
                while ((double)hashSet.size() < d - d2) {
                    this.m_progressMonitor.elementClassified(atomicConcept2);
                    d2 += 1.0;
                }
            }
            hashSet.removeAll(hashSet2);
            if (hashSet.isEmpty()) break;
            Set<AtomicConcept> set = this.m_possibleSubsumptions.getSuccessors(atomicConcept);
            if (!this.isEveryPossibleSubsumerNonSubsumer(set, atomicConcept, 2, 7) && !set.isEmpty()) {
                Hierarchy<AtomicConcept> hierarchy = this.buildHierarchyOfUnknownPossible(set);
                this.checkUnknownSubsumersUsingEnhancedTraversal(relation, hierarchy.getTopNode(), atomicConcept);
            }
            set.clear();
        }
        return this.buildTransitivelyReducedHierarchy(this.m_knownSubsumptions, this.m_elements);
    }

    protected Hierarchy<AtomicConcept> buildHierarchyOfUnknownPossible(Set<AtomicConcept> set) {
        Graph<AtomicConcept> graph = new Graph<AtomicConcept>();
        for (AtomicConcept atomicConcept : set) {
            graph.addEdge(this.m_bottomElement, atomicConcept);
            graph.addEdge(atomicConcept, this.m_topElement);
            Set<AtomicConcept> set2 = this.getAllKnownSubsumers(atomicConcept);
            for (AtomicConcept atomicConcept2 : set) {
                if (!set2.contains(atomicConcept2)) continue;
                graph.addEdge(atomicConcept, atomicConcept2);
            }
        }
        HashSet<AtomicConcept> hashSet = new HashSet<AtomicConcept>(set);
        hashSet.add(this.m_bottomElement);
        hashSet.add(this.m_topElement);
        return this.buildTransitivelyReducedHierarchy(graph, (Set<AtomicConcept>)hashSet);
    }

    protected double updateSubsumptionsUsingLeafNodeStrategy(double d) {
        double d2 = 0.0;
        Hierarchy<AtomicConcept> hierarchy = this.buildTransitivelyReducedHierarchy(this.m_knownSubsumptions, this.m_elements);
        Stack stack = new Stack();
        stack.addAll(hierarchy.getBottomNode().getParentNodes());
        HashSet<HierarchyNode> hashSet = new HashSet<HierarchyNode>();
        while (!stack.empty()) {
            HierarchyNode hierarchyNode = (HierarchyNode)stack.pop();
            AtomicConcept atomicConcept = (AtomicConcept)hierarchyNode.getRepresentative();
            if (d2 < Math.ceil(d * 0.85)) {
                this.m_progressMonitor.elementClassified(atomicConcept);
                d2 += 1.0;
            }
            if (this.conceptHasBeenProcessedAlready(atomicConcept)) continue;
            Node node = this.buildModelForConcept(atomicConcept);
            if (node == null) {
                this.makeConceptUnsatisfiable(atomicConcept);
                hashSet.add(hierarchyNode);
                stack.addAll(hierarchyNode.getParentNodes());
                HashSet<HierarchyNode> hashSet2 = new HashSet<HierarchyNode>();
                LinkedList linkedList = new LinkedList(hierarchyNode.getChildNodes());
                while (!linkedList.isEmpty()) {
                    HierarchyNode hierarchyNode2 = (HierarchyNode)linkedList.poll();
                    if (!hashSet2.add(hierarchyNode2) || hashSet.contains(hierarchyNode2)) continue;
                    linkedList.addAll(hierarchyNode2.getChildNodes());
                    hashSet.add(hierarchyNode2);
                    this.makeConceptUnsatisfiable((AtomicConcept)hierarchyNode2.getRepresentative());
                    stack.remove(hierarchyNode2);
                    for (HierarchyNode hierarchyNode3 : hierarchyNode2.getParentNodes()) {
                        if (this.conceptHasBeenProcessedAlready((AtomicConcept)hierarchyNode3.getRepresentative())) continue;
                        stack.add(hierarchyNode3);
                    }
                }
                continue;
            }
            this.readKnownSubsumersFromRootNode(atomicConcept, node);
            this.updatePossibleSubsumers();
        }
        return d2;
    }

    private boolean conceptHasBeenProcessedAlready(AtomicConcept atomicConcept) {
        return !this.m_possibleSubsumptions.getSuccessors(atomicConcept).isEmpty() || this.isUnsatisfiable(atomicConcept);
    }

    protected Node buildModelForConcept(AtomicConcept atomicConcept) {
        Individual individual = Individual.createAnonymous("fresh-individual");
        HashMap<Individual, Node> hashMap = new HashMap<Individual, Node>();
        hashMap.put(individual, null);
        if (this.m_tableau.isSatisfiable(false, Collections.singleton(Atom.create(atomicConcept, individual)), null, null, null, hashMap, this.getSatTestDescription(atomicConcept))) {
            return (Node)hashMap.get(individual);
        }
        return null;
    }

    protected void makeConceptUnsatisfiable(AtomicConcept atomicConcept) {
        this.addKnownSubsumption(atomicConcept, this.m_bottomElement);
        this.m_possibleSubsumptions.getSuccessors(atomicConcept).clear();
    }

    protected boolean isUnsatisfiable(AtomicConcept atomicConcept) {
        return this.m_knownSubsumptions.getSuccessors(atomicConcept).contains(this.m_bottomElement);
    }

    protected void readKnownSubsumersFromRootNode(AtomicConcept atomicConcept, Node node) {
        if (node.getCanonicalNodeDependencySet().isEmpty()) {
            node = node.getCanonicalNode();
            ExtensionTable.Retrieval retrieval = this.m_tableau.getExtensionManager().getBinaryExtensionTable().createRetrieval(new boolean[]{false, true}, ExtensionTable.View.TOTAL);
            retrieval.getBindingsBuffer()[1] = node;
            retrieval.open();
            while (!retrieval.afterLast()) {
                Object object = retrieval.getTupleBuffer()[0];
                if (object instanceof AtomicConcept && retrieval.getDependencySet().isEmpty() && this.m_elements.contains(object)) {
                    this.addKnownSubsumption(atomicConcept, (AtomicConcept)object);
                }
                retrieval.next();
            }
        }
    }

    protected void updatePossibleSubsumers() {
        ExtensionTable.Retrieval retrieval = this.m_tableau.getExtensionManager().getBinaryExtensionTable().createRetrieval(new boolean[]{false, false}, ExtensionTable.View.TOTAL);
        retrieval.open();
        Object[] objectArray = retrieval.getTupleBuffer();
        while (!retrieval.afterLast()) {
            Object object = objectArray[0];
            if (object instanceof AtomicConcept && this.m_elements.contains(object)) {
                AtomicConcept atomicConcept = (AtomicConcept)object;
                Node node = (Node)objectArray[1];
                if (node.isActive() && !node.isBlocked()) {
                    if (this.m_possibleSubsumptions.getSuccessors(atomicConcept).isEmpty()) {
                        this.readPossibleSubsumersFromNodeLabel(atomicConcept, node);
                    } else {
                        this.prunePossibleSubsumersOfConcept(atomicConcept, node);
                    }
                }
            }
            retrieval.next();
        }
    }

    protected void prunePossibleSubsumers() {
        ExtensionTable.Retrieval retrieval = this.m_tableau.getExtensionManager().getBinaryExtensionTable().createRetrieval(new boolean[]{false, false}, ExtensionTable.View.TOTAL);
        retrieval.open();
        Object[] objectArray = retrieval.getTupleBuffer();
        while (!retrieval.afterLast()) {
            Node node;
            Object object = objectArray[0];
            if (object instanceof AtomicConcept && this.m_elements.contains(object) && (node = (Node)objectArray[1]).isActive() && !node.isBlocked()) {
                this.prunePossibleSubsumersOfConcept((AtomicConcept)object, node);
            }
            retrieval.next();
        }
    }

    protected void prunePossibleSubsumersOfConcept(AtomicConcept atomicConcept, Node node) {
        HashSet<AtomicConcept> hashSet = new HashSet<AtomicConcept>(this.m_possibleSubsumptions.getSuccessors(atomicConcept));
        for (AtomicConcept atomicConcept2 : hashSet) {
            if (this.m_tableau.getExtensionManager().containsConceptAssertion(atomicConcept2, node)) continue;
            this.m_possibleSubsumptions.getSuccessors(atomicConcept).remove(atomicConcept2);
        }
    }

    protected void readPossibleSubsumersFromNodeLabel(AtomicConcept atomicConcept, Node node) {
        ExtensionTable.Retrieval retrieval = this.m_tableau.getExtensionManager().getBinaryExtensionTable().createRetrieval(new boolean[]{false, true}, ExtensionTable.View.TOTAL);
        retrieval.getBindingsBuffer()[1] = node;
        retrieval.open();
        while (!retrieval.afterLast()) {
            Object object = retrieval.getTupleBuffer()[0];
            if (object instanceof AtomicConcept && this.m_elements.contains(object)) {
                this.addPossibleSubsumption(atomicConcept, (AtomicConcept)object);
            }
            retrieval.next();
        }
    }

    protected Hierarchy<AtomicConcept> buildTransitivelyReducedHierarchy(Graph<AtomicConcept> graph, Set<AtomicConcept> set) {
        HashMap<AtomicConcept, DeterministicClassification.GraphNode<AtomicConcept>> hashMap = new HashMap<AtomicConcept, DeterministicClassification.GraphNode<AtomicConcept>>();
        for (AtomicConcept atomicConcept : set) {
            HashSet<AtomicConcept> hashSet = new HashSet<AtomicConcept>(graph.getSuccessors(atomicConcept));
            hashSet.add(this.m_topElement);
            hashSet.add(atomicConcept);
            hashMap.put(atomicConcept, new DeterministicClassification.GraphNode<AtomicConcept>(atomicConcept, hashSet));
        }
        hashMap.put(this.m_bottomElement, new DeterministicClassification.GraphNode<AtomicConcept>(this.m_bottomElement, set));
        return DeterministicClassification.buildHierarchy(this.m_topElement, this.m_bottomElement, hashMap);
    }

    protected void initialiseKnownSubsumptionsUsingToldSubsumers() {
        this.initialiseKnownSubsumptionsUsingToldSubsumers(this.m_tableau.getPermanentDLOntology().getDLClauses());
    }

    protected void initialiseKnownSubsumptionsUsingToldSubsumers(Set<DLClause> set) {
        for (DLClause dLClause : set) {
            if (dLClause.getHeadLength() != 1 || dLClause.getBodyLength() != 1) continue;
            DLPredicate dLPredicate = dLClause.getHeadAtom(0).getDLPredicate();
            DLPredicate dLPredicate2 = dLClause.getBodyAtom(0).getDLPredicate();
            if (!(dLPredicate instanceof AtomicConcept) || !(dLPredicate2 instanceof AtomicConcept)) continue;
            AtomicConcept atomicConcept = (AtomicConcept)dLPredicate;
            AtomicConcept atomicConcept2 = (AtomicConcept)dLPredicate2;
            if (!this.m_elements.contains(atomicConcept) || !this.m_elements.contains(atomicConcept2)) continue;
            this.addKnownSubsumption(atomicConcept2, atomicConcept);
        }
    }

    protected void checkUnknownSubsumersUsingEnhancedTraversal(HierarchySearch.Relation<AtomicConcept> relation, HierarchyNode<AtomicConcept> hierarchyNode, AtomicConcept atomicConcept) {
        Set<HierarchyNode<AtomicConcept>> set = Collections.singleton(hierarchyNode);
        HashSet<HierarchyNode<AtomicConcept>> hashSet = new HashSet<HierarchyNode<AtomicConcept>>(set);
        LinkedList<HierarchyNode<AtomicConcept>> linkedList = new LinkedList<HierarchyNode<AtomicConcept>>(set);
        while (!linkedList.isEmpty()) {
            HierarchyNode hierarchyNode2 = (HierarchyNode)linkedList.remove();
            Set set2 = hierarchyNode2.getChildNodes();
            for (HierarchyNode hierarchyNode3 : set2) {
                AtomicConcept atomicConcept2 = (AtomicConcept)hierarchyNode3.getRepresentative();
                if (hashSet.contains(hierarchyNode3)) continue;
                if (relation.doesSubsume(atomicConcept2, atomicConcept)) {
                    this.addKnownSubsumption(atomicConcept, atomicConcept2);
                    this.addKnownSubsumptions(atomicConcept, hierarchyNode3.getEquivalentElements());
                    if (hashSet.add(hierarchyNode3)) {
                        linkedList.add(hierarchyNode3);
                    }
                }
                hashSet.add(hierarchyNode3);
            }
        }
    }

    protected boolean isEveryPossibleSubsumerNonSubsumer(Set<AtomicConcept> set, AtomicConcept atomicConcept, int n, int n2) {
        if (set.size() > n && set.size() < n2) {
            boolean bl;
            Individual individual = Individual.createAnonymous("fresh-individual");
            Atom atom = Atom.create(atomicConcept, individual);
            HashSet<Atom> hashSet = new HashSet<Atom>();
            Object[] objectArray = new Object[set.size()];
            int n3 = 0;
            for (AtomicConcept atomicConcept2 : set) {
                Atom atom2 = Atom.create(atomicConcept2, individual);
                hashSet.add(atom2);
                objectArray[n3++] = atom2.getDLPredicate();
            }
            HashMap hashMap = new HashMap();
            hashMap.put(individual, null);
            boolean bl2 = bl = !this.m_tableau.isSatisfiable(false, Collections.singleton(atom), null, null, hashSet, hashMap, this.getSubsumedByListTestDescription(atomicConcept, objectArray));
            if (!bl) {
                this.prunePossibleSubsumers();
            } else {
                this.readKnownSubsumersFromRootNode(atomicConcept, (Node)hashMap.get(individual));
                this.m_possibleSubsumptions.getSuccessors(atomicConcept).removeAll(this.getAllKnownSubsumers(atomicConcept));
            }
            return !bl;
        }
        return false;
    }

    protected Set<AtomicConcept> getAllKnownSubsumers(AtomicConcept atomicConcept) {
        return this.m_knownSubsumptions.getReachableSuccessors(atomicConcept);
    }

    protected void addKnownSubsumption(AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
        this.m_knownSubsumptions.addEdge(atomicConcept, atomicConcept2);
    }

    protected void addKnownSubsumptions(AtomicConcept atomicConcept, Set<AtomicConcept> set) {
        this.m_knownSubsumptions.addEdges(atomicConcept, set);
    }

    protected void addPossibleSubsumption(AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
        this.m_possibleSubsumptions.addEdge(atomicConcept, atomicConcept2);
    }

    protected ReasoningTaskDescription getSatTestDescription(AtomicConcept atomicConcept) {
        return ReasoningTaskDescription.isConceptSatisfiable(atomicConcept);
    }

    protected ReasoningTaskDescription getSubsumptionTestDescription(AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
        return ReasoningTaskDescription.isConceptSubsumedBy(atomicConcept, atomicConcept2);
    }

    protected ReasoningTaskDescription getSubsumedByListTestDescription(AtomicConcept atomicConcept, Object[] objectArray) {
        return ReasoningTaskDescription.isConceptSubsumedByList(atomicConcept, objectArray);
    }
}

