/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.Reasoner;
import org.semanticweb.HermiT.graph.Graph;
import org.semanticweb.HermiT.hierarchy.AtomicConceptElement;
import org.semanticweb.HermiT.hierarchy.DeterministicClassification;
import org.semanticweb.HermiT.hierarchy.Hierarchy;
import org.semanticweb.HermiT.hierarchy.HierarchyNode;
import org.semanticweb.HermiT.hierarchy.RoleElementManager;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLOntology;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.Individual;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.model.InverseRole;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.InterruptFlag;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.NodeType;
import org.semanticweb.HermiT.tableau.ReasoningTaskDescription;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceManager {
    public static final int thresholdForAdditionalAxioms = 10000;
    protected final InterruptFlag m_interruptFlag;
    protected final Reasoner m_reasoner;
    protected final Tableau m_tableau;
    protected final Individual[] m_individuals;
    protected final HashSet<AtomicRole> m_complexRoles;
    protected final Map<AtomicConcept, AtomicConceptElement> m_conceptToElement;
    protected final AtomicConcept m_topConcept;
    protected final AtomicConcept m_bottomConcept;
    protected Hierarchy<AtomicConcept> m_currentConceptHierarchy;
    protected final RoleElementManager m_roleElementManager;
    protected final RoleElementManager.RoleElement m_topRoleElement;
    protected final RoleElementManager.RoleElement m_bottomRoleElement;
    protected Hierarchy<RoleElementManager.RoleElement> m_currentRoleHierarchy;
    protected final boolean m_usesInverseRoles;
    protected final Map<Individual, Node> m_nodesForIndividuals;
    protected final Map<Node, Individual> m_individualsForNodes;
    protected final Map<Node, Set<Node>> m_canonicalNodeToDetMergedNodes;
    protected final Map<Node, Set<Node>> m_canonicalNodeToNonDetMergedNodes;
    protected boolean m_isInconsistent;
    protected boolean m_realizationCompleted;
    protected boolean m_roleRealizationCompleted;
    protected boolean m_usesClassifiedConceptHierarchy;
    protected boolean m_usesClassifiedObjectRoleHierarchy;
    protected boolean m_classesInitialised;
    protected boolean m_propertiesInitialised;
    protected boolean m_readingOffFoundPossibleConceptInstance;
    protected boolean m_readingOffFoundPossiblePropertyInstance;
    protected final Map<Individual, Set<Individual>> m_individualToEquivalenceClass;
    protected Map<Set<Individual>, Set<Set<Individual>>> m_individualToPossibleEquivalenceClass;
    protected final ExtensionTable.Retrieval m_binaryRetrieval0Bound;
    protected final ExtensionTable.Retrieval m_binaryRetrieval1Bound;
    protected final ExtensionTable.Retrieval m_binaryRetrieval01Bound;
    protected final ExtensionTable.Retrieval m_ternaryRetrieval1Bound;
    protected final ExtensionTable.Retrieval m_ternaryRetrieval0Bound;
    protected final ExtensionTable.Retrieval m_ternaryRetrieval012Bound;
    protected int m_currentIndividualIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public InstanceManager(InterruptFlag interruptFlag, Reasoner reasoner, Tableau tableau, Hierarchy<AtomicConcept> hierarchy, Hierarchy<Role> hierarchy2) {
        this.m_interruptFlag = interruptFlag;
        this.m_interruptFlag.startTask();
        try {
            void var7_10;
            Set<Object> set;
            this.m_reasoner = reasoner;
            this.m_tableau = tableau;
            DLOntology dLOntology = this.m_reasoner.getDLOntology();
            this.m_individuals = new ArrayList<Individual>(dLOntology.getAllIndividuals()).toArray(new Individual[0]);
            this.m_complexRoles = new HashSet();
            this.m_individualToEquivalenceClass = new HashMap<Individual, Set<Individual>>();
            this.m_nodesForIndividuals = new HashMap<Individual, Node>();
            for (Individual individual : this.m_individuals) {
                this.m_nodesForIndividuals.put(individual, null);
                set = new HashSet<Individual>();
                set.add(individual);
                this.m_individualToEquivalenceClass.put(individual, set);
                this.m_interruptFlag.checkInterrupt();
            }
            this.m_individualsForNodes = new HashMap<Node, Individual>();
            this.m_canonicalNodeToDetMergedNodes = new HashMap<Node, Set<Node>>();
            this.m_canonicalNodeToNonDetMergedNodes = new HashMap<Node, Set<Node>>();
            this.m_individualToPossibleEquivalenceClass = null;
            this.m_topConcept = AtomicConcept.THING;
            this.m_bottomConcept = AtomicConcept.NOTHING;
            this.m_conceptToElement = new HashMap<AtomicConcept, AtomicConceptElement>();
            this.m_conceptToElement.put(this.m_topConcept, new AtomicConceptElement(null, null));
            Object var7_8 = null;
            HashSet<AtomicConcept> hashSet = null;
            if (hierarchy != null) {
                this.setToClassifiedConceptHierarchy(hierarchy);
            } else {
                Graph<AtomicConcept> graph = new Graph<AtomicConcept>();
                hashSet = new HashSet<AtomicConcept>();
                hashSet.add(this.m_topConcept);
                hashSet.add(this.m_bottomConcept);
                for (AtomicConcept atomicConcept : dLOntology.getAllAtomicConcepts()) {
                    if (!Prefixes.isInternalIRI(atomicConcept.getIRI())) {
                        hashSet.add(atomicConcept);
                        this.addKnownConceptSubsumption(graph, atomicConcept, atomicConcept);
                        this.addKnownConceptSubsumption(graph, atomicConcept, this.m_topConcept);
                        this.addKnownConceptSubsumption(graph, this.m_bottomConcept, atomicConcept);
                    }
                    this.m_interruptFlag.checkInterrupt();
                }
                this.addKnownConceptSubsumption(graph, this.m_bottomConcept, this.m_bottomConcept);
            }
            this.m_roleElementManager = new RoleElementManager();
            Graph<Role> graph = null;
            this.m_topRoleElement = this.m_roleElementManager.getRoleElement(AtomicRole.TOP_OBJECT_ROLE);
            this.m_bottomRoleElement = this.m_roleElementManager.getRoleElement(AtomicRole.BOTTOM_OBJECT_ROLE);
            this.m_usesInverseRoles = dLOntology.hasInverseRoles();
            Object var10_19 = null;
            set = dLOntology.getAllComplexObjectRoles();
            if (hierarchy2 != null) {
                this.setToClassifiedRoleHierarchy(hierarchy2);
                for (Role role : set) {
                    if (!(role instanceof AtomicRole) || role == AtomicRole.TOP_OBJECT_ROLE || role == AtomicRole.BOTTOM_OBJECT_ROLE) continue;
                    this.m_complexRoles.add((AtomicRole)role);
                }
            } else {
                graph = new Graph<Role>();
                HashSet<AtomicRole> hashSet2 = new HashSet<AtomicRole>();
                hashSet2.add(AtomicRole.TOP_OBJECT_ROLE);
                hashSet2.add(AtomicRole.BOTTOM_OBJECT_ROLE);
                hashSet2.addAll(dLOntology.getAllAtomicObjectRoles());
                for (Role role : hashSet2) {
                    this.addKnownRoleSubsumption(graph, role, role);
                    this.addKnownRoleSubsumption(graph, role, AtomicRole.TOP_OBJECT_ROLE);
                    this.addKnownRoleSubsumption(graph, AtomicRole.BOTTOM_OBJECT_ROLE, role);
                    if (set.contains(role) && role instanceof AtomicRole && role != AtomicRole.TOP_OBJECT_ROLE && role != AtomicRole.BOTTOM_OBJECT_ROLE) {
                        this.m_complexRoles.add((AtomicRole)role);
                    }
                    this.m_interruptFlag.checkInterrupt();
                }
                this.addKnownRoleSubsumption(graph, AtomicRole.BOTTOM_OBJECT_ROLE, AtomicRole.BOTTOM_OBJECT_ROLE);
            }
            if (hierarchy == null || hierarchy2 == null) {
                void var10_21;
                this.updateKnownSubsumptionsUsingToldSubsumers(dLOntology.getDLClauses(), (Graph<AtomicConcept>)var7_10, hashSet, graph, (Set<Role>)var10_21);
            }
            if (hierarchy == null) {
                this.m_currentConceptHierarchy = this.buildTransitivelyReducedConceptHierarchy((Graph<AtomicConcept>)var7_10);
            }
            if (hierarchy2 == null) {
                this.m_currentRoleHierarchy = this.buildTransitivelyReducedRoleHierarchy(graph);
            }
            Iterator iterator = this.m_tableau.getExtensionManager();
            this.m_binaryRetrieval0Bound = ((ExtensionManager)((Object)iterator)).getBinaryExtensionTable().createRetrieval(new boolean[]{true, false}, ExtensionTable.View.TOTAL);
            this.m_binaryRetrieval1Bound = ((ExtensionManager)((Object)iterator)).getBinaryExtensionTable().createRetrieval(new boolean[]{false, true}, ExtensionTable.View.TOTAL);
            this.m_binaryRetrieval01Bound = ((ExtensionManager)((Object)iterator)).getBinaryExtensionTable().createRetrieval(new boolean[]{true, true}, ExtensionTable.View.TOTAL);
            this.m_ternaryRetrieval1Bound = ((ExtensionManager)((Object)iterator)).getTernaryExtensionTable().createRetrieval(new boolean[]{false, true, false}, ExtensionTable.View.TOTAL);
            this.m_ternaryRetrieval0Bound = ((ExtensionManager)((Object)iterator)).getTernaryExtensionTable().createRetrieval(new boolean[]{true, false, false}, ExtensionTable.View.TOTAL);
            this.m_ternaryRetrieval012Bound = ((ExtensionManager)((Object)iterator)).getTernaryExtensionTable().createRetrieval(new boolean[]{true, true, true}, ExtensionTable.View.TOTAL);
        }
        finally {
            this.m_interruptFlag.endTask();
        }
    }

    protected void addKnownConceptSubsumption(Graph<AtomicConcept> graph, AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
        graph.addEdge(atomicConcept, atomicConcept2);
    }

    protected void addKnownRoleSubsumption(Graph<Role> graph, Role role, Role role2) {
        graph.addEdge(role, role2);
        if (this.m_usesInverseRoles) {
            graph.addEdge(role.getInverse(), role2.getInverse());
        }
    }

    protected void updateKnownSubsumptionsUsingToldSubsumers(Set<DLClause> set, Graph<AtomicConcept> graph, Set<AtomicConcept> set2, Graph<Role> graph2, Set<Role> set3) {
        boolean bl;
        boolean bl2 = graph != null;
        boolean bl3 = bl = graph2 != null;
        if (bl2 || bl) {
            for (DLClause dLClause : set) {
                if (dLClause.getHeadLength() == 1 && dLClause.getBodyLength() == 1) {
                    DLPredicate dLPredicate;
                    DLPredicate dLPredicate2;
                    DLPredicate dLPredicate3 = dLClause.getHeadAtom(0).getDLPredicate();
                    DLPredicate dLPredicate4 = dLClause.getBodyAtom(0).getDLPredicate();
                    if (bl2 && dLPredicate3 instanceof AtomicConcept && dLPredicate4 instanceof AtomicConcept) {
                        dLPredicate2 = (AtomicConcept)dLPredicate3;
                        dLPredicate = (AtomicConcept)dLPredicate4;
                        if (set2.contains(dLPredicate2) && set2.contains(dLPredicate)) {
                            this.addKnownConceptSubsumption(graph, (AtomicConcept)dLPredicate, (AtomicConcept)dLPredicate2);
                        }
                    } else if (bl && dLPredicate3 instanceof AtomicRole && dLPredicate4 instanceof AtomicRole) {
                        dLPredicate2 = (AtomicRole)dLPredicate3;
                        dLPredicate = (AtomicRole)dLPredicate4;
                        if (set3.contains(dLPredicate2) && set3.contains(dLPredicate)) {
                            if (dLClause.getBodyAtom(0).getArgument(0) != dLClause.getHeadAtom(0).getArgument(0)) {
                                this.addKnownRoleSubsumption(graph2, InverseRole.create((AtomicRole)dLPredicate), (Role)((Object)dLPredicate2));
                            } else {
                                this.addKnownRoleSubsumption(graph2, (Role)((Object)dLPredicate), (Role)((Object)dLPredicate2));
                            }
                        }
                    }
                }
                this.m_interruptFlag.checkInterrupt();
            }
        }
    }

    protected Hierarchy<AtomicConcept> buildTransitivelyReducedConceptHierarchy(Graph<AtomicConcept> graph) {
        HashMap<AtomicConcept, DeterministicClassification.GraphNode<AtomicConcept>> hashMap = new HashMap<AtomicConcept, DeterministicClassification.GraphNode<AtomicConcept>>();
        for (AtomicConcept atomicConcept : graph.getElements()) {
            hashMap.put(atomicConcept, new DeterministicClassification.GraphNode<AtomicConcept>(atomicConcept, graph.getSuccessors(atomicConcept)));
        }
        this.m_interruptFlag.checkInterrupt();
        return DeterministicClassification.buildHierarchy(this.m_topConcept, this.m_bottomConcept, hashMap);
    }

    public void setToClassifiedConceptHierarchy(Hierarchy<AtomicConcept> hierarchy) {
        if (hierarchy != this.m_currentConceptHierarchy) {
            this.m_currentConceptHierarchy = hierarchy;
            if (this.m_classesInitialised && this.m_individuals.length > 0) {
                Object object;
                Set set;
                Object object2;
                AtomicConcept atomicConcept;
                for (HierarchyNode<AtomicConcept> hierarchyNode : this.m_currentConceptHierarchy.getAllNodesSet()) {
                    if (hierarchyNode.m_representative == this.m_bottomConcept) continue;
                    atomicConcept = hierarchyNode.getRepresentative();
                    object2 = new HashSet();
                    set = null;
                    for (AtomicConcept atomicConcept2 : hierarchyNode.getEquivalentElements()) {
                        if (!this.m_conceptToElement.containsKey(atomicConcept2)) continue;
                        object = this.m_conceptToElement.get(atomicConcept2);
                        object2.addAll(((AtomicConceptElement)object).m_knownInstances);
                        if (set == null) {
                            set = new HashSet<Individual>(((AtomicConceptElement)object).m_possibleInstances);
                        } else {
                            set.retainAll(((AtomicConceptElement)object).m_possibleInstances);
                        }
                        this.m_conceptToElement.remove(atomicConcept2);
                    }
                    if (set != null) {
                        set.removeAll((Collection<?>)object2);
                    }
                    if (object2.isEmpty() && set == null && atomicConcept != this.m_topConcept) continue;
                    this.m_conceptToElement.put(atomicConcept, new AtomicConceptElement((Set<Individual>)object2, set));
                }
                LinkedList linkedList = new LinkedList();
                linkedList.addAll(this.m_currentConceptHierarchy.m_bottomNode.m_parentNodes);
                while (!linkedList.isEmpty()) {
                    HierarchyNode hierarchyNode = (HierarchyNode)linkedList.remove();
                    atomicConcept = (AtomicConcept)hierarchyNode.getRepresentative();
                    object2 = this.m_conceptToElement.get(atomicConcept);
                    if (object2 != null) {
                        set = hierarchyNode.getAncestorNodes();
                        set.remove(hierarchyNode);
                        for (HierarchyNode hierarchyNode2 : set) {
                            object = (AtomicConcept)hierarchyNode2.getRepresentative();
                            AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(object);
                            if (atomicConceptElement == null) continue;
                            atomicConceptElement.m_knownInstances.removeAll(((AtomicConceptElement)object2).m_knownInstances);
                            atomicConceptElement.m_possibleInstances.removeAll(((AtomicConceptElement)object2).m_knownInstances);
                            atomicConceptElement.m_possibleInstances.removeAll(((AtomicConceptElement)object2).m_possibleInstances);
                        }
                        for (HierarchyNode hierarchyNode3 : hierarchyNode.getParentNodes()) {
                            if (linkedList.contains(hierarchyNode3)) continue;
                            linkedList.add(hierarchyNode3);
                        }
                    }
                    this.m_interruptFlag.checkInterrupt();
                }
            }
            this.m_usesClassifiedConceptHierarchy = true;
        }
    }

    protected Hierarchy<RoleElementManager.RoleElement> buildTransitivelyReducedRoleHierarchy(Graph<Role> graph) {
        HashMap<Role, DeterministicClassification.GraphNode<Role>> hashMap = new HashMap<Role, DeterministicClassification.GraphNode<Role>>();
        for (Role role : graph.getElements()) {
            hashMap.put(role, new DeterministicClassification.GraphNode<Role>(role, graph.getSuccessors(role)));
        }
        this.m_interruptFlag.checkInterrupt();
        return this.transformRoleHierarchy(DeterministicClassification.buildHierarchy(AtomicRole.TOP_OBJECT_ROLE, AtomicRole.BOTTOM_OBJECT_ROLE, hashMap));
    }

    public Hierarchy<RoleElementManager.RoleElement> transformRoleHierarchy(Hierarchy<Role> hierarchy) {
        Hierarchy<Role> hierarchy2 = this.removeInverses(hierarchy);
        Hierarchy.Transformer<Role, RoleElementManager.RoleElement> transformer = new Hierarchy.Transformer<Role, RoleElementManager.RoleElement>(){

            @Override
            public RoleElementManager.RoleElement transform(Role role) {
                InstanceManager.this.m_interruptFlag.checkInterrupt();
                return InstanceManager.this.m_roleElementManager.getRoleElement(role);
            }

            @Override
            public RoleElementManager.RoleElement determineRepresentative(Role role, Set<RoleElementManager.RoleElement> set) {
                RoleElementManager.RoleElement roleElement = this.transform(role);
                for (RoleElementManager.RoleElement roleElement2 : set) {
                    Set<Individual> set2;
                    if (roleElement2.equals(roleElement)) continue;
                    for (Individual individual : roleElement2.m_knownRelations.keySet()) {
                        set2 = roleElement.m_knownRelations.get(individual);
                        if (set2 == null) {
                            set2 = new HashSet<Individual>();
                            roleElement.m_knownRelations.put(individual, set2);
                        }
                        set2.addAll((Collection<Individual>)roleElement2.m_knownRelations.get(individual));
                    }
                    for (Individual individual : roleElement2.m_possibleRelations.keySet()) {
                        set2 = roleElement.m_possibleRelations.get(individual);
                        if (set2 == null) continue;
                        set2.retainAll((Collection)roleElement2.m_possibleRelations.get(individual));
                    }
                    roleElement2.m_knownRelations.clear();
                    roleElement2.m_possibleRelations.clear();
                }
                InstanceManager.this.m_interruptFlag.checkInterrupt();
                return roleElement;
            }
        };
        return hierarchy2.transform(transformer, null);
    }

    protected Hierarchy<Role> removeInverses(Hierarchy<Role> hierarchy) {
        Object object;
        HashMap<Object, DeterministicClassification.GraphNode<Role>> hashMap = new HashMap<Object, DeterministicClassification.GraphNode<Role>>();
        HashSet<Role> hashSet = new HashSet<Role>();
        HashSet<Role> hashSet2 = new HashSet<Role>();
        hashSet.add(this.m_bottomRoleElement.m_role);
        while (!hashSet.isEmpty()) {
            object = (Role)hashSet.iterator().next();
            hashSet2.add((Role)object);
            HierarchyNode<Role> hierarchyNode = hierarchy.getNodeForElement((Role)object);
            Serializable serializable = new HashSet<Role>();
            this.findNextHierarchyNodeWithAtomic((Set<Role>)((Object)serializable), hierarchyNode);
            hashMap.put(object, new DeterministicClassification.GraphNode<Role>((Role)object, (Set<Role>)((Object)serializable)));
            hashSet.addAll((Collection<Role>)((Object)serializable));
            hashSet.removeAll(hashSet2);
            this.m_interruptFlag.checkInterrupt();
        }
        object = DeterministicClassification.buildHierarchy(this.m_topRoleElement.m_role, this.m_bottomRoleElement.m_role, hashMap);
        for (Serializable serializable : ((Hierarchy)object).m_nodesByElements.keySet()) {
            HierarchyNode<HashSet<Role>> hierarchyNode = hierarchy.getNodeForElement((Role)serializable);
            HierarchyNode<HashSet<Role>> hierarchyNode2 = ((Hierarchy)object).getNodeForElement(serializable);
            for (Role role : hierarchyNode.m_equivalentElements) {
                if (!(role instanceof AtomicRole)) continue;
                hierarchyNode2.m_equivalentElements.add(role);
            }
            this.m_interruptFlag.checkInterrupt();
        }
        return object;
    }

    public void setToClassifiedRoleHierarchy(Hierarchy<Role> hierarchy) {
        this.m_currentRoleHierarchy = this.transformRoleHierarchy(hierarchy);
        if (this.m_propertiesInitialised && this.m_individuals.length > 0) {
            LinkedList linkedList = new LinkedList();
            linkedList.add(this.m_currentRoleHierarchy.m_bottomNode);
            while (!linkedList.isEmpty()) {
                HierarchyNode hierarchyNode = (HierarchyNode)linkedList.remove();
                RoleElementManager.RoleElement roleElement = (RoleElementManager.RoleElement)hierarchyNode.getRepresentative();
                Set set = hierarchyNode.getAncestorNodes();
                set.remove(hierarchyNode);
                for (HierarchyNode hierarchyNode2 : set) {
                    Set<Individual> set2;
                    RoleElementManager.RoleElement roleElement2 = (RoleElementManager.RoleElement)hierarchyNode2.m_representative;
                    Map<Individual, Set<Individual>> map = roleElement2.m_knownRelations;
                    Map<Individual, Set<Individual>> map2 = roleElement2.m_possibleRelations;
                    for (Individual individual : roleElement.m_knownRelations.keySet()) {
                        set2 = map.get(individual);
                        if (set2 != null) {
                            set2.removeAll((Collection)roleElement.m_knownRelations.get(individual));
                            if (set2.isEmpty()) {
                                map.remove(individual);
                            }
                        }
                        if ((set2 = map2.get(individual)) == null) continue;
                        set2.removeAll((Collection)roleElement.m_knownRelations.get(individual));
                        if (!set2.isEmpty()) continue;
                        map2.remove(individual);
                    }
                    for (Individual individual : roleElement.m_possibleRelations.keySet()) {
                        set2 = map2.get(individual);
                        if (set2 == null) continue;
                        set2.removeAll((Collection)roleElement.m_possibleRelations.get(individual));
                        if (!set2.isEmpty()) continue;
                        map2.remove(individual);
                    }
                }
                for (HierarchyNode hierarchyNode2 : hierarchyNode.getParentNodes()) {
                    if (linkedList.contains(hierarchyNode2)) continue;
                    linkedList.add(hierarchyNode2);
                }
                this.m_interruptFlag.checkInterrupt();
            }
        }
        this.m_usesClassifiedObjectRoleHierarchy = true;
    }

    protected void findNextHierarchyNodeWithAtomic(Set<Role> set, HierarchyNode<Role> hierarchyNode) {
        for (HierarchyNode<Role> hierarchyNode2 : hierarchyNode.getParentNodes()) {
            HashSet<Role> hashSet = new HashSet<Role>();
            for (Role role : hierarchyNode2.getEquivalentElements()) {
                if (!(role instanceof AtomicRole)) continue;
                hashSet.add(role);
            }
            if (!hashSet.isEmpty()) {
                set.add((Role)hashSet.iterator().next());
                continue;
            }
            if (hierarchyNode2 == hierarchyNode) continue;
            this.findNextHierarchyNodeWithAtomic(set, hierarchyNode2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLAxiom[] getAxiomsForReadingOffCompexProperties(OWLDataFactory oWLDataFactory, ReasonerProgressMonitor reasonerProgressMonitor, int n, int n2) {
        if (this.m_complexRoles.size() > 0) {
            Object object;
            int n3 = 0;
            ArrayList<OWLClassAssertionAxiom> arrayList = new ArrayList<OWLClassAssertionAxiom>();
            this.m_interruptFlag.startTask();
            try {
                while (this.m_currentIndividualIndex < this.m_individuals.length && n3 < 10000) {
                    object = this.m_individuals[this.m_currentIndividualIndex];
                    for (AtomicRole atomicRole : this.m_complexRoles) {
                        ++n;
                        if (reasonerProgressMonitor != null) {
                            reasonerProgressMonitor.reasonerTaskProgressChanged(n, n2);
                        }
                        OWLObjectProperty oWLObjectProperty = oWLDataFactory.getOWLObjectProperty(IRI.create((String)atomicRole.getIRI()));
                        String string = ((Individual)object).getIRI();
                        OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create((String)("internal:individual-concept#" + string)));
                        OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom((OWLClassExpression)oWLClass, (OWLIndividual)oWLDataFactory.getOWLNamedIndividual(IRI.create((String)string)));
                        arrayList.add(oWLClassAssertionAxiom);
                        AtomicConcept atomicConcept = AtomicConcept.create("internal:individual-concept#" + atomicRole.getIRI() + "#" + string);
                        OWLClass oWLClass2 = oWLDataFactory.getOWLClass(IRI.create((String)atomicConcept.getIRI()));
                        oWLClassAssertionAxiom = oWLDataFactory.getOWLSubClassOfAxiom((OWLClassExpression)oWLClass, (OWLClassExpression)oWLDataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)oWLObjectProperty, (OWLClassExpression)oWLClass2));
                        arrayList.add(oWLClassAssertionAxiom);
                        n3 += 2;
                        this.m_interruptFlag.checkInterrupt();
                    }
                    ++this.m_currentIndividualIndex;
                }
            }
            finally {
                this.m_interruptFlag.endTask();
            }
            object = new OWLAxiom[arrayList.size()];
            return arrayList.toArray((T[])object);
        }
        this.m_currentIndividualIndex = this.m_individuals.length - 1;
        return new OWLAxiom[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeKnowAndPossibleClassInstances(Tableau tableau, ReasonerProgressMonitor reasonerProgressMonitor, int n, int n2) {
        if (!this.m_classesInitialised) {
            this.m_interruptFlag.startTask();
            try {
                this.initializeIndividualsForNodes();
                if (!this.m_propertiesInitialised) {
                    this.initializeSameAs();
                }
                n = this.readOffClassInstancesByIndividual(tableau, reasonerProgressMonitor, n, n2);
                if (!this.m_readingOffFoundPossibleConceptInstance && this.m_usesClassifiedConceptHierarchy) {
                    this.m_realizationCompleted = true;
                }
                this.m_classesInitialised = true;
                this.m_individualsForNodes.clear();
                this.m_canonicalNodeToDetMergedNodes.clear();
                this.m_canonicalNodeToNonDetMergedNodes.clear();
            }
            finally {
                this.m_interruptFlag.endTask();
            }
        }
    }

    protected int readOffClassInstancesByIndividual(Tableau tableau, ReasonerProgressMonitor reasonerProgressMonitor, int n, int n2) {
        for (Individual individual : this.m_individuals) {
            Node node = this.m_nodesForIndividuals.get(individual);
            boolean bl = this.readOffTypes(individual, node);
            if (!bl) {
                AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(this.m_topConcept);
                if (atomicConceptElement == null) {
                    atomicConceptElement = new AtomicConceptElement(null, null);
                    this.m_conceptToElement.put(this.m_topConcept, atomicConceptElement);
                }
                atomicConceptElement.m_knownInstances.add(individual);
            }
            ++n;
            if (reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskProgressChanged(n, n2);
            }
            this.m_interruptFlag.checkInterrupt();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initializeKnowAndPossiblePropertyInstances(Tableau tableau, ReasonerProgressMonitor reasonerProgressMonitor, int n, int n2, int n3) {
        if (!this.m_propertiesInitialised) {
            this.m_interruptFlag.startTask();
            try {
                this.initializeIndividualsForNodes();
                if (!this.m_classesInitialised) {
                    this.initializeSameAs();
                }
                n2 = this.readOffPropertyInstancesByIndividual(tableau, this.m_individualsForNodes, reasonerProgressMonitor, n2, n3, n);
                if (this.m_currentIndividualIndex >= this.m_individuals.length - 1) {
                    if (!this.m_readingOffFoundPossiblePropertyInstance) {
                        this.m_roleRealizationCompleted = true;
                    }
                    this.m_propertiesInitialised = true;
                }
                this.m_individualsForNodes.clear();
            }
            finally {
                this.m_interruptFlag.endTask();
            }
        }
        return n2;
    }

    protected int readOffPropertyInstancesByIndividual(Tableau tableau, Map<Node, Individual> map, ReasonerProgressMonitor reasonerProgressMonitor, int n, int n2, int n3) {
        int n4 = n3 == 0 ? this.m_individuals.length : this.m_currentIndividualIndex;
        for (int i = n3; i < n4; ++i) {
            Individual individual = this.m_individuals[i];
            Node node = this.m_nodesForIndividuals.get(individual);
            if (n3 == 0) {
                if (!node.isMerged()) {
                    this.readOffPropertyInstances(node);
                }
                ++n;
                if (reasonerProgressMonitor != null) {
                    reasonerProgressMonitor.reasonerTaskProgressChanged(n, n2);
                }
            }
            if (i < this.m_currentIndividualIndex) {
                n = this.readOffComplexRoleSuccessors(individual, node, reasonerProgressMonitor, n, n2);
            }
            this.m_interruptFlag.checkInterrupt();
        }
        return n;
    }

    protected void initializeIndividualsForNodes() {
        for (Individual individual : this.m_individuals) {
            Node node = this.m_nodesForIndividuals.get(individual);
            this.m_individualsForNodes.put(node, individual);
            if (node.isMerged()) {
                Set<Node> set;
                Node node2 = node.getCanonicalNode();
                if (node.getCanonicalNodeDependencySet() == null) {
                    set = this.m_canonicalNodeToDetMergedNodes.get(node2);
                    if (set == null) {
                        set = new HashSet<Node>();
                        this.m_canonicalNodeToDetMergedNodes.put(node2, set);
                    }
                    set.add(node);
                } else {
                    set = this.m_canonicalNodeToNonDetMergedNodes.get(node2);
                    if (set == null) {
                        set = new HashSet<Node>();
                        this.m_canonicalNodeToNonDetMergedNodes.put(node2, set);
                    }
                    set.add(node);
                }
            }
            this.m_interruptFlag.checkInterrupt();
        }
    }

    protected void initializeSameAs() {
        this.m_individualToPossibleEquivalenceClass = new HashMap<Set<Individual>, Set<Set<Individual>>>();
        for (Node node : this.m_individualsForNodes.keySet()) {
            Node node2 = node.getMergedInto();
            if (node2 != null) {
                Individual individual = this.m_individualsForNodes.get(node);
                Individual individual2 = this.m_individualsForNodes.get(node2);
                Set<Individual> set = this.m_individualToEquivalenceClass.get(individual);
                Set<Individual> set2 = this.m_individualToEquivalenceClass.get(individual2);
                if (node.getMergedIntoDependencySet().isEmpty()) {
                    set.addAll(set2);
                    this.m_individualToEquivalenceClass.put(individual2, set);
                } else {
                    Set<Set<Individual>> set3 = this.m_individualToPossibleEquivalenceClass.get(set);
                    if (set3 == null) {
                        set3 = new HashSet<Set<Individual>>();
                        this.m_individualToPossibleEquivalenceClass.put(set, set3);
                    }
                    set3.add(set2);
                }
            }
            this.m_interruptFlag.checkInterrupt();
        }
    }

    protected boolean readOffTypes(Individual individual, Node node) {
        boolean bl = false;
        this.m_binaryRetrieval1Bound.getBindingsBuffer()[1] = node.getCanonicalNode();
        this.m_binaryRetrieval1Bound.open();
        Object[] objectArray = this.m_binaryRetrieval1Bound.getTupleBuffer();
        while (!this.m_binaryRetrieval1Bound.afterLast()) {
            AtomicConcept atomicConcept;
            Object object = objectArray[0];
            if (object instanceof AtomicConcept && !(atomicConcept = (AtomicConcept)object).equals(this.m_topConcept) && !Prefixes.isInternalIRI(atomicConcept.getIRI())) {
                HierarchyNode<AtomicConcept> hierarchyNode = this.m_currentConceptHierarchy.getNodeForElement(atomicConcept);
                AtomicConcept atomicConcept2 = hierarchyNode.getRepresentative();
                AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(atomicConcept2);
                if (atomicConceptElement == null) {
                    atomicConceptElement = new AtomicConceptElement(null, null);
                    this.m_conceptToElement.put(atomicConcept2, atomicConceptElement);
                }
                bl = true;
                if (this.m_binaryRetrieval1Bound.getDependencySet().isEmpty()) {
                    this.addKnownConceptInstance(hierarchyNode, atomicConceptElement, individual);
                } else {
                    this.addPossibleConceptInstance(hierarchyNode, atomicConceptElement, individual);
                    this.m_readingOffFoundPossibleConceptInstance = true;
                }
            }
            this.m_interruptFlag.checkInterrupt();
            this.m_binaryRetrieval1Bound.next();
        }
        return bl;
    }

    protected void readOffPropertyInstances(Node node) {
        this.m_ternaryRetrieval1Bound.getBindingsBuffer()[1] = node;
        this.m_ternaryRetrieval1Bound.open();
        Object[] objectArray = this.m_ternaryRetrieval1Bound.getTupleBuffer();
        while (!this.m_ternaryRetrieval1Bound.afterLast()) {
            AtomicRole atomicRole;
            Object object = objectArray[0];
            Node node2 = (Node)objectArray[2];
            if (object instanceof AtomicRole && !node2.isMerged() && node2.getNodeType() == NodeType.NAMED_NODE && this.m_individualsForNodes.containsKey(node2) && node2.isActive() && !(atomicRole = (AtomicRole)object).equals(AtomicRole.TOP_OBJECT_ROLE) && this.m_roleElementManager.m_roleToElement.containsKey(atomicRole)) {
                Individual individual;
                Individual individual2;
                Set<Node> set;
                RoleElementManager.RoleElement roleElement = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole)).getRepresentative();
                Set<Node> set2 = this.m_canonicalNodeToDetMergedNodes.get(node);
                if (set2 == null) {
                    set2 = new HashSet<Node>();
                }
                set2.add(node);
                Set<Node> set3 = this.m_canonicalNodeToNonDetMergedNodes.get(node);
                if (set3 == null) {
                    set3 = new HashSet<Node>();
                }
                if ((set = this.m_canonicalNodeToDetMergedNodes.get(node2)) == null) {
                    set = new HashSet<Node>();
                }
                set.add(node2);
                Set<Node> set4 = this.m_canonicalNodeToNonDetMergedNodes.get(node2);
                if (set4 == null) {
                    set4 = new HashSet<Node>();
                }
                for (Node node3 : set2) {
                    individual2 = this.m_individualsForNodes.get(node3);
                    for (Node node4 : set) {
                        individual = this.m_individualsForNodes.get(node4);
                        if (this.m_ternaryRetrieval1Bound.getDependencySet().isEmpty()) {
                            this.addKnownRoleInstance(roleElement, individual2, individual);
                            continue;
                        }
                        this.m_readingOffFoundPossiblePropertyInstance = true;
                        this.addPossibleRoleInstance(roleElement, individual2, individual);
                    }
                    for (Node node4 : set4) {
                        individual = this.m_individualsForNodes.get(node4);
                        this.m_readingOffFoundPossiblePropertyInstance = true;
                        this.addPossibleRoleInstance(roleElement, individual2, individual);
                    }
                }
                for (Node node3 : set3) {
                    individual2 = this.m_individualsForNodes.get(node3);
                    set4.addAll(set);
                    for (Node node4 : set4) {
                        individual = this.m_individualsForNodes.get(node4);
                        this.m_readingOffFoundPossiblePropertyInstance = true;
                        this.addPossibleRoleInstance(roleElement, individual2, individual);
                    }
                }
            }
            this.m_interruptFlag.checkInterrupt();
            this.m_ternaryRetrieval1Bound.next();
        }
    }

    protected int readOffComplexRoleSuccessors(Individual individual, Node node, ReasonerProgressMonitor reasonerProgressMonitor, int n, int n2) {
        String string = individual.getIRI();
        for (AtomicRole atomicRole : this.m_complexRoles) {
            AtomicConcept atomicConcept = AtomicConcept.create("internal:individual-concept#" + atomicRole.getIRI() + "#" + string);
            this.m_binaryRetrieval0Bound.getBindingsBuffer()[0] = atomicConcept;
            this.m_binaryRetrieval0Bound.open();
            Object[] objectArray = this.m_binaryRetrieval0Bound.getTupleBuffer();
            while (!this.m_binaryRetrieval0Bound.afterLast()) {
                Node node2 = (Node)objectArray[1];
                if (node2.isActive() && node2.getNodeType() == NodeType.NAMED_NODE && this.m_individualsForNodes.containsKey(node2)) {
                    Individual individual2;
                    RoleElementManager.RoleElement roleElement = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole)).getRepresentative();
                    Set<Node> set = this.m_canonicalNodeToDetMergedNodes.get(node2);
                    if (set == null) {
                        set = new HashSet<Node>();
                    }
                    set.add(node2);
                    Set<Node> set2 = this.m_canonicalNodeToNonDetMergedNodes.get(node2);
                    if (set2 == null) {
                        set2 = new HashSet<Node>();
                    }
                    for (Node node3 : set) {
                        individual2 = this.m_individualsForNodes.get(node3);
                        if (this.m_binaryRetrieval0Bound.getDependencySet().isEmpty()) {
                            this.addKnownRoleInstance(roleElement, individual, individual2);
                            continue;
                        }
                        this.m_readingOffFoundPossiblePropertyInstance = true;
                        this.addPossibleRoleInstance(roleElement, individual, individual2);
                    }
                    for (Node node3 : set2) {
                        individual2 = this.m_individualsForNodes.get(node3);
                        this.m_readingOffFoundPossiblePropertyInstance = true;
                        this.addPossibleRoleInstance(roleElement, individual, individual2);
                    }
                }
                this.m_interruptFlag.checkInterrupt();
                this.m_binaryRetrieval0Bound.next();
            }
            ++n;
            if (reasonerProgressMonitor == null) continue;
            reasonerProgressMonitor.reasonerTaskProgressChanged(n, n2);
        }
        return n;
    }

    protected void addKnownConceptInstance(HierarchyNode<AtomicConcept> hierarchyNode, AtomicConceptElement atomicConceptElement, Individual individual) {
        AtomicConceptElement atomicConceptElement2;
        Set<HierarchyNode<AtomicConcept>> set = hierarchyNode.getDescendantNodes();
        for (HierarchyNode<AtomicConcept> hierarchyNode2 : set) {
            atomicConceptElement2 = this.m_conceptToElement.get(hierarchyNode2.getRepresentative());
            if (atomicConceptElement2 != null && atomicConceptElement2.m_knownInstances.contains(individual)) {
                return;
            }
            this.m_interruptFlag.checkInterrupt();
        }
        atomicConceptElement.m_knownInstances.add(individual);
        set = hierarchyNode.getAncestorNodes();
        set.remove(hierarchyNode);
        for (HierarchyNode<AtomicConcept> hierarchyNode2 : set) {
            atomicConceptElement2 = this.m_conceptToElement.get(hierarchyNode2.getRepresentative());
            if (atomicConceptElement2 == null) continue;
            atomicConceptElement2.m_knownInstances.remove(individual);
            atomicConceptElement2.m_possibleInstances.remove(individual);
        }
    }

    protected void addPossibleConceptInstance(HierarchyNode<AtomicConcept> hierarchyNode, AtomicConceptElement atomicConceptElement, Individual individual) {
        AtomicConceptElement atomicConceptElement2;
        Set<HierarchyNode<AtomicConcept>> set = hierarchyNode.getDescendantNodes();
        for (HierarchyNode<AtomicConcept> hierarchyNode2 : set) {
            atomicConceptElement2 = this.m_conceptToElement.get(hierarchyNode2.getRepresentative());
            if (atomicConceptElement2 != null && (atomicConceptElement2.m_knownInstances.contains(individual) || atomicConceptElement2.m_possibleInstances.contains(individual))) {
                return;
            }
            this.m_interruptFlag.checkInterrupt();
        }
        atomicConceptElement.m_possibleInstances.add(individual);
        set = hierarchyNode.getAncestorNodes();
        set.remove(hierarchyNode);
        for (HierarchyNode<AtomicConcept> hierarchyNode2 : set) {
            atomicConceptElement2 = this.m_conceptToElement.get(hierarchyNode2.getRepresentative());
            if (atomicConceptElement2 != null) {
                atomicConceptElement2.m_possibleInstances.remove(individual);
                if (atomicConceptElement2.m_possibleInstances.isEmpty() && atomicConceptElement2.m_knownInstances.isEmpty() && hierarchyNode2.getRepresentative() != this.m_topConcept) {
                    this.m_conceptToElement.remove(hierarchyNode2.getRepresentative());
                }
            }
            this.m_interruptFlag.checkInterrupt();
        }
    }

    protected void addKnownRoleInstance(RoleElementManager.RoleElement roleElement, Individual individual, Individual individual2) {
        if (!roleElement.equals(this.m_topRoleElement)) {
            HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(roleElement);
            Set<HierarchyNode<RoleElementManager.RoleElement>> set = hierarchyNode.getDescendantNodes();
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : set) {
                for (RoleElementManager.RoleElement roleElement2 : hierarchyNode2.getEquivalentElements()) {
                    if (!roleElement2.isKnown(individual, individual2)) continue;
                    return;
                }
                this.m_interruptFlag.checkInterrupt();
            }
            roleElement.addKnown(individual, individual2);
            set = hierarchyNode.getAncestorNodes();
            set.remove(hierarchyNode);
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : set) {
                hierarchyNode2.getRepresentative().removeKnown(individual, individual2);
                this.m_interruptFlag.checkInterrupt();
            }
        }
    }

    protected void addPossibleRoleInstance(RoleElementManager.RoleElement roleElement, Individual individual, Individual individual2) {
        if (!roleElement.equals(this.m_topRoleElement)) {
            HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(roleElement);
            Set<HierarchyNode<RoleElementManager.RoleElement>> set = hierarchyNode.getDescendantNodes();
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : set) {
                for (RoleElementManager.RoleElement roleElement2 : hierarchyNode2.getEquivalentElements()) {
                    if (!roleElement2.isPossible(individual, individual2)) continue;
                    return;
                }
                this.m_interruptFlag.checkInterrupt();
            }
            roleElement.addPossible(individual, individual2);
            set = hierarchyNode.getAncestorNodes();
            set.remove(hierarchyNode);
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : set) {
                for (RoleElementManager.RoleElement roleElement2 : hierarchyNode2.getEquivalentElements()) {
                    if (!roleElement2.isPossible(individual, individual2)) continue;
                    roleElement2.removePossible(individual, individual2);
                }
                this.m_interruptFlag.checkInterrupt();
            }
        }
    }

    public void setInconsistent() {
        this.m_isInconsistent = true;
        this.m_realizationCompleted = true;
        this.m_roleRealizationCompleted = true;
        this.m_usesClassifiedConceptHierarchy = true;
        this.m_usesClassifiedObjectRoleHierarchy = true;
        this.m_currentConceptHierarchy = null;
        this.m_currentRoleHierarchy = null;
    }

    public void realize(ReasonerProgressMonitor reasonerProgressMonitor) {
        assert (this.m_usesClassifiedConceptHierarchy);
        if (this.m_readingOffFoundPossibleConceptInstance && !this.m_realizationCompleted) {
            if (reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskStarted("Computing instances for all classes");
            }
            int n = this.m_currentConceptHierarchy.m_nodesByElements.values().size();
            int n2 = 0;
            LinkedList linkedList = new LinkedList();
            HashSet<HierarchyNode> hashSet = new HashSet<HierarchyNode>();
            linkedList.addAll(this.m_currentConceptHierarchy.m_bottomNode.m_parentNodes);
            while (!linkedList.isEmpty()) {
                if (reasonerProgressMonitor != null) {
                    reasonerProgressMonitor.reasonerTaskProgressChanged(n2, n);
                }
                HierarchyNode hierarchyNode = (HierarchyNode)linkedList.remove();
                hashSet.add(hierarchyNode);
                ++n2;
                AtomicConcept atomicConcept = (AtomicConcept)hierarchyNode.getRepresentative();
                AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(atomicConcept);
                if (atomicConceptElement != null) {
                    Set set = hierarchyNode.getParentNodes();
                    for (HierarchyNode hierarchyNode2 : set) {
                        if (hashSet.contains(hierarchyNode2) || linkedList.contains(hierarchyNode2)) continue;
                        linkedList.add(hierarchyNode2);
                    }
                    if (atomicConceptElement.hasPossibles()) {
                        HashSet hashSet2 = new HashSet();
                        for (Individual individual : atomicConceptElement.getPossibleInstances()) {
                            if (this.isInstance(individual, atomicConcept)) {
                                atomicConceptElement.m_knownInstances.add(individual);
                                continue;
                            }
                            hashSet2.add(individual);
                        }
                        atomicConceptElement.m_possibleInstances.clear();
                        for (HierarchyNode hierarchyNode3 : set) {
                            AtomicConcept atomicConcept2 = (AtomicConcept)hierarchyNode3.getRepresentative();
                            AtomicConceptElement atomicConceptElement2 = this.m_conceptToElement.get(atomicConcept2);
                            if (atomicConceptElement2 == null) {
                                atomicConceptElement2 = new AtomicConceptElement(null, hashSet2);
                                this.m_conceptToElement.put(atomicConcept2, atomicConceptElement2);
                                continue;
                            }
                            if (atomicConcept2.equals(this.m_topConcept)) {
                                this.m_conceptToElement.get((Object)this.m_topConcept).m_knownInstances.addAll(hashSet2);
                                continue;
                            }
                            atomicConceptElement2.addPossibles(hashSet2);
                        }
                    }
                }
                this.m_interruptFlag.checkInterrupt();
            }
            if (reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskStopped();
            }
        }
        this.m_realizationCompleted = true;
    }

    public void realizeObjectRoles(ReasonerProgressMonitor reasonerProgressMonitor) {
        if (this.m_readingOffFoundPossiblePropertyInstance && !this.m_roleRealizationCompleted) {
            if (reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskStarted("Computing instances for all object properties...");
            }
            int n = this.m_currentRoleHierarchy.m_nodesByElements.values().size();
            int n2 = 0;
            LinkedList linkedList = new LinkedList();
            HashSet<HierarchyNode> hashSet = new HashSet<HierarchyNode>();
            linkedList.add(this.m_currentRoleHierarchy.m_bottomNode);
            while (!linkedList.isEmpty()) {
                if (reasonerProgressMonitor != null) {
                    reasonerProgressMonitor.reasonerTaskProgressChanged(n2, n);
                }
                HierarchyNode hierarchyNode = (HierarchyNode)linkedList.remove();
                hashSet.add(hierarchyNode);
                ++n2;
                RoleElementManager.RoleElement roleElement = (RoleElementManager.RoleElement)hierarchyNode.getRepresentative();
                Role role = roleElement.getRole();
                Set set = hierarchyNode.getParentNodes();
                for (HierarchyNode hierarchyNode2 : set) {
                    if (linkedList.contains(hierarchyNode2) || hashSet.contains(hierarchyNode2)) continue;
                    linkedList.add(hierarchyNode2);
                }
                if (roleElement.hasPossibles()) {
                    for (Individual individual : roleElement.m_possibleRelations.keySet()) {
                        HashSet<Individual> hashSet2 = new HashSet<Individual>();
                        for (Individual individual2 : roleElement.m_possibleRelations.get(individual)) {
                            if (this.isRoleInstance(role, individual, individual2)) {
                                roleElement.addKnown(individual, individual2);
                                continue;
                            }
                            hashSet2.add(individual);
                        }
                        for (HierarchyNode hierarchyNode3 : set) {
                            RoleElementManager.RoleElement roleElement2 = (RoleElementManager.RoleElement)hierarchyNode3.getRepresentative();
                            if (roleElement2.equals(this.m_topRoleElement)) continue;
                            roleElement2.addPossibles(individual, hashSet2);
                        }
                    }
                    roleElement.m_possibleRelations.clear();
                }
                this.m_interruptFlag.checkInterrupt();
            }
            if (reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskStopped();
            }
        }
        this.m_roleRealizationCompleted = true;
    }

    public Set<HierarchyNode<AtomicConcept>> getTypes(Individual individual, boolean bl) {
        if (this.m_isInconsistent) {
            return Collections.singleton(this.m_currentConceptHierarchy.m_bottomNode);
        }
        HashSet<HierarchyNode<AtomicConcept>> hashSet = new HashSet<HierarchyNode<AtomicConcept>>();
        assert (!bl || this.m_usesClassifiedConceptHierarchy);
        LinkedList linkedList = new LinkedList();
        linkedList.add(this.m_currentConceptHierarchy.m_bottomNode);
        while (!linkedList.isEmpty()) {
            HierarchyNode hierarchyNode = (HierarchyNode)linkedList.remove();
            Set set = hierarchyNode.getParentNodes();
            AtomicConcept atomicConcept = (AtomicConcept)hierarchyNode.getRepresentative();
            AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(atomicConcept);
            if (atomicConceptElement != null && atomicConceptElement.isPossible(individual)) {
                if (this.isInstance(individual, atomicConcept)) {
                    atomicConceptElement.setToKnown(individual);
                } else {
                    for (HierarchyNode hierarchyNode2 : set) {
                        AtomicConcept atomicConcept2 = (AtomicConcept)hierarchyNode2.getRepresentative();
                        AtomicConceptElement atomicConceptElement2 = this.m_conceptToElement.get(atomicConcept2);
                        if (atomicConceptElement2 == null) {
                            atomicConceptElement2 = new AtomicConceptElement(null, null);
                            this.m_conceptToElement.put(atomicConcept2, atomicConceptElement2);
                        }
                        atomicConceptElement2.addPossible(individual);
                    }
                }
            }
            if (atomicConceptElement != null && atomicConceptElement.isKnown(individual)) {
                if (bl) {
                    hashSet.add(hierarchyNode);
                    continue;
                }
                hashSet.addAll(hierarchyNode.getAncestorNodes());
                continue;
            }
            for (HierarchyNode hierarchyNode2 : set) {
                if (linkedList.contains(hierarchyNode2)) continue;
                linkedList.add(hierarchyNode2);
            }
        }
        return hashSet;
    }

    public boolean hasType(Individual individual, AtomicConcept atomicConcept, boolean bl) {
        HierarchyNode<AtomicConcept> hierarchyNode = this.m_currentConceptHierarchy.getNodeForElement(atomicConcept);
        if (hierarchyNode == null) {
            return false;
        }
        return this.hasType(individual, hierarchyNode, bl);
    }

    public boolean hasType(Individual individual, HierarchyNode<AtomicConcept> hierarchyNode, boolean bl) {
        block9: {
            block8: {
                assert (!bl || this.m_usesClassifiedConceptHierarchy);
                AtomicConcept atomicConcept = hierarchyNode.getRepresentative();
                if (atomicConcept == this.m_bottomConcept) {
                    return false;
                }
                AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(atomicConcept);
                if (atomicConceptElement != null && atomicConceptElement.isKnown(individual) || !bl && hierarchyNode == this.m_currentConceptHierarchy.m_topNode) {
                    return true;
                }
                if (atomicConceptElement == null || !atomicConceptElement.isPossible(individual)) break block8;
                if (this.isInstance(individual, atomicConcept)) {
                    atomicConceptElement.setToKnown(individual);
                    return true;
                }
                atomicConceptElement.m_possibleInstances.remove(individual);
                if (atomicConceptElement.m_knownInstances.isEmpty() && atomicConceptElement.m_possibleInstances.isEmpty() && atomicConcept != this.m_topConcept) {
                    this.m_conceptToElement.remove(atomicConcept);
                }
                for (HierarchyNode<AtomicConcept> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                    AtomicConcept atomicConcept2 = hierarchyNode2.getRepresentative();
                    AtomicConceptElement atomicConceptElement2 = this.m_conceptToElement.get(atomicConcept2);
                    if (atomicConceptElement2 == null) {
                        atomicConceptElement2 = new AtomicConceptElement(null, null);
                        this.m_conceptToElement.put(atomicConcept2, atomicConceptElement2);
                    }
                    atomicConceptElement2.addPossible(individual);
                }
                break block9;
            }
            if (bl) break block9;
            for (HierarchyNode<AtomicConcept> hierarchyNode3 : hierarchyNode.getChildNodes()) {
                if (!this.hasType(individual, hierarchyNode3, false)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<Individual> getInstances(AtomicConcept atomicConcept, boolean bl) {
        HashSet<Individual> hashSet = new HashSet<Individual>();
        HierarchyNode<AtomicConcept> hierarchyNode = this.m_currentConceptHierarchy.getNodeForElement(atomicConcept);
        if (hierarchyNode == null) {
            return hashSet;
        }
        this.getInstancesForNode(hierarchyNode, hashSet, bl);
        return hashSet;
    }

    public Set<Individual> getInstances(HierarchyNode<AtomicConcept> hierarchyNode, boolean bl) {
        HashSet<Individual> hashSet = new HashSet<Individual>();
        HierarchyNode<AtomicConcept> hierarchyNode2 = this.m_currentConceptHierarchy.getNodeForElement((AtomicConcept)hierarchyNode.m_representative);
        if (hierarchyNode2 == null) {
            if (!bl) {
                for (HierarchyNode<AtomicConcept> hierarchyNode3 : hierarchyNode.getChildNodes()) {
                    this.getInstancesForNode(hierarchyNode3, hashSet, bl);
                }
            }
        } else {
            this.getInstancesForNode(hierarchyNode2, hashSet, bl);
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    protected void getInstancesForNode(HierarchyNode<AtomicConcept> hierarchyNode, Set<Individual> set, boolean bl) {
        assert (!bl || this.m_usesClassifiedConceptHierarchy);
        AtomicConcept atomicConcept = hierarchyNode.getRepresentative();
        if (!bl && atomicConcept.equals(this.m_topConcept)) {
            void object;
            Individual[] individualArray = this.m_individuals;
            int n = individualArray.length;
            boolean bl2 = false;
            while (object < n) {
                Individual individual = individualArray[object];
                if (InstanceManager.isResultRelevantIndividual(individual)) {
                    set.add(individual);
                }
                ++object;
            }
            return;
        }
        AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(atomicConcept);
        if (atomicConceptElement != null) {
            Set<Individual> set2 = atomicConceptElement.getPossibleInstances();
            if (!set2.isEmpty()) {
                for (Individual individual : new HashSet(set2)) {
                    if (this.isInstance(individual, atomicConcept)) {
                        atomicConceptElement.setToKnown(individual);
                        continue;
                    }
                    atomicConceptElement.m_possibleInstances.remove(individual);
                    if (atomicConceptElement.m_knownInstances.isEmpty() && atomicConceptElement.m_possibleInstances.isEmpty() && atomicConcept != this.m_topConcept) {
                        this.m_conceptToElement.remove(atomicConcept);
                    }
                    for (HierarchyNode<AtomicConcept> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                        HierarchyNode<AtomicConcept> hierarchyNode3 = (AtomicConcept)hierarchyNode2.getRepresentative();
                        AtomicConceptElement atomicConceptElement2 = this.m_conceptToElement.get(hierarchyNode3);
                        if (atomicConceptElement2 == null) {
                            atomicConceptElement2 = new AtomicConceptElement(null, null);
                            this.m_conceptToElement.put((AtomicConcept)((Object)hierarchyNode3), atomicConceptElement2);
                        }
                        atomicConceptElement2.addPossible(individual);
                    }
                }
            }
            for (Individual individual : atomicConceptElement.getKnownInstances()) {
                if (!InstanceManager.isResultRelevantIndividual(individual)) continue;
                boolean bl3 = true;
                if (bl) {
                    for (HierarchyNode<AtomicConcept> hierarchyNode3 : hierarchyNode.getChildNodes()) {
                        if (!this.hasType(individual, hierarchyNode3, false)) continue;
                        bl3 = false;
                        break;
                    }
                }
                if (bl && !bl3) continue;
                set.add(individual);
            }
        }
        if (!bl) {
            for (HierarchyNode hierarchyNode4 : hierarchyNode.getChildNodes()) {
                if (hierarchyNode4 == this.m_currentConceptHierarchy.m_bottomNode) continue;
                this.getInstancesForNode(hierarchyNode4, set, false);
            }
        }
    }

    public boolean hasObjectRoleRelationship(AtomicRole atomicRole, Individual individual, Individual individual2) {
        RoleElementManager.RoleElement roleElement = this.m_roleElementManager.getRoleElement(atomicRole);
        HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(roleElement);
        if (hierarchyNode == null) {
            return false;
        }
        return this.hasObjectRoleRelationship(hierarchyNode, individual, individual2);
    }

    public boolean hasObjectRoleRelationship(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, Individual individual, Individual individual2) {
        boolean bl;
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.isKnown(individual, individual2) || roleElement.equals(this.m_topRoleElement)) {
            return true;
        }
        List<Individual> list = Arrays.asList(this.m_individuals);
        boolean bl2 = bl = !list.contains(individual) || !list.contains(individual2);
        if (roleElement.isPossible(individual, individual2) || bl) {
            if (this.isRoleInstance(roleElement.getRole(), individual, individual2)) {
                if (!bl) {
                    roleElement.setToKnown(individual, individual2);
                }
                return true;
            }
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                hierarchyNode2.getRepresentative().addPossible(individual, individual2);
            }
        } else {
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode3 : hierarchyNode.getChildNodes()) {
                if (!this.hasObjectRoleRelationship(hierarchyNode3, individual, individual2)) continue;
                return true;
            }
        }
        return false;
    }

    public Map<Individual, Set<Individual>> getObjectPropertyInstances(AtomicRole atomicRole) {
        HashMap<Individual, Set<Individual>> hashMap = new HashMap<Individual, Set<Individual>>();
        HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole));
        if (hierarchyNode == null) {
            return hashMap;
        }
        this.getObjectPropertyInstances(hierarchyNode, hashMap);
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    protected void getObjectPropertyInstances(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, Map<Individual, Set<Individual>> map) {
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.equals(this.m_topRoleElement) || this.m_isInconsistent) {
            void var7_13;
            HashSet<Individual> hashSet = new HashSet<Individual>();
            Individual[] individualArray = this.m_individuals;
            int n = individualArray.length;
            boolean bl = false;
            while (var7_13 < n) {
                Individual individual = individualArray[var7_13];
                if (InstanceManager.isResultRelevantIndividual(individual)) {
                    hashSet.add(individual);
                    map.put(individual, hashSet);
                }
                ++var7_13;
            }
            return;
        }
        Map<Individual, Set<Individual>> map2 = roleElement.getPossibleRelations();
        for (Individual iterator : new HashSet<Individual>(map2.keySet())) {
            for (HashSet<Individual> hashSet : new HashSet(map2.get(iterator))) {
                if (this.isRoleInstance(roleElement.getRole(), iterator, (Individual)((Object)hashSet))) {
                    roleElement.setToKnown(iterator, (Individual)((Object)hashSet));
                    continue;
                }
                for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                    hierarchyNode2.getRepresentative().addPossible(iterator, (Individual)((Object)hashSet));
                }
            }
        }
        Map<Individual, Set<Individual>> map3 = roleElement.getKnownRelations();
        for (Individual individual : map3.keySet()) {
            HashSet<Individual> hashSet;
            if (!InstanceManager.isResultRelevantIndividual(individual)) continue;
            hashSet = map.get(individual);
            boolean bl = false;
            if (hashSet == null) {
                hashSet = new HashSet<Individual>();
                bl = true;
            }
            for (Individual individual2 : (Set)map3.get(individual)) {
                if (!InstanceManager.isResultRelevantIndividual(individual2)) continue;
                hashSet.add(individual2);
            }
            if (!bl || hashSet.isEmpty()) continue;
            map.put(individual, hashSet);
        }
        for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode3 : hierarchyNode.getChildNodes()) {
            this.getObjectPropertyInstances(hierarchyNode3, map);
        }
    }

    public Set<Individual> getObjectPropertyValues(Role role, Individual individual) {
        HashSet<Individual> hashSet = new HashSet<Individual>();
        if (role instanceof AtomicRole) {
            HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(role));
            this.getObjectPropertyValues(hierarchyNode, individual, hashSet);
        } else {
            HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(((InverseRole)role).getInverseOf()));
            this.getObjectPropertySubjects(hierarchyNode, individual, hashSet);
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    protected void getObjectPropertySubjects(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, Individual individual, Set<Individual> set) {
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.equals(this.m_topRoleElement) || this.m_isInconsistent) {
            void object;
            Individual[] individualArray = this.m_individuals;
            int n = individualArray.length;
            boolean bl = false;
            while (object < n) {
                Individual individual2 = individualArray[object];
                if (InstanceManager.isResultRelevantIndividual(individual2)) {
                    set.add(individual2);
                }
                ++object;
            }
            return;
        }
        Map<Individual, Set<Individual>> map = roleElement.getKnownRelations();
        for (Individual individual3 : new HashSet<Individual>(map.keySet())) {
            if (!InstanceManager.isResultRelevantIndividual(individual3) || !map.get(individual3).contains(individual)) continue;
            set.add(individual3);
        }
        map = roleElement.getPossibleRelations();
        for (Individual individual4 : new HashSet<Individual>(map.keySet())) {
            if (InstanceManager.isResultRelevantIndividual(individual4) && map.get(individual4).contains(individual) && this.isRoleInstance(roleElement.getRole(), individual4, individual)) {
                roleElement.setToKnown(individual4, individual);
                set.add(individual4);
                continue;
            }
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                hierarchyNode2.getRepresentative().addPossible(individual4, individual);
            }
        }
        for (HierarchyNode hierarchyNode3 : hierarchyNode.getChildNodes()) {
            this.getObjectPropertySubjects(hierarchyNode3, individual, set);
        }
    }

    protected void getObjectPropertyValues(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, Individual individual, Set<Individual> set) {
        Object object;
        Object object2;
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.equals(this.m_topRoleElement) || this.m_isInconsistent) {
            for (Individual individual2 : this.m_individuals) {
                if (!InstanceManager.isResultRelevantIndividual(individual2)) continue;
                set.add(individual2);
            }
            return;
        }
        Set<Individual> set2 = roleElement.getPossibleRelations().get(individual);
        if (set2 != null) {
            object2 = new HashSet<Individual>(set2).iterator();
            while (object2.hasNext()) {
                object = (Individual)object2.next();
                if (this.isRoleInstance(roleElement.getRole(), individual, (Individual)object)) {
                    roleElement.setToKnown(individual, (Individual)object);
                    continue;
                }
                for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                    hierarchyNode2.getRepresentative().addPossible(individual, (Individual)object);
                }
            }
        }
        if ((object2 = roleElement.getKnownRelations().get(individual)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                Individual individual2 = (Individual)object.next();
                if (!InstanceManager.isResultRelevantIndividual(individual2)) continue;
                set.add(individual2);
            }
        }
        for (HierarchyNode hierarchyNode3 : hierarchyNode.getChildNodes()) {
            this.getObjectPropertyValues(hierarchyNode3, individual, set);
        }
    }

    public Set<Individual> getSameAsIndividuals(Individual individual) {
        Set<Individual> set = this.m_individualToEquivalenceClass.get(individual);
        Set<Set<Individual>> set2 = this.m_individualToPossibleEquivalenceClass.get(set);
        if (set2 != null) {
            while (!set2.isEmpty()) {
                Object object;
                Set<Individual> set3 = set2.iterator().next();
                set2.remove(set3);
                if (set2.isEmpty()) {
                    this.m_individualToPossibleEquivalenceClass.remove(set);
                }
                Individual object2 = (Individual)set3.iterator().next();
                if (this.isSameIndividual(set.iterator().next(), object2)) {
                    set.addAll((Collection<Individual>)set3);
                    set.addAll((Collection<Individual>)this.m_individualToEquivalenceClass.get(object2));
                    object = set3.iterator();
                    while (object.hasNext()) {
                        Individual individual2 = (Individual)object.next();
                        this.m_individualToEquivalenceClass.put(individual2, set);
                    }
                    continue;
                }
                object = this.m_individualToPossibleEquivalenceClass.get(set3);
                if (object == null || !object.contains(set)) continue;
                object.remove(set);
                if (!object.isEmpty()) continue;
                this.m_individualToPossibleEquivalenceClass.remove(set3);
            }
        }
        for (Set set3 : new HashSet<Set<Individual>>(this.m_individualToPossibleEquivalenceClass.keySet())) {
            if (set3 == set || !this.m_individualToPossibleEquivalenceClass.get(set3).contains(set) || !this.isSameIndividual(set.iterator().next(), (Individual)set3.iterator().next())) continue;
            this.m_individualToPossibleEquivalenceClass.get(set3).remove(set);
            if (this.m_individualToPossibleEquivalenceClass.get(set3).isEmpty()) {
                this.m_individualToPossibleEquivalenceClass.remove(set3);
            }
            for (Individual individual2 : set3) {
                this.m_individualToEquivalenceClass.put(individual2, set);
            }
            set.addAll(set3);
        }
        return set;
    }

    public boolean isSameIndividual(Individual individual, Individual individual2) {
        this.m_tableau.clearAdditionalDLOntology();
        return !this.m_tableau.isSatisfiable(true, false, Collections.singleton(Atom.create(Inequality.INSTANCE, individual, individual2)), null, null, null, null, new ReasoningTaskDescription(true, "is {0} same as {1}", individual, individual2));
    }

    public void computeSameAsEquivalenceClasses(ReasonerProgressMonitor reasonerProgressMonitor) {
        if (!this.m_individualToPossibleEquivalenceClass.isEmpty()) {
            int n = this.m_individualToPossibleEquivalenceClass.keySet().size();
            if (n > 0 && reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskStarted("Precompute same individuals");
            }
            while (!this.m_individualToPossibleEquivalenceClass.isEmpty()) {
                Set<Individual> set = this.m_individualToPossibleEquivalenceClass.keySet().iterator().next();
                this.getSameAsIndividuals(set.iterator().next());
                if (reasonerProgressMonitor == null) continue;
                reasonerProgressMonitor.reasonerTaskProgressChanged(n - this.m_individualToPossibleEquivalenceClass.keySet().size(), n);
            }
            if (reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskStopped();
            }
        }
    }

    protected boolean isInstance(Individual individual, AtomicConcept atomicConcept) {
        this.m_tableau.clearAdditionalDLOntology();
        return !this.m_tableau.isSatisfiable(true, false, null, Collections.singleton(Atom.create(atomicConcept, individual)), null, null, null, ReasoningTaskDescription.isInstanceOf(atomicConcept, individual));
    }

    protected boolean isRoleInstance(Role role, Individual individual, Individual individual2) {
        AtomicRole atomicRole;
        Individual individual3;
        OWLDataFactory oWLDataFactory = this.m_reasoner.getDataFactory();
        if (role instanceof InverseRole) {
            individual3 = individual;
            individual = individual2;
            individual2 = individual3;
            atomicRole = ((InverseRole)role).getInverseOf();
        } else {
            atomicRole = (AtomicRole)role;
        }
        individual3 = oWLDataFactory.getOWLObjectProperty(IRI.create((String)atomicRole.getIRI()));
        OWLNamedIndividual oWLNamedIndividual = oWLDataFactory.getOWLNamedIndividual(IRI.create((String)individual.getIRI()));
        OWLNamedIndividual oWLNamedIndividual2 = oWLDataFactory.getOWLNamedIndividual(IRI.create((String)individual2.getIRI()));
        OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create((String)"internal:pseudo-nominal"));
        OWLObjectAllValuesFrom oWLObjectAllValuesFrom = oWLDataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)individual3, oWLClass.getObjectComplementOf());
        OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom((OWLClassExpression)oWLObjectAllValuesFrom, (OWLIndividual)oWLNamedIndividual);
        OWLClassAssertionAxiom oWLClassAssertionAxiom2 = oWLDataFactory.getOWLClassAssertionAxiom((OWLClassExpression)oWLClass, (OWLIndividual)oWLNamedIndividual2);
        Tableau tableau = this.m_reasoner.getTableau(new OWLAxiom[]{oWLClassAssertionAxiom, oWLClassAssertionAxiom2});
        return !tableau.isSatisfiable(true, true, null, null, null, null, null, new ReasoningTaskDescription(true, "is {0} connected to {1} via {2}", individual, individual2, atomicRole));
    }

    protected static boolean isResultRelevantIndividual(Individual individual) {
        return !individual.isAnonymous() && !Prefixes.isInternalIRI(individual.getIRI());
    }

    public boolean realizationCompleted() {
        return this.m_realizationCompleted;
    }

    public boolean objectPropertyRealizationCompleted() {
        return this.m_roleRealizationCompleted;
    }

    public boolean sameAsIndividualsComputed() {
        return this.m_individualToPossibleEquivalenceClass.isEmpty();
    }

    public boolean areClassesInitialised() {
        return this.m_classesInitialised;
    }

    public boolean arePropertiesInitialised() {
        return this.m_propertiesInitialised;
    }

    public int getCurrentIndividualIndex() {
        return this.m_currentIndividualIndex;
    }

    public Map<Individual, Node> getNodesForIndividuals() {
        return this.m_nodesForIndividuals;
    }

    public HierarchyNode<AtomicConcept> getTopConceptNode() {
        return this.m_currentConceptHierarchy.getTopNode();
    }

    public HierarchyNode<AtomicConcept> getBottomConceptNode() {
        return this.m_currentConceptHierarchy.getBottomNode();
    }

    public RoleElementManager.RoleElement getTopRoleElement() {
        return this.m_topRoleElement;
    }

    public RoleElementManager.RoleElement getBottomRoleElement() {
        return this.m_bottomRoleElement;
    }

    public HierarchyNode<RoleElementManager.RoleElement> getTopRoleNode() {
        return this.m_currentRoleHierarchy.getTopNode();
    }

    public HierarchyNode<RoleElementManager.RoleElement> getBottomRoleNode() {
        return this.m_currentRoleHierarchy.getBottomNode();
    }

    public int[] getNumberOfInstances(AtomicConcept atomicConcept) {
        int[] nArray = new int[2];
        HierarchyNode<AtomicConcept> hierarchyNode = this.m_currentConceptHierarchy.getNodeForElement(atomicConcept);
        if (hierarchyNode == null) {
            return nArray;
        }
        AtomicConcept atomicConcept2 = hierarchyNode.getRepresentative();
        if (atomicConcept2.equals(this.m_bottomConcept)) {
            return nArray;
        }
        if (atomicConcept2.equals(this.m_topConcept)) {
            nArray[0] = this.m_individuals.length;
            return nArray;
        }
        return this.getNumberOfInstances(hierarchyNode, nArray);
    }

    protected int[] getNumberOfInstances(HierarchyNode<AtomicConcept> hierarchyNode, int[] nArray) {
        AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(hierarchyNode.getRepresentative());
        if (atomicConceptElement != null) {
            nArray[0] = nArray[0] + atomicConceptElement.getKnownInstances().size();
            nArray[1] = nArray[1] + atomicConceptElement.getPossibleInstances().size();
        }
        for (HierarchyNode<AtomicConcept> hierarchyNode2 : hierarchyNode.getChildNodes()) {
            if (hierarchyNode2 == this.m_currentConceptHierarchy.m_bottomNode) continue;
            this.getNumberOfInstances(hierarchyNode2, nArray);
        }
        return nArray;
    }

    public int[] getNumberOfInstances(AtomicRole atomicRole) {
        int[] nArray = new int[2];
        HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole));
        if (hierarchyNode == null) {
            return nArray;
        }
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.equals(this.m_topRoleElement)) {
            int n = this.m_individuals.length;
            nArray[0] = n * n;
            return nArray;
        }
        if (roleElement.equals(this.m_bottomRoleElement)) {
            return nArray;
        }
        return this.getNumberOfRoleInstances(hierarchyNode, nArray);
    }

    protected int[] getNumberOfRoleInstances(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, int[] nArray) {
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        Map<Individual, Set<Individual>> map = roleElement.getKnownRelations();
        for (Individual object : map.keySet()) {
            nArray[0] = nArray[0] + map.get(object).size();
        }
        map = roleElement.getPossibleRelations();
        for (Individual individual : map.keySet()) {
            nArray[1] = nArray[1] + map.get(individual).size();
        }
        for (HierarchyNode hierarchyNode2 : hierarchyNode.getChildNodes()) {
            if (hierarchyNode2 == this.m_currentRoleHierarchy.m_bottomNode) continue;
            this.getNumberOfRoleInstances(hierarchyNode2, nArray);
        }
        return nArray;
    }

    public int[] getNumberOfSuccessors(AtomicRole atomicRole, Individual individual) {
        int[] nArray = new int[2];
        HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole));
        if (hierarchyNode == null) {
            return nArray;
        }
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.equals(this.m_topRoleElement)) {
            nArray[0] = this.m_individuals.length;
            return nArray;
        }
        if (roleElement.equals(this.m_bottomRoleElement)) {
            return nArray;
        }
        return this.getNumberOfRoleSuccessors(hierarchyNode, individual, nArray);
    }

    protected int[] getNumberOfRoleSuccessors(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, Individual individual, int[] nArray) {
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        Map<Individual, Set<Individual>> map = roleElement.getKnownRelations();
        if (map != null && map.containsKey(individual)) {
            nArray[0] = nArray[0] + map.get(individual).size();
        }
        if ((map = roleElement.getPossibleRelations()) != null && map.containsKey(individual)) {
            nArray[1] = nArray[1] + map.get(individual).size();
        }
        for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : hierarchyNode.getChildNodes()) {
            if (hierarchyNode2 == this.m_currentRoleHierarchy.m_bottomNode) continue;
            this.getNumberOfRoleSuccessors(hierarchyNode2, individual, nArray);
        }
        return nArray;
    }

    public boolean[] hasSuccessor(AtomicRole atomicRole, Individual individual, Individual individual2) {
        boolean[] blArray = new boolean[2];
        HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole));
        if (hierarchyNode == null) {
            return blArray;
        }
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.equals(this.m_topRoleElement)) {
            return new boolean[]{true, false};
        }
        if (roleElement.equals(this.m_bottomRoleElement)) {
            return blArray;
        }
        return this.hasRoleSuccessor(hierarchyNode, individual, individual2);
    }

    protected boolean[] hasRoleSuccessor(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, Individual individual, Individual individual2) {
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        Map<Individual, Set<Individual>> map = roleElement.getKnownRelations();
        Map<Individual, Set<Individual>> map2 = roleElement.getPossibleRelations();
        if (map != null && map.containsKey(individual) && map.get(individual).contains(individual2)) {
            return new boolean[]{true, false};
        }
        if (map2 != null && map2.containsKey(individual) && map2.get(individual).contains(individual2)) {
            return new boolean[]{false, true};
        }
        for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : hierarchyNode.getChildNodes()) {
            boolean[] blArray;
            if (hierarchyNode2 == this.m_currentRoleHierarchy.m_bottomNode || !(blArray = this.hasRoleSuccessor(hierarchyNode2, individual, individual2))[0] && !blArray[1]) continue;
            return blArray;
        }
        return new boolean[]{false, false};
    }

    public int[] getNumberOfPredecessors(AtomicRole atomicRole, Individual individual) {
        int[] nArray = new int[2];
        HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole));
        if (hierarchyNode == null) {
            return nArray;
        }
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.equals(this.m_topRoleElement)) {
            nArray[0] = this.m_individuals.length;
            return nArray;
        }
        if (roleElement.equals(this.m_bottomRoleElement)) {
            return nArray;
        }
        return this.getNumberOfRolePredecessors(hierarchyNode, individual, nArray);
    }

    protected int[] getNumberOfRolePredecessors(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, Individual individual, int[] nArray) {
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        Map<Individual, Set<Individual>> map = roleElement.getKnownRelations();
        for (Individual object : map.keySet()) {
            if (!map.get(object).contains(individual)) continue;
            nArray[0] = nArray[0] + 1;
        }
        map = roleElement.getPossibleRelations();
        for (Individual individual2 : map.keySet()) {
            if (!map.get(individual2).contains(individual)) continue;
            nArray[1] = nArray[1] + 1;
        }
        for (HierarchyNode hierarchyNode2 : hierarchyNode.getChildNodes()) {
            if (hierarchyNode2 == this.m_currentRoleHierarchy.m_bottomNode) continue;
            this.getNumberOfRolePredecessors(hierarchyNode2, individual, nArray);
        }
        return nArray;
    }

    public int[] getNumberOfSameAs(Individual individual) {
        int[] nArray = new int[2];
        Set<Individual> set = this.m_individualToEquivalenceClass.get(individual);
        if (set != null) {
            nArray[0] = set.size();
            Set<Set<Individual>> set2 = this.m_individualToPossibleEquivalenceClass.get(set);
            if (set2 != null) {
                for (Set<Individual> set3 : set2) {
                    nArray[1] = nArray[1] + set3.size();
                }
            }
        }
        return nArray;
    }

    public int[] getNumberOfPropertyInstances(AtomicRole atomicRole) {
        int[] nArray = new int[3];
        HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole));
        if (hierarchyNode == null) {
            return nArray;
        }
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.equals(this.m_bottomRoleElement)) {
            return nArray;
        }
        AverageRoleSuccessorStatistics averageRoleSuccessorStatistics = new AverageRoleSuccessorStatistics(this.m_currentRoleHierarchy.m_bottomNode);
        HierarchyNode[] hierarchyNodeArray = new HierarchyNode[2];
        HashSet hashSet = new HashSet();
        this.m_currentRoleHierarchy.traverseDepthFirst(averageRoleSuccessorStatistics, 0, hierarchyNode, null, hashSet, hierarchyNodeArray);
        nArray[0] = averageRoleSuccessorStatistics.successors;
        nArray[1] = averageRoleSuccessorStatistics.possibleSuccessors;
        nArray[2] = averageRoleSuccessorStatistics.inds.size();
        return nArray;
    }

    public int[] getNumberOfTypes(Individual individual) {
        int[] nArray = new int[2];
        DFS dFS = new DFS(this.m_currentConceptHierarchy.m_bottomNode);
        DFSTypeCounter dFSTypeCounter = new DFSTypeCounter(individual);
        dFS.traverse(this.m_currentConceptHierarchy.m_topNode, dFSTypeCounter);
        nArray[0] = dFSTypeCounter.types;
        if (nArray[0] == 0) {
            nArray[0] = 1;
        }
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class DFSTypeCounter
    implements DFSVisitor<AtomicConcept> {
        protected final Individual m_individual;
        protected int types = 0;
        protected int possibleTypes = 0;
        protected List<Integer> typesStack = new ArrayList<Integer>();

        public DFSTypeCounter(Individual individual) {
            this.m_individual = individual;
        }

        @Override
        public void previsit(int n, HierarchyNode<AtomicConcept> hierarchyNode) {
        }

        @Override
        public boolean visit(int n, HierarchyNode<AtomicConcept> hierarchyNode) {
            AtomicConceptElement atomicConceptElement = InstanceManager.this.m_conceptToElement.get(hierarchyNode.getRepresentative());
            int n2 = this.typesStack.size() > 0 ? this.typesStack.get(this.typesStack.size() - 1) : 0;
            this.typesStack.add(n2 += hierarchyNode.getEquivalentElements().size());
            if (atomicConceptElement != null) {
                if (atomicConceptElement.getKnownInstances().contains(this.m_individual)) {
                    this.types += n2;
                    this.typesStack.clear();
                    return false;
                }
                if (atomicConceptElement.getPossibleInstances().contains(this.m_individual)) {
                    this.possibleTypes += n2;
                    this.typesStack.clear();
                    return false;
                }
            }
            return true;
        }

        @Override
        public void postvisit(int n, HierarchyNode<AtomicConcept> hierarchyNode) {
            if (!this.typesStack.isEmpty()) {
                this.typesStack.remove(this.typesStack.size() - 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface DFSVisitor<E> {
        public void previsit(int var1, HierarchyNode<E> var2);

        public boolean visit(int var1, HierarchyNode<E> var2);

        public void postvisit(int var1, HierarchyNode<E> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class DFS<T> {
        Set<HierarchyNode<T>> visited = new HashSet<HierarchyNode<T>>();
        protected final HierarchyNode<T> m_bottomNode;

        public DFS(HierarchyNode<T> hierarchyNode) {
            this.m_bottomNode = hierarchyNode;
        }

        public void traverse(HierarchyNode<T> hierarchyNode, DFSVisitor<T> dFSVisitor) {
            this.traverse(0, hierarchyNode, dFSVisitor);
        }

        protected void traverse(int n, HierarchyNode<T> hierarchyNode, DFSVisitor<T> dFSVisitor) {
            boolean bl = this.visited.add(hierarchyNode);
            if (bl) {
                dFSVisitor.previsit(n, hierarchyNode);
                boolean bl2 = dFSVisitor.visit(n, hierarchyNode);
                if (bl2) {
                    for (HierarchyNode hierarchyNode2 : hierarchyNode.m_childNodes) {
                        this.traverse(n + 1, hierarchyNode2, dFSVisitor);
                    }
                }
                dFSVisitor.postvisit(n, hierarchyNode);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AverageRoleSuccessorStatistics
    implements Hierarchy.HierarchyNodeVisitor<RoleElementManager.RoleElement> {
        protected final HierarchyNode<RoleElementManager.RoleElement> m_bottomNode;
        protected final Set<Individual> inds;
        protected int successors = 0;
        protected int possibleSuccessors = 0;

        public AverageRoleSuccessorStatistics(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode) {
            this.m_bottomNode = hierarchyNode;
            this.inds = new HashSet<Individual>();
        }

        @Override
        public boolean redirect(HierarchyNode<RoleElementManager.RoleElement>[] hierarchyNodeArray) {
            return true;
        }

        @Override
        public void visit(int n, HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2, boolean bl) {
            if (bl && !hierarchyNode.equals(this.m_bottomNode)) {
                RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
                Map<Individual, Set<Individual>> map = roleElement.getKnownRelations();
                for (Individual individual : map.keySet()) {
                    this.inds.add(individual);
                    this.successors += map.get(individual).size();
                }
                map = roleElement.getPossibleRelations();
                for (Individual individual : map.keySet()) {
                    this.inds.add(individual);
                    this.possibleSuccessors += map.get(individual).size();
                }
            }
        }
    }
}

