/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.HermiT.hierarchy.HierarchyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hierarchy<E> {
    protected final HierarchyNode<E> m_topNode;
    protected final HierarchyNode<E> m_bottomNode;
    protected final Map<E, HierarchyNode<E>> m_nodesByElements;

    public Hierarchy(HierarchyNode<E> hierarchyNode, HierarchyNode<E> hierarchyNode2) {
        this.m_topNode = hierarchyNode;
        this.m_bottomNode = hierarchyNode2;
        this.m_nodesByElements = new HashMap<E, HierarchyNode<E>>();
        for (Object e : this.m_topNode.m_equivalentElements) {
            this.m_nodesByElements.put(e, this.m_topNode);
        }
        for (Object e : this.m_bottomNode.m_equivalentElements) {
            this.m_nodesByElements.put(e, this.m_bottomNode);
        }
    }

    public HierarchyNode<E> getTopNode() {
        return this.m_topNode;
    }

    public HierarchyNode<E> getBottomNode() {
        return this.m_bottomNode;
    }

    public boolean isEmpty() {
        return this.m_nodesByElements.size() == 2 && this.m_topNode.m_equivalentElements.size() == 1 && this.m_bottomNode.m_equivalentElements.size() == 1;
    }

    public HierarchyNode<E> getNodeForElement(E e) {
        return this.m_nodesByElements.get(e);
    }

    public Collection<HierarchyNode<E>> getAllNodes() {
        return Collections.unmodifiableCollection(this.m_nodesByElements.values());
    }

    public Set<HierarchyNode<E>> getAllNodesSet() {
        return Collections.unmodifiableSet(new HashSet<HierarchyNode<E>>(this.m_nodesByElements.values()));
    }

    public Set<E> getAllElements() {
        return Collections.unmodifiableSet(this.m_nodesByElements.keySet());
    }

    public int getDepth() {
        HierarchyDepthFinder<E> hierarchyDepthFinder = new HierarchyDepthFinder<E>(this.m_bottomNode);
        this.traverseDepthFirst(hierarchyDepthFinder);
        return hierarchyDepthFinder.depth;
    }

    /*
     * WARNING - void declaration
     */
    public <T> Hierarchy<T> transform(Transformer<? super E, T> transformer, Comparator<T> comparator) {
        Iterator iterator;
        Hierarchy<E> hierarchy;
        HierarchyNodeComparator<T> hierarchyNodeComparator = new HierarchyNodeComparator<T>(comparator);
        HashMap hashMap = new HashMap();
        for (HierarchyNode<E> hierarchyNode2 : this.m_nodesByElements.values()) {
            void var9_12;
            Object object2;
            Iterator iterator2;
            if (comparator == null) {
                hierarchy = new HashSet();
                iterator2 = new HashSet();
                HashSet hashSet = new HashSet();
            } else {
                hierarchy = new TreeSet<T>(comparator);
                iterator2 = new TreeSet<T>(hierarchyNodeComparator);
                TreeSet<T> treeSet = new TreeSet<T>(hierarchyNodeComparator);
            }
            for (Object object2 : hierarchyNode2.m_equivalentElements) {
                E e = transformer.transform(object2);
                hierarchy.add(e);
            }
            iterator = transformer.determineRepresentative(hierarchyNode2.m_representative, hierarchy);
            object2 = new HierarchyNode<Object>(iterator, (Set<Object>)((Object)hierarchy), (Set<HierarchyNode<Object>>)((Object)iterator2), (Set<HierarchyNode<Object>>)var9_12);
            hashMap.put(hierarchyNode2, object2);
        }
        for (HierarchyNode<E> hierarchyNode : this.m_nodesByElements.values()) {
            hierarchy = (HierarchyNode)hashMap.get(hierarchyNode);
            for (HierarchyNode hierarchyNode2 : hierarchyNode.m_childNodes) {
                iterator = (HierarchyNode)hashMap.get(hierarchyNode2);
                ((HierarchyNode)((Object)hierarchy)).m_childNodes.add(iterator);
                ((HierarchyNode)((Object)iterator)).m_parentNodes.add((HierarchyNode<Hierarchy<E>>)((Object)hierarchy));
            }
        }
        HierarchyNode hierarchyNode3 = (HierarchyNode)hashMap.get(this.m_topNode);
        HierarchyNode hierarchyNode = (HierarchyNode)hashMap.get(this.m_bottomNode);
        hierarchy = new Hierarchy<E>(hierarchyNode3, hierarchyNode);
        for (HierarchyNode hierarchyNode4 : hashMap.values()) {
            for (Object object2 : hierarchyNode4.m_equivalentElements) {
                hierarchy.m_nodesByElements.put(object2, hierarchyNode4);
            }
        }
        return hierarchy;
    }

    public void traverseDepthFirst(HierarchyNodeVisitor<E> hierarchyNodeVisitor) {
        HierarchyNode[] hierarchyNodeArray = new HierarchyNode[2];
        HashSet<HierarchyNode<E>> hashSet = new HashSet<HierarchyNode<E>>();
        this.traverseDepthFirst(hierarchyNodeVisitor, 0, this.m_topNode, null, hashSet, hierarchyNodeArray);
    }

    protected void traverseDepthFirst(HierarchyNodeVisitor<E> hierarchyNodeVisitor, int n, HierarchyNode<E> hierarchyNode, HierarchyNode<E> hierarchyNode2, Set<HierarchyNode<E>> set, HierarchyNode<E>[] hierarchyNodeArray) {
        hierarchyNodeArray[0] = hierarchyNode;
        hierarchyNodeArray[1] = hierarchyNode2;
        if (hierarchyNodeVisitor.redirect(hierarchyNodeArray)) {
            hierarchyNode = hierarchyNodeArray[0];
            hierarchyNode2 = hierarchyNodeArray[1];
            boolean bl = set.add(hierarchyNode);
            hierarchyNodeVisitor.visit(n, hierarchyNode, hierarchyNode2, bl);
            if (bl) {
                for (HierarchyNode hierarchyNode3 : hierarchyNode.m_childNodes) {
                    this.traverseDepthFirst(hierarchyNodeVisitor, n + 1, hierarchyNode3, hierarchyNode, set, hierarchyNodeArray);
                }
            }
        }
    }

    public static <T> Hierarchy<T> emptyHierarchy(Collection<T> collection, T t, T t2) {
        HierarchyNode<T> hierarchyNode = new HierarchyNode<T>(t);
        hierarchyNode.m_equivalentElements.add(t);
        hierarchyNode.m_equivalentElements.add(t2);
        hierarchyNode.m_equivalentElements.addAll(collection);
        return new Hierarchy<T>(hierarchyNode, hierarchyNode);
    }

    public static <T> Hierarchy<T> trivialHierarchy(T t, T t2) {
        HierarchyNode<T> hierarchyNode = new HierarchyNode<T>(t);
        hierarchyNode.m_equivalentElements.add(t);
        HierarchyNode<T> hierarchyNode2 = new HierarchyNode<T>(t2);
        hierarchyNode2.m_equivalentElements.add(t2);
        hierarchyNode.m_childNodes.add(hierarchyNode2);
        hierarchyNode2.m_parentNodes.add(hierarchyNode);
        return new Hierarchy<T>(hierarchyNode, hierarchyNode2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class HierarchyNodeComparator<E>
    implements Comparator<HierarchyNode<E>> {
        protected final Comparator<E> m_elementComparator;

        public HierarchyNodeComparator(Comparator<E> comparator) {
            this.m_elementComparator = comparator;
        }

        @Override
        public int compare(HierarchyNode<E> hierarchyNode, HierarchyNode<E> hierarchyNode2) {
            return this.m_elementComparator.compare(hierarchyNode.m_representative, hierarchyNode2.m_representative);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Transformer<E, T> {
        public T transform(E var1);

        public T determineRepresentative(E var1, Set<T> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface HierarchyNodeVisitor<E> {
        public boolean redirect(HierarchyNode<E>[] var1);

        public void visit(int var1, HierarchyNode<E> var2, HierarchyNode<E> var3, boolean var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class HierarchyDepthFinder<T>
    implements HierarchyNodeVisitor<T> {
        protected final HierarchyNode<T> m_bottomNode;
        protected int depth = 0;

        public HierarchyDepthFinder(HierarchyNode<T> hierarchyNode) {
            this.m_bottomNode = hierarchyNode;
        }

        @Override
        public boolean redirect(HierarchyNode<T>[] hierarchyNodeArray) {
            return true;
        }

        @Override
        public void visit(int n, HierarchyNode<T> hierarchyNode, HierarchyNode<T> hierarchyNode2, boolean bl) {
            if (hierarchyNode.equals(this.m_bottomNode) && n > this.depth) {
                this.depth = n;
            }
        }
    }
}

