/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.HermiT.model.Individual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicConceptElement {
    public static final String LB = System.getProperty("line.separator");
    protected final Set<Individual> m_knownInstances;
    protected final Set<Individual> m_possibleInstances;

    public AtomicConceptElement(Set<Individual> set, Set<Individual> set2) {
        this.m_knownInstances = set == null ? new HashSet<Individual>() : set;
        this.m_possibleInstances = set2 == null ? new HashSet<Individual>() : set2;
    }

    public boolean isKnown(Individual individual) {
        return this.m_knownInstances.contains(individual);
    }

    public boolean isPossible(Individual individual) {
        return this.m_possibleInstances.contains(individual);
    }

    public Set<Individual> getKnownInstances() {
        return this.m_knownInstances;
    }

    public Set<Individual> getPossibleInstances() {
        return this.m_possibleInstances;
    }

    public boolean hasPossibles() {
        return !this.m_possibleInstances.isEmpty();
    }

    public void setToKnown(Individual individual) {
        this.m_possibleInstances.remove(individual);
        this.m_knownInstances.add(individual);
    }

    public boolean addPossible(Individual individual) {
        return this.m_possibleInstances.add(individual);
    }

    public boolean addPossibles(Set<Individual> set) {
        return this.m_possibleInstances.addAll(set);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" (known instances: ");
        boolean bl = false;
        for (Individual individual : this.m_knownInstances) {
            if (bl) {
                stringBuffer.append(", ");
            }
            bl = true;
            stringBuffer.append(individual.toString());
        }
        stringBuffer.append(" | possible instances: ");
        bl = false;
        for (Individual individual : this.m_possibleInstances) {
            if (bl) {
                stringBuffer.append(", ");
            }
            bl = true;
            stringBuffer.append(individual.toString());
        }
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }
}

